/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.VirtualStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.TextField;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.imageio.ImageIO;

public class AVI_Reader
extends VirtualStack
implements PlugIn {
    private static final int FOURCC_RIFF = 1179011410;
    private static final int FOURCC_AVI = 541677121;
    private static final int FOURCC_AVIX = 1481201217;
    private static final int FOURCC_ix00 = 808482921;
    private static final int FOURCC_indx = 2019847785;
    private static final int FOURCC_idx1 = 829973609;
    private static final int FOURCC_LIST = 1414744396;
    private static final int FOURCC_hdrl = 1819436136;
    private static final int FOURCC_avih = 1751742049;
    private static final int FOURCC_strl = 1819440243;
    private static final int FOURCC_strh = 1752331379;
    private static final int FOURCC_strf = 1718776947;
    private static final int FOURCC_movi = 1769369453;
    private static final int FOURCC_rec = 543384946;
    private static final int FOURCC_JUNK = 1263424842;
    private static final int FOURCC_vids = 1935960438;
    private static final int FOURCC_00db = 1650733104;
    private static final int FOURCC_00dc = 1667510320;
    private static final int NO_COMPRESSION = 0;
    private static final int NO_COMPRESSION_RGB = 541214546;
    private static final int NO_COMPRESSION_RAW = 542589266;
    private static final int NO_COMPRESSION_Y800 = 808466521;
    private static final int NO_COMPRESSION_Y8 = 538982489;
    private static final int NO_COMPRESSION_GREY = 1497715271;
    private static final int NO_COMPRESSION_Y16 = 540422489;
    private static final int NO_COMPRESSION_MIL = 541870413;
    private static final int AYUV_COMPRESSION = 1448433985;
    private static final int UYVY_COMPRESSION = 0x59565955;
    private static final int Y422_COMPRESSION = 1447975253;
    private static final int UYNV_COMPRESSION = 842151001;
    private static final int CYUV_COMPRESSION = 1987410275;
    private static final int V422_COMPRESSION = 842150998;
    private static final int YUY2_COMPRESSION = 844715353;
    private static final int YUNV_COMPRESSION = 1447974233;
    private static final int YUYV_COMPRESSION = 0x56595559;
    private static final int YVYU_COMPRESSION = 0x55595659;
    private static final int I420_COMPRESSION = 808596553;
    private static final int IYUV_COMPRESSION = 1448433993;
    private static final int YV12_COMPRESSION = 842094169;
    private static final int NV12_COMPRESSION = 842094158;
    private static final int NV21_COMPRESSION = 825382478;
    private static final int JPEG_COMPRESSION = 1734701162;
    private static final int JPEG_COMPRESSION2 = 1195724874;
    private static final int JPEG_COMPRESSION3 = 4;
    private static final int MJPG_COMPRESSION = 1196444237;
    private static final int PNG_COMPRESSION = 543649392;
    private static final int PNG_COMPRESSION2 = 541544016;
    private static final int PNG_COMPRESSION3 = 5;
    private static final int BITMASK24 = 65536;
    private static final long SIZE_MASK = 0xFFFFFFFFL;
    private static final long FOUR_GB = 0x100000000L;
    private static final int AVIF_HASINDEX = 16;
    private static final int AVIF_MUSTUSEINDEX = 32;
    private static final int AVIF_ISINTERLEAVED = 256;
    private static final byte AVI_INDEX_OF_CHUNKS = 1;
    private static final byte AVI_INDEX_OF_INDEXES = 0;
    private static boolean staticConvertToGray;
    private static boolean staticFlipVertical;
    private static boolean staticIsVirtual;
    private static final String PATH_KEY = "avi.reader.path";
    private String path;
    private String fileName;
    private String fileDir;
    private int firstFrame = 1;
    private int lastFrame = 0;
    private boolean convertToGray;
    private boolean flipVertical;
    private boolean isVirtual;
    private RandomAccessFile raFile;
    private String raFilePath;
    private boolean headerOK = false;
    private int streamNumber;
    private int type0xdb;
    private int type0xdc;
    private long fileSize;
    private long aviSize;
    private long headerPositionEnd;
    private long indexPosition;
    private long indexPositionEnd;
    private long moviPosition;
    private int paddingGranularity = 2;
    private int frameNumber = 1;
    private int lastFrameToRead = Integer.MAX_VALUE;
    private int totalFramesFromIndex;
    private boolean indexForCountingOnly;
    private boolean isOversizedAvi1;
    private int dataCompression;
    private boolean isPlanarFormat;
    private int scanLineSize;
    private boolean dataTopDown;
    private ColorModel cm;
    private boolean variableLength;
    private Vector<long[]> frameInfos;
    private ImageStack stack;
    private ImagePlus imp;
    private boolean verbose = IJ.debugMode;
    private long startTime;
    private boolean aborting;
    private boolean displayDialog = true;
    private String errorText;
    private int dwMicroSecPerFrame;
    private int dwMaxBytesPerSec;
    private int dwReserved1;
    private int dwFlags;
    private int dwTotalFrames;
    private int dwInitialFrames;
    private int dwStreams;
    private int dwSuggestedBufferSize;
    private int dwWidth;
    private int dwHeight;
    private int fccStreamHandler;
    private int dwStreamFlags;
    private int dwPriorityLanguage;
    private int dwStreamInitialFrames;
    private int dwStreamScale;
    private int dwStreamRate;
    private int dwStreamStart;
    private int dwStreamLength;
    private int dwStreamSuggestedBufferSize;
    private int dwStreamQuality;
    private int dwStreamSampleSize;
    private int biSize;
    private int biWidth;
    private int biHeight;
    private short biPlanes;
    private short biBitCount;
    private int biCompression;
    private int biSizeImage;
    private int biXPelsPerMeter;
    private int biYPelsPerMeter;
    private int biClrUsed;
    private int biClrImportant;
    private static final int BUFFERSIZE = 4096;
    private static final byte[] HUFFMAN_TABLES;
    private static final int HUFFMAN_LENGTH = 420;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String arg) {
        String options;
        String string = options = IJ.isMacro() ? Macro.getOptions() : null;
        if (options != null && options.contains("select=") && !options.contains("open=")) {
            Macro.setOptions(options.replaceAll("select=", "open="));
        }
        this.path = arg;
        if (this.displayDialog && !this.showDialog()) {
            return;
        }
        try {
            this.openAndReadHeader(this.path);
        }
        catch (Exception e) {
            this.error(this.exceptionMessage(e));
            return;
        }
        finally {
            this.closeFile(this.raFile);
        }
        this.errorText = null;
        ImageStack stack = this.makeStack(this.path, this.firstFrame, this.lastFrame, this.isVirtual, this.convertToGray, this.flipVertical);
        if (this.aborting) {
            return;
        }
        if (stack == null || stack.size() == 0 || stack.getProcessor(1) == null) {
            if (this.errorText != null) {
                this.error(this.errorText);
            } else {
                String rangeText = "";
                if (this.firstFrame > 1 || this.lastFrame != 0 && this.lastFrame != this.dwTotalFrames) {
                    rangeText = "\nin Range " + this.firstFrame + (this.lastFrame > 0 ? " - " + this.lastFrame : " - end");
                }
                this.error("Error: No Frames Found" + rangeText);
            }
            return;
        }
        if (this.errorText != null) {
            IJ.showMessage("AVI Reader", this.errorText);
        }
        if (this.fileName == null) {
            File f = new File(this.path);
            this.fileName = f.getName();
        }
        this.imp = new ImagePlus(WindowManager.makeUniqueName(this.fileName), stack);
        if (this.imp.getBitDepth() == 16) {
            this.imp.getProcessor().resetMinAndMax();
        }
        this.setFramesPerSecond(this.imp);
        FileInfo fi = new FileInfo();
        fi.fileName = this.fileName;
        fi.directory = this.fileDir;
        this.imp.setFileInfo(fi);
        if (arg.equals("")) {
            this.imp.show();
        }
        IJ.showTime(this.imp, this.startTime, "Read AVI in ", stack.size());
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    public static ImagePlus openVirtual(String path) {
        return AVI_Reader.open(path, true);
    }

    public static ImagePlus open(String path, boolean virtual) {
        AVI_Reader reader = new AVI_Reader();
        ImageStack stack = reader.makeStack(path, 1, 0, virtual, false, false);
        if (stack != null) {
            return new ImagePlus(new File(path).getName(), stack);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageStack makeStack(String path, int firstFrame, int lastFrame, boolean isVirtual, boolean convertToGray, boolean flipVertical) {
        this.firstFrame = firstFrame;
        this.lastFrame = lastFrame;
        this.isVirtual = isVirtual;
        this.convertToGray = convertToGray;
        this.flipVertical = flipVertical;
        IJ.showProgress(0.001);
        try {
            this.readAVI(path);
        }
        catch (OutOfMemoryError e) {
            this.stack.trim();
            this.errorText = "Out of memory.  " + this.stack.size() + " of " + this.dwTotalFrames + " frames will be opened.";
        }
        catch (Exception e) {
            this.errorText = this.exceptionMessage(e);
            if (isVirtual || this.stack == null || this.stack.size() == 0) {
                ImageStack imageStack = null;
                return imageStack;
            }
        }
        finally {
            this.closeFile(this.raFile);
            if (this.verbose) {
                IJ.log("File closed.");
            }
            IJ.showProgress(1.0);
        }
        if (isVirtual && this.frameInfos != null) {
            this.stack = this;
        }
        if (this.stack != null && this.cm != null) {
            this.stack.setColorModel(this.cm);
        }
        return this.stack;
    }

    public String getErrorText() {
        return this.errorText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ImageProcessor getProcessor(int n) {
        if (this.frameInfos == null || this.frameInfos.size() == 0 || this.raFilePath == null) {
            return null;
        }
        if ((n = this.translate(n)) < 1 || n > this.frameInfos.size()) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        Object pixels = null;
        RandomAccessFile rFile = null;
        try {
            rFile = new RandomAccessFile(new File(this.raFilePath), "r");
            long[] frameInfo = this.frameInfos.get(n - 1);
            pixels = this.readFrame(rFile, frameInfo[0], (int)frameInfo[1]);
            this.closeFile(rFile);
        }
        catch (Exception e) {
            try {
                this.error(this.exceptionMessage(e));
                ImageProcessor imageProcessor = null;
                this.closeFile(rFile);
                return imageProcessor;
            }
            catch (Throwable throwable) {
                this.closeFile(rFile);
                throw throwable;
            }
        }
        if (pixels == null) {
            return null;
        }
        if (pixels instanceof byte[]) {
            return new ByteProcessor(this.dwWidth, this.biHeight, (byte[])pixels, this.cm);
        }
        if (pixels instanceof short[]) {
            return new ShortProcessor(this.dwWidth, this.biHeight, (short[])pixels, this.cm);
        }
        return new ColorProcessor(this.dwWidth, this.biHeight, (int[])pixels);
    }

    @Override
    public int getWidth() {
        return this.dwWidth;
    }

    @Override
    public int getHeight() {
        return this.biHeight;
    }

    @Override
    public int getSize() {
        if (this.frameInfos == null) {
            return 0;
        }
        return this.frameInfos.size();
    }

    @Override
    public String getSliceLabel(int n) {
        if (this.frameInfos == null || n < 1 || n > this.frameInfos.size()) {
            throw new IllegalArgumentException("No Virtual Stack or argument out of range: " + n);
        }
        return this.frameLabel(this.frameInfos.get(n - 1)[2]);
    }

    @Override
    public void deleteSlice(int n) {
        if (this.frameInfos == null || this.frameInfos.size() == 0) {
            return;
        }
        if (n < 1 || n > this.frameInfos.size()) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        this.frameInfos.removeElementAt(n - 1);
    }

    private boolean showDialog() {
        double last;
        String options;
        if (this.lastFrame != -1) {
            this.lastFrame = this.dwTotalFrames;
        }
        if (!IJ.isMacro()) {
            this.convertToGray = staticConvertToGray;
            this.flipVertical = staticFlipVertical;
            this.isVirtual = staticIsVirtual;
        }
        if ((options = Macro.getOptions()) != null && options.contains("open=")) {
            Macro.setOptions(options.replace("open=", "avi="));
        }
        if (this.path == null || this.path.length() == 0) {
            this.path = Prefs.get(PATH_KEY, IJ.getDir("downloads") + "movie.avi");
        }
        GenericDialog gd = new GenericDialog("AVI Reader");
        gd.setInsets(5, 0, 0);
        gd.addFileField("AVI:", this.path, 29);
        gd.setInsets(2, 40, 5);
        gd.addMessage("drag and drop target", IJ.font10, Color.darkGray);
        gd.addCheckbox("Use Virtual Stack", this.isVirtual);
        gd.addCheckbox("Convert to Grayscale", this.convertToGray);
        gd.addCheckbox("Flip Vertical", this.flipVertical);
        gd.setInsets(15, 0, 3);
        gd.addNumericField("First:", this.firstFrame, 0);
        gd.addNumericField("Last:", this.lastFrame, this.lastFrame, 6, "*");
        TextField lastField = (TextField)gd.getNumericFields().lastElement();
        if (this.lastFrame == 0) {
            lastField.setText("");
        }
        gd.setInsets(0, 40, 5);
        gd.addMessage("* Leave empty or set to 0 for reading to the end.\n   Also accepts e.g. -5 to skip last 5 frames.", IJ.font10, Color.darkGray);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.path = gd.getNextString();
        Prefs.set(PATH_KEY, this.path);
        File f = new File(this.path);
        this.fileName = f.getName();
        this.fileDir = IJ.addSeparator(f.getParent());
        gd.setSmartRecording(true);
        this.isVirtual = gd.getNextBoolean();
        this.convertToGray = gd.getNextBoolean();
        this.flipVertical = gd.getNextBoolean();
        double first = gd.getNextNumber();
        if (!Double.isNaN(first)) {
            this.firstFrame = (int)first;
        }
        if (lastField.getText().length() == 0) {
            lastField.setText("0");
        }
        if (!Double.isNaN(last = gd.getNextNumber())) {
            this.lastFrame = (int)last;
        }
        if (!IJ.isMacro()) {
            staticConvertToGray = this.convertToGray;
            staticFlipVertical = this.flipVertical;
            staticIsVirtual = this.isVirtual;
        }
        IJ.register(this.getClass());
        return true;
    }

    private void readAVI(String path) throws Exception, IOException {
        boolean hasIndex;
        if (!this.headerOK) {
            this.openAndReadHeader(path);
        } else {
            File file2 = new File(path);
            this.raFile = new RandomAccessFile(file2, "r");
        }
        this.startTime += System.currentTimeMillis();
        if (this.lastFrame > 0) {
            this.lastFrameToRead = this.lastFrame;
        }
        if (this.lastFrame < 0 && this.dwTotalFrames > 0) {
            this.lastFrameToRead = this.dwTotalFrames + this.lastFrame;
        }
        if (this.lastFrameToRead < this.firstFrame) {
            return;
        }
        boolean bl = hasIndex = (this.dwFlags & 0x10) != 0;
        if (this.isVirtual || this.firstFrame > 1) {
            this.frameInfos = new Vector(100);
            long nextPosition = -1L;
            if (this.indexPosition > 0L) {
                this.raFile.seek(this.indexPosition);
                nextPosition = this.findFourccAndRead(2019847785, false, this.indexPositionEnd, false);
            }
            if (hasIndex && (this.frameInfos == null || this.frameInfos.size() == 0)) {
                this.raFile.seek(this.headerPositionEnd);
                this.moviPosition = this.findFourccAndSkip(1769369453, true, this.fileSize);
                if (this.moviPosition < 0L) {
                    throw new Exception("AVI File has no movie data");
                }
                for (long positionBehindMovie = this.raFile.getFilePointer(); positionBehindMovie < this.fileSize - 8L; positionBehindMovie += 0x100000000L) {
                    if (this.verbose) {
                        IJ.log("searching for 'idx1' at 0x" + Long.toHexString(positionBehindMovie));
                    }
                    this.raFile.seek(positionBehindMovie);
                    if (positionBehindMovie > 0x100000000L) {
                        this.isOversizedAvi1 = true;
                    }
                    if ((nextPosition = this.findFourccAndRead(829973609, false, this.fileSize, false)) >= 0L) break;
                }
            }
            if (this.verbose) {
                IJ.log("'frameInfos' has " + this.frameInfos.size() + " entries");
            }
        }
        if (this.isVirtual && this.frameInfos.size() > 0) {
            return;
        }
        this.raFile.seek(this.headerPositionEnd);
        if (this.firstFrame > 1 && this.frameInfos.size() > 0) {
            long[] frameInfo = this.frameInfos.get(0);
            this.raFile.seek(frameInfo[0] - 8L);
            this.frameNumber = this.firstFrame;
            if (this.verbose) {
                IJ.log("directly go to frame " + this.firstFrame + " @ 0x" + Long.toHexString(frameInfo[0] - 8L));
            }
            this.readMovieData(this.fileSize);
        } else {
            this.frameNumber = 1;
            this.findFourccAndRead(1769369453, true, this.fileSize, true);
        }
        long pos = this.raFile.getFilePointer();
        while (pos > 0L && pos < this.fileSize && this.frameNumber < this.lastFrameToRead + 1) {
            pos = this.findFourccAndRead(1179011410, false, this.fileSize, false);
        }
    }

    private void openAndReadHeader(String path) throws Exception, IOException {
        this.startTime = System.currentTimeMillis();
        if (this.verbose) {
            IJ.log("OPEN AND READ AVI FILE HEADER " + this.timeString());
        }
        File file2 = new File(path);
        this.raFile = new RandomAccessFile(file2, "r");
        this.raFilePath = path;
        this.fileSize = this.raFile.length();
        int fileType = this.readInt();
        if (this.verbose) {
            IJ.log("File header: File type='" + this.fourccString(fileType) + "' (should be 'RIFF')" + this.timeString());
        }
        if (fileType != 1179011410) {
            throw new Exception("Not an AVI file.");
        }
        this.aviSize = (long)this.readInt() & 0xFFFFFFFFL;
        int riffType = this.readInt();
        if (this.verbose) {
            IJ.log("File header: RIFF type='" + this.fourccString(riffType) + "' (should be 'AVI ')");
        }
        if (riffType != 541677121) {
            throw new Exception("Not an AVI file.");
        }
        this.findFourccAndRead(1819436136, true, this.fileSize, true);
        this.startTime -= System.currentTimeMillis();
        this.headerOK = true;
    }

    private void readAVIX(long endPosition) throws Exception, IOException {
        if (this.verbose) {
            IJ.log("Trying to read AVIX" + this.timeString());
        }
        int riffType = this.readInt();
        if (this.verbose) {
            IJ.log("File header: RIFF type='" + this.fourccString(riffType) + "' (should be 'AVIX')");
        }
        if (riffType != 1481201217) {
            throw new Exception("Not an AVI file.");
        }
        this.findFourccAndRead(1769369453, true, this.fileSize, true);
    }

    private long findFourccAndRead(int fourcc, boolean isList, long endPosition, boolean throwNotFoundException) throws Exception, IOException {
        long nextPos;
        boolean contentOk = false;
        do {
            int type;
            if ((type = this.readType(endPosition)) == 0) {
                if (throwNotFoundException) {
                    throw new Exception("Required item '" + this.fourccString(fourcc) + "' not found");
                }
                return -1L;
            }
            long size = (long)this.readInt() & 0xFFFFFFFFL;
            nextPos = this.raFile.getFilePointer() + size;
            if (nextPos > endPosition || nextPos > this.fileSize) {
                this.errorText = "AVI File Error: '" + this.fourccString(type) + "' @ 0x" + Long.toHexString(this.raFile.getFilePointer() - 8L) + " has invalid length. File damaged/truncated?";
                IJ.log(this.errorText);
                if (fourcc == 1769369453) {
                    nextPos = this.fileSize;
                } else {
                    return -1L;
                }
            }
            if (isList && type == 1414744396) {
                type = this.readInt();
            }
            if (this.verbose) {
                IJ.log("Search for '" + this.fourccString(fourcc) + "', found " + this.fourccString(type) + "' data " + this.posSizeString(nextPos - size, size));
            }
            if (type == fourcc) {
                contentOk = this.readContents(fourcc, nextPos);
            } else if (this.verbose) {
                IJ.log("'" + this.fourccString(type) + "', ignored");
            }
            this.raFile.seek(nextPos);
            if (!contentOk) continue;
            return nextPos;
        } while (!contentOk);
        return nextPos;
    }

    private long findFourccAndSkip(int fourcc, boolean isList, long endPosition) throws IOException {
        long chunkPos;
        int type;
        do {
            if ((type = this.readType(endPosition)) == 0) {
                return -1L;
            }
            long size = (long)this.readInt() & 0xFFFFFFFFL;
            chunkPos = this.raFile.getFilePointer();
            long nextPos = chunkPos + size;
            if (isList && type == 1414744396) {
                type = this.readInt();
            }
            if (this.verbose) {
                IJ.log("Searching for (to skip) '" + this.fourccString(fourcc) + "', found " + this.fourccString(type) + "' data " + this.posSizeString(chunkPos, size));
            }
            this.raFile.seek(nextPos);
        } while (type != fourcc);
        return chunkPos;
    }

    private boolean readContents(int fourcc, long endPosition) throws Exception, IOException {
        switch (fourcc) {
            case 1819436136: {
                this.headerPositionEnd = endPosition;
                this.findFourccAndRead(1751742049, false, endPosition, true);
                this.findFourccAndRead(1819440243, true, endPosition, true);
                return true;
            }
            case 1751742049: {
                this.readAviHeader();
                return true;
            }
            case 1819440243: {
                long nextPosition = this.findFourccAndRead(1752331379, false, endPosition, false);
                if (nextPosition < 0L) {
                    return false;
                }
                this.indexPosition = this.findFourccAndRead(1718776947, false, endPosition, true);
                this.indexPositionEnd = endPosition;
                this.indexForCountingOnly = true;
                this.totalFramesFromIndex = 0;
                nextPosition = this.findFourccAndRead(2019847785, false, endPosition, false);
                if (nextPosition > 0L && this.totalFramesFromIndex > this.dwTotalFrames) {
                    this.dwTotalFrames = this.totalFramesFromIndex;
                }
                this.indexForCountingOnly = false;
                return true;
            }
            case 1752331379: {
                int streamType = this.readInt();
                if (streamType != 1935960438) {
                    if (this.verbose) {
                        IJ.log("Non-video Stream '" + this.fourccString(streamType) + " skipped");
                    }
                    ++this.streamNumber;
                    return false;
                }
                this.readStreamHeader();
                return true;
            }
            case 1718776947: {
                this.readBitMapInfo(endPosition);
                return true;
            }
            case 808482921: 
            case 2019847785: {
                this.readAvi2Index(endPosition);
                return true;
            }
            case 829973609: {
                this.readOldFrameIndex(endPosition);
                return true;
            }
            case 1179011410: {
                this.readAVIX(endPosition);
                return true;
            }
            case 1769369453: {
                this.readMovieData(endPosition);
                return true;
            }
        }
        throw new Exception("Program error, type " + this.fourccString(fourcc));
    }

    void readAviHeader() throws Exception, IOException {
        this.dwMicroSecPerFrame = this.readInt();
        this.dwMaxBytesPerSec = this.readInt();
        this.dwReserved1 = this.readInt();
        this.dwFlags = this.readInt();
        this.dwTotalFrames = this.readInt();
        this.dwInitialFrames = this.readInt();
        this.dwStreams = this.readInt();
        this.dwSuggestedBufferSize = this.readInt();
        this.dwWidth = this.readInt();
        this.dwHeight = this.readInt();
        if (this.verbose) {
            IJ.log("AVI HEADER (avih):" + this.timeString());
            IJ.log("   dwMicroSecPerFrame=" + this.dwMicroSecPerFrame);
            IJ.log("   dwMaxBytesPerSec=" + this.dwMaxBytesPerSec);
            IJ.log("   dwReserved1=" + this.dwReserved1);
            IJ.log("   dwFlags=" + this.dwFlags);
            IJ.log("   dwTotalFrames=" + this.dwTotalFrames);
            IJ.log("   dwInitialFrames=" + this.dwInitialFrames);
            IJ.log("   dwStreams=" + this.dwStreams);
            IJ.log("   dwSuggestedBufferSize=" + this.dwSuggestedBufferSize);
            IJ.log("   dwWidth=" + this.dwWidth);
            IJ.log("   dwHeight=" + this.dwHeight);
        }
    }

    void readStreamHeader() throws Exception, IOException {
        this.fccStreamHandler = this.readInt();
        this.dwStreamFlags = this.readInt();
        this.dwPriorityLanguage = this.readInt();
        this.dwStreamInitialFrames = this.readInt();
        this.dwStreamScale = this.readInt();
        this.dwStreamRate = this.readInt();
        this.dwStreamStart = this.readInt();
        this.dwStreamLength = this.readInt();
        this.dwStreamSuggestedBufferSize = this.readInt();
        this.dwStreamQuality = this.readInt();
        this.dwStreamSampleSize = this.readInt();
        if (this.verbose) {
            IJ.log("VIDEO STREAM HEADER (strh):");
            IJ.log("   fccStreamHandler='" + this.fourccString(this.fccStreamHandler) + "'");
            IJ.log("   dwStreamFlags=" + this.dwStreamFlags);
            IJ.log("   wPriority,wLanguage=" + this.dwPriorityLanguage);
            IJ.log("   dwStreamInitialFrames=" + this.dwStreamInitialFrames);
            IJ.log("   dwStreamScale=" + this.dwStreamScale);
            IJ.log("   dwStreamRate=" + this.dwStreamRate);
            IJ.log("   dwStreamStart=" + this.dwStreamStart);
            IJ.log("   dwStreamLength=" + this.dwStreamLength);
            IJ.log("   dwStreamSuggestedBufferSize=" + this.dwStreamSuggestedBufferSize);
            IJ.log("   dwStreamQuality=" + this.dwStreamQuality);
            IJ.log("   dwStreamSampleSize=" + this.dwStreamSampleSize);
        }
        if (this.dwStreamSampleSize > 1) {
            throw new Exception("Video stream with " + this.dwStreamSampleSize + " (more than 1) frames/chunk not supported");
        }
        this.type0xdb = 1650733104 + (this.streamNumber << 8);
        this.type0xdc = 1667510320 + (this.streamNumber << 8);
    }

    private void readAvi2Index(long endPosition) throws Exception, IOException {
        short wLongsPerEntry = this.readShort();
        byte bIndexSubType = this.raFile.readByte();
        byte bIndexType = this.raFile.readByte();
        int nEntriesInUse = this.readInt();
        int dwChunkId = this.readInt();
        long qwBaseOffset = this.readLong();
        this.readInt();
        if (this.verbose) {
            String bIndexString = bIndexType == 1 ? ": AVI_INDEX_OF_CHUNKS" : (bIndexType == 0 ? ": AVI_INDEX_OF_INDEXES" : ": UNSUPPORTED");
            IJ.log("AVI 2 INDEX:");
            IJ.log("   wLongsPerEntry=" + wLongsPerEntry);
            IJ.log("   bIndexSubType=" + bIndexSubType);
            IJ.log("   bIndexType=" + bIndexType + bIndexString);
            IJ.log("   nEntriesInUse=" + nEntriesInUse);
            IJ.log("   dwChunkId='" + this.fourccString(dwChunkId) + "'");
            if (bIndexType == 1) {
                IJ.log("   qwBaseOffset=0x" + Long.toHexString(qwBaseOffset));
            }
        }
        if (bIndexType == 0) {
            if (wLongsPerEntry != 4) {
                return;
            }
            for (int i = 0; i < nEntriesInUse; ++i) {
                long qwOffset = this.readLong();
                int dwSize = this.readInt();
                int dwDuration = this.readInt();
                if (this.verbose) {
                    IJ.log("   indx entry: '" + this.fourccString(dwChunkId) + "' incl header " + this.posSizeString(qwOffset, dwSize) + this.timeString());
                }
                long nextIndxEntryPointer = this.raFile.getFilePointer();
                this.raFile.seek(qwOffset);
                this.findFourccAndRead(808482921, false, qwOffset + (long)dwSize, false);
                this.raFile.seek(nextIndxEntryPointer);
                if (this.frameNumber <= this.lastFrameToRead) {
                    continue;
                }
                break;
            }
        } else if (bIndexType == 1) {
            if (this.verbose) {
                IJ.log("readAvi2Index frameNumber=" + this.frameNumber + " firstFrame=" + this.firstFrame);
                if (this.indexForCountingOnly) {
                    IJ.log("<just counting frames, not interpreting index now>");
                }
            }
            if (wLongsPerEntry != 2) {
                return;
            }
            if (dwChunkId != this.type0xdb && dwChunkId != this.type0xdc) {
                if (this.verbose) {
                    IJ.log("INDEX ERROR: SKIPPED ix00, wrong stream number or type, should be " + this.fourccString(this.type0xdb) + " or " + this.fourccString(this.type0xdc));
                }
                return;
            }
            if (this.indexForCountingOnly) {
                this.totalFramesFromIndex += nEntriesInUse;
                return;
            }
            for (int i = 0; i < nEntriesInUse; ++i) {
                long dwOffset = (long)this.readInt() & 0xFFFFFFFFL;
                long pos = qwBaseOffset + dwOffset;
                int dwSize = this.readInt();
                if (this.isVirtual) {
                    IJ.showProgress((double)this.frameNumber / (double)this.lastFrameToRead);
                }
                if (this.frameNumber >= this.firstFrame && dwSize > 0) {
                    this.frameInfos.add(new long[]{pos, dwSize, (long)this.frameNumber * (long)this.dwMicroSecPerFrame});
                    if (this.verbose) {
                        IJ.log("movie data " + this.frameNumber + " '" + this.fourccString(dwChunkId) + "' " + this.posSizeString(pos, dwSize) + this.timeString());
                    }
                }
                ++this.frameNumber;
                if (this.frameNumber > this.lastFrameToRead) break;
            }
            if (this.verbose) {
                IJ.log("Index read up to frame " + (this.frameNumber - 1));
            }
        }
    }

    private void readOldFrameIndex(long endPosition) throws Exception, IOException {
        int offset = -1;
        int[] offsetsToTry = new int[]{0, (int)this.moviPosition};
        long lastFramePos = 0L;
        while (this.raFile.getFilePointer() + 16L <= endPosition) {
            long framePos;
            int dwChunkId = this.readInt();
            int dwFlags = this.readInt();
            int dwOffset = this.readInt();
            int dwSize = this.readInt();
            if (dwChunkId != this.type0xdb && dwChunkId != this.type0xdc || dwSize <= 0) continue;
            if (offset < 0) {
                long temp = this.raFile.getFilePointer();
                for (int i = 0; i < offsetsToTry.length; ++i) {
                    long pos = (long)(dwOffset + offsetsToTry[i]) & 0xFFFFFFFFL;
                    if (pos < this.moviPosition) continue;
                    this.raFile.seek(pos);
                    int chunkIdAtPos = this.readInt();
                    if (chunkIdAtPos != dwChunkId) continue;
                    offset = offsetsToTry[i];
                    break;
                }
                if (this.verbose) {
                    IJ.log("idx1: dwOffsets are w.r.t. 0x" + (offset < 0 ? " UNKONWN??" : Long.toHexString(offset)));
                }
                this.raFile.seek(temp);
                if (offset < 0) {
                    return;
                }
            }
            if (this.isOversizedAvi1) {
                for (framePos = ((long)dwOffset & 0xFFFFFFFFL) + (long)offset; framePos < lastFramePos; framePos += 0x100000000L) {
                }
            }
            lastFramePos = framePos;
            if (this.frameNumber >= this.firstFrame) {
                this.frameInfos.add(new long[]{framePos + 8L, dwSize, (long)this.frameNumber * (long)this.dwMicroSecPerFrame});
                if (this.verbose) {
                    IJ.log("idx1 movie data '" + this.fourccString(dwChunkId) + "' " + this.posSizeString(framePos, dwSize) + this.timeString());
                }
            }
            ++this.frameNumber;
            if (this.frameNumber <= this.lastFrameToRead) continue;
            break;
        }
        if (this.verbose) {
            IJ.log("Index read up to frame " + (this.frameNumber - 1));
        }
    }

    void readBitMapInfo(long endPosition) throws Exception, IOException {
        int bitCountTest;
        this.biSize = this.readInt();
        this.biWidth = this.readInt();
        this.biHeight = this.readInt();
        this.biPlanes = this.readShort();
        this.biBitCount = this.readShort();
        this.biCompression = this.readInt();
        this.biSizeImage = this.readInt();
        this.biXPelsPerMeter = this.readInt();
        this.biYPelsPerMeter = this.readInt();
        this.biClrUsed = this.readInt();
        this.biClrImportant = this.readInt();
        if (this.verbose) {
            IJ.log("   biSize=" + this.biSize);
            IJ.log("   biWidth=" + this.biWidth);
            IJ.log("   biHeight=" + this.biHeight);
            IJ.log("   biPlanes=" + this.biPlanes);
            IJ.log("   biBitCount=" + this.biBitCount);
            IJ.log("   biCompression=0x" + Integer.toHexString(this.biCompression) + " '" + this.fourccString(this.biCompression) + "'");
            IJ.log("   biSizeImage=" + this.biSizeImage);
            IJ.log("   biXPelsPerMeter=" + this.biXPelsPerMeter);
            IJ.log("   biYPelsPerMeter=" + this.biYPelsPerMeter);
            IJ.log("   biClrUsed=" + this.biClrUsed);
            IJ.log("   biClrImportant=" + this.biClrImportant);
        }
        int allowedBitCount = 0;
        boolean readPalette = false;
        switch (this.biCompression) {
            case 0: 
            case 541214546: 
            case 542589266: {
                this.dataCompression = 0;
                this.dataTopDown = this.biHeight < 0;
                allowedBitCount = 65576;
                readPalette = this.biBitCount <= 8;
                break;
            }
            case 538982489: 
            case 808466521: 
            case 1497715271: {
                this.dataTopDown = true;
                this.dataCompression = 0;
                allowedBitCount = 8;
                break;
            }
            case 540422489: 
            case 541870413: {
                this.dataCompression = 0;
                allowedBitCount = 16;
                break;
            }
            case 1448433985: {
                this.dataCompression = 1448433985;
                allowedBitCount = 32;
                break;
            }
            case 842151001: 
            case 0x59565955: {
                this.dataTopDown = true;
            }
            case 842150998: 
            case 1987410275: {
                this.dataCompression = 0x59565955;
                allowedBitCount = 16;
                break;
            }
            case 844715353: 
            case 1447974233: 
            case 0x56595559: {
                this.dataTopDown = true;
                this.dataCompression = 844715353;
                allowedBitCount = 16;
                break;
            }
            case 0x55595659: {
                this.dataTopDown = true;
                this.dataCompression = 0x55595659;
                allowedBitCount = 16;
                break;
            }
            case 808596553: 
            case 825382478: 
            case 842094158: 
            case 842094169: 
            case 1448433993: {
                this.dataCompression = this.dataCompression == 1448433993 ? 808596553 : this.biCompression;
                this.dataTopDown = this.biHeight > 0;
                this.isPlanarFormat = true;
                allowedBitCount = 12;
                break;
            }
            case 4: 
            case 1195724874: 
            case 1196444237: 
            case 1734701162: {
                this.dataCompression = 1734701162;
                this.variableLength = true;
                break;
            }
            case 5: 
            case 541544016: 
            case 543649392: {
                this.variableLength = true;
                this.dataCompression = 543649392;
                break;
            }
            default: {
                throw new Exception("Unsupported compression: " + Integer.toHexString(this.biCompression) + (this.biCompression >= 0x20202020 ? " '" + this.fourccString(this.biCompression) + "'" : ""));
            }
        }
        int n = bitCountTest = this.biBitCount == 24 ? 65536 : (int)this.biBitCount;
        if (allowedBitCount != 0 && (bitCountTest & allowedBitCount) == 0) {
            throw new Exception("Unsupported: " + this.biBitCount + " bits/pixel for compression '" + this.fourccString(this.biCompression) + "'");
        }
        if (this.biHeight < 0) {
            this.biHeight = -this.biHeight;
        }
        if (this.isPlanarFormat && ((this.biWidth & 1) != 0 || (this.biHeight & 1) != 0)) {
            throw new Exception("Odd size (" + this.biWidth + "x" + this.biHeight + ") unsupported with " + this.fourccString(this.biCompression) + " compression");
        }
        this.scanLineSize = this.isPlanarFormat ? this.biWidth * this.biBitCount / 8 : (this.biWidth * this.biBitCount + 31) / 32 * 4;
        long spaceForPalette = endPosition - this.raFile.getFilePointer();
        if (readPalette && this.biClrUsed == 0 && spaceForPalette != 0L) {
            this.biClrUsed = 1 << this.biBitCount;
        }
        if (this.verbose) {
            IJ.log("   > data compression=0x" + Integer.toHexString(this.dataCompression) + " '" + this.fourccString(this.dataCompression) + "'");
            IJ.log("   > palette colors=" + this.biClrUsed);
            IJ.log("   > scan line size=" + this.scanLineSize);
            IJ.log("   > data top down=" + this.dataTopDown);
        }
        if (readPalette && this.biClrUsed > 0) {
            if (this.verbose) {
                IJ.log("   Reading " + this.biClrUsed + " Palette colors: " + this.posSizeString(spaceForPalette));
            }
            if (spaceForPalette < (long)(this.biClrUsed * 4)) {
                throw new Exception("Not enough data (" + spaceForPalette + ") for palette of size " + this.biClrUsed * 4);
            }
            byte[] pr = new byte[this.biClrUsed];
            byte[] pg = new byte[this.biClrUsed];
            byte[] pb = new byte[this.biClrUsed];
            for (int i = 0; i < this.biClrUsed; ++i) {
                pb[i] = this.raFile.readByte();
                pg[i] = this.raFile.readByte();
                pr[i] = this.raFile.readByte();
                this.raFile.readByte();
            }
            this.cm = new IndexColorModel((int)this.biBitCount, this.biClrUsed, pr, pg, pb);
        }
    }

    void readMovieData(long endPosition) throws Exception, IOException {
        int type;
        if (this.verbose) {
            IJ.log("MOVIE DATA " + this.posSizeString(endPosition - this.raFile.getFilePointer()) + this.timeString() + "\nSearching for stream " + this.streamNumber + ": '" + this.fourccString(this.type0xdb) + "' or '" + this.fourccString(this.type0xdc) + "' chunks");
        }
        if (this.isVirtual) {
            if (this.frameInfos == null) {
                this.frameInfos = new Vector(this.lastFrameToRead);
            }
        } else if (this.stack == null) {
            this.stack = new ImageStack(this.dwWidth, this.biHeight);
        }
        while ((type = this.readType(endPosition)) != 0) {
            long size = (long)this.readInt() & 0xFFFFFFFFL;
            long pos = this.raFile.getFilePointer();
            long nextPos = pos + size;
            if (nextPos > endPosition && nextPos < this.fileSize - 8L && this.fileSize > 0x100000000L) {
                endPosition = this.fileSize;
            }
            if ((type == this.type0xdb || type == this.type0xdc) && size > 0L) {
                IJ.showProgress((double)this.frameNumber / (double)this.lastFrameToRead);
                if (this.verbose) {
                    IJ.log(this.frameNumber + " movie data '" + this.fourccString(type) + "' " + this.posSizeString(size) + this.timeString());
                }
                if (this.frameNumber >= this.firstFrame) {
                    if (this.isVirtual) {
                        this.frameInfos.add(new long[]{pos, size, this.frameNumber * this.dwMicroSecPerFrame});
                    } else {
                        Object pixels = this.readFrame(this.raFile, pos, (int)size);
                        String label = this.frameLabel(this.frameNumber * this.dwMicroSecPerFrame);
                        this.stack.addSlice(label, pixels);
                    }
                }
                ++this.frameNumber;
                if (this.frameNumber > this.lastFrameToRead) {
                    break;
                }
            } else if (this.verbose) {
                IJ.log("skipped '" + this.fourccString(type) + "' " + this.posSizeString(size));
            }
            if (nextPos > endPosition) break;
            this.raFile.seek(nextPos);
        }
    }

    private Object readFrame(RandomAccessFile rFile, long filePos, int size) throws Exception, IOException {
        rFile.seek(filePos);
        if (this.variableLength) {
            return this.readCompressedFrame(rFile, size);
        }
        return this.readFixedLengthFrame(rFile, size);
    }

    private Object readCompressedFrame(RandomAccessFile rFile, int size) throws Exception, IOException {
        raInputStream inputStream2 = new raInputStream(rFile, size, this.biCompression == 1196444237);
        BufferedImage bi = ImageIO.read(inputStream2);
        if (bi == null) {
            throw new Exception("can't read frame, ImageIO returns null");
        }
        int type = bi.getType();
        ImageProcessor ip = null;
        if (type == 10) {
            ip = new ByteProcessor(bi);
        } else if (type == 13) {
            this.cm = bi.getColorModel();
            ip = new ByteProcessor((Image)bi);
        } else {
            ip = new ColorProcessor(bi);
        }
        if (this.convertToGray) {
            ip = ip.convertToByte(false);
        }
        if (this.flipVertical) {
            ip.flipVertical();
        }
        if (ip.getWidth() != this.dwWidth || ip.getHeight() != this.biHeight) {
            ip = ip.resize(this.dwWidth, this.biHeight);
        }
        return ip.getPixels();
    }

    private Object readFixedLengthFrame(RandomAccessFile rFile, int size) throws Exception, IOException {
        byte[] rawData;
        int n;
        if (size < this.scanLineSize * this.biHeight) {
            size = this.scanLineSize * this.biHeight;
        }
        if ((n = rFile.read(rawData = new byte[size], 0, size)) < rawData.length) {
            throw new Exception("Frame ended prematurely after " + n + " bytes");
        }
        boolean topDown = this.flipVertical ? !this.dataTopDown : this.dataTopDown;
        Object[] pixels = null;
        byte[] bPixels = null;
        int[] cPixels = null;
        short[] sPixels = null;
        if (this.biBitCount <= 8 || this.convertToGray) {
            pixels = bPixels = new byte[this.dwWidth * this.biHeight];
        } else if (this.biBitCount == 16 && this.dataCompression == 0) {
            sPixels = new short[this.dwWidth * this.biHeight];
            pixels = sPixels;
        } else {
            cPixels = new int[this.dwWidth * this.biHeight];
            pixels = cPixels;
        }
        if (this.isPlanarFormat && !this.convertToGray) {
            this.unpackPlanarImage(rawData, cPixels, topDown);
        } else {
            int offset = topDown ? 0 : (this.biHeight - 1) * this.dwWidth;
            int rawOffset = 0;
            for (int i = this.biHeight - 1; i >= 0; --i) {
                if (this.biBitCount <= 8 || this.isPlanarFormat) {
                    this.unpack8bit(rawData, rawOffset, bPixels, offset, this.dwWidth);
                } else if (this.convertToGray) {
                    this.unpackGray(rawData, rawOffset, bPixels, offset, this.dwWidth);
                } else if (this.biBitCount == 16 && this.dataCompression == 0) {
                    this.unpackShort(rawData, rawOffset, sPixels, offset, this.dwWidth);
                } else {
                    this.unpack(rawData, rawOffset, cPixels, offset, this.dwWidth);
                }
                rawOffset += this.isPlanarFormat ? this.dwWidth : this.scanLineSize;
                offset += topDown ? this.dwWidth : -this.dwWidth;
            }
        }
        return pixels;
    }

    void unpack8bit(byte[] rawData, int rawOffset, byte[] pixels, int byteOffset, int w) {
        for (int i = 0; i < w; ++i) {
            pixels[byteOffset + i] = rawData[rawOffset + i];
        }
    }

    void unpackGray(byte[] rawData, int rawOffset, byte[] pixels, int byteOffset, int w) {
        int j = byteOffset;
        int k = rawOffset;
        if (this.dataCompression == 0) {
            for (int i = 0; i < w; ++i) {
                int b0 = rawData[k++] & 0xFF;
                int b1 = rawData[k++] & 0xFF;
                int b2 = rawData[k++] & 0xFF;
                if (this.biBitCount == 32) {
                    ++k;
                }
                pixels[j++] = (byte)(b0 * 934 + b1 * 4809 + b2 * 2449 + 4096 >> 13);
            }
        } else {
            if (this.dataCompression == 0x59565955 || this.dataCompression == 1448433985) {
                ++k;
            }
            int step = this.dataCompression == 1448433985 ? 4 : 2;
            for (int i = 0; i < w; ++i) {
                pixels[j++] = rawData[k];
                k += step;
            }
        }
    }

    void unpackShort(byte[] rawData, int rawOffset, short[] pixels, int shortOffset, int w) {
        int j = shortOffset;
        int k = rawOffset;
        for (int i = 0; i < w; ++i) {
            pixels[j++] = (short)(rawData[k++] & 0xFF | (rawData[k++] & 0xFF) << 8);
        }
    }

    void unpack(byte[] rawData, int rawOffset, int[] pixels, int intOffset, int w) {
        int j = intOffset;
        int k = rawOffset;
        switch (this.dataCompression) {
            case 0: {
                for (int i = 0; i < w; ++i) {
                    int b0 = rawData[k++] & 0xFF;
                    int b1 = (rawData[k++] & 0xFF) << 8;
                    int b2 = (rawData[k++] & 0xFF) << 16;
                    if (this.biBitCount == 32) {
                        ++k;
                    }
                    pixels[j++] = 0xFF000000 | b0 | b1 | b2;
                }
                break;
            }
            case 844715353: {
                for (int i = 0; i < w / 2; ++i) {
                    int y0 = rawData[k++] & 0xFF;
                    int u = rawData[k++] ^ 0xFFFFFF80;
                    int y1 = rawData[k++] & 0xFF;
                    int v = rawData[k++] ^ 0xFFFFFF80;
                    this.writeRGBfromYUV(y0, u, v, pixels, j++);
                    this.writeRGBfromYUV(y1, u, v, pixels, j++);
                }
                break;
            }
            case 0x59565955: {
                for (int i = 0; i < w / 2; ++i) {
                    int u = rawData[k++] ^ 0xFFFFFF80;
                    int y0 = rawData[k++] & 0xFF;
                    int v = rawData[k++] ^ 0xFFFFFF80;
                    int y1 = rawData[k++] & 0xFF;
                    this.writeRGBfromYUV(y0, u, v, pixels, j++);
                    this.writeRGBfromYUV(y1, u, v, pixels, j++);
                }
                break;
            }
            case 0x55595659: {
                for (int i = 0; i < w / 2; ++i) {
                    int y0 = rawData[k++] & 0xFF;
                    int v = rawData[k++] ^ 0xFFFFFF80;
                    int y1 = rawData[k++] & 0xFF;
                    int u = rawData[k++] ^ 0xFFFFFF80;
                    this.writeRGBfromYUV(y0, u, v, pixels, j++);
                    this.writeRGBfromYUV(y1, u, v, pixels, j++);
                }
                break;
            }
            case 1448433985: {
                for (int i = 0; i < w; ++i) {
                    int n = ++k;
                    int y = rawData[n] & 0xFF;
                    int n2 = ++k;
                    int v = rawData[n2] ^ 0xFFFFFF80;
                    int n3 = ++k;
                    ++k;
                    int u = rawData[n3] ^ 0xFFFFFF80;
                    this.writeRGBfromYUV(y, u, v, pixels, j++);
                }
                break;
            }
        }
    }

    void unpackPlanarImage(byte[] rawData, int[] cPixels, boolean topDown) {
        int uvInc;
        int w = this.dwWidth;
        int h2 = this.dwHeight;
        int uP = w * h2;
        int vP = w * h2;
        int n = uvInc = this.dataCompression == 842094158 || this.dataCompression == 825382478 ? 2 : 1;
        if (this.dataCompression == 842094169) {
            uP += w * h2 / 4;
        } else if (this.dataCompression == 808596553) {
            vP += w * h2 / 4;
        } else if (this.dataCompression == 842094158) {
            ++vP;
        } else {
            ++uP;
        }
        int lineOutInc = topDown ? w : -w;
        for (int line = 0; line < h2; line += 2) {
            int pRaw0 = line * w;
            int pRawEnd = pRaw0 + w;
            int pOut = topDown ? line * w : (h2 - line - 1) * w;
            int pRaw = pRaw0;
            while (pRaw < pRawEnd) {
                int u = rawData[uP] ^ 0xFFFFFF80;
                int v = rawData[vP] ^ 0xFFFFFF80;
                this.writeRGBfromYUV(rawData[pRaw] & 0xFF, u, v, cPixels, pOut);
                this.writeRGBfromYUV(rawData[pRaw + w] & 0xFF, u, v, cPixels, pOut + lineOutInc);
                this.writeRGBfromYUV(rawData[++pRaw] & 0xFF, u, v, cPixels, ++pOut);
                this.writeRGBfromYUV(rawData[pRaw + w] & 0xFF, u, v, cPixels, pOut + lineOutInc);
                ++pRaw;
                ++pOut;
                uP += uvInc;
                vP += uvInc;
            }
        }
    }

    final void writeRGBfromYUV(int y, int u, int v, int[] pixels, int intArrayIndex) {
        int r = 9535 * y + 13074 * v - 148464 >> 13;
        int g2 = 9535 * y - 6660 * v - 3203 * u - 148464 >> 13;
        int b = 9535 * y + 16531 * u - 148464 >> 13;
        if (r > 255) {
            r = 255;
        }
        if (r < 0) {
            r = 0;
        }
        if (g2 > 255) {
            g2 = 255;
        }
        if (g2 < 0) {
            g2 = 0;
        }
        if (b > 255) {
            b = 255;
        }
        if (b < 0) {
            b = 0;
        }
        pixels[intArrayIndex] = 0xFF000000 | r << 16 | g2 << 8 | b;
    }

    final long readLong() throws IOException {
        long low = (long)this.readInt() & 0xFFFFFFFFL;
        long high = (long)this.readInt() & 0xFFFFFFFFL;
        long result = high << 32 | low;
        return result;
    }

    final int readInt() throws IOException {
        int result = 0;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            result |= (this.raFile.readByte() & 0xFF) << shiftBy;
        }
        return result;
    }

    final short readShort() throws IOException {
        int low = this.raFile.readByte() & 0xFF;
        int high = this.raFile.readByte() & 0xFF;
        return (short)(high << 8 | low);
    }

    private int readType(long endPosition) throws IOException {
        while (true) {
            long pos;
            if ((pos = this.raFile.getFilePointer()) % (long)this.paddingGranularity != 0L) {
                pos = (pos / (long)this.paddingGranularity + 1L) * (long)this.paddingGranularity;
                this.raFile.seek(pos);
            }
            if (pos >= endPosition) {
                return 0;
            }
            int type = this.readInt();
            if (type != 1263424842) {
                return type;
            }
            long size = (long)this.readInt() & 0xFFFFFFFFL;
            if (this.verbose) {
                IJ.log("Skip JUNK: " + this.posSizeString(size));
            }
            this.raFile.seek(this.raFile.getFilePointer() + size);
        }
    }

    private void setFramesPerSecond(ImagePlus imp) {
        if (this.dwMicroSecPerFrame < 1000 && this.dwStreamRate > 0) {
            this.dwMicroSecPerFrame = (int)((double)this.dwStreamScale * 1000000.0 / (double)this.dwStreamRate);
        }
        if (this.dwMicroSecPerFrame >= 1000) {
            imp.getCalibration().fps = 1000000.0 / (double)this.dwMicroSecPerFrame;
        }
    }

    private String frameLabel(long timeMicroSec) {
        return IJ.d2s((double)timeMicroSec / 1000000.0) + " s";
    }

    private String posSizeString(long size) throws IOException {
        return this.posSizeString(this.raFile.getFilePointer(), size);
    }

    private String posSizeString(long pos, long size) {
        return "0x" + Long.toHexString(pos) + "-0x" + Long.toHexString(pos + size - 1L) + " (" + size + " Bytes)";
    }

    private String timeString() {
        return " (t=" + (System.currentTimeMillis() - this.startTime) + " ms)";
    }

    private String fourccString(int fourcc) {
        String s2 = "";
        for (int i = 0; i < 4; ++i) {
            int c = fourcc & 0xFF;
            s2 = s2 + Character.toString((char)c);
            fourcc >>= 8;
        }
        return s2;
    }

    private void closeFile(RandomAccessFile rFile) {
        if (rFile != null) {
            try {
                rFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void error(String msg) {
        this.aborting = true;
        IJ.error("AVI Reader", msg);
    }

    private String exceptionMessage(Exception e) {
        String msg = e.getClass() == Exception.class ? e.getMessage() : e + "\n" + e.getStackTrace()[0] + "\n" + e.getStackTrace()[1];
        return "An error occurred reading the AVI file.\n \n" + msg;
    }

    public void displayDialog(boolean displayDialog) {
        this.displayDialog = displayDialog;
    }

    public void setVirtual(boolean virtual) {
        this.isVirtual = virtual;
    }

    static {
        staticIsVirtual = true;
        HUFFMAN_TABLES = new byte[]{-1, -60, 1, -94, 0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 1, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 16, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125, 1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, -127, -111, -95, 8, 35, 66, -79, -63, 21, 82, -47, -16, 36, 51, 98, 114, -126, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, 17, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119, 0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, -127, 8, 20, 66, -111, -95, -79, -63, 9, 35, 51, 82, -16, 21, 98, 114, -47, 10, 22, 36, 52, -31, 37, -15, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -126, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -30, -29, -28, -27, -26, -25, -24, -23, -22, -14, -13, -12, -11, -10, -9, -8, -7, -6};
    }

    class raInputStream
    extends InputStream {
        RandomAccessFile rFile;
        int readableSize;
        boolean fixMJPG;
        byte[] buffer;
        int bufferPointer;
        int bufferLength;

        raInputStream(RandomAccessFile rFile, int readableSize, boolean fixMJPG) throws IOException {
            this.rFile = rFile;
            this.readableSize = readableSize;
            this.fixMJPG = fixMJPG;
            if (fixMJPG) {
                this.buffer = new byte[4096];
                this.bufferLength = Math.min(3676, readableSize);
                this.bufferLength = rFile.read(this.buffer, 0, this.bufferLength);
                this.addHuffmanTables();
            }
        }

        @Override
        public int available() {
            return this.readableSize;
        }

        @Override
        public int read() throws IOException {
            --this.readableSize;
            if (this.fixMJPG) {
                int result = this.buffer[this.bufferPointer] & 0xFF;
                ++this.bufferPointer;
                if (this.bufferPointer >= this.bufferLength) {
                    this.fixMJPG = false;
                }
                return result;
            }
            return this.rFile.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int nBytes;
            if (this.fixMJPG) {
                nBytes = Math.min(len, this.bufferLength - this.bufferPointer);
                System.arraycopy(this.buffer, this.bufferPointer, b, off, nBytes);
                this.bufferPointer += nBytes;
                if (this.bufferPointer >= this.bufferLength) {
                    this.fixMJPG = false;
                    if (len - nBytes > 0) {
                        nBytes += this.rFile.read(b, off + nBytes, len - nBytes);
                    }
                }
            } else {
                nBytes = this.rFile.read(b, off, len);
            }
            this.readableSize -= nBytes;
            return nBytes;
        }

        private void addHuffmanTables() {
            if (this.readShort(0) != 65496 || this.bufferLength < 6) {
                return;
            }
            int offset = 2;
            int segmentLength = 0;
            do {
                int code;
                if ((code = this.readShort(offset)) == 65476) {
                    return;
                }
                if (code == 65498 || code == 65497) {
                    this.insertHuffmanTables(offset);
                    return;
                }
                offset += 2;
            } while ((offset += (segmentLength = this.readShort(offset))) < this.bufferLength - 4 && segmentLength >= 0);
        }

        private int readShort(int offset) {
            return (this.buffer[offset] & 0xFF) << 8 | this.buffer[offset + 1] & 0xFF;
        }

        private void insertHuffmanTables(int position) {
            System.arraycopy(this.buffer, position, this.buffer, position + 420, this.bufferLength - position);
            System.arraycopy(HUFFMAN_TABLES, 0, this.buffer, position, 420);
            this.bufferLength += 420;
            this.readableSize += 420;
        }
    }
}

