/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.DicomDecoder;
import ij.plugin.DicomDictionary;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class DICOM
extends ImagePlus
implements PlugIn {
    private boolean showErrors = true;
    private boolean gettingInfo;
    private BufferedInputStream inputStream;
    private String info;

    public DICOM() {
    }

    public DICOM(InputStream is) {
        this(new BufferedInputStream(is));
    }

    public DICOM(BufferedInputStream bis) {
        this.inputStream = bis;
    }

    @Override
    public void run(String arg) {
        FileInfo fi;
        DicomDecoder dd;
        String fileName;
        block23: {
            OpenDialog od = new OpenDialog("Open Dicom...", arg);
            String directory = od.getDirectory();
            fileName = od.getFileName();
            if (fileName == null) {
                return;
            }
            dd = new DicomDecoder(directory, fileName);
            dd.inputStream = this.inputStream;
            fi = null;
            try {
                fi = dd.getFileInfo();
            }
            catch (IOException e) {
                String msg = e.getMessage();
                IJ.showStatus("");
                if (msg.indexOf("EOF") < 0 && this.showErrors) {
                    IJ.error("DICOM Reader", e.getClass().getName() + "\n \n" + msg);
                    return;
                }
                if (dd.dicmFound() || !this.showErrors) break block23;
                msg = "This does not appear to be a valid\nDICOM file. It does not have the\ncharacters 'DICM' at offset 128.";
                IJ.error("DICOM Reader", msg);
                return;
            }
        }
        if (this.gettingInfo) {
            this.info = dd.getDicomInfo();
            return;
        }
        if (fi != null && fi.width > 0 && fi.height > 0 && fi.offset > 0) {
            double[] coeff;
            FileOpener fo = new FileOpener(fi);
            ImagePlus imp = fo.openImage();
            boolean openAsFloat = dd.rescaleSlope != 1.0 && !Prefs.ignoreRescaleSlope && !Prefs.fixedDicomScaling || Prefs.openDicomsAsFloat;
            String options = Macro.getOptions();
            if (openAsFloat) {
                IJ.run(imp, "32-bit", "");
                if (dd.rescaleSlope != 1.0) {
                    IJ.run(imp, "Multiply...", "value=" + dd.rescaleSlope + " stack");
                }
                if (dd.rescaleIntercept != 0.0) {
                    IJ.run(imp, "Add...", "value=" + dd.rescaleIntercept + " stack");
                }
                if (imp.getStackSize() > 1) {
                    imp.setSlice(imp.getStackSize() / 2);
                    ImageStatistics stats = imp.getRawStatistics();
                    imp.setDisplayRange(stats.min, stats.max);
                }
            } else if (fi.fileType == 1) {
                if (dd.rescaleIntercept != 0.0 && (dd.rescaleSlope == 1.0 || Prefs.fixedDicomScaling)) {
                    coeff = new double[]{dd.rescaleSlope * -32768.0 + dd.rescaleIntercept, dd.rescaleSlope};
                    imp.getCalibration().setFunction(0, coeff, "Gray Value");
                }
            } else if (dd.rescaleIntercept != 0.0 && (dd.rescaleSlope == 1.0 || Prefs.fixedDicomScaling || fi.fileType == 0)) {
                coeff = new double[]{dd.rescaleIntercept, dd.rescaleSlope};
                imp.getCalibration().setFunction(0, coeff, "Gray Value");
            }
            Macro.setOptions(options);
            if (dd.windowWidth > 0.0) {
                double min2 = dd.windowCenter - dd.windowWidth / 2.0;
                double max = dd.windowCenter + dd.windowWidth / 2.0;
                if (!openAsFloat) {
                    Calibration cal = imp.getCalibration();
                    min2 = cal.getRawValue(min2);
                    max = cal.getRawValue(max);
                }
                ImageProcessor ip = imp.getProcessor();
                ip.setMinAndMax(min2, max);
                if (IJ.debugMode) {
                    IJ.log("window: " + min2 + "-" + max);
                }
            }
            if (imp.getStackSize() > 1) {
                this.setStack(fileName, imp.getStack());
            } else {
                this.setProcessor(fileName, imp.getProcessor());
            }
            this.setCalibration(imp.getCalibration());
            this.setProperty("Info", dd.getDicomInfo());
            this.setFileInfo(fi);
            if (arg.equals("")) {
                this.show();
            }
        } else if (this.showErrors) {
            IJ.error("DICOM Reader", "Unable to decode DICOM header.");
        }
        IJ.showStatus("");
    }

    public void open(String path) {
        this.showErrors = false;
        this.run(path);
    }

    public String getInfo(String path) {
        this.showErrors = false;
        this.gettingInfo = true;
        this.run(path);
        return this.info;
    }

    void convertToUnsigned(ImagePlus imp, FileInfo fi) {
        int i;
        ImageProcessor ip = imp.getProcessor();
        short[] pixels = (short[])ip.getPixels();
        int min2 = Integer.MAX_VALUE;
        for (i = 0; i < pixels.length; ++i) {
            int value = pixels[i] & 0xFFFF;
            if (value >= min2) continue;
            min2 = value;
        }
        if (IJ.debugMode) {
            IJ.log("min: " + (min2 - 32768));
        }
        if (min2 >= 32768) {
            for (i = 0; i < pixels.length; ++i) {
                pixels[i] = (short)(pixels[i] - 32768);
            }
            ip.resetMinAndMax();
            Calibration cal = imp.getCalibration();
            cal.setFunction(20, null, "Gray Value");
            fi.fileType = 2;
        }
    }

    public static String getTagName(String id) {
        id = id.replaceAll(",", "");
        DicomDictionary d = new DicomDictionary();
        Properties dictionary = d.getDictionary();
        String name = (String)dictionary.get(id);
        if (name != null) {
            name = name.substring(2);
        }
        return name;
    }
}

