/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.VirtualStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.io.TiffDecoder;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class FileInfoVirtualStack
extends VirtualStack
implements PlugIn {
    private FileInfo[] info;
    private int nImages;

    public FileInfoVirtualStack() {
    }

    public FileInfoVirtualStack(FileInfo fi) {
        this.info = new FileInfo[1];
        this.info[0] = fi;
        ImagePlus imp = this.open();
        if (imp != null) {
            imp.show();
        }
    }

    public FileInfoVirtualStack(FileInfo fi, boolean show) {
        this.info = new FileInfo[1];
        this.info[0] = fi;
        ImagePlus imp = this.open();
        if (imp != null && show) {
            imp.show();
        }
    }

    public FileInfoVirtualStack(FileInfo[] fi) {
        this.info = fi;
        this.nImages = this.info.length;
    }

    public static ImagePlus openVirtual(String path) {
        OpenDialog od = new OpenDialog("Open TIFF", path);
        String name = od.getFileName();
        String dir = od.getDirectory();
        if (name == null) {
            return null;
        }
        FileInfoVirtualStack stack = new FileInfoVirtualStack();
        stack.init(dir, name);
        if (stack.info == null) {
            return null;
        }
        return stack.open();
    }

    @Override
    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open TIFF", arg);
        String name = od.getFileName();
        String dir = od.getDirectory();
        if (name == null) {
            return;
        }
        this.init(dir, name);
        if (this.info == null) {
            return;
        }
        ImagePlus imp = this.open();
        if (imp != null) {
            imp.show();
        }
    }

    private void init(String dir, String name) {
        if (name.endsWith(".zip")) {
            IJ.error("Virtual Stack", "ZIP compressed stacks not supported");
            return;
        }
        TiffDecoder td = new TiffDecoder(dir, name);
        if (IJ.debugMode) {
            td.enableDebugging();
        }
        IJ.showStatus("Decoding TIFF header...");
        try {
            this.info = td.getTiffInfo();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.error("TiffDecoder", msg);
            return;
        }
        if (this.info == null || this.info.length == 0) {
            IJ.error("Virtual Stack", "This does not appear to be a TIFF stack");
            return;
        }
        if (IJ.debugMode) {
            IJ.log(this.info[0].debugInfo);
        }
    }

    private ImagePlus open() {
        FileInfo fi = this.info[0];
        int n = fi.nImages;
        if (this.info.length == 1 && n > 1) {
            long bytesPerImage = fi.width * fi.height * fi.getBytesPerPixel();
            if (fi.fileType == 13) {
                bytesPerImage = (int)(1.5 * (double)fi.width) * fi.height;
            }
            n = this.validateNImages(fi, bytesPerImage);
            this.info = new FileInfo[n];
            for (int i = 0; i < n; ++i) {
                this.info[i] = (FileInfo)fi.clone();
                this.info[i].nImages = 1;
                this.info[i].longOffset = fi.getOffset() + (long)i * (bytesPerImage + fi.getGap());
            }
        }
        this.nImages = this.info.length;
        FileOpener fo = new FileOpener(this.info[0]);
        ImagePlus imp = fo.openImage();
        if (this.nImages == 1 && fi.fileType == 12) {
            return imp;
        }
        Properties props = fo.decodeDescriptionString(fi);
        ImagePlus imp2 = new ImagePlus(fi.fileName, this);
        imp2.setDisplayRange(imp.getDisplayRangeMin(), imp.getDisplayRangeMax());
        imp2.setFileInfo(fi);
        if (imp != null && props != null) {
            int frames;
            int slices;
            int channels;
            this.setBitDepth(imp.getBitDepth());
            imp2.setCalibration(imp.getCalibration());
            imp2.setOverlay(imp.getOverlay());
            if (fi.info != null) {
                imp2.setProperty("Info", fi.info);
            }
            if ((channels = this.getInt(props, "channels")) * (slices = this.getInt(props, "slices")) * (frames = this.getInt(props, "frames")) == this.nImages) {
                imp2.setDimensions(channels, slices, frames);
                if (this.getBoolean(props, "hyperstack")) {
                    imp2.setOpenAsHyperStack(true);
                }
            }
            if (channels > 1 && fi.description != null) {
                int mode = 1;
                if (fi.description.indexOf("mode=color") != -1) {
                    mode = 2;
                } else if (fi.description.indexOf("mode=gray") != -1) {
                    mode = 3;
                }
                imp2 = new CompositeImage(imp2, mode);
            }
        }
        return imp2;
    }

    private int validateNImages(FileInfo fi, long bytesPerImage) {
        File f = new File(fi.getFilePath());
        if (!f.exists()) {
            return fi.nImages;
        }
        long fileLength = f.length();
        for (int i = fi.nImages - 1; i >= 0; --i) {
            long offset = fi.getOffset() + (long)i * (bytesPerImage + fi.getGap());
            if (offset + bytesPerImage > fileLength) continue;
            return i + 1;
        }
        return fi.nImages;
    }

    int getInt(Properties props, String key) {
        Double n = this.getNumber(props, key);
        return n != null ? (int)n.doubleValue() : 1;
    }

    Double getNumber(Properties props, String key) {
        String s2 = props.getProperty(key);
        if (s2 != null) {
            try {
                return Double.valueOf(s2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    boolean getBoolean(Properties props, String key) {
        String s2 = props.getProperty(key);
        return s2 != null && s2.equals("true");
    }

    @Override
    public void deleteSlice(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.nImages < 1) {
            return;
        }
        for (int i = n; i < this.nImages; ++i) {
            this.info[i - 1] = this.info[i];
        }
        this.info[this.nImages - 1] = null;
        --this.nImages;
    }

    @Override
    public ImageProcessor getProcessor(int n) {
        if ((n = this.translate(n)) < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        this.info[n - 1].nImages = 1;
        ImageProcessor ip = null;
        if (IJ.debugMode) {
            long t0 = System.currentTimeMillis();
            FileOpener fo = new FileOpener(this.info[n - 1]);
            ip = fo.openProcessor();
            IJ.log("FileInfoVirtualStack: " + n + ", offset=" + this.info[n - 1].getOffset() + ", " + (System.currentTimeMillis() - t0) + "ms");
        } else {
            FileOpener fo = new FileOpener(this.info[n - 1]);
            if (this.info[n - 1].fileType == 12) {
                ImagePlus imp = fo.openImage();
                if (this.info[n - 1].sliceNumber > 0) {
                    imp.setSlice(this.info[n - 1].sliceNumber);
                }
                ip = imp.getProcessor();
            } else {
                ip = fo.openProcessor();
            }
        }
        if (ip != null) {
            if (this.cTable != null) {
                ip.setCalibrationTable(this.cTable);
            }
            return ip;
        }
        int w = this.getWidth();
        int h2 = this.getHeight();
        IJ.log("Read error or file not found (" + n + "): " + this.info[n - 1].directory + this.info[n - 1].fileName);
        switch (this.getBitDepth()) {
            case 8: {
                return new ByteProcessor(w, h2);
            }
            case 16: {
                return new ShortProcessor(w, h2);
            }
            case 24: {
                return new ColorProcessor(w, h2);
            }
            case 32: {
                return new FloatProcessor(w, h2);
            }
        }
        return null;
    }

    @Override
    public int size() {
        return this.getSize();
    }

    @Override
    public int getSize() {
        return this.nImages;
    }

    @Override
    public String getSliceLabel(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.info[0].sliceLabels == null || this.info[0].sliceLabels.length != this.nImages) {
            return null;
        }
        return this.info[0].sliceLabels[n - 1];
    }

    @Override
    public int getWidth() {
        return this.info[0].width;
    }

    @Override
    public int getHeight() {
        return this.info[0].height;
    }

    public synchronized void addImage(FileInfo fileInfo) {
        ++this.nImages;
        if (this.info == null) {
            this.info = new FileInfo[250];
        }
        if (this.nImages == this.info.length) {
            FileInfo[] tmp = new FileInfo[this.nImages * 2];
            System.arraycopy(this.info, 0, tmp, 0, this.nImages);
            this.info = tmp;
        }
        this.info[this.nImages - 1] = fileInfo;
    }

    @Override
    public String getDirectory() {
        if (this.info != null && this.info.length > 0) {
            return this.info[0].directory;
        }
        return null;
    }

    @Override
    public String getFileName(int n) {
        int index = n - 1;
        if (index >= 0 && this.info != null && this.info.length > index) {
            return this.info[index].fileName;
        }
        return null;
    }
}

