/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.VirtualStack;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.plugin.FileInfoVirtualStack;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.util.DicomTools;
import ij.util.StringSorter;
import ij.util.Tools;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.image.ColorModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;

public class FolderOpener
implements PlugIn,
TextListener {
    private static final int MAX_SEPARATE = 100;
    private static final String DIR_KEY = "import.sequence.dir";
    private static final String[] types = new String[]{"default", "16-bit", "32-bit", "RGB"};
    private static String[] excludedTypes = new String[]{".txt", ".lut", ".roi", ".pty", ".hdr", ".java", ".ijm", ".py", ".js", ".bsh", ".xml", ".rar", ".h5", ".doc", ".xls"};
    private static boolean staticSortFileNames = true;
    private static boolean staticOpenAsVirtualStack;
    private boolean convertToGrayscale;
    private boolean sortFileNames = true;
    private boolean sortByMetaData = true;
    private boolean openAsVirtualStack;
    private String directory;
    private boolean directorySet;
    private String filter;
    private String legacyRegex;
    private FileInfo fi;
    private String info1;
    private ImagePlus image;
    private boolean saveImage;
    private long t0;
    private int stackWidth;
    private int stackHeight;
    private int bitDepth;
    private int defaultBitDepth;
    private int nFiles = 0;
    private int start = 1;
    private int step = 1;
    private double scale = 100.0;
    private boolean openAsSeparateImages;
    private boolean runningOpen;
    private TextField dirField;
    private TextField filterField;
    private TextField startField;
    private TextField countField;
    private TextField stepField;

    public static ImagePlus open(String path) {
        return FolderOpener.open(path, null);
    }

    public static ImagePlus open(String path, String options) {
        FolderOpener fo = new FolderOpener();
        fo.saveImage = true;
        fo.setOptions(options);
        fo.run(path);
        return fo.image;
    }

    public static ImagePlus open(String path, int width, int height, String options) {
        FolderOpener fo = new FolderOpener();
        fo.saveImage = true;
        fo.stackWidth = width;
        fo.stackHeight = height;
        fo.setOptions(options);
        fo.run(path);
        return fo.image;
    }

    private void setOptions(String options) {
        if (options == null) {
            return;
        }
        boolean bl = this.openAsVirtualStack = options.contains("virtual") || options.contains("use");
        if (options.contains("noMetaSort")) {
            this.sortByMetaData = false;
        }
        this.bitDepth = (int)Tools.getNumberFromList(options, "bitdepth=", 0.0);
        this.filter = Macro.getValue(options, "filter", "");
        this.start = (int)Tools.getNumberFromList(options, "start=", 1.0);
        this.step = (int)Tools.getNumberFromList(options, "step=", 1.0);
        this.scale = Tools.getNumberFromList(options, "scale=", 100.0);
        this.nFiles = (int)Tools.getNumberFromList(options, "count=", 0.0);
        if (options.contains(" open")) {
            this.openAsSeparateImages = true;
            this.openAsVirtualStack = true;
            this.saveImage = false;
            this.runningOpen = true;
        }
    }

    public ImagePlus openFolder(String path) {
        this.saveImage = true;
        this.run(path);
        return this.image;
    }

    @Override
    public void run(String arg) {
        Overlay overlay;
        boolean allSameCalibration;
        Calibration cal;
        double max;
        double min2;
        ImageStack stack;
        String title;
        String[] list;
        block110: {
            int index;
            boolean isMacro;
            boolean bl = isMacro = Macro.getOptions() != null;
            if (!this.directorySet) {
                this.directory = null;
            }
            if (arg != null && !arg.equals("")) {
                this.directory = arg;
            } else {
                if (!isMacro) {
                    this.sortFileNames = staticSortFileNames;
                    this.openAsVirtualStack = staticOpenAsVirtualStack;
                }
                arg = null;
                String macroOptions = Macro.getOptions();
                if (macroOptions != null) {
                    this.legacyRegex = Macro.getValue(macroOptions, "or", "");
                    if (this.legacyRegex.equals("")) {
                        this.legacyRegex = null;
                    }
                }
            }
            if (arg == null && !this.showDialog()) {
                return;
            }
            if (this.directory == null || this.directory.length() == 0) {
                this.error("No directory specified.     ");
                return;
            }
            File file2 = new File(this.directory);
            list = file2.list();
            if (list == null) {
                String parent = file2.getParent();
                if (parent != null) {
                    file2 = new File(parent);
                    list = file2.list();
                }
                if (list != null) {
                    this.directory = parent;
                } else {
                    this.error("Directory not found: " + this.directory);
                    return;
                }
            }
            if (!this.directory.endsWith("/") && !this.directory.endsWith("\\")) {
                this.directory = this.directory + "/";
            }
            if (arg == null && !isMacro) {
                Prefs.set(DIR_KEY, this.directory);
            }
            ArrayList<String> fileList = new ArrayList<String>();
            for (int i = 0; i < list.length; ++i) {
                File f = new File(this.directory + list[i]);
                if (f.isDirectory()) continue;
                fileList.add(list[i]);
            }
            if (fileList.size() < list.length) {
                list = fileList.toArray(new String[fileList.size()]);
            }
            if ((title = this.directory).endsWith(File.separator) || title.endsWith("/")) {
                title = title.substring(0, title.length() - 1);
            }
            if ((index = title.lastIndexOf(File.separatorChar)) != -1) {
                title = title.substring(index + 1);
            } else {
                index = title.lastIndexOf("/");
                if (index != -1) {
                    title = title.substring(index + 1);
                }
            }
            if (title.endsWith(":")) {
                title = title.substring(0, title.length() - 1);
            }
            if ((list = this.trimFileList(list)) == null) {
                return;
            }
            String pluginName = "Sequence Reader";
            if (this.legacyRegex != null) {
                pluginName = pluginName + "(legacy)";
            }
            if ((list = FolderOpener.getFilteredList(list, this.filter, pluginName)) == null) {
                return;
            }
            if (this.sortFileNames || IJ.isMacOSX()) {
                list = StringSorter.sortNumerically(list);
            }
            if (IJ.debugMode) {
                IJ.log("FolderOpener: " + this.directory + " (" + list.length + " files)");
            }
            int width = 0;
            int height = 0;
            int stackSize = 1;
            stack = null;
            min2 = Double.MAX_VALUE;
            max = -1.7976931348623157E308;
            cal = null;
            allSameCalibration = true;
            IJ.resetEscape();
            overlay = null;
            if (this.nFiles == 0) {
                this.nFiles = list.length;
            }
            boolean dicomImages = false;
            try {
                ImagePlus imp;
                for (int i = 0; i < list.length; ++i) {
                    String info;
                    Opener opener = new Opener();
                    opener.setSilentMode(true);
                    IJ.redirectErrorMessages(true);
                    imp = opener.openTempImage(this.directory, list[i]);
                    IJ.redirectErrorMessages(false);
                    if (imp == null) continue;
                    width = imp.getWidth();
                    height = imp.getHeight();
                    if (this.bitDepth == 0) {
                        this.defaultBitDepth = this.bitDepth = imp.getBitDepth();
                    }
                    if ((info = (String)imp.getProperty("Info")) == null || !info.contains("7FE0,0010")) break;
                    dicomImages = true;
                    break;
                }
                if (width == 0) {
                    this.error("This folder does not appear to contain\nany TIFF, JPEG, BMP, DICOM, GIF, FITS or PGM files.\n \n   \"" + this.directory + "\"");
                    return;
                }
                IJ.showStatus("");
                this.t0 = System.currentTimeMillis();
                if (dicomImages && !IJ.isMacOSX() && !this.sortFileNames) {
                    list = StringSorter.sortNumerically(list);
                }
                if (this.nFiles < 1) {
                    this.nFiles = list.length;
                }
                if (this.start < 1 || this.start > list.length) {
                    this.start = 1;
                }
                if (this.start + this.nFiles - 1 > list.length) {
                    this.nFiles = list.length - this.start + 1;
                }
                int count = 0;
                int counter = 0;
                imp = null;
                boolean firstMessage = true;
                boolean fileInfoStack = false;
                for (int i = this.start - 1; i < list.length; ++i) {
                    if (counter++ % this.step != 0) continue;
                    Opener opener = new Opener();
                    opener.setSilentMode(true);
                    IJ.redirectErrorMessages(true);
                    if ("RoiSet.zip".equals(list[i])) {
                        IJ.open(this.directory + list[i]);
                        imp = null;
                    } else if (!this.openAsVirtualStack || stack == null) {
                        imp = opener.openTempImage(this.directory, list[i]);
                        stackSize = imp != null ? imp.getStackSize() : 1;
                    }
                    IJ.redirectErrorMessages(false);
                    if (imp != null && stack == null) {
                        width = imp.getWidth();
                        height = imp.getHeight();
                        if (this.stackWidth > 0 && this.stackHeight > 0) {
                            width = this.stackWidth;
                            height = this.stackHeight;
                        }
                        if (this.bitDepth == 0) {
                            this.bitDepth = imp.getBitDepth();
                        }
                        this.fi = imp.getOriginalFileInfo();
                        ImageProcessor ip = imp.getProcessor();
                        min2 = ip.getMin();
                        max = ip.getMax();
                        cal = imp.getCalibration();
                        ColorModel cm = imp.getProcessor().getColorModel();
                        if (this.openAsVirtualStack) {
                            if (stackSize > 1) {
                                stack = new FileInfoVirtualStack();
                                fileInfoStack = true;
                            } else {
                                stack = this.stackWidth > 0 && this.stackHeight > 0 ? new VirtualStack(this.stackWidth, this.stackHeight, cm, this.directory) : new VirtualStack(width, height, cm, this.directory);
                            }
                        } else {
                            stack = this.scale < 100.0 ? new ImageStack((int)((double)width * this.scale / 100.0), (int)((double)height * this.scale / 100.0), cm) : new ImageStack(width, height, cm);
                        }
                        if (this.bitDepth != 0) {
                            stack.setBitDepth(this.bitDepth);
                        }
                        this.info1 = (String)imp.getProperty("Info");
                    }
                    if (imp == null) continue;
                    if (imp.getWidth() != width || imp.getHeight() != height) {
                        if (this.stackWidth > 0 && this.stackHeight > 0) {
                            ImagePlus imp2 = imp.createImagePlus();
                            ImageProcessor ip = imp.getProcessor();
                            ImageProcessor ip2 = ip.createProcessor(width, height);
                            ip2.insert(ip, 0, 0);
                            imp2.setProcessor(ip2);
                            imp = imp2;
                        } else {
                            IJ.log(list[i] + ": wrong size; " + width + "x" + height + " expected, " + imp.getWidth() + "x" + imp.getHeight() + " found");
                            continue;
                        }
                    }
                    String label = imp.getTitle();
                    if (stackSize == 1) {
                        String sliceLabel;
                        String info = (String)imp.getProperty("Info");
                        if (info != null) {
                            if (FolderOpener.useInfo(info)) {
                                label = label + "\n" + info;
                            }
                        } else if (imp.getStackSize() > 0 && FolderOpener.useInfo(sliceLabel = imp.getStack().getSliceLabel(1))) {
                            label = sliceLabel;
                        }
                    }
                    if (Math.abs(imp.getCalibration().pixelWidth - cal.pixelWidth) > 1.0E-10) {
                        allSameCalibration = false;
                    }
                    ImageStack inputStack = imp.getStack();
                    Overlay overlay2 = imp.getOverlay();
                    if (overlay2 != null && !this.openAsVirtualStack) {
                        if (overlay == null) {
                            overlay = new Overlay();
                        }
                        for (int j = 0; j < overlay2.size(); ++j) {
                            Roi roi = overlay2.get(j);
                            int position = roi.getPosition();
                            if (position == 0) {
                                roi.setPosition(count + 1);
                            }
                            overlay.add(roi);
                        }
                    }
                    if (this.openAsVirtualStack) {
                        if (fileInfoStack) {
                            this.openAsFileInfoStack((FileInfoVirtualStack)stack, this.directory + list[i]);
                        } else {
                            ((VirtualStack)stack).addSlice(list[i]);
                        }
                    } else {
                        for (int slice = 1; slice <= stackSize; ++slice) {
                            int bitDepth2 = imp.getBitDepth();
                            String label2 = label;
                            ImageProcessor ip = null;
                            if (stackSize > 1) {
                                String sliceLabel = inputStack.getSliceLabel(slice);
                                if (sliceLabel != null && sliceLabel.length() <= 15) {
                                    label2 = label2 + ":" + sliceLabel;
                                } else if (label2 != null && !label2.equals("")) {
                                    label2 = label2 + ":" + slice;
                                }
                            }
                            ip = inputStack.getProcessor(slice);
                            if (bitDepth2 != this.bitDepth && dicomImages && this.bitDepth == 16 && bitDepth2 == 32 && this.scale == 100.0) {
                                ip = ip.convertToFloat();
                                this.bitDepth = 32;
                                ImageStack stack2 = new ImageStack(width, height, stack.getColorModel());
                                for (int n = 1; n <= stack.size(); ++n) {
                                    ImageProcessor ip2 = stack.getProcessor(n);
                                    ip2 = ip2.convertToFloat();
                                    ip2.subtract(32768.0);
                                    String sliceLabel = stack.getSliceLabel(n);
                                    stack2.addSlice(sliceLabel, ip2.convertToFloat());
                                }
                                stack = stack2;
                            }
                            if (this.scale < 100.0) {
                                ip = ip.resize((int)((double)width * this.scale / 100.0), (int)((double)height * this.scale / 100.0));
                            }
                            if (ip.getMin() < min2) {
                                min2 = ip.getMin();
                            }
                            if (ip.getMax() > max) {
                                max = ip.getMax();
                            }
                            stack.addSlice(label2, ip);
                        }
                    }
                    IJ.showStatus("!" + ++count + "/" + this.nFiles);
                    IJ.showProgress(count, this.nFiles);
                    if (count < this.nFiles) {
                        if (!IJ.escapePressed()) continue;
                        IJ.beep();
                    }
                    break;
                }
            }
            catch (OutOfMemoryError e) {
                IJ.outOfMemory("FolderOpener");
                if (stack == null) break block110;
                stack.trim();
            }
        }
        if (stack != null && stack.size() > 0) {
            Properties props;
            ImagePlus imp2 = new ImagePlus(title, stack);
            if (imp2.getType() == 1 || imp2.getType() == 2) {
                imp2.getProcessor().setMinAndMax(min2, max);
            }
            if (this.fi == null) {
                this.fi = new FileInfo();
            }
            this.fi.fileFormat = 0;
            this.fi.fileName = "";
            this.fi.directory = this.directory;
            imp2.setFileInfo(this.fi);
            imp2.setOverlay(overlay);
            if (stack instanceof VirtualStack && (props = ((VirtualStack)stack).getProperties()) != null) {
                imp2.setProperty("FHT", props.get("FHT"));
            }
            if (allSameCalibration) {
                if (this.scale != 100.0 && cal.scaled()) {
                    cal.pixelWidth /= this.scale / 100.0;
                    cal.pixelHeight /= this.scale / 100.0;
                }
                if (cal.pixelWidth != 1.0 && cal.pixelDepth == 1.0) {
                    cal.pixelDepth = cal.pixelWidth;
                }
                imp2.setCalibration(cal);
            }
            if (this.info1 != null && this.info1.lastIndexOf("7FE0,0010") > 0) {
                if (this.sortByMetaData) {
                    stack = DicomTools.sort(stack);
                }
                imp2.setStack(stack);
                double voxelDepth = DicomTools.getVoxelDepth(stack);
                if (voxelDepth > 0.0) {
                    if (IJ.debugMode) {
                        IJ.log("DICOM voxel depth set to " + voxelDepth + " (" + cal.pixelDepth + ")");
                    }
                    cal.pixelDepth = voxelDepth;
                    imp2.setCalibration(cal);
                }
                if (imp2.getType() == 1 || imp2.getType() == 2) {
                    imp2.getProcessor().setMinAndMax(min2, max);
                    imp2.updateAndDraw();
                }
            }
            if (imp2.getStackSize() == 1) {
                int idx = this.start - 1;
                if (idx < 0 || idx >= list.length) {
                    idx = 0;
                }
                imp2.setProp("Slice_Label", list[idx]);
                if (this.info1 != null) {
                    imp2.setProperty("Info", this.info1);
                }
            }
            if ((arg == null || this.runningOpen) && !this.saveImage) {
                String time = (double)(System.currentTimeMillis() - this.t0) / 1000.0 + " seconds";
                if (this.openAsSeparateImages) {
                    boolean ok;
                    if (imp2.getStackSize() > 100 && !IJ.isMacro() && !(ok = IJ.showMessageWithCancel("Import>Image Sequence", "Are you sure you want to open " + imp2.getStackSize() + " separate windows?\nThis may cause the system to become very slow or stall."))) {
                        return;
                    }
                    this.openAsSeparateImages(imp2);
                } else {
                    imp2.show(time);
                }
                if (stack.isVirtual() && (overlay = stack.getProcessor(1).getOverlay()) != null) {
                    imp2.setOverlay(overlay);
                }
            }
            if (this.saveImage) {
                this.image = imp2;
            }
        }
        IJ.showProgress(1.0);
        if (Recorder.record) {
            String options;
            String string = options = this.openAsVirtualStack && !this.openAsSeparateImages ? "virtual" : "";
            if (this.bitDepth != this.defaultBitDepth) {
                options = options + " bitdepth=" + this.bitDepth;
            }
            if (this.filter != null && this.filter.length() > 0) {
                if (this.filter.contains(" ")) {
                    this.filter = "[" + this.filter + "]";
                }
                options = options + " filter=" + this.filter;
            }
            if (this.start != 1) {
                options = options + " start=" + this.start;
            }
            if (this.step != 1) {
                options = options + " step=" + this.step;
            }
            if (this.scale != 100.0) {
                options = options + " scale=" + this.scale;
            }
            if (!this.sortByMetaData) {
                options = options + " noMetaSort";
            }
            if (!Recorder.scriptMode() && this.openAsSeparateImages) {
                options = options + " open";
            }
            String dir = Recorder.fixPath(this.directory);
            if (Recorder.scriptMode()) {
                Recorder.recordCall("imp = FolderOpener.open(\"" + dir + "\", \"" + options + "\");");
            } else {
                if (options.length() == 0) {
                    Recorder.recordString("File.openSequence(\"" + dir + "\");\n");
                } else {
                    Recorder.recordString("File.openSequence(\"" + dir + "\", \"" + options + "\");\n");
                }
                Recorder.disableCommandRecording();
            }
        }
    }

    private void error(String msg) {
        IJ.error("Import>Image Sequence", msg);
    }

    private void openAsSeparateImages(ImagePlus imp) {
        VirtualStack stack = (VirtualStack)imp.getStack();
        String dir = stack.getDirectory();
        int skip = 0;
        for (int n = 1; n <= stack.size(); ++n) {
            ImagePlus imp2 = IJ.openImage(dir + stack.getFileName(n));
            if (skip <= 0) {
                imp2.show();
                skip = imp2.getStackSize() - 1;
                continue;
            }
            --skip;
        }
    }

    public static boolean useInfo(String info) {
        return info != null && !info.startsWith("Software") && !info.startsWith("ImageDescription");
    }

    private void openAsFileInfoStack(FileInfoVirtualStack stack, String path) {
        FileInfo[] info = Opener.getTiffFileInfo(path);
        if (info == null || info.length == 0) {
            return;
        }
        int n = info[0].nImages;
        if (info.length == 1 && n > 1) {
            long size = this.fi.width * this.fi.height * this.fi.getBytesPerPixel();
            for (int i = 0; i < n; ++i) {
                FileInfo fi = (FileInfo)info[0].clone();
                fi.nImages = 1;
                fi.longOffset = fi.getOffset() + (long)i * (size + fi.getGap());
                stack.addImage(fi);
            }
        } else {
            FileInfo fi = info[0];
            if (fi.fileType == 12) {
                int slice = 1;
                while (slice <= 3) {
                    FileInfo fi2 = (FileInfo)fi.clone();
                    fi2.sliceNumber = slice++;
                    stack.addImage(fi2);
                }
            } else {
                stack.addImage(fi);
            }
        }
    }

    boolean showDialog() {
        String options = Macro.getOptions();
        if (options != null) {
            String optionsOrig = options;
            options = options.replace("open=", "dir=");
            options = options.replace("file=", "filter=");
            options = options.replace("starting=", "start=");
            options = options.replace("number=", "count=");
            options = options.replace("increment=", "step=");
            if (!(options = options.replace("inc=", "step=")).equals(optionsOrig)) {
                Macro.setOptions(options);
            }
            if (options.contains("convert_to_rgb")) {
                this.bitDepth = 24;
            }
        }
        String countStr = "---";
        if (!this.directorySet && options == null) {
            this.directory = Prefs.get(DIR_KEY, IJ.getDir("downloads") + "stack/");
        }
        if (this.directory != null && !IJ.isMacro()) {
            File f = new File(this.directory);
            String[] names = f.list();
            countStr = (names = this.trimFileList(names)) != null ? "" + names.length : "---";
        }
        GenericDialog gd = new GenericDialog("Import Image Sequence");
        gd.setInsets(5, 0, 0);
        gd.addDirectoryField("Dir:", this.directory);
        gd.setInsets(2, 55, 10);
        gd.addMessage("drag and drop target", IJ.font10, Color.darkGray);
        gd.addChoice("Type:", types, this.bitDepthToType(this.bitDepth));
        gd.addStringField("Filter:", "", 10);
        gd.setInsets(0, 55, 0);
        gd.addMessage("enclose regex in parens", IJ.font10, Color.darkGray);
        gd.addNumericField("Start:", this.start, 0, 6, "");
        gd.addStringField("Count:", countStr, 6);
        gd.addNumericField("Step:", this.step, 0, 6, "");
        if (!IJ.isMacro() && !GraphicsEnvironment.isHeadless()) {
            Vector v = gd.getStringFields();
            this.dirField = (TextField)v.elementAt(0);
            this.dirField.addTextListener(this);
            this.filterField = (TextField)v.elementAt(1);
            this.filterField.addTextListener(this);
            this.countField = (TextField)v.elementAt(2);
            v = gd.getNumericFields();
            this.startField = (TextField)v.elementAt(0);
            this.startField.addTextListener(this);
            this.stepField = (TextField)v.elementAt(1);
            this.stepField.addTextListener(this);
        }
        gd.addNumericField("Scale:", this.scale, 0, 6, "%");
        gd.addCheckbox("Sort names numerically", this.sortFileNames);
        gd.addCheckbox("Use virtual stack", this.openAsVirtualStack);
        gd.addCheckbox("Open as separate images", false);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/file.html#seq1");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.directory = gd.getNextString();
        gd.setSmartRecording(true);
        int index = gd.getNextChoiceIndex();
        this.bitDepth = this.typeToBitDepth(types[index]);
        this.filter = gd.getNextString();
        if (this.legacyRegex != null) {
            this.filter = "(" + this.legacyRegex + ")";
        }
        gd.setSmartRecording(true);
        this.start = (int)gd.getNextNumber();
        countStr = gd.getNextString();
        double count = Tools.parseDouble(countStr);
        if (!Double.isNaN(count)) {
            this.nFiles = (int)count;
        }
        this.step = (int)gd.getNextNumber();
        if (this.step < 1) {
            this.step = 1;
        }
        this.scale = gd.getNextNumber();
        if (this.scale < 5.0) {
            this.scale = 5.0;
        }
        if (this.scale > 100.0) {
            this.scale = 100.0;
        }
        this.sortFileNames = gd.getNextBoolean();
        if (!this.sortFileNames) {
            this.sortByMetaData = false;
        }
        this.openAsVirtualStack = gd.getNextBoolean();
        if (this.openAsVirtualStack) {
            this.scale = 100.0;
        }
        this.openAsSeparateImages = gd.getNextBoolean();
        if (this.openAsSeparateImages) {
            this.openAsVirtualStack = true;
        }
        if (!IJ.macroRunning()) {
            staticSortFileNames = this.sortFileNames;
            if (!this.openAsSeparateImages) {
                staticOpenAsVirtualStack = this.openAsVirtualStack;
            }
        }
        return true;
    }

    public static String[] getFilteredList(String[] list, String filter, String title) {
        int i;
        boolean isRegex = false;
        if (filter != null && (filter.equals("") || filter.equals("*"))) {
            filter = null;
        }
        if (list == null || filter == null) {
            return list;
        }
        if (title == null) {
            String[] list2 = new String[list.length];
            for (i = 0; i < list.length; ++i) {
                list2[i] = list[i];
            }
            list = list2;
        }
        if (filter.length() >= 2 && filter.startsWith("(") && filter.endsWith(")")) {
            filter = filter.substring(1, filter.length() - 1);
            isRegex = true;
        }
        int filteredImages = 0;
        for (i = 0; i < list.length; ++i) {
            if (isRegex && FolderOpener.containsRegex(list[i], filter, title != null && title.contains("(legacy)"))) {
                ++filteredImages;
                continue;
            }
            if (list[i].contains(filter)) {
                ++filteredImages;
                continue;
            }
            list[i] = null;
        }
        if (filteredImages == 0) {
            if (title != null) {
                if (isRegex) {
                    IJ.error(title, "None of the file names contain the regular expression '" + filter + "'.");
                } else {
                    IJ.error(title, "None of the " + list.length + " files contain '" + filter + "' in the name.");
                }
            }
            return null;
        }
        String[] list2 = new String[filteredImages];
        int j = 0;
        for (int i2 = 0; i2 < list.length; ++i2) {
            if (list[i2] == null) continue;
            list2[j++] = list[i2];
        }
        list = list2;
        return list;
    }

    public static boolean containsRegex(String name, String regex, boolean legacy) {
        boolean contains = false;
        try {
            contains = legacy ? name.matches(regex) : name.replaceAll(regex, "").length() != name.length();
            IJ.showStatus("");
        }
        catch (Exception e) {
            String msg = e.getMessage();
            int index = msg.indexOf("\n");
            if (index > 0) {
                msg = msg.substring(0, index);
            }
            IJ.showStatus("Regex error: " + msg);
            contains = true;
        }
        return contains;
    }

    private int typeToBitDepth(String type) {
        int depth = 0;
        if (type.equals("16-bit")) {
            depth = 16;
        } else if (type.equals("32-bit")) {
            depth = 32;
        } else if (type.equals("RGB")) {
            depth = 24;
        }
        return depth;
    }

    private String bitDepthToType(int bitDepth) {
        switch (bitDepth) {
            case 0: {
                return types[0];
            }
            case 16: {
                return types[1];
            }
            case 32: {
                return types[2];
            }
            case 24: {
                return types[3];
            }
        }
        return types[0];
    }

    public String[] trimFileList(String[] rawlist) {
        if (rawlist == null) {
            return null;
        }
        int count = 0;
        for (int i = 0; i < rawlist.length; ++i) {
            String name = rawlist[i];
            if (name.startsWith(".") || name.equals("Thumbs.db") || FolderOpener.excludedFileType(name)) {
                rawlist[i] = null;
                continue;
            }
            ++count;
        }
        if (count == 0) {
            return null;
        }
        String[] list = rawlist;
        if (count < rawlist.length) {
            list = new String[count];
            int index = 0;
            for (int i = 0; i < rawlist.length; ++i) {
                if (rawlist[i] == null) continue;
                list[index++] = rawlist[i];
            }
        }
        return list;
    }

    public static boolean excludedFileType(String name) {
        if (name == null) {
            return true;
        }
        for (int i = 0; i < excludedTypes.length; ++i) {
            if (!name.endsWith(excludedTypes[i])) continue;
            return true;
        }
        return false;
    }

    public void openAsVirtualStack(boolean b) {
        this.openAsVirtualStack = b;
    }

    public void sortFileNames(boolean b) {
        this.sortFileNames = b;
    }

    public void sortByMetaData(boolean b) {
        this.sortByMetaData = b;
    }

    public void setDirectory(String path) {
        this.directory = path;
        this.directorySet = true;
    }

    public String[] sortFileList(String[] list) {
        return StringSorter.sortNumerically(list);
    }

    @Override
    public void textValueChanged(TextEvent e) {
        double step;
        if (this.dirField == null) {
            return;
        }
        String dir = this.dirField.getText();
        File f = new File(dir);
        String[] names = f.list();
        names = this.trimFileList(names);
        int count = (names = FolderOpener.getFilteredList(names, this.filterField.getText(), null)) != null ? names.length : 0;
        double start = Tools.parseDouble(this.startField.getText(), Double.NaN);
        if (!Double.isNaN(start) && start > 1.0) {
            count -= (int)start - 1;
        }
        if (!Double.isNaN(step = Tools.parseDouble(this.stepField.getText(), Double.NaN)) && step > 1.0) {
            count /= (int)step;
        }
        String countStr = count > 0 ? "" + count : "---";
        this.countField.setText(countStr);
    }
}

