/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.plugin.GifFrame;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;

class GifDecoder {
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    private BufferedInputStream in;
    private int status;
    private int width;
    private int height;
    private boolean gctFlag;
    private int gctSize;
    private int loopCount;
    private int[] gct;
    private int[] lct;
    private int[] act;
    private int bgIndex;
    private int bgColor;
    private int lastBgColor;
    private int pixelAspect;
    private boolean lctFlag;
    private boolean interlace;
    private int lctSize;
    private int ix;
    private int iy;
    private int iw;
    private int ih;
    private Rectangle lastRect;
    private ImageProcessor image;
    private ImageProcessor lastImage;
    private byte[] block = new byte[256];
    private int blockSize = 0;
    private int dispose = 0;
    private int lastDispose = 0;
    private boolean transparency = false;
    private int delay = 0;
    private int transIndex;
    private static final int MaxStackSize = 4096;
    private short[] prefix;
    private byte[] suffix;
    private byte[] pixelStack;
    private byte[] pixels;
    private Vector frames;
    private int frameCount;

    GifDecoder() {
    }

    public int getDelay(int n) {
        this.delay = -1;
        if (n >= 0 && n < this.frameCount) {
            this.delay = ((GifFrame)this.frames.elementAt((int)n)).delay;
        }
        return this.delay;
    }

    public ImageProcessor getFrame(int n) {
        ImageProcessor im = null;
        if (n >= 0 && n < this.frameCount) {
            im = ((GifFrame)this.frames.elementAt((int)n)).image;
        }
        return im;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public ImageProcessor getImage() {
        return this.getFrame(0);
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public int read(BufferedInputStream is) {
        this.init();
        if (is != null) {
            this.in = is;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.status;
    }

    public int read(String name) {
        this.status = 0;
        try {
            name = name.trim();
            if (name.indexOf("://") > 0) {
                URL url = new URL(name);
                this.in = new BufferedInputStream(url.openStream());
            } else {
                this.in = new BufferedInputStream(new FileInputStream(name));
            }
            this.status = this.read(this.in);
        }
        catch (IOException e) {
            this.status = 2;
        }
        return this.status;
    }

    private void decodeImageData() {
        int code;
        int NullCode = -1;
        int npix = this.iw * this.ih;
        if (this.pixels == null || this.pixels.length < npix) {
            this.pixels = new byte[npix];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int data_size = this.read();
        int clear = 1 << data_size;
        int end_of_information = clear + 1;
        int available = clear + 2;
        int old_code = NullCode;
        int code_size = data_size + 1;
        int code_mask = (1 << code_size) - 1;
        for (code = 0; code < clear; ++code) {
            this.prefix[code] = 0;
            this.suffix[code] = (byte)code;
        }
        int bi = 0;
        int pi = 0;
        int top = 0;
        int first = 0;
        int count = 0;
        int bits = 0;
        int datum = 0;
        int i = 0;
        while (i < npix) {
            if (top == 0) {
                if (bits < code_size) {
                    if (count == 0) {
                        count = this.readBlock();
                        if (count <= 0) break;
                        bi = 0;
                    }
                    datum += (this.block[bi] & 0xFF) << bits;
                    bits += 8;
                    ++bi;
                    --count;
                    continue;
                }
                code = datum & code_mask;
                datum >>= code_size;
                bits -= code_size;
                if (code > available || code == end_of_information) break;
                if (code == clear) {
                    code_size = data_size + 1;
                    code_mask = (1 << code_size) - 1;
                    available = clear + 2;
                    old_code = NullCode;
                    continue;
                }
                if (old_code == NullCode) {
                    this.pixelStack[top++] = this.suffix[code];
                    old_code = code;
                    first = code;
                    continue;
                }
                int in_code = code;
                if (code == available) {
                    this.pixelStack[top++] = (byte)first;
                    code = old_code;
                }
                while (code > clear) {
                    this.pixelStack[top++] = this.suffix[code];
                    code = this.prefix[code];
                }
                first = this.suffix[code] & 0xFF;
                if (available >= 4096) break;
                this.pixelStack[top++] = (byte)first;
                this.prefix[available] = (short)old_code;
                this.suffix[available] = (byte)first;
                if ((++available & code_mask) == 0 && available < 4096) {
                    ++code_size;
                    code_mask += available;
                }
                old_code = in_code;
            }
            this.pixels[pi++] = this.pixelStack[--top];
            ++i;
        }
        for (i = pi; i < npix; ++i) {
            this.pixels[i] = 0;
        }
    }

    private boolean err() {
        return this.status != 0;
    }

    private void init() {
        this.status = 0;
        this.frameCount = 0;
        this.frames = new Vector();
        this.gct = null;
        this.lct = null;
    }

    private int read() {
        int curByte = 0;
        try {
            curByte = this.in.read();
        }
        catch (IOException e) {
            this.status = 1;
        }
        return curByte;
    }

    private int readBlock() {
        int n;
        this.blockSize = this.read();
        if (this.blockSize > 0) {
            try {
                int count;
                for (n = 0; n < this.blockSize && (count = this.in.read(this.block, n, this.blockSize - n)) != -1; n += count) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n < this.blockSize) {
                this.status = 1;
            }
        }
        return n;
    }

    private int[] readColorTable(int ncolors) {
        int nbytes = 3 * ncolors;
        int[] tab = null;
        byte[] c = new byte[nbytes];
        int n = 0;
        try {
            n = this.in.read(c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n < nbytes) {
            this.status = 1;
        } else {
            tab = new int[256];
            int i = 0;
            int j = 0;
            while (i < ncolors) {
                int r = c[j++] & 0xFF;
                int g2 = c[j++] & 0xFF;
                int b = c[j++] & 0xFF;
                tab[i++] = 0xFF000000 | r << 16 | g2 << 8 | b;
            }
        }
        return tab;
    }

    private void readContents() {
        boolean done = false;
        block9: while (!done && !this.err()) {
            int code = this.read();
            switch (code) {
                case 44: {
                    this.readImage();
                    continue block9;
                }
                case 33: {
                    code = this.read();
                    switch (code) {
                        case 249: {
                            this.readGraphicControlExt();
                            continue block9;
                        }
                        case 255: {
                            this.readBlock();
                            String app = "";
                            for (int i = 0; i < 11; ++i) {
                                app = app + (char)this.block[i];
                            }
                            if (app.equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                continue block9;
                            }
                            this.skip();
                            continue block9;
                        }
                    }
                    this.skip();
                    continue block9;
                }
                case 59: {
                    done = true;
                    continue block9;
                }
            }
            this.status = 1;
        }
    }

    private void readGraphicControlExt() {
        this.read();
        int packed = this.read();
        this.dispose = (packed & 0x1C) >> 1;
        this.transparency = (packed & 1) != 0;
        this.delay = this.readShort() * 10;
        this.transIndex = this.read();
        this.read();
    }

    private void readHeader() {
        String id = "";
        for (int i = 0; i < 6; ++i) {
            id = id + (char)this.read();
        }
        if (!id.startsWith("GIF")) {
            this.status = 1;
            return;
        }
        this.readLSD();
        if (this.gctFlag && !this.err()) {
            this.gct = this.readColorTable(this.gctSize);
            this.bgColor = this.gct[this.bgIndex];
        }
    }

    private void readImage() {
        this.ix = this.readShort();
        this.iy = this.readShort();
        this.iw = this.readShort();
        this.ih = this.readShort();
        int packed = this.read();
        this.lctFlag = (packed & 0x80) != 0;
        this.interlace = (packed & 0x40) != 0;
        this.lctSize = 2 << (packed & 7);
        if (this.lctFlag) {
            this.lct = this.readColorTable(this.lctSize);
            this.act = this.lct;
        } else {
            this.act = this.gct;
            if (this.bgIndex == this.transIndex) {
                this.bgColor = 0;
            }
        }
        int save = 0;
        if (this.transparency) {
            save = this.act[this.transIndex];
            this.act[this.transIndex] = 0;
        }
        if (this.act == null) {
            this.status = 1;
        }
        if (this.err()) {
            return;
        }
        this.decodeImageData();
        this.skip();
        if (this.err()) {
            return;
        }
        ++this.frameCount;
        this.image = new ColorProcessor(this.width, this.height);
        this.setPixels();
        this.frames.addElement(new GifFrame(this.image, this.delay));
        if (this.transparency) {
            this.act[this.transIndex] = save;
        }
        this.resetFrame();
    }

    private void readLSD() {
        this.width = this.readShort();
        this.height = this.readShort();
        int packed = this.read();
        this.gctFlag = (packed & 0x80) != 0;
        this.gctSize = 2 << (packed & 7);
        this.bgIndex = this.read();
        this.pixelAspect = this.read();
    }

    private void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 3) continue;
            int b1 = this.block[1] & 0xFF;
            int b2 = this.block[2] & 0xFF;
            this.loopCount = b2 << 8 | b1;
        } while (this.blockSize > 0 && !this.err());
    }

    private int readShort() {
        return this.read() | this.read() << 8;
    }

    private void resetFrame() {
        this.lastDispose = this.dispose;
        this.lastRect = new Rectangle(this.ix, this.iy, this.iw, this.ih);
        this.lastImage = this.image;
        this.lastBgColor = this.bgColor;
        boolean dispose = false;
        boolean transparency = false;
        boolean delay = false;
        this.lct = null;
    }

    private void setPixels() {
        int[] dest = (int[])this.image.getPixels();
        if (this.lastDispose > 0) {
            if (this.lastDispose == 3) {
                int n = this.frameCount - 2;
                this.lastImage = n > 0 ? this.getFrame(n - 1) : null;
            }
            if (this.lastImage != null) {
                int[] prev = (int[])this.lastImage.getPixels();
                System.arraycopy(prev, 0, dest, 0, this.width * this.height);
                if (this.lastDispose == 2 && this.lastBgColor != 0) {
                    this.image.setColor(new Color(this.lastBgColor));
                    this.image.setRoi(this.lastRect);
                    this.image.fill();
                }
            }
        }
        int pass = 1;
        int inc = 8;
        int iline = 0;
        for (int i = 0; i < this.ih; ++i) {
            int line = i;
            if (this.interlace) {
                if (iline >= this.ih) {
                    switch (++pass) {
                        case 2: {
                            iline = 4;
                            break;
                        }
                        case 3: {
                            iline = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            iline = 1;
                            inc = 2;
                        }
                    }
                }
                line = iline;
                iline += inc;
            }
            if ((line += this.iy) >= this.height) continue;
            int k = line * this.width;
            int dx = k + this.ix;
            int dlim = dx + this.iw;
            if (k + this.width < dlim) {
                dlim = k + this.width;
            }
            int sx = i * this.iw;
            while (dx < dlim) {
                int index = this.pixels[sx++] & 0xFF;
                dest[dx++] = this.act[index];
            }
        }
    }

    private void skip() {
        do {
            this.readBlock();
        } while (this.blockSize > 0 && !this.err());
    }
}

