/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.io.FileSaver;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.util.Tools;
import java.awt.Color;
import java.io.File;
import java.util.Locale;
import java.util.Properties;

public class StackWriter
implements PlugIn {
    private static final String DIR_KEY = "save.sequence.dir";
    private static String[] choices = new String[]{"BMP", "FITS", "GIF", "JPEG", "PGM", "PNG", "Raw", "Text", "TIFF", "ZIP"};
    private static String staticFileType = "TIFF";
    private String fileType = "TIFF";
    private int ndigits = 4;
    private boolean useLabels;
    private boolean firstTime = true;
    private int startAt;
    private boolean hyperstack;
    private int[] dim;
    private ImagePlus imp;
    private String directory;
    private String format = "tiff";
    private String name;

    public static void save(ImagePlus imp, String directoryPath, String options) {
        StackWriter sw = new StackWriter();
        sw.imp = imp;
        sw.format = Tools.getStringFromList(options, "format=", sw.format);
        sw.name = Tools.getStringFromList(options, "name=");
        sw.ndigits = (int)Tools.getNumberFromList(options, "digits=", sw.ndigits);
        sw.useLabels = options.contains(" use");
        sw.run(directoryPath);
    }

    @Override
    public void run(String arg) {
        boolean isOverlay;
        int maxImages;
        if (this.imp == null) {
            this.imp = WindowManager.getCurrentImage();
        }
        if (this.imp == null || this.imp != null && this.imp.getStackSize() < 2 && !IJ.isMacro()) {
            IJ.error("Stack Writer", "This command requires a stack.");
            return;
        }
        int stackSize = this.imp.getStackSize();
        if (this.name == null) {
            this.name = this.imp.getTitle();
            int dotIndex = this.name.lastIndexOf(".");
            if (dotIndex >= 0) {
                this.name = this.name.substring(0, dotIndex);
            }
        }
        this.hyperstack = this.imp.isHyperStack();
        LUT[] luts = null;
        int lutIndex = 0;
        int nChannels = this.imp.getNChannels();
        if (this.hyperstack) {
            this.dim = this.imp.getDimensions();
            if (this.imp.isComposite()) {
                luts = ((CompositeImage)this.imp).getLuts();
            }
            if (this.firstTime && this.ndigits == 4) {
                this.ndigits = 3;
                this.firstTime = false;
            }
        }
        if (arg != null && arg.length() > 0) {
            this.directory = arg;
        } else if (!this.showDialog(this.imp)) {
            return;
        }
        File d = new File(this.directory);
        if (d == null || !d.isDirectory()) {
            IJ.error("File>Save As>Image Sequence", "Directory not found: " + this.directory);
            return;
        }
        int number = 0;
        if (this.ndigits < 1) {
            this.ndigits = 1;
        }
        if (this.ndigits > 8) {
            this.ndigits = 8;
        }
        if (stackSize > (maxImages = (int)Math.pow(10.0, this.ndigits)) && !this.useLabels && !this.hyperstack) {
            IJ.error("Stack Writer", "More than " + this.ndigits + " digits are required to generate \nunique file names for " + stackSize + " images.");
            return;
        }
        if (this.format.equals("fits") && !FileSaver.okForFits(this.imp)) {
            return;
        }
        if (this.format.equals("text")) {
            this.format = "text image";
        }
        String extension = "." + this.format;
        if (this.format.equals("tiff")) {
            extension = ".tif";
        } else if (this.format.equals("text image")) {
            extension = ".txt";
        }
        Overlay overlay = this.imp.getOverlay();
        boolean bl = isOverlay = overlay != null && !this.imp.getHideOverlay();
        if (!this.format.equals("jpeg") && !this.format.equals("png")) {
            isOverlay = false;
        }
        ImageStack stack = this.imp.getStack();
        ImagePlus imp2 = new ImagePlus();
        imp2.setTitle(this.imp.getTitle());
        Calibration cal = this.imp.getCalibration();
        int nSlices = stack.size();
        String label = null;
        this.imp.lock();
        for (int i = 1; i <= nSlices; ++i) {
            File f;
            IJ.showStatus("writing: " + i + "/" + nSlices);
            IJ.showProgress(i, nSlices);
            ImageProcessor ip = stack.getProcessor(i);
            if (isOverlay) {
                this.imp.setSliceWithoutUpdate(i);
                ip = this.imp.flatten().getProcessor();
            } else if (luts != null && nChannels > 1 && this.hyperstack) {
                ip.setColorModel(luts[lutIndex++]);
                if (lutIndex >= luts.length) {
                    lutIndex = 0;
                }
            }
            imp2.setProcessor(null, ip);
            String label2 = stack.getSliceLabel(i);
            imp2.setProp("Slice_Label", null);
            if (label2 != null) {
                if (label2.contains("\n")) {
                    imp2.setProperty("Info", label2);
                } else {
                    imp2.setProp("Slice_Label", label2);
                }
            } else {
                Properties props = imp2.getProperties();
                if (props != null) {
                    props.remove("Info");
                }
            }
            imp2.setCalibration(cal);
            String digits = this.getDigits(number++);
            if (this.useLabels) {
                label = stack.getShortSliceLabel(i, 111);
                if (label != null && label.equals("")) {
                    label = null;
                }
                if (label != null) {
                    label = label.replaceAll("/", "-");
                }
            }
            String path = label == null ? this.directory + this.name + digits + extension : this.directory + label + extension;
            if (i == 1 && (f = new File(path)).exists() && !IJ.isMacro() && !IJ.showMessageWithCancel("Overwrite files?", "One or more files will be overwritten if you click \"OK\".\n \n" + path)) {
                this.imp.unlock();
                IJ.showStatus("");
                IJ.showProgress(1.0);
                return;
            }
            if (Recorder.record) {
                Recorder.disablePathRecording();
            }
            imp2.setOverlay(null);
            if (overlay != null && this.format.equals("tiff")) {
                Overlay overlay2 = overlay.duplicate();
                overlay2.crop(i, i);
                if (overlay2.size() > 0) {
                    for (int j = 0; j < overlay2.size(); ++j) {
                        Roi roi = overlay2.get(j);
                        int pos = roi.getPosition();
                        if (pos != 1) continue;
                        roi.setPosition(i);
                    }
                    imp2.setOverlay(overlay2);
                }
            }
            IJ.saveAs(imp2, this.format, path);
        }
        this.imp.unlock();
        if (isOverlay) {
            this.imp.setSlice(1);
        }
        IJ.showStatus("");
    }

    private boolean showDialog(ImagePlus imp) {
        int ndigits2;
        String name2;
        String options = Macro.getOptions();
        if (options != null && options.contains("save=")) {
            Macro.setOptions(options.replaceAll("save=", "dir="));
        }
        this.directory = Prefs.get(DIR_KEY, IJ.getDir("downloads") + "stack2/");
        GenericDialog gd = new GenericDialog("Save Image Sequence");
        if (!IJ.isMacro()) {
            this.fileType = staticFileType;
        }
        gd.setInsets(5, 0, 0);
        gd.addDirectoryField("Dir:", this.directory);
        gd.setInsets(2, 110, 5);
        gd.addMessage("drag and drop target", IJ.font10, Color.darkGray);
        gd.addChoice("Format:", choices, this.fileType);
        gd.addStringField("Name:", this.name, 12);
        if (!this.hyperstack) {
            gd.addNumericField("Start At:", this.startAt, 0);
        }
        gd.addNumericField("Digits (1-8):", this.ndigits, 0);
        if (!this.hyperstack) {
            gd.addCheckbox("Use slice labels as file names", this.useLabels);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.directory = gd.getNextString();
        this.directory = IJ.addSeparator(this.directory);
        Prefs.set(DIR_KEY, this.directory);
        gd.setSmartRecording(true);
        this.fileType = gd.getNextChoice();
        this.format = this.fileType.toLowerCase(Locale.US);
        if (!IJ.isMacro()) {
            staticFileType = this.fileType;
        }
        boolean nameChanged = !(name2 = gd.getNextString()).equals(this.name);
        this.name = name2;
        if (!this.hyperstack) {
            this.startAt = (int)gd.getNextNumber();
        }
        if (this.startAt < 0) {
            this.startAt = 0;
        }
        boolean ndigitsChanged = (ndigits2 = (int)gd.getNextNumber()) != this.ndigits;
        this.ndigits = ndigits2;
        this.useLabels = !this.hyperstack ? gd.getNextBoolean() : false;
        if (Recorder.record) {
            String options2 = "format=" + this.format;
            if (nameChanged) {
                options2 = options2 + " name=" + this.name;
            }
            if (ndigitsChanged) {
                options2 = options2 + " digits=" + this.ndigits;
            }
            if (this.useLabels) {
                options2 = options2 + " use";
            }
            String dir = Recorder.fixPath(this.directory);
            Recorder.recordCall("StackWriter.save(imp, \"" + dir + "\", \"" + options2 + "\");");
        }
        return true;
    }

    String getDigits(int n) {
        if (this.hyperstack) {
            int c = n % this.dim[2] + 1;
            int z = n / this.dim[2] % this.dim[3] + 1;
            int t2 = n / (this.dim[2] * this.dim[3]) % this.dim[4] + 1;
            String cs = "";
            String zs = "";
            String ts = "";
            if (this.dim[2] > 1) {
                cs = "00000000" + c;
                cs = "_c" + cs.substring(cs.length() - this.ndigits);
            }
            if (this.dim[3] > 1) {
                zs = "00000000" + z;
                zs = "_z" + zs.substring(zs.length() - this.ndigits);
            }
            if (this.dim[4] > 1) {
                ts = "00000000" + t2;
                ts = "_t" + ts.substring(ts.length() - this.ndigits);
            }
            return ts + zs + cs;
        }
        String digits = "00000000" + (this.startAt + n);
        return digits.substring(digits.length() - this.ndigits);
    }
}

