/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import javax.swing.SwingUtilities;

public class ThreadLister
implements PlugIn {
    @Override
    public void run(String arg) {
        if (IJ.getApplet() != null) {
            return;
        }
        CharArrayWriter caw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(caw);
        try {
            ThreadLister.listAllThreads(pw);
            new TextWindow("Threads", caw.toString(), 420, 420);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (IJ.altKeyDown()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((Object)null).toString();
                }
            });
        }
    }

    private static void print_thread_info(PrintWriter out, Thread t2, String indent) {
        if (t2 == null) {
            return;
        }
        out.print(indent + "Thread: " + t2.getName() + "  Priority: " + t2.getPriority() + (t2.isDaemon() ? " Daemon" : "") + (t2.isAlive() ? "" : " Not Alive") + "\n");
    }

    private static void list_group(PrintWriter out, ThreadGroup g2, String indent) {
        int i;
        if (g2 == null) {
            return;
        }
        int num_threads = g2.activeCount();
        int num_groups = g2.activeGroupCount();
        Thread[] threads = new Thread[num_threads];
        ThreadGroup[] groups2 = new ThreadGroup[num_groups];
        g2.enumerate(threads, false);
        g2.enumerate(groups2, false);
        out.println(indent + "Thread Group: " + g2.getName() + "  Max Priority: " + g2.getMaxPriority() + "\n");
        for (i = 0; i < num_threads; ++i) {
            ThreadLister.print_thread_info(out, threads[i], indent + "    ");
        }
        for (i = 0; i < num_groups; ++i) {
            ThreadLister.list_group(out, groups2[i], indent + "    ");
        }
    }

    public static void listAllThreads(PrintWriter out) {
        ThreadGroup current_thread_group;
        ThreadGroup root_thread_group = current_thread_group = Thread.currentThread().getThreadGroup();
        for (ThreadGroup parent = root_thread_group.getParent(); parent != null; parent = parent.getParent()) {
            root_thread_group = parent;
        }
        ThreadLister.list_group(out, root_thread_group, "");
    }
}

