/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.macro.Interpreter;
import ij.plugin.ChannelSplitter;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackMerge;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.util.Arrays;

public class ZProjector
implements PlugIn {
    public static final int AVG_METHOD = 0;
    public static final int MAX_METHOD = 1;
    public static final int MIN_METHOD = 2;
    public static final int SUM_METHOD = 3;
    public static final int SD_METHOD = 4;
    public static final int MEDIAN_METHOD = 5;
    public static final String[] METHODS = new String[]{"Average Intensity", "Max Intensity", "Min Intensity", "Sum Slices", "Standard Deviation", "Median"};
    private static final String METHOD_KEY = "zproject.method";
    private int method = (int)Prefs.get("zproject.method", 0.0);
    private static final int BYTE_TYPE = 0;
    private static final int SHORT_TYPE = 1;
    private static final int FLOAT_TYPE = 2;
    public static final String lutMessage = "Stacks with inverting LUTs may not project correctly.\nTo create a standard LUT, invert the stack (Edit/Invert)\nand invert the LUT (Image/Lookup Tables/Invert LUT).";
    private ImagePlus projImage = null;
    private ImagePlus imp = null;
    private int startSlice = 1;
    private int stopSlice = 1;
    private boolean allTimeFrames = true;
    private String color = "";
    private boolean isHyperstack;
    private boolean simpleComposite;
    private int increment = 1;
    private int sliceCount;

    public ZProjector() {
    }

    public ZProjector(ImagePlus imp) {
        this.setImage(imp);
    }

    public static ImagePlus run(ImagePlus imp, String method) {
        return ZProjector.run(imp, method, 1, imp.getStackSize());
    }

    public static ImagePlus run(ImagePlus imp, String method, int startSlice, int stopSlice) {
        ZProjector zp = new ZProjector(imp);
        zp.setStartSlice(startSlice);
        zp.setStopSlice(stopSlice);
        zp.isHyperstack = imp.isHyperStack();
        if (zp.isHyperstack && startSlice == 1 && stopSlice == imp.getStackSize()) {
            zp.setDefaultBounds();
        }
        if (method == null) {
            return null;
        }
        method = method.toLowerCase();
        int m4 = -1;
        if (method.startsWith("av")) {
            m4 = 0;
        } else if (method.startsWith("max")) {
            m4 = 1;
        } else if (method.startsWith("min")) {
            m4 = 2;
        } else if (method.startsWith("sum")) {
            m4 = 3;
        } else if (method.startsWith("sd")) {
            m4 = 4;
        } else if (method.startsWith("median")) {
            m4 = 5;
        }
        if (m4 < 0) {
            throw new IllegalArgumentException("Invalid projection method: " + method);
        }
        zp.allTimeFrames = method.contains("all");
        zp.setMethod(m4);
        zp.doProjection(true);
        return zp.getProjection();
    }

    public void setImage(ImagePlus imp) {
        this.imp = imp;
        this.startSlice = 1;
        this.stopSlice = imp.getStackSize();
    }

    public void setStartSlice(int slice) {
        if (this.imp == null || slice < 1 || slice > this.imp.getStackSize()) {
            return;
        }
        this.startSlice = slice;
    }

    public void setStopSlice(int slice) {
        if (this.imp == null || slice < 1 || slice > this.imp.getStackSize()) {
            return;
        }
        this.stopSlice = slice;
    }

    public void setMethod(int projMethod) {
        this.method = projMethod;
    }

    public ImagePlus getProjection() {
        return this.projImage;
    }

    @Override
    public void run(String arg) {
        this.imp = IJ.getImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (this.imp.getStackSize() == 1) {
            IJ.error("Z Project", "Stack required");
            return;
        }
        if (this.imp.getProcessor().isInvertedLut() && !IJ.showMessageWithCancel("ZProjection", lutMessage)) {
            return;
        }
        this.setDefaultBounds();
        GenericDialog gd = this.buildControlDialog(this.startSlice, this.stopSlice);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        long tstart = System.currentTimeMillis();
        gd.setSmartRecording(true);
        int startSlice2 = this.startSlice;
        int stopSlice2 = this.stopSlice;
        this.setStartSlice((int)gd.getNextNumber());
        this.setStopSlice((int)gd.getNextNumber());
        boolean rangeChanged = this.startSlice != startSlice2 || this.stopSlice != stopSlice2;
        startSlice2 = this.startSlice;
        stopSlice2 = this.stopSlice;
        gd.setSmartRecording(false);
        this.method = gd.getNextChoiceIndex();
        Prefs.set(METHOD_KEY, this.method);
        if (this.isHyperstack) {
            this.allTimeFrames = this.imp.getNFrames() > 1 && this.imp.getNSlices() > 1 ? gd.getNextBoolean() : false;
        }
        this.doProjection(true);
        if (arg.equals("") && this.projImage != null) {
            long tstop = System.currentTimeMillis();
            if (this.simpleComposite && this.imp.getBitDepth() != 24) {
                IJ.run(this.projImage, "Grays", "");
            }
            this.projImage.show("ZProjector: " + IJ.d2s((double)(tstop - tstart) / 1000.0, 2) + " seconds");
        }
        this.imp.unlock();
        IJ.register(ZProjector.class);
        if (Recorder.scriptMode()) {
            String m4 = this.getMethodAsString();
            if (this.isHyperstack && this.allTimeFrames) {
                m4 = m4 + " all";
            }
            String range = "";
            if (rangeChanged) {
                range = "," + startSlice2 + "," + stopSlice2;
            }
            Recorder.recordCall("imp = ZProjector.run(imp,\"" + m4 + "\"" + range + ");");
        }
    }

    private String getMethodAsString() {
        switch (this.method) {
            case 0: {
                return "avg";
            }
            case 1: {
                return "max";
            }
            case 2: {
                return "min";
            }
            case 3: {
                return "sum";
            }
            case 4: {
                return "sd";
            }
            case 5: {
                return "median";
            }
        }
        return "avg";
    }

    private void setDefaultBounds() {
        int nSlices;
        int stackSize = this.imp.getStackSize();
        int channels = this.imp.getNChannels();
        int frames = this.imp.getNFrames();
        int slices = this.imp.getNSlices();
        this.isHyperstack = this.imp.isHyperStack() || Interpreter.isBatchMode() && (frames > 1 && frames < stackSize || slices > 1 && slices < stackSize);
        boolean bl = this.simpleComposite = channels == stackSize;
        if (this.simpleComposite) {
            this.isHyperstack = false;
        }
        this.startSlice = 1;
        this.stopSlice = this.isHyperstack ? ((nSlices = this.imp.getNSlices()) > 1 ? nSlices : this.imp.getNFrames()) : stackSize;
    }

    public void doRGBProjection() {
        this.doRGBProjection(this.imp.getStack());
    }

    public void doRGBProjection(boolean handleOverlay) {
        this.doRGBProjection(this.imp.getStack());
        Overlay overlay = this.imp.getOverlay();
        if (handleOverlay && overlay != null) {
            this.projImage.setOverlay(this.projectRGBHyperStackRois(overlay));
        }
    }

    private void doRGBProjection(ImageStack stack) {
        boolean clip = this.method == 3 && "true".equals(this.imp.getProp("ClipWhenSumming"));
        ImageStack[] channels = ChannelSplitter.splitRGB(stack, true);
        ImagePlus red = new ImagePlus("Red", channels[0]);
        ImagePlus green = new ImagePlus("Green", channels[1]);
        ImagePlus blue = new ImagePlus("Blue", channels[2]);
        this.imp.unlock();
        ImagePlus saveImp = this.imp;
        this.imp = red;
        this.color = "(red)";
        this.doProjection();
        ImagePlus red2 = this.projImage;
        this.imp = green;
        this.color = "(green)";
        this.doProjection();
        ImagePlus green2 = this.projImage;
        this.imp = blue;
        this.color = "(blue)";
        this.doProjection();
        ImagePlus blue2 = this.projImage;
        int w = red2.getWidth();
        int h2 = red2.getHeight();
        int d = red2.getStackSize();
        if (this.method == 4) {
            double bmax;
            double gmax;
            ImageProcessor r = red2.getProcessor();
            ImageProcessor g2 = green2.getProcessor();
            ImageProcessor b = blue2.getProcessor();
            double rmax = r.getStats().max;
            double max = 0.0;
            if (rmax > max) {
                max = rmax;
            }
            if ((gmax = g2.getStats().max) > max) {
                max = gmax;
            }
            if ((bmax = b.getStats().max) > max) {
                max = bmax;
            }
            double scale = 255.0 / max;
            r.multiply(scale);
            g2.multiply(scale);
            b.multiply(scale);
            red2.setProcessor(r.convertToByte(false));
            green2.setProcessor(g2.convertToByte(false));
            blue2.setProcessor(b.convertToByte(false));
        }
        RGBStackMerge merge = new RGBStackMerge();
        if (clip) {
            merge.setScaleWhenConverting(false);
        }
        ImageStack stack2 = merge.mergeStacks(w, h2, d, red2.getStack(), green2.getStack(), blue2.getStack(), true);
        this.imp = saveImp;
        this.projImage = new ImagePlus(this.makeTitle(), stack2);
    }

    protected GenericDialog buildControlDialog(int start, int stop) {
        GenericDialog gd = new GenericDialog("ZProjection");
        gd.addNumericField("Start slice:", this.startSlice, 0);
        gd.addNumericField("Stop slice:", this.stopSlice, 0);
        gd.addChoice("Projection type", METHODS, METHODS[this.method]);
        if (this.isHyperstack && this.imp.getNFrames() > 1 && this.imp.getNSlices() > 1) {
            gd.addCheckbox("All time frames", this.allTimeFrames);
        }
        return gd;
    }

    public void doProjection() {
        int ptype;
        if (this.imp == null) {
            return;
        }
        if (this.imp.getBitDepth() == 24) {
            this.doRGBProjection();
            return;
        }
        this.sliceCount = 0;
        if (this.method < 0 || this.method > 5) {
            this.method = 0;
        }
        for (int slice = this.startSlice; slice <= this.stopSlice; slice += this.increment) {
            ++this.sliceCount;
        }
        if (this.method == 5) {
            this.projImage = this.doMedianProjection();
            return;
        }
        FloatProcessor fp = new FloatProcessor(this.imp.getWidth(), this.imp.getHeight());
        ImageStack stack = this.imp.getStack();
        RayFunction rayFunc = this.getRayFunction(this.method, fp);
        if (IJ.debugMode) {
            IJ.log("\nProjecting stack from: " + this.startSlice + " to: " + this.stopSlice);
        }
        if (stack.getProcessor(1) instanceof ByteProcessor) {
            ptype = 0;
        } else if (stack.getProcessor(1) instanceof ShortProcessor) {
            ptype = 1;
        } else if (stack.getProcessor(1) instanceof FloatProcessor) {
            ptype = 2;
        } else {
            IJ.error("Z Project", "Non-RGB stack required");
            return;
        }
        int sliceCount = 0;
        for (int n = this.startSlice; n <= this.stopSlice; n += this.increment) {
            if (!this.isHyperstack) {
                IJ.showStatus("ZProjection " + this.color + ": " + n + "/" + this.stopSlice);
                IJ.showProgress(n - this.startSlice, this.stopSlice - this.startSlice);
            }
            this.projectSlice(stack.getPixels(n), rayFunc, ptype);
            ++sliceCount;
        }
        if (this.method == 3) {
            if (this.imp.getCalibration().isSigned16Bit()) {
                fp.subtract((double)sliceCount * 32768.0);
            }
            fp.resetMinAndMax();
            this.projImage = new ImagePlus(this.makeTitle(), fp);
        } else if (this.method == 4) {
            rayFunc.postProcess();
            fp.resetMinAndMax();
            this.projImage = new ImagePlus(this.makeTitle(), fp);
        } else {
            rayFunc.postProcess();
            this.projImage = this.makeOutputImage(this.imp, fp, ptype);
        }
        if (this.projImage == null) {
            IJ.error("Z Project", "Error computing projection.");
        }
    }

    public void doProjection(boolean handleOverlay) {
        if (this.isHyperstack) {
            this.doHyperStackProjection(this.allTimeFrames);
        } else if (this.imp.getType() == 4) {
            this.doRGBProjection(handleOverlay);
        } else {
            this.doProjection();
            Overlay overlay = this.imp.getOverlay();
            if (handleOverlay && overlay != null) {
                this.projImage.setOverlay(this.projectStackRois(overlay));
            }
        }
        if (this.projImage != null) {
            this.projImage.setCalibration(this.imp.getCalibration());
        }
    }

    private Overlay projectStackRois(Overlay overlay) {
        if (overlay == null) {
            return null;
        }
        Overlay overlay2 = overlay.create();
        for (Roi r : overlay.toArray()) {
            int s2 = r.getPosition();
            Roi roi = (Roi)r.clone();
            if ((s2 < this.startSlice || s2 > this.stopSlice) && s2 != 0) continue;
            roi.setPosition(s2);
            overlay2.add(roi);
        }
        return overlay2;
    }

    public void doHyperStackProjection(boolean allTimeFrames) {
        Overlay overlay;
        int start = this.startSlice;
        int stop = this.stopSlice;
        int firstFrame = 1;
        int lastFrame = this.imp.getNFrames();
        if (!allTimeFrames) {
            firstFrame = lastFrame = this.imp.getFrame();
        }
        ImageStack stack = new ImageStack(this.imp.getWidth(), this.imp.getHeight());
        int channels = this.imp.getNChannels();
        int slices = this.imp.getNSlices();
        if (slices == 1) {
            slices = this.imp.getNFrames();
            lastFrame = 1;
            firstFrame = 1;
        }
        int frames = lastFrame - firstFrame + 1;
        this.increment = channels;
        boolean rgb = this.imp.getBitDepth() == 24;
        for (int frame = firstFrame; frame <= lastFrame; ++frame) {
            IJ.showStatus("" + (frame - firstFrame) + "/" + (lastFrame - firstFrame));
            IJ.showProgress(frame - firstFrame, lastFrame - firstFrame);
            for (int channel = 1; channel <= channels; ++channel) {
                this.startSlice = (frame - 1) * channels * slices + (start - 1) * channels + channel;
                this.stopSlice = (frame - 1) * channels * slices + (stop - 1) * channels + channel;
                if (rgb) {
                    this.doHSRGBProjection(this.imp);
                } else {
                    this.doProjection();
                }
                stack.addSlice(null, this.projImage.getProcessor());
            }
        }
        this.projImage = new ImagePlus(this.makeTitle(), stack);
        this.projImage.setDimensions(channels, 1, frames);
        if (channels > 1) {
            this.projImage = new CompositeImage(this.projImage, 0);
            ((CompositeImage)this.projImage).copyLuts(this.imp);
            if (this.method == 3 || this.method == 4) {
                ((CompositeImage)this.projImage).resetDisplayRanges();
            }
        }
        if (frames > 1) {
            this.projImage.setOpenAsHyperStack(true);
        }
        if ((overlay = this.imp.getOverlay()) != null) {
            this.startSlice = start;
            this.stopSlice = stop;
            if (this.imp.getType() == 4) {
                this.projImage.setOverlay(this.projectRGBHyperStackRois(overlay));
            } else {
                this.projImage.setOverlay(this.projectHyperStackRois(overlay));
            }
        }
        IJ.showProgress(1, 1);
    }

    private Overlay projectRGBHyperStackRois(Overlay overlay) {
        if (overlay == null) {
            return null;
        }
        int frames = this.projImage.getNFrames();
        int t1 = this.imp.getFrame();
        Overlay overlay2 = overlay.create();
        for (Roi r : overlay.toArray()) {
            int c = r.getCPosition();
            int z = r.hasHyperStackPosition() ? r.getZPosition() : 0;
            int t2 = r.getTPosition();
            Roi roi = (Roi)r.clone();
            if ((z < this.startSlice || z > this.stopSlice) && z != 0 && c != 0 && t2 != 0 || frames == 1 && t2 != t1 && t2 != 0) continue;
            roi.setPosition(t2);
            overlay2.add(roi);
        }
        return overlay2;
    }

    private Overlay projectHyperStackRois(Overlay overlay) {
        if (overlay == null) {
            return null;
        }
        int t1 = this.imp.getFrame();
        int channels = this.projImage.getNChannels();
        int slices = 1;
        int frames = this.projImage.getNFrames();
        Overlay overlay2 = overlay.create();
        int size = channels * slices * frames;
        for (Roi r : overlay.toArray()) {
            int c = r.getCPosition();
            int z = r.getZPosition();
            int t2 = r.getTPosition();
            Roi roi = (Roi)r.clone();
            if (size == channels) {
                if ((z < this.startSlice || z > this.stopSlice || t2 != t1) && c != 0) continue;
                roi.setPosition(c);
                overlay2.add(roi);
                continue;
            }
            if (size != frames * channels) continue;
            if (z >= this.startSlice && z <= this.stopSlice) {
                roi.setPosition(c, 1, t2);
            } else {
                if (z != 0) continue;
                roi.setPosition(c, 0, t2);
            }
            overlay2.add(roi);
        }
        return overlay2;
    }

    private void doHSRGBProjection(ImagePlus rgbImp) {
        ImageStack stack = rgbImp.getStack();
        ImageStack stack2 = new ImageStack(stack.getWidth(), stack.getHeight());
        for (int i = this.startSlice; i <= this.stopSlice; ++i) {
            stack2.addSlice(null, stack.getProcessor(i));
        }
        this.startSlice = 1;
        this.stopSlice = stack2.getSize();
        this.doRGBProjection(stack2);
    }

    private RayFunction getRayFunction(int method, FloatProcessor fp) {
        switch (method) {
            case 0: 
            case 3: {
                return new AverageIntensity(fp, this.sliceCount);
            }
            case 1: {
                return new MaxIntensity(fp);
            }
            case 2: {
                return new MinIntensity(fp);
            }
            case 4: {
                return new StandardDeviation(fp, this.sliceCount);
            }
        }
        IJ.error("Z Project", "Unknown method.");
        return null;
    }

    private ImagePlus makeOutputImage(ImagePlus imp, FloatProcessor fp, int ptype) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        float[] pixels = (float[])fp.getPixels();
        ImageProcessor oip = null;
        int size = pixels.length;
        switch (ptype) {
            case 0: {
                oip = imp.getProcessor().createProcessor(width, height);
                byte[] pixels8 = (byte[])oip.getPixels();
                for (int i = 0; i < size; ++i) {
                    pixels8[i] = (byte)(pixels[i] + 0.5f);
                }
                break;
            }
            case 1: {
                oip = imp.getProcessor().createProcessor(width, height);
                short[] pixels16 = (short[])oip.getPixels();
                for (int i = 0; i < size; ++i) {
                    pixels16[i] = (short)(pixels[i] + 0.5f);
                }
                break;
            }
            case 2: {
                oip = new FloatProcessor(width, height, pixels, null);
            }
        }
        oip.resetMinAndMax();
        return new ImagePlus(this.makeTitle(), oip);
    }

    private void projectSlice(Object pixelArray, RayFunction rayFunc, int ptype) {
        switch (ptype) {
            case 0: {
                rayFunc.projectSlice((byte[])pixelArray);
                break;
            }
            case 1: {
                rayFunc.projectSlice((short[])pixelArray);
                break;
            }
            case 2: {
                rayFunc.projectSlice((float[])pixelArray);
            }
        }
    }

    String makeTitle() {
        String prefix = "AVG_";
        switch (this.method) {
            case 3: {
                prefix = "SUM_";
                break;
            }
            case 1: {
                prefix = "MAX_";
                break;
            }
            case 2: {
                prefix = "MIN_";
                break;
            }
            case 4: {
                prefix = "STD_";
                break;
            }
            case 5: {
                prefix = "MED_";
            }
        }
        return WindowManager.makeUniqueName(prefix + this.imp.getTitle());
    }

    ImagePlus doMedianProjection() {
        IJ.showStatus("Calculating median...");
        ImageStack stack = this.imp.getStack();
        ImageProcessor[] slices = new ImageProcessor[this.sliceCount];
        int index = 0;
        for (int slice = this.startSlice; slice <= this.stopSlice; slice += this.increment) {
            slices[index++] = stack.getProcessor(slice);
        }
        ImageProcessor ip2 = slices[0].duplicate();
        ip2 = ip2.convertToFloat();
        float[] values2 = new float[this.sliceCount];
        int width = ip2.getWidth();
        int height = ip2.getHeight();
        int inc = Math.max(height / 30, 1);
        for (int y = 0; y < height; ++y) {
            if (y % inc == 0) {
                IJ.showProgress(y, height - 1);
            }
            for (int x = 0; x < width; ++x) {
                for (int i = 0; i < this.sliceCount; ++i) {
                    values2[i] = slices[i].getPixelValue(x, y);
                }
                ip2.putPixelValue(x, y, this.median(values2));
            }
        }
        if (this.imp.getBitDepth() == 8) {
            ip2 = ip2.convertToByte(false);
        }
        IJ.showProgress(1, 1);
        return new ImagePlus(this.makeTitle(), ip2);
    }

    float median(float[] a) {
        Arrays.sort(a);
        int middle = a.length / 2;
        if ((a.length & 1) == 0) {
            return (a[middle - 1] + a[middle]) / 2.0f;
        }
        return a[middle];
    }

    class StandardDeviation
    extends RayFunction {
        private float[] result;
        private double[] sum;
        private double[] sum2;
        private int num;
        private int len;

        public StandardDeviation(FloatProcessor fp, int num) {
            this.result = (float[])fp.getPixels();
            this.len = this.result.length;
            this.num = num;
            this.sum = new double[this.len];
            this.sum2 = new double[this.len];
        }

        @Override
        public void projectSlice(byte[] pixels) {
            int i = 0;
            while (i < this.len) {
                int v = pixels[i] & 0xFF;
                int n = i;
                this.sum[n] = this.sum[n] + (double)v;
                int n2 = i++;
                this.sum2[n2] = this.sum2[n2] + (double)(v * v);
            }
        }

        @Override
        public void projectSlice(short[] pixels) {
            int i = 0;
            while (i < this.len) {
                double v = pixels[i] & 0xFFFF;
                int n = i;
                this.sum[n] = this.sum[n] + v;
                int n2 = i++;
                this.sum2[n2] = this.sum2[n2] + v * v;
            }
        }

        @Override
        public void projectSlice(float[] pixels) {
            int i = 0;
            while (i < this.len) {
                double v = pixels[i];
                int n = i;
                this.sum[n] = this.sum[n] + v;
                int n2 = i++;
                this.sum2[n2] = this.sum2[n2] + v * v;
            }
        }

        @Override
        public void postProcess() {
            double n = this.num;
            for (int i = 0; i < this.len; ++i) {
                if (this.num > 1) {
                    double stdDev = (n * this.sum2[i] - this.sum[i] * this.sum[i]) / n;
                    if (stdDev > 0.0) {
                        this.result[i] = (float)Math.sqrt(stdDev / (n - 1.0));
                        continue;
                    }
                    this.result[i] = 0.0f;
                    continue;
                }
                this.result[i] = 0.0f;
            }
        }
    }

    class MinIntensity
    extends RayFunction {
        private float[] fpixels;
        private int len;

        public MinIntensity(FloatProcessor fp) {
            this.fpixels = (float[])fp.getPixels();
            this.len = this.fpixels.length;
            for (int i = 0; i < this.len; ++i) {
                this.fpixels[i] = Float.MAX_VALUE;
            }
        }

        @Override
        public void projectSlice(byte[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                if (!((float)(pixels[i] & 0xFF) < this.fpixels[i])) continue;
                this.fpixels[i] = pixels[i] & 0xFF;
            }
        }

        @Override
        public void projectSlice(short[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                if (!((float)(pixels[i] & 0xFFFF) < this.fpixels[i])) continue;
                this.fpixels[i] = pixels[i] & 0xFFFF;
            }
        }

        @Override
        public void projectSlice(float[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                if (!(pixels[i] < this.fpixels[i])) continue;
                this.fpixels[i] = pixels[i];
            }
        }
    }

    class MaxIntensity
    extends RayFunction {
        private float[] fpixels;
        private int len;

        public MaxIntensity(FloatProcessor fp) {
            this.fpixels = (float[])fp.getPixels();
            this.len = this.fpixels.length;
            for (int i = 0; i < this.len; ++i) {
                this.fpixels[i] = -3.4028235E38f;
            }
        }

        @Override
        public void projectSlice(byte[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                if (!((float)(pixels[i] & 0xFF) > this.fpixels[i])) continue;
                this.fpixels[i] = pixels[i] & 0xFF;
            }
        }

        @Override
        public void projectSlice(short[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                if (!((float)(pixels[i] & 0xFFFF) > this.fpixels[i])) continue;
                this.fpixels[i] = pixels[i] & 0xFFFF;
            }
        }

        @Override
        public void projectSlice(float[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                if (Float.isNaN(pixels[i]) || !(pixels[i] > this.fpixels[i])) continue;
                this.fpixels[i] = pixels[i];
            }
        }
    }

    class AverageIntensity
    extends RayFunction {
        private float[] fpixels;
        private int num;
        private int len;

        public AverageIntensity(FloatProcessor fp, int num) {
            this.fpixels = (float[])fp.getPixels();
            this.len = this.fpixels.length;
            this.num = num;
        }

        @Override
        public void projectSlice(byte[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + (float)(pixels[i] & 0xFF);
            }
        }

        @Override
        public void projectSlice(short[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + (float)(pixels[i] & 0xFFFF);
            }
        }

        @Override
        public void projectSlice(float[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + pixels[i];
            }
        }

        @Override
        public void postProcess() {
            float fnum = this.num;
            int i = 0;
            while (i < this.len) {
                int n = i++;
                this.fpixels[n] = this.fpixels[n] / fnum;
            }
        }
    }

    abstract class RayFunction {
        RayFunction() {
        }

        public abstract void projectSlice(byte[] var1);

        public abstract void projectSlice(short[] var1);

        public abstract void projectSlice(float[] var1);

        public void postProcess() {
        }
    }
}

