/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.Prefs;
import ij.process.ImageStatistics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class ContrastPlot
extends Canvas
implements MouseListener {
    static final int WIDTH = 128;
    static final int HEIGHT = 64;
    double defaultMin = 0.0;
    double defaultMax = 255.0;
    double min = 0.0;
    double max = 255.0;
    int[] histogram;
    int hmax;
    Image os;
    Graphics osg;
    Color color = Color.gray;
    double scale = Prefs.getGuiScale();
    int width = 128;
    int height = 64;

    public ContrastPlot() {
        this.addMouseListener(this);
        if (this.scale > 1.0) {
            this.width = (int)((double)this.width * this.scale);
            this.height = (int)((double)this.height * this.scale);
        }
        this.setSize(this.width + 1, this.height + 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width + 1, this.height + 1);
    }

    void setHistogram(ImageStatistics stats, Color color) {
        this.color = color;
        this.histogram = stats.histogram;
        if (this.histogram.length != 256) {
            this.histogram = null;
            return;
        }
        int maxCount = 0;
        int mode = 0;
        for (int i = 0; i < 256; ++i) {
            if (this.histogram[i] <= maxCount) continue;
            maxCount = this.histogram[i];
            mode = i;
        }
        int maxCount2 = 0;
        for (int i = 0; i < 256; ++i) {
            if (this.histogram[i] <= maxCount2 || i == mode) continue;
            maxCount2 = this.histogram[i];
        }
        this.hmax = stats.maxCount;
        if (this.hmax > maxCount2 * 2 && maxCount2 != 0) {
            this.histogram[mode] = this.hmax = (int)((double)maxCount2 * 1.5);
        }
        this.os = null;
    }

    @Override
    public void update(Graphics g2) {
        this.paint(g2);
    }

    @Override
    public void paint(Graphics g2) {
        int y2;
        int x2;
        int y1;
        int x1;
        double scale = (double)this.width / (this.defaultMax - this.defaultMin);
        double slope = 0.0;
        if (this.max != this.min) {
            slope = (double)this.height / (this.max - this.min);
        }
        if (this.min >= this.defaultMin) {
            x1 = (int)(scale * (this.min - this.defaultMin));
            y1 = this.height;
        } else {
            x1 = 0;
            y1 = this.max > this.min ? this.height - (int)((this.defaultMin - this.min) * slope) : this.height;
        }
        if (this.max <= this.defaultMax) {
            x2 = (int)(scale * (this.max - this.defaultMin));
            y2 = 0;
        } else {
            x2 = this.width;
            y2 = this.max > this.min ? this.height - (int)((this.defaultMax - this.min) * slope) : 0;
        }
        if (this.histogram != null) {
            if (this.os == null && this.hmax != 0) {
                this.os = this.createImage(this.width, this.height);
                this.osg = this.os.getGraphics();
                this.osg.setColor(Color.white);
                this.osg.fillRect(0, 0, this.width, this.height);
                this.osg.setColor(this.color);
                double scale2 = (double)this.width / 256.0;
                for (int i = 0; i < 256; ++i) {
                    int x = (int)((double)i * scale2);
                    this.osg.drawLine(x, this.height, x, this.height - this.height * this.histogram[i] / this.hmax);
                }
                this.osg.dispose();
            }
            if (this.os != null) {
                g2.drawImage(this.os, 0, 0, this);
            }
        } else {
            g2.setColor(Color.white);
            g2.fillRect(0, 0, this.width, this.height);
        }
        g2.setColor(Color.black);
        g2.drawLine(x1, y1, x2, y2);
        g2.drawLine(x2, this.height - 5, x2, this.height);
        g2.drawRect(0, 0, this.width, this.height);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }
}

