/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.plugin.frame.PlugInFrame;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;

public class MemoryMonitor
extends PlugInFrame {
    private static final double scale = Prefs.getGuiScale();
    private static final int width = (int)(250.0 * scale);
    private static final int height = (int)(90.0 * scale);
    private static final String LOC_KEY = "memory.loc";
    private static MemoryMonitor instance;
    private Image image;
    private Graphics2D g;
    private int frames;
    private double[] mem;
    private int index;
    private long value;
    private double defaultMax;
    private double max;
    private long maxMemory;
    private boolean done;

    public MemoryMonitor() {
        super("Memory");
        this.max = this.defaultMax = 2.097152E7;
        this.maxMemory = IJ.maxMemory();
        if (instance != null) {
            WindowManager.toFront(instance);
            return;
        }
        instance = this;
        WindowManager.addWindow(this);
        this.setLayout(new BorderLayout());
        PlotCanvas ic = new PlotCanvas();
        ic.setSize(width, height);
        this.add(ic);
        this.setResizable(false);
        this.pack();
        Point loc = Prefs.getLocation(LOC_KEY);
        if (loc != null) {
            this.setLocation(loc);
        } else {
            GUI.centerOnImageJScreen(this);
        }
        this.image = this.createImage(width, height);
        this.g = (Graphics2D)this.image.getGraphics();
        this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g.setColor(Color.white);
        this.g.fillRect(0, 0, width, height);
        this.g.setFont(new Font("SansSerif", 0, (int)(12.0 * Prefs.getGuiScale())));
        this.show();
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            this.addKeyListener(ij);
            ic.addKeyListener(ij);
            ic.addMouseListener(ij);
        }
        this.mem = new double[width + 1];
        Thread.currentThread().setPriority(1);
        while (!this.done) {
            this.updatePlot();
            this.addText();
            ic.repaint();
            IJ.wait(50);
            ++this.frames;
        }
    }

    void addText() {
        double value2 = (double)this.value / 1048576.0;
        String s2 = IJ.d2s(value2, value2 > 50.0 ? 0 : 2) + "MB";
        if (this.maxMemory > 0L) {
            double percent = this.value * 100L / this.maxMemory;
            s2 = s2 + " (" + (percent < 1.0 ? "<1" : IJ.d2s(percent, 0)) + "%)";
        }
        this.g.drawString(s2, 2, 15);
        String images = "" + WindowManager.getImageCount();
        this.g.drawString(images, width - (5 + images.length() * 8), 15);
    }

    void updatePlot() {
        int index2;
        double used = IJ.currentMemory();
        if (this.frames % 10 == 0) {
            this.value = (long)used;
        }
        if (used > 0.86 * this.max) {
            this.max *= 2.0;
        }
        this.mem[this.index++] = used;
        if (this.index == this.mem.length) {
            this.index = 0;
        }
        double maxmax = 0.0;
        for (int i = 0; i < this.mem.length; ++i) {
            if (!(this.mem[i] > maxmax)) continue;
            maxmax = this.mem[i];
        }
        if (maxmax < this.defaultMax) {
            this.max = this.defaultMax * 2.0;
        }
        if (maxmax < this.defaultMax / 2.0) {
            this.max = this.defaultMax;
        }
        if ((index2 = this.index + 1) == this.mem.length) {
            index2 = 0;
        }
        this.g.setColor(Color.white);
        this.g.fillRect(0, 0, width, height);
        this.g.setColor(Color.black);
        double scale = (double)height / this.max;
        int x1 = 0;
        int y1 = height - (int)(this.mem[index2] * scale);
        int x2 = 1;
        while (x2 < width) {
            if (++index2 == this.mem.length) {
                index2 = 0;
            }
            int y2 = height - (int)(this.mem[index2] * scale);
            this.g.drawLine(x1, y1, x2, y2);
            x1 = x2++;
            y1 = y2;
        }
    }

    @Override
    public void close() {
        super.close();
        instance = null;
        Prefs.saveLocation(LOC_KEY, this.getLocation());
        this.done = true;
    }

    class PlotCanvas
    extends Canvas {
        PlotCanvas() {
        }

        @Override
        public void update(Graphics g2) {
            this.paint(g2);
        }

        @Override
        public void paint(Graphics g2) {
            g2.drawImage(MemoryMonitor.this.image, 0, 0, null);
        }
    }
}

