/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.ChannelSplitter;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.StackStatistics;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

class ThresholdPlot
extends Canvas
implements Measurements,
MouseListener {
    double scale = Prefs.getGuiScale();
    int width = (int)Math.round(256.0 * this.scale);
    int height = (int)Math.round(48.0 * this.scale);
    int lowerThreshold = -1;
    int upperThreshold = (int)Math.round(170.0 * this.scale);
    ImageStatistics stats;
    int[] histogram;
    Color[] hColors;
    int hmax;
    Image os;
    Graphics osg;
    int mode;
    int originalModeCount;
    double stackMin;
    double stackMax;
    int imageID2;
    boolean entireStack2;
    double mean2;

    public ThresholdPlot() {
        this.addMouseListener(this);
        this.setSize(this.width + 2, this.height + 2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width + 2, this.height + 2);
    }

    ImageStatistics setHistogram(ImagePlus imp, boolean entireStack, boolean rawValues) {
        Roi roi;
        double mean;
        if (IJ.debugMode) {
            IJ.log("ThresholdAdjuster:setHistogram: " + entireStack + " " + this.entireStack2);
        }
        double d = mean = entireStack ? imp.getProcessor().getStats().mean : 0.0;
        if (entireStack && this.stats != null && imp.getID() == this.imageID2 && entireStack == this.entireStack2 && mean == this.mean2) {
            return this.stats;
        }
        this.mean2 = mean;
        ImageProcessor ip = imp.getProcessor();
        ColorModel cm = ip.getColorModel();
        this.stats = null;
        if (entireStack) {
            if (imp.isHyperStack()) {
                ImageStack stack = ChannelSplitter.getChannel(imp, imp.getChannel());
                this.stats = new StackStatistics(new ImagePlus("", stack));
            } else {
                this.stats = new StackStatistics(imp);
            }
        }
        if (!(ip instanceof ByteProcessor)) {
            int digits;
            boolean calibrated;
            if (entireStack) {
                if (imp.getLocalCalibration().isSigned16Bit()) {
                    this.stats.min += 32768.0;
                    this.stats.max += 32768.0;
                }
                this.stackMin = this.stats.min;
                this.stackMax = this.stats.max;
                ip.setMinAndMax(this.stackMin, this.stackMax);
                imp.updateAndDraw();
            } else {
                this.stackMax = 0.0;
                this.stackMin = 0.0;
                if (this.entireStack2) {
                    ip.resetMinAndMax();
                    imp.updateAndDraw();
                }
            }
            Calibration cal = imp.getCalibration();
            boolean bl = calibrated = cal.calibrated() && !rawValues;
            if (ip instanceof FloatProcessor) {
                digits = Math.max(Analyzer.getPrecision(), 2);
                IJ.showStatus("min=" + IJ.d2s(ip.getMin(), digits) + ", max=" + IJ.d2s(ip.getMax(), digits));
            } else {
                digits = calibrated && !cal.isSigned16Bit() ? 2 : 0;
                double cmin = calibrated ? cal.getCValue(ip.getMin()) : ip.getMin();
                double cmax = calibrated ? cal.getCValue(ip.getMax()) : ip.getMax();
                IJ.showStatus("min=" + IJ.d2s(cal.getCValue(cmin), digits) + ", max=" + IJ.d2s(cal.getCValue(cmax), digits));
            }
            ip = ip.convertToByte(true);
            ip.setColorModel(ip.getDefaultColorModel());
        }
        if ((roi = imp.getRoi()) != null && !roi.isArea()) {
            roi = null;
        }
        ip.setRoi(roi);
        if (this.stats == null) {
            this.stats = ip.getStats();
        }
        if (IJ.debugMode) {
            IJ.log("  stats: " + this.stats);
        }
        int maxCount2 = 0;
        this.histogram = this.stats.histogram;
        this.originalModeCount = this.histogram[this.stats.mode];
        for (int i = 0; i < this.stats.nBins; ++i) {
            if (this.histogram[i] <= maxCount2 || i == this.stats.mode) continue;
            maxCount2 = this.histogram[i];
        }
        this.hmax = this.stats.maxCount;
        if ((double)this.hmax > (double)maxCount2 * 1.5 && maxCount2 != 0) {
            this.hmax = (int)((double)maxCount2 * 1.2);
        }
        this.os = null;
        if (!(cm instanceof IndexColorModel)) {
            return null;
        }
        IndexColorModel icm = (IndexColorModel)cm;
        int mapSize = icm.getMapSize();
        if (mapSize != 256) {
            return null;
        }
        byte[] r = new byte[256];
        byte[] g2 = new byte[256];
        byte[] b = new byte[256];
        icm.getReds(r);
        icm.getGreens(g2);
        icm.getBlues(b);
        this.hColors = new Color[256];
        int brightnessLimit = 1800;
        for (int i = 0; i < 256; ++i) {
            int sum = 4 * (r[i] & 0xFF) + 5 * (g2[i] & 0xFF) + (b[i] & 0xFF);
            if (sum > 1800) {
                r[i] = (byte)((r[i] & 0xFF) * 1800 * 2 / (sum + 1800));
                g2[i] = (byte)((g2[i] & 0xFF) * 1800 * 2 / (sum + 1800));
                b[i] = (byte)((b[i] & 0xFF) * 1800 * 2 / (sum + 1800));
            }
            this.hColors[i] = new Color(r[i] & 0xFF, g2[i] & 0xFF, b[i] & 0xFF);
        }
        this.imageID2 = imp.getID();
        this.entireStack2 = entireStack;
        return this.stats;
    }

    @Override
    public void update(Graphics g2) {
        this.paint(g2);
    }

    @Override
    public void paint(Graphics g2) {
        if (g2 == null) {
            return;
        }
        if (this.histogram != null) {
            if (this.os == null && this.hmax > 0) {
                this.os = this.createImage(this.width, this.height);
                this.osg = this.os.getGraphics();
                if (this.scale > 1.0) {
                    ((Graphics2D)this.osg).setStroke(new BasicStroke((float)this.scale));
                }
                this.osg.setColor(Color.white);
                this.osg.fillRect(0, 0, this.width, this.height);
                this.osg.setColor(Color.gray);
                double scale2 = (double)this.width / 256.0;
                int barWidth = 1;
                if (this.scale > 1.0) {
                    barWidth = 2;
                }
                if (this.scale > 2.0) {
                    barWidth = 3;
                }
                for (int i = 0; i < 256; ++i) {
                    if (this.hColors != null) {
                        this.osg.setColor(this.hColors[i]);
                    }
                    int x = (int)((double)i * scale2);
                    for (int j = 0; j < barWidth; ++j) {
                        this.osg.drawLine(x + j, this.height, x + j, this.height - (this.height * this.histogram[i] + this.hmax - 1) / this.hmax);
                    }
                }
                this.osg.dispose();
            }
            if (this.os == null) {
                return;
            }
            g2.drawImage(this.os, 1, 1, this);
        } else {
            g2.setColor(Color.white);
            g2.fillRect(1, 1, this.width, this.height);
        }
        g2.setColor(Color.black);
        g2.drawRect(0, 0, this.width + 1, this.height + 1);
        if (this.lowerThreshold == -1) {
            return;
        }
        if (this.mode == 2) {
            g2.setColor(Color.blue);
            g2.drawRect(0, 0, this.lowerThreshold, this.height + 1);
            g2.drawRect(0, 1, this.lowerThreshold, 1);
            g2.setColor(Color.green);
            g2.drawRect(this.upperThreshold + 2, 0, this.width - this.upperThreshold - 1, this.height + 1);
            g2.drawLine(this.upperThreshold + 2, 1, this.width + 1, 1);
            return;
        }
        if (this.mode == 0) {
            g2.setColor(Color.red);
        }
        g2.drawRect(this.lowerThreshold + 1, 0, this.upperThreshold - this.lowerThreshold, this.height + 1);
        g2.drawLine(this.lowerThreshold + 1, 1, this.upperThreshold + 1, 1);
    }

    void setThreshold(int min2, int max) {
        this.lowerThreshold = (int)Math.round((double)min2 * this.scale);
        this.upperThreshold = (int)Math.round((double)max * this.scale);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }
}

