/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class PolygonFiller {
    int BLACK = -16777216;
    int WHITE = -1;
    int edges;
    int activeEdges;
    int[] x;
    int[] y;
    float[] xf;
    float[] yf;
    double xOffset;
    double yOffset;
    int n;
    double[] ex;
    int[] ey1;
    int[] ey2;
    double[] eslope;
    int yMin;
    int yMax;
    int[] sedge;
    int[] aedge;

    public PolygonFiller() {
    }

    public PolygonFiller(int[] x, int[] y, int n) {
        this.setPolygon(x, y, n);
    }

    public PolygonFiller(float[] xf, float[] yf, int n, double xOffset, double yOffset) {
        this.setPolygon(xf, yf, n, xOffset, yOffset);
    }

    public void setPolygon(int[] x, int[] y, int n) {
        this.x = x;
        this.y = y;
        this.n = n;
    }

    public void setPolygon(float[] xf, float[] yf, int n, double xOffset, double yOffset) {
        this.y = null;
        this.x = null;
        this.xf = xf;
        this.yf = yf;
        this.n = n;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    void allocateArrays(int n) {
        if (this.ex == null || n > this.ex.length) {
            this.ex = new double[n];
            this.ey1 = new int[n];
            this.ey2 = new int[n];
            this.sedge = new int[n];
            this.aedge = new int[n];
            this.eslope = new double[n];
        }
    }

    void buildEdgeTable() {
        int i;
        this.yMin = Integer.MAX_VALUE;
        this.yMax = Integer.MIN_VALUE;
        this.edges = 0;
        int polyStart = 0;
        for (i = 0; i < this.n; ++i) {
            int iplus1;
            int n = iplus1 = i == this.n - 1 ? polyStart : i + 1;
            if (this.x != null) {
                int y1 = this.y[i];
                int y2 = this.y[iplus1];
                int x1 = this.x[i];
                int x2 = this.x[iplus1];
                if (y1 == y2) continue;
                if (y1 > y2) {
                    int tmp = y1;
                    y1 = y2;
                    y2 = tmp;
                    tmp = x1;
                    x1 = x2;
                    x2 = tmp;
                }
                double slope = (double)(x2 - x1) / (double)(y2 - y1);
                this.ex[this.edges] = (double)x1 + 0.5 * slope + 1.0E-8;
                this.ey1[this.edges] = y1;
                this.ey2[this.edges] = y2;
                this.eslope[this.edges] = slope;
                if (y1 < this.yMin) {
                    this.yMin = y1;
                }
                if (y2 > this.yMax) {
                    this.yMax = y2;
                }
            } else {
                int y2;
                if (Float.isNaN(this.xf[iplus1])) {
                    iplus1 = polyStart;
                }
                if (Float.isNaN(this.xf[i])) {
                    polyStart = i + 1;
                    continue;
                }
                double y1f = (double)this.yf[i] + this.yOffset;
                double y2f = (double)this.yf[iplus1] + this.yOffset;
                double x1f = (double)this.xf[i] + this.xOffset;
                double x2f = (double)this.xf[iplus1] + this.xOffset;
                int y1 = (int)Math.round(y1f);
                if (y1 == (y2 = (int)Math.round(y2f)) || y1 <= 0 && y2 <= 0) continue;
                if (y1 > y2) {
                    int tmp = y1;
                    y1 = y2;
                    y2 = tmp;
                    double ftmp = y1f;
                    y1f = y2f;
                    y2f = ftmp;
                    ftmp = x1f;
                    x1f = x2f;
                    x2f = ftmp;
                }
                double slope = (x2f - x1f) / (y2f - y1f);
                this.ex[this.edges] = x1f + ((double)y1 - y1f + 0.5) * slope + 1.0E-8;
                this.ey1[this.edges] = y1;
                this.ey2[this.edges] = y2;
                this.eslope[this.edges] = slope;
                if (y1 < this.yMin) {
                    this.yMin = y1;
                }
                if (y2 > this.yMax) {
                    this.yMax = y2;
                }
            }
            ++this.edges;
        }
        for (i = 0; i < this.edges; ++i) {
            this.sedge[i] = i;
        }
        this.activeEdges = 0;
    }

    public void fill(ImageProcessor ip, Rectangle r) {
        ip.fill(this.getMask(r.width, r.height));
    }

    public ImageProcessor getMask(int width, int height) {
        ByteProcessor mask = new ByteProcessor(width, height);
        this.fillByteProcessorMask(mask);
        return mask;
    }

    public void fillByteProcessorMask(ByteProcessor mask) {
        int yStart;
        int width = mask.getWidth();
        int height = mask.getHeight();
        byte[] pixels = (byte[])mask.getPixels();
        this.allocateArrays(this.n);
        this.buildEdgeTable();
        int n = yStart = this.yMin > 0 ? this.yMin : 0;
        if (this.yMin != 0) {
            this.shiftXValuesAndActivate(yStart);
        }
        for (int y = yStart; y < Math.min(height, this.yMax + 1); ++y) {
            this.removeInactiveEdges(y);
            this.activateEdges(y);
            int offset = y * width;
            for (int i = 0; i < this.activeEdges; i += 2) {
                int x2;
                int x1 = (int)(this.ex[this.aedge[i]] + 0.5);
                if (x1 < 0) {
                    x1 = 0;
                }
                if (x1 > width) {
                    x1 = width;
                }
                if ((x2 = (int)(this.ex[this.aedge[i + 1]] + 0.5)) < 0) {
                    x2 = 0;
                }
                if (x2 > width) {
                    x2 = width;
                }
                for (int x = x1; x < x2; ++x) {
                    pixels[offset + x] = -1;
                }
            }
            this.updateXCoordinates();
        }
    }

    void shiftXValuesAndActivate(int yStart) {
        for (int i = 0; i < this.edges; ++i) {
            int index = this.sedge[i];
            if (this.ey1[index] >= yStart || this.ey2[index] < yStart) continue;
            int n = index;
            this.ex[n] = this.ex[n] + this.eslope[index] * (double)(yStart - this.ey1[index]);
            this.aedge[this.activeEdges++] = index;
        }
        this.sortActiveEdges();
    }

    void updateXCoordinates() {
        double x1 = -1.7976931348623157E308;
        boolean sorted2 = true;
        for (int i = 0; i < this.activeEdges; ++i) {
            double x2;
            int index = this.aedge[i];
            this.ex[index] = x2 = this.ex[index] + this.eslope[index];
            if (x2 < x1) {
                sorted2 = false;
            }
            x1 = x2;
        }
        if (!sorted2) {
            this.sortActiveEdges();
        }
    }

    void sortActiveEdges() {
        for (int i = 0; i < this.activeEdges; ++i) {
            int min2 = i;
            for (int j = i; j < this.activeEdges; ++j) {
                if (!(this.ex[this.aedge[j]] < this.ex[this.aedge[min2]])) continue;
                min2 = j;
            }
            int tmp = this.aedge[min2];
            this.aedge[min2] = this.aedge[i];
            this.aedge[i] = tmp;
        }
    }

    void removeInactiveEdges(int y) {
        int i = 0;
        while (i < this.activeEdges) {
            int index = this.aedge[i];
            if (y < this.ey1[index] || y >= this.ey2[index]) {
                for (int j = i; j < this.activeEdges - 1; ++j) {
                    this.aedge[j] = this.aedge[j + 1];
                }
                --this.activeEdges;
                continue;
            }
            ++i;
        }
    }

    void activateEdges(int y) {
        for (int i = 0; i < this.edges; ++i) {
            int index;
            int edge = this.sedge[i];
            if (y != this.ey1[edge]) continue;
            for (index = 0; index < this.activeEdges && this.ex[edge] > this.ex[this.aedge[index]]; ++index) {
            }
            for (int j = this.activeEdges - 1; j >= index; --j) {
                this.aedge[j + 1] = this.aedge[j];
            }
            this.aedge[index] = edge;
            ++this.activeEdges;
        }
    }

    void printEdges() {
        for (int i = 0; i < this.edges; ++i) {
            int index = i;
            IJ.log(i + ": x=" + IJ.d2s(this.ex[index]) + " y=" + this.ey1[index] + " to " + this.ey2[index] + " sl=" + IJ.d2s(this.eslope[index], 2));
        }
    }

    void printActiveEdges() {
        for (int i = 0; i < this.activeEdges; ++i) {
            int index = this.aedge[i];
            IJ.log(i + ": x=" + IJ.d2s(this.ex[index]) + " y=" + this.ey1[index] + " to " + this.ey2[index] + " sl=" + IJ.d2s(this.eslope[index], 2));
        }
    }
}

