/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

import java.util.Arrays;

public class ArrayUtil {
    private int size;
    float[] values;
    boolean sorted;

    public void setSize(int si) {
        this.size = si;
    }

    public ArrayUtil(int size) {
        this.size = size;
        this.values = new float[size];
        this.sorted = false;
    }

    public ArrayUtil(float[] data) {
        this.size = data.length;
        this.sorted = false;
        this.values = data;
    }

    public boolean putValue(int pos, float value) {
        if (pos < this.size) {
            this.values[pos] = value;
            this.sorted = false;
            return true;
        }
        return false;
    }

    public double getMean() {
        double total = 0.0;
        for (int i = 0; i < this.size; ++i) {
            total += (double)this.values[i];
        }
        return total / (double)this.size;
    }

    public double medianSort() {
        if (!this.sorted) {
            this.sort();
        }
        if (this.size % 2 == 1) {
            return this.values[this.size / 2];
        }
        return 0.5f * (this.values[this.size / 2 - 1] + this.values[this.size / 2]);
    }

    public void sort() {
        if (this.size < this.values.length) {
            float[] tosort = new float[this.size];
            System.arraycopy(this.values, 0, tosort, 0, this.size);
            Arrays.sort(tosort);
            System.arraycopy(tosort, 0, this.values, 0, this.size);
        } else {
            Arrays.sort(this.values);
        }
        this.sorted = true;
    }

    public boolean isMaximum(double val) {
        int i;
        boolean maxok = true;
        for (i = 0; i < this.size && (double)this.values[i] <= val; ++i) {
        }
        if (i < this.size) {
            maxok = false;
        }
        return maxok;
    }

    public double getMinimum() {
        double min2 = this.values[0];
        for (int i = 1; i < this.size; ++i) {
            if (!((double)this.values[i] < min2)) continue;
            min2 = this.values[i];
        }
        return min2;
    }

    public double getMaximum() {
        double max = this.values[0];
        for (int i = 1; i < this.size; ++i) {
            if (!((double)this.values[i] > max)) continue;
            max = this.values[i];
        }
        return max;
    }

    public double getVariance() {
        if (this.size == 1) {
            return 0.0;
        }
        double total = 0.0;
        double total2 = 0.0;
        for (int i = 0; i < this.size; ++i) {
            total += (double)this.values[i];
            total2 += (double)(this.values[i] * this.values[i]);
        }
        double var = (total2 - total * total / (double)this.size) / (double)(this.size - 1);
        return var;
    }

    public String toString() {
        String str = "{" + this.values[0];
        for (int i = 1; i < this.size; ++i) {
            str = str + ", " + this.values[i];
        }
        return str + "}";
    }
}

