/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Set;
import java.util.TreeMap;
import loci.common.IniList;
import loci.common.IniTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IniWriter.class);

    public void saveINI(IniList ini, String path) throws IOException {
        this.saveINI(ini, path, true);
    }

    public void saveINI(IniList ini, String path, boolean append, boolean sorted2) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path, append), "UTF-8"));
        for (IniTable table : ini) {
            Set keys2;
            String header = (String)table.get("header");
            out.write("[" + header + "]\n");
            if (sorted2) {
                TreeMap<String, String> treeMap = new TreeMap<String, String>(table);
                keys2 = treeMap.keySet();
            } else {
                keys2 = table.keySet();
            }
            for (String key : keys2) {
                out.write(key + " = " + (String)table.get(key) + "\n");
            }
            out.write("\n");
        }
        out.close();
    }

    public void saveINI(IniList ini, String path, boolean append) throws IOException {
        this.saveINI(ini, path, append, false);
    }
}

