/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.Collator;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.model.primitives.Color;

public class GatanReader
extends FormatReader {
    public static final int DM3_MAGIC_BYTES = 3;
    public static final int DM4_MAGIC_BYTES = 4;
    private static final int GROUP = 20;
    private static final int VALUE = 21;
    private static final int ARRAY = 15;
    private static final int SHORT = 2;
    private static final int USHORT = 4;
    private static final int INT = 3;
    private static final int UINT = 5;
    private static final int FLOAT = 6;
    private static final int DOUBLE = 7;
    private static final int BYTE = 8;
    private static final int UBYTE = 9;
    private static final int CHAR = 10;
    private static final int UNKNOWN = 11;
    private static final int UNKNOWN2 = 12;
    private static final int LINE = 2;
    private static final int RECTANGLE = 5;
    private static final int ELLIPSE = 6;
    private static final int TEXT = 13;
    public static final String SPLIT_MONTAGE = "gatan.split_montage";
    public static final boolean SPLIT_MONTAGE_DEFAULT = true;
    private long pixelOffset;
    private List<Double> pixelSizes;
    private List<String> units;
    private long numPixelBytes;
    private boolean signed;
    private long timestamp;
    private double gamma;
    private double mag;
    private double voltage;
    private String info;
    private Length posX;
    private Length posY;
    private Length posZ;
    private double sampleTime;
    private boolean adjustEndianness = true;
    private int version;
    private transient List<ROIShape> shapes;
    private transient boolean foundMontage = false;
    private transient List<Length> stageX = new ArrayList<Length>();
    private transient List<Length> stageY = new ArrayList<Length>();
    private transient List<Length> stageZ = new ArrayList<Length>();

    public GatanReader() {
        super("Gatan Digital Micrograph", new String[]{"dm3", "dm4"});
        this.domains = new String[]{"Electron Microscopy (EM)"};
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        int check2 = stream.readInt();
        return check2 == 3 || check2 == 4;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int planeIndex = this.getSeries() * this.getImageCount() + no;
        long planeOffset = (long)planeIndex * (long)FormatTools.getPlaneSize(this);
        this.in.seek(this.pixelOffset + planeOffset);
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
            this.numPixelBytes = 0L;
            this.pixelSizes = null;
            this.signed = false;
            this.timestamp = 0L;
            this.voltage = 0.0;
            this.mag = 0.0;
            this.gamma = 0.0;
            this.info = null;
            this.adjustEndianness = true;
            this.version = 0;
            this.posZ = null;
            this.posY = null;
            this.posX = null;
            this.sampleTime = 0.0;
            this.units = null;
            this.shapes = null;
            this.foundMontage = false;
            this.stageX.clear();
            this.stageY.clear();
            this.stageZ.clear();
        }
    }

    @Override
    protected ArrayList<String> getAvailableOptions() {
        ArrayList<String> optionsList = super.getAvailableOptions();
        optionsList.add(SPLIT_MONTAGE);
        return optionsList;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.pixelOffset = 0L;
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        LOGGER.info("Verifying Gatan format");
        m4.littleEndian = false;
        this.pixelSizes = new ArrayList<Double>();
        this.units = new ArrayList<String>();
        this.shapes = new ArrayList<ROIShape>();
        this.in.order(this.isLittleEndian());
        this.version = this.in.readInt();
        if (this.version != 3 && this.version != 4) {
            throw new FormatException("invalid header");
        }
        LOGGER.info("Reading tags");
        this.in.skipBytes(4);
        this.skipPadding();
        m4.littleEndian = this.in.readInt() != 1;
        this.in.order(this.isLittleEndian());
        this.in.skipBytes(2);
        this.skipPadding();
        int numTags = this.in.readInt();
        if ((long)numTags > this.in.length()) {
            m4.littleEndian = !this.isLittleEndian();
            this.in.order(this.isLittleEndian());
            this.adjustEndianness = false;
        }
        LOGGER.debug("tags ({}) {", (Object)numTags);
        try {
            this.parseTags(numTags, null, "  ");
        }
        catch (Exception e) {
            throw new FormatException("Unable to parse metadata tag", e);
        }
        LOGGER.debug("}");
        LOGGER.info("Populating metadata");
        m4.littleEndian = true;
        if (this.getSizeX() == 0 || this.getSizeY() == 0) {
            throw new FormatException("Dimensions information not found");
        }
        if (m4.sizeZ == 0) {
            m4.sizeZ = 1;
        }
        m4.sizeC = 1;
        m4.sizeT = 1;
        m4.dimensionOrder = "XYZTC";
        m4.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        int bytes = (int)(this.numPixelBytes / ((long)(this.getSizeX() * this.getSizeY()) * (long)this.getImageCount()));
        if (bytes != FormatTools.getBytesPerPixel(this.getPixelType())) {
            m4.pixelType = FormatTools.pixelTypeFromBytes(bytes, this.signed, false);
        }
        m4.rgb = false;
        m4.interleaved = false;
        m4.metadataComplete = true;
        m4.indexed = false;
        m4.falseColor = false;
        if (this.foundMontage && this.splitMontage() && this.stageX.size() > 1 && m4.sizeZ > 1) {
            m4.sizeZ /= this.stageX.size();
            m4.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            for (int i = 1; i < this.stageX.size(); ++i) {
                this.core.add(new CoreMetadata((CoreMetadata)this.core.get(0)));
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String[] scopeInfo;
            int index = 0;
            if (this.pixelSizes.size() > 4) {
                index = this.pixelSizes.size() - 3;
            } else if (this.pixelSizes.size() == 4 && Math.abs(this.pixelSizes.get(0) - 1.0) < 1.0E-6) {
                index = this.pixelSizes.size() - 2;
            }
            if (index + 2 < this.pixelSizes.size() && Math.abs(this.pixelSizes.get(index + 1) - this.pixelSizes.get(index + 2)) < 1.0E-6 && Math.abs(this.pixelSizes.get(index) - this.pixelSizes.get(index + 1)) > 1.0E-6 && this.getSizeY() > 1) {
                ++index;
            }
            if (index < this.pixelSizes.size() - 1) {
                String zUnits;
                Double z;
                Length sizeZ;
                int i;
                Double x = this.pixelSizes.get(index);
                Double y = this.pixelSizes.get(index + 1);
                String xUnits = index < this.units.size() ? this.units.get(index) : "";
                String yUnits = index + 1 < this.units.size() ? this.units.get(index + 1) : "";
                Length sizeX = FormatTools.getPhysicalSizeX(x, this.convertUnits(xUnits));
                String[] sizeY = FormatTools.getPhysicalSizeY(y, this.convertUnits(yUnits));
                if (sizeX != null) {
                    for (i = 0; i < this.getSeriesCount(); ++i) {
                        store.setPixelsPhysicalSizeX(sizeX, i);
                    }
                }
                if (sizeY != null) {
                    for (i = 0; i < this.getSeriesCount(); ++i) {
                        store.setPixelsPhysicalSizeY((Length)sizeY, i);
                    }
                }
                if (index < this.pixelSizes.size() - 2 && (sizeZ = FormatTools.getPhysicalSizeZ(z = this.pixelSizes.get(index + 2), this.convertUnits(zUnits = index + 2 < this.units.size() ? this.units.get(index + 2) : ""))) != null) {
                    for (int i2 = 0; i2 < this.getSeriesCount(); ++i2) {
                        store.setPixelsPhysicalSizeZ(sizeZ, i2);
                    }
                }
            }
            String instrument = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrument, 0);
            String objective = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objective, 0, 0);
            store.setObjectiveCorrection(MetadataTools.getCorrection("Unknown"), 0, 0);
            store.setObjectiveImmersion(MetadataTools.getImmersion("Unknown"), 0, 0);
            store.setObjectiveNominalMagnification(this.mag, 0, 0);
            String detector = MetadataTools.createLSID("Detector", 0, 0);
            store.setDetectorID(detector, 0, 0);
            String mode = null;
            if (this.info == null) {
                this.info = "";
            }
            for (String token : scopeInfo = this.info.split("\\(")) {
                if (!(token = token.trim()).startsWith("Mode")) continue;
                if (token.indexOf(32) > 0) {
                    token = token.substring(token.indexOf(32)).trim();
                }
                if (!(mode = token.indexOf(32) > 0 ? token.substring(0, token.indexOf(32)).trim() : token).equals("TEM")) continue;
                mode = "Other";
            }
            int digits = String.valueOf(this.getSeriesCount() + 1).length();
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                if (this.foundMontage && this.getSeriesCount() > 1) {
                    store.setImageName(String.format("Tile #%0" + digits + "d", i + 1), i);
                }
                store.setImageInstrumentRef(instrument, i);
                store.setObjectiveSettingsID(objective, i);
                store.setDetectorSettingsID(detector, i, 0);
                store.setDetectorSettingsVoltage(new ElectricPotential(this.voltage, UNITS.VOLT), i, 0);
                if (mode != null) {
                    store.setChannelAcquisitionMode(MetadataTools.getAcquisitionMode(mode), i, 0);
                }
                if (this.foundMontage && i < this.stageX.size()) {
                    store.setPlanePositionX(this.stageX.get(i), i, 0);
                    store.setPlanePositionY(this.stageY.get(i), i, 0);
                    store.setPlanePositionZ(this.stageZ.get(i), i, 0);
                } else {
                    store.setPlanePositionX(this.posX, i, 0);
                    store.setPlanePositionY(this.posY, i, 0);
                    store.setPlanePositionZ(this.posZ, i, 0);
                }
                for (int p = 0; p < this.getImageCount(); ++p) {
                    store.setPlaneExposureTime(new Time(this.sampleTime, UNITS.SECOND), i, p);
                }
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.NO_OVERLAYS && this.shapes.size() > 0) {
            int nextROI = 0;
            block15: for (int i = 0; i < this.shapes.size(); ++i) {
                ROIShape shape = this.shapes.get(i);
                String shapeID = null;
                switch (shape.type) {
                    case 2: {
                        shapeID = this.createROI(store, nextROI);
                        store.setLineID(shapeID, nextROI, 0);
                        store.setLineX1(shape.x1, nextROI, 0);
                        store.setLineY1(shape.y1, nextROI, 0);
                        store.setLineX2(shape.x2, nextROI, 0);
                        store.setLineY2(shape.y2, nextROI, 0);
                        store.setLineText(shape.text, nextROI, 0);
                        store.setLineFontSize(shape.fontSize, nextROI, 0);
                        store.setLineStrokeColor(shape.strokeColor, nextROI, 0);
                        ++nextROI;
                        continue block15;
                    }
                    case 13: {
                        shapeID = this.createROI(store, nextROI);
                        store.setLabelID(shapeID, nextROI, 0);
                        store.setLabelX(shape.x1, nextROI, 0);
                        store.setLabelY(shape.y1, nextROI, 0);
                        store.setLabelText(shape.text, nextROI, 0);
                        store.setLabelFontSize(shape.fontSize, nextROI, 0);
                        store.setLabelStrokeColor(shape.strokeColor, nextROI, 0);
                        ++nextROI;
                        continue block15;
                    }
                    case 6: {
                        shapeID = this.createROI(store, nextROI);
                        store.setEllipseID(shapeID, nextROI, 0);
                        double radiusX = (shape.x2 - shape.x1) / 2.0;
                        double radiusY = (shape.y2 - shape.y1) / 2.0;
                        store.setEllipseX(shape.x1 + radiusX, nextROI, 0);
                        store.setEllipseY(shape.y1 + radiusY, nextROI, 0);
                        store.setEllipseRadiusX(radiusX, nextROI, 0);
                        store.setEllipseRadiusY(radiusY, nextROI, 0);
                        store.setEllipseText(shape.text, nextROI, 0);
                        store.setEllipseFontSize(shape.fontSize, nextROI, 0);
                        store.setEllipseStrokeColor(shape.strokeColor, nextROI, 0);
                        ++nextROI;
                        continue block15;
                    }
                    case 5: {
                        shapeID = this.createROI(store, nextROI);
                        store.setRectangleID(shapeID, nextROI, 0);
                        store.setRectangleX(shape.x1, nextROI, 0);
                        store.setRectangleY(shape.y1, nextROI, 0);
                        store.setRectangleWidth(shape.x2 - shape.x1, nextROI, 0);
                        store.setRectangleHeight(shape.y2 - shape.y1, nextROI, 0);
                        store.setRectangleText(shape.text, nextROI, 0);
                        store.setRectangleFontSize(shape.fontSize, nextROI, 0);
                        store.setRectangleStrokeColor(shape.strokeColor, nextROI, 0);
                        ++nextROI;
                        continue block15;
                    }
                    default: {
                        LOGGER.warn("Unknown ROI type: {}", (Object)shape.type);
                    }
                }
            }
        }
    }

    public boolean splitMontage() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(SPLIT_MONTAGE, true);
        }
        return true;
    }

    private void parseTags(int numTags, String parent, String indent) throws FormatException, IOException, ParseException {
        if ("Montage".equals(parent)) {
            this.foundMontage = true;
        }
        for (int i = 0; i < numTags && this.in.getFilePointer() + 3L < this.in.length(); ++i) {
            boolean validPhysicalSize;
            byte type = this.in.readByte();
            int length = this.in.readShort();
            String labelString = null;
            String value = null;
            if (type == 21) {
                labelString = this.in.readByteToString(length);
                this.skipPadding();
                this.skipPadding();
                int skip = this.in.readInt();
                this.skipPadding();
                int n = this.in.readInt();
                this.skipPadding();
                int dataType = this.in.readInt();
                String sb = labelString;
                if (sb.length() > 32) {
                    sb = sb.substring(0, 20) + "... (" + sb.length() + ")";
                }
                LOGGER.debug("{}{}: n={}, dataType={}, label={}", indent, i, n, dataType, sb);
                if (skip != 0x25252525) {
                    LOGGER.warn("Skip mismatch: {}", (Object)skip);
                }
                if (n == 1) {
                    if ("Dimensions".equals(parent) && labelString.length() == 0) {
                        if (this.adjustEndianness) {
                            this.in.order(!this.in.isLittleEndian());
                        }
                        if (i == 0) {
                            ((CoreMetadata)this.core.get((int)0)).sizeX = this.in.readInt();
                        } else if (i == 1) {
                            ((CoreMetadata)this.core.get((int)0)).sizeY = this.in.readInt();
                        } else if (i == 2) {
                            ((CoreMetadata)this.core.get((int)0)).sizeZ = this.in.readInt();
                        }
                        if (this.adjustEndianness) {
                            this.in.order(!this.in.isLittleEndian());
                        }
                    } else {
                        value = String.valueOf(this.readValue(dataType));
                    }
                } else if (n == 2) {
                    if (dataType == 18) {
                        length = this.in.readInt();
                    } else {
                        LOGGER.warn("dataType mismatch: {}", (Object)dataType);
                    }
                    value = this.in.readString(length);
                } else if (n == 3) {
                    if (dataType == 20) {
                        this.skipPadding();
                        dataType = this.in.readInt();
                        long dataLength = 0L;
                        dataLength = this.version == 4 ? this.in.readLong() : (long)this.in.readInt();
                        length = (int)(dataLength & 0xFFFFFFFFFFFFFFFFL);
                        if (labelString.equals("Data")) {
                            if (dataLength > 0L) {
                                this.pixelOffset = this.in.getFilePointer();
                                this.in.seek(this.in.getFilePointer() + (long)this.getNumBytes(dataType) * dataLength);
                                this.numPixelBytes = this.in.getFilePointer() - this.pixelOffset;
                            }
                        } else if (dataType == 10) {
                            this.in.skipBytes(length);
                        } else {
                            value = this.in.readByteToString(length * 2);
                        }
                    } else {
                        LOGGER.warn("dataType mismatch: {}", (Object)dataType);
                    }
                } else if (dataType == 15) {
                    this.in.skipBytes(4);
                    this.skipPadding();
                    this.skipPadding();
                    int numFields = this.in.readInt();
                    long startFP = this.in.getFilePointer();
                    StringBuilder s2 = new StringBuilder();
                    this.in.skipBytes(4);
                    this.skipPadding();
                    long baseFP = this.in.getFilePointer();
                    if (this.version == 4) {
                        baseFP += 4L;
                    }
                    int width = this.version == 4 ? 16 : 8;
                    for (int j = 0; j < numFields; ++j) {
                        this.in.seek(baseFP + (long)(j * width));
                        dataType = this.in.readInt();
                        this.in.seek(startFP + (long)(numFields * width) + (long)(j * this.getNumBytes(dataType)));
                        s2.append(this.readValue(dataType));
                        if (j >= numFields - 1) continue;
                        s2.append(", ");
                    }
                    value = s2.toString();
                } else if (dataType == 20) {
                    this.skipPadding();
                    dataType = this.in.readInt();
                    if (dataType == 15) {
                        this.in.skipBytes(4);
                        this.skipPadding();
                        this.skipPadding();
                        int numFields = this.in.readInt();
                        int[] dataTypes = new int[numFields];
                        long baseFP = this.in.getFilePointer() + 12L;
                        for (int j = 0; j < numFields; ++j) {
                            this.in.skipBytes(4);
                            if (this.version == 4) {
                                this.in.seek(baseFP + (long)(j * 16));
                            }
                            dataTypes[j] = this.in.readInt();
                        }
                        this.skipPadding();
                        int len = this.in.readInt();
                        double[][] values2 = new double[numFields][len];
                        for (int k = 0; k < len; ++k) {
                            for (int q = 0; q < numFields; ++q) {
                                values2[q][k] = this.readValue(dataTypes[q]);
                            }
                        }
                    } else {
                        LOGGER.warn("dataType mismatch: {}", (Object)dataType);
                    }
                }
            } else if (type == 20) {
                labelString = this.in.readByteToString(length);
                this.in.skipBytes(2);
                this.skipPadding();
                this.skipPadding();
                this.skipPadding();
                int num = this.in.readInt();
                LOGGER.debug("{}{}: group({}) {} {", indent, i, num, labelString);
                this.parseTags(num, labelString.isEmpty() ? parent : labelString, indent + "  ");
                LOGGER.debug("{}}", (Object)indent);
            } else if (type == 23) {
                this.in.skipBytes(5);
                --i;
            } else {
                LOGGER.debug("{}{}: unknown type: {}", indent, i, type);
                LOGGER.debug("  unknown type @ fp = {}", (Object)this.in.getFilePointer());
            }
            NumberFormat f = NumberFormat.getInstance(Locale.ENGLISH);
            if (value == null) continue;
            value = value.replaceAll("\u0000", "");
            this.addGlobalMeta(labelString, value);
            if (parent != null && (parent.equals("AnnotationGroupList") || parent.equals("DocumentObjectList"))) {
                ROIShape shape = new ROIShape();
                if (labelString.equals("AnnotationType")) {
                    shape.type = DataTools.parseDouble(value).intValue();
                    this.shapes.add(shape);
                } else if (this.shapes.size() > 0) {
                    shape = this.shapes.get(this.shapes.size() - 1);
                }
                if (labelString.equals("Rectangle")) {
                    String[] points = value.split(",");
                    shape.y1 = DataTools.parseDouble(points[0].trim());
                    shape.x1 = DataTools.parseDouble(points[1].trim());
                    shape.y2 = DataTools.parseDouble(points[2].trim());
                    shape.x2 = DataTools.parseDouble(points[3].trim());
                } else if (labelString.equals("Text")) {
                    shape.text = value;
                } else if (labelString.equals("ForegroundColor")) {
                    String[] colors = value.split(",");
                    int red = DataTools.parseDouble(colors[0].trim()).intValue() & 0xFF;
                    int green = DataTools.parseDouble(colors[1].trim()).intValue() & 0xFF;
                    int blue = DataTools.parseDouble(colors[2].trim()).intValue() & 0xFF;
                    shape.strokeColor = new Color(red, green, blue, 255);
                }
            } else if (parent != null && parent.equals("TextFormat")) {
                if (labelString.equals("FontSize")) {
                    ROIShape shape = this.shapes.get(this.shapes.size() - 1);
                    shape.fontSize = FormatTools.getFontSize(DataTools.parseDouble(value).intValue());
                }
            } else if (this.foundMontage && parent != null && parent.equals("Stage Position")) {
                if (labelString.equals("Stage X")) {
                    this.stageX.add(new Length(DataTools.parseDouble(value), UNITS.REFERENCEFRAME));
                } else if (labelString.equals("Stage Y")) {
                    this.stageY.add(new Length(DataTools.parseDouble(value), UNITS.REFERENCEFRAME));
                } else if (labelString.equals("Stage Z")) {
                    this.stageZ.add(new Length(DataTools.parseDouble(value), UNITS.REFERENCEFRAME));
                }
            }
            boolean bl = validPhysicalSize = parent != null && (parent.equals("Dimension") || (this.pixelSizes.size() == 4 || this.units.size() == 4) && parent.equals("2"));
            if (labelString.equals("Scale") && validPhysicalSize) {
                if (value.indexOf(44) == -1) {
                    this.pixelSizes.add(f.parse(value).doubleValue());
                }
            } else if (labelString.equals("Units") && validPhysicalSize) {
                if (this.pixelSizes.size() == this.units.size() + 1) {
                    this.units.add(value);
                }
            } else if (labelString.equals("LowLimit")) {
                this.signed = f.parse(value).doubleValue() < 0.0;
            } else if (labelString.equals("Acquisition Start Time (epoch)")) {
                this.timestamp = f.parse(value).longValue();
            } else if (labelString.equals("Voltage")) {
                this.voltage = f.parse(value).doubleValue();
            } else if (labelString.equals("Microscope Info")) {
                this.info = value;
            } else if (labelString.equals("Indicated Magnification")) {
                this.mag = f.parse(value).doubleValue();
            } else if (labelString.equals("Gamma")) {
                this.gamma = f.parse(value).doubleValue();
            } else if (labelString.startsWith("xPos")) {
                Double number = f.parse(value).doubleValue();
                this.posX = new Length(number, UNITS.REFERENCEFRAME);
            } else if (labelString.startsWith("yPos")) {
                Double number = f.parse(value).doubleValue();
                this.posY = new Length(number, UNITS.REFERENCEFRAME);
            } else if (labelString.startsWith("Specimen position")) {
                Double number = f.parse(value).doubleValue();
                this.posZ = new Length(number, UNITS.REFERENCEFRAME);
            } else if (labelString.equals("Sample Time")) {
                this.sampleTime = f.parse(value).doubleValue();
            } else if (labelString.equals("DataType")) {
                int pixelType = f.parse(value).intValue();
                switch (pixelType) {
                    case 1: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 2;
                        break;
                    }
                    case 10: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 3;
                        break;
                    }
                    case 2: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 6;
                        break;
                    }
                    case 12: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 7;
                        break;
                    }
                    case 9: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 0;
                        break;
                    }
                    case 6: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 1;
                        break;
                    }
                    case 7: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 4;
                        break;
                    }
                    case 11: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 5;
                    }
                }
            }
            value = null;
        }
    }

    private double readValue(int type) throws IOException {
        switch (type) {
            case 2: 
            case 4: {
                return this.in.readShort();
            }
            case 3: 
            case 5: {
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                int i = this.in.readInt();
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                return i;
            }
            case 6: {
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                float f = this.in.readFloat();
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                return f;
            }
            case 7: {
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                double dbl = this.in.readDouble();
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                return dbl;
            }
            case 8: 
            case 9: 
            case 10: {
                return this.in.readByte();
            }
            case 11: 
            case 12: {
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                long l = this.in.readLong();
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                return l;
            }
        }
        return 0.0;
    }

    private int getNumBytes(int type) {
        switch (type) {
            case 2: 
            case 4: {
                return 2;
            }
            case 3: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: 
            case 9: 
            case 10: {
                return 1;
            }
            case 11: 
            case 12: {
                return 8;
            }
        }
        return 0;
    }

    private void skipPadding() throws IOException {
        if (this.version == 4) {
            this.in.skipBytes(4);
        }
    }

    private Unit<Length> convertUnits(String units) {
        Collator c = Collator.getInstance(Locale.ENGLISH);
        if (units != null) {
            if (c.compare("nm", units) == 0) {
                return UNITS.NANOMETER;
            }
            if (c.compare("um", units) != 0 && c.compare("\u00b5m", units) != 0) {
                LOGGER.warn("Not adjusting for unknown units: {}", (Object)units);
            }
        }
        return UNITS.MICROMETER;
    }

    private String createROI(MetadataStore store, int index) {
        String roi = MetadataTools.createLSID("ROI", index);
        store.setROIID(roi, index);
        store.setImageROIRef(roi, 0, index);
        return MetadataTools.createLSID("Shape", index, 0);
    }

    class ROIShape {
        public int type;
        public double x1;
        public double y1;
        public double x2;
        public double y2;
        public String text;
        public Length fontSize;
        public Color strokeColor;

        ROIShape() {
        }
    }
}

