/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class ImspectorReader
extends FormatReader {
    private static final String MAGIC_STRING = "CDataStack";
    private ArrayList<Long> pixelsOffsets = new ArrayList();
    private ArrayList<String> uniquePMTs = new ArrayList();
    private ArrayList<Integer> planesPerBlock = new ArrayList();
    private boolean isFLIM = false;
    private int tileCount = 1;

    public ImspectorReader() {
        super("Lavision Imspector", "msr");
        this.domains = new String[]{"Fluorescence-Lifetime Imaging"};
        this.suffixSufficient = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 32;
        if (!FormatTools.validStream(stream, 32, false)) {
            return false;
        }
        return stream.readString(32).indexOf(MAGIC_STRING) >= 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int index = 0;
        for (int i = 0; i < this.getSeries(); ++i) {
            index += ((CoreMetadata)this.core.get((int)i)).imageCount;
        }
        index += no;
        int[] zct = this.getZCTCoords(no);
        int block = this.getSeries() * this.getSizeC() + zct[1];
        int plane = this.getIndex(zct[0], 0, zct[2]);
        if (plane < this.planesPerBlock.get(block)) {
            this.in.seek(this.pixelsOffsets.get(block) + (long)(FormatTools.getPlaneSize(this) * plane));
            this.readPlane(this.in, x, y, w, h2, buf);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelsOffsets.clear();
            this.uniquePMTs.clear();
            this.planesPerBlock.clear();
            this.isFLIM = false;
            this.tileCount = 1;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        m4.littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.in.skipBytes(20);
        int length = this.in.readShort();
        String tag = this.in.readString(length);
        int count = this.in.readInt();
        this.skipTags(count);
        if (this.in.getFilePointer() % 2L == 1L) {
            this.in.skipBytes(1);
        } else {
            int check2 = this.in.read() & 0xFF;
            if (check2 != 255) {
                this.in.seek(this.in.getFilePointer() - 1L);
            }
        }
        length = this.in.readShort();
        String metadata = this.in.readString(length);
        String[] values2 = metadata.split("::");
        if (length % 2 == 0 && this.in.read() != 13) {
            this.in.seek(this.in.getFilePointer() - 1L);
        }
        int check3 = this.in.readShort();
        while (check3 != 3 && check3 != 2) {
            this.in.seek(this.in.getFilePointer() - 1L);
            check3 = this.in.readShort();
        }
        this.in.skipBytes(26);
        int pmtMarkerLength = this.in.read();
        String pmtMarker = this.in.readString(pmtMarkerLength);
        this.uniquePMTs.add(pmtMarker);
        this.in.skipBytes(6);
        m4.sizeX = this.in.readInt();
        m4.sizeY = this.in.readInt();
        int originalZ = this.in.readInt();
        int originalT = this.in.readInt();
        m4.sizeZ = originalZ;
        m4.sizeT = originalT;
        this.planesPerBlock.add(m4.sizeT * m4.sizeZ);
        this.in.skipBytes(16);
        for (i = 0; i < 4; ++i) {
            int len = this.in.read();
            String string = this.in.readString(len);
        }
        this.pixelsOffsets.add(this.in.getFilePointer());
        for (i = 0; i < values2.length - 1; i += 2) {
            this.addGlobalMeta(values2[i], values2[i + 1]);
            if (!values2[i].equals("Instrument Mode")) continue;
            this.isFLIM = values2[i + 1].startsWith("TCSPC") || values2[i + 1].startsWith("FLIM");
        }
        m4.pixelType = 3;
        int bpp = FormatTools.getBytesPerPixel(m4.pixelType);
        this.in.skipBytes((long)m4.sizeX * (long)m4.sizeY * (long)this.planesPerBlock.get(0).intValue() * (long)bpp + 2L);
        int tileX = 1;
        int tileY = 1;
        Double timeBase = null;
        int realTimepoints = 1;
        block14: while (this.in.getFilePointer() < this.in.length()) {
            check3 = this.in.readShort() & 0xFFFF;
            if (check3 != 32771) {
                this.in.skipBytes(2);
                length = this.in.readShort();
            } else {
                length = this.in.read() & 0xFF;
            }
            if (length == 0 && check3 == 65535) {
                this.in.skipBytes(46);
                int tagBlockSize = this.skipTagBlock();
                if (tagBlockSize == 0) {
                    this.in.skipBytes(26);
                } else {
                    this.in.skipBytes(50);
                }
                this.findOffset();
                continue;
            }
            if (length == 3 && check3 == 65535) {
                this.in.seek(this.in.getFilePointer() - 2L);
                this.findOffset(false);
                continue;
            }
            if (length < 0) continue;
            tag = this.in.readString(length);
            while (this.in.getFilePointer() < this.in.length()) {
                if (tag.equals("CImageStack")) {
                    this.readStackHeader();
                    this.in.skipBytes(60);
                    while ((this.in.read() & 0xFF) != 255) {
                    }
                    length = this.in.readShort();
                    if (length == 0) {
                        this.in.skipBytes(1);
                        if ((this.in.read() & 0xFF) == 255) {
                            length = this.in.readShort();
                        } else {
                            this.in.seek(this.in.getFilePointer() - 1L);
                            length = this.in.readShort();
                            this.in.skipBytes(length - 2);
                            continue block14;
                        }
                    }
                    this.in.skipBytes(length + 50);
                    this.findOffset();
                    continue block14;
                }
                if (tag.equals("Label")) {
                    this.in.skipBytes(4);
                }
                if ((length = this.in.read()) < 0) continue block14;
                String key = this.in.readString(length);
                int type = this.in.readInt();
                String value = null;
                if (type == 5) {
                    length = this.in.read();
                    if (length == 0) {
                        this.in.skipBytes(4);
                        length = this.in.read();
                    }
                    value = this.in.readString(length);
                } else if (type > 65535 && type != 524288) {
                    this.in.seek(this.in.getFilePointer() - 2L);
                    value = String.valueOf(this.in.readDouble());
                } else {
                    length = this.in.read();
                    value = this.in.readString(length);
                }
                if (tag.equals("Label")) {
                    this.in.skipBytes(350);
                    this.findOffset();
                    continue block14;
                }
                int valueType = this.in.readShort();
                int valueLen = this.in.readShort();
                int check1 = 0;
                int check2 = 0;
                switch (valueType) {
                    case 10: 
                    case 11: 
                    case 12: {
                        key = value;
                        value = String.valueOf(this.in.readInt() == 1);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 13: 
                    case 14: 
                    case 17: {
                        key = value;
                        value = String.valueOf(this.in.readFloat());
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: {
                        key = value;
                        value = String.valueOf(this.in.readInt());
                        break;
                    }
                    default: {
                        LOGGER.debug("found type {}", (Object)valueType);
                        check1 = valueType;
                        check2 = valueLen;
                    }
                }
                if (key.equals("Stitching X")) {
                    try {
                        tileX = Integer.parseInt(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (key.equals("Stitching Y")) {
                    try {
                        tileY = Integer.parseInt(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                check1 = this.in.readShort();
                check2 = this.in.readShort();
                if (check1 == 0 && check2 == 8) {
                    if (this.in.readShort() != 32771) {
                        this.in.seek(this.in.getFilePointer() - 2L);
                        int v = this.in.readInt();
                        if (v < 65535) {
                            value = String.valueOf(v);
                            if (key.equals("StitchingX")) {
                                tileX = v;
                            } else if (key.equals("StitchingY")) {
                                tileY = v;
                            }
                        } else {
                            this.in.seek(this.in.getFilePointer() - 4L);
                        }
                    } else {
                        this.in.seek(this.in.getFilePointer() - 2L);
                    }
                } else {
                    this.in.seek(this.in.getFilePointer() - 4L);
                }
                check1 = this.in.read() & 0xFF;
                check2 = this.in.read() & 0xFF;
                while (!(check1 == 3 && check2 == 128 || type == 5 && check1 == 255 && check2 == 255 || this.in.getFilePointer() >= this.in.length())) {
                    check1 = check2;
                    check2 = this.in.read() & 0xFF;
                }
                this.addGlobalMeta(key, value);
                if (key.equals("TCSPC  Z Length") || key.equals("TDC  Z Length") || key.equals("DC-TCSPC T Length")) {
                    try {
                        if (timeBase == null) {
                            timeBase = Double.parseDouble(value);
                        }
                    }
                    catch (NumberFormatException v) {}
                } else if (key.equals("xyz-Table Z Resolution")) {
                    int z;
                    Double doubleValue = DataTools.parseDouble(value);
                    if (doubleValue != null && (z = doubleValue.intValue()) == 1 && this.getSizeZ() > 1) {
                        originalT = this.getSizeT();
                        originalZ = this.getSizeZ();
                        m4.sizeT *= this.getSizeZ();
                        m4.sizeZ = 1;
                    }
                } else if (key.equals("Time Time Resolution")) {
                    realTimepoints = Integer.parseInt(value);
                }
                if (check1 != 255 || check2 != 255) continue;
                this.in.seek(this.in.getFilePointer() - 2L);
                continue block14;
            }
        }
        for (Integer blockSize : this.planesPerBlock) {
            m4.imageCount += blockSize.intValue();
        }
        if (this.isFLIM) {
            if (this.getSizeZ() == 1 || this.getSizeT() == 1) {
                m4.sizeZ = 1;
                m4.sizeT = m4.imageCount;
                if (m4.imageCount % this.uniquePMTs.size() == 0) {
                    m4.sizeT /= this.uniquePMTs.size();
                }
            }
            LOGGER.debug("m.imageCount = {}", (Object)m4.imageCount);
            m4.moduloT.parentType = "Spectra";
            m4.moduloT.type = "Lifetime";
            m4.sizeC = m4.imageCount / (m4.sizeZ * m4.sizeT);
            m4.dimensionOrder = this.getSizeZ() > 1 && this.getSizeT() > 1 ? "XYTZC" : "XYZTC";
            if (timeBase == null) {
                timeBase = 1.0;
            }
            if (timeBase > 1.0) {
                timeBase = timeBase * 1000.0;
            }
            if (realTimepoints > 1) {
                originalT = this.getSizeT() / realTimepoints;
            } else if (realTimepoints == 1 && originalT == 1) {
                originalT = this.getSizeT();
            }
            m4.moduloT.step = timeBase / (double)originalT;
            m4.moduloT.end = m4.moduloT.step * (double)(originalT - 1);
            m4.moduloT.unit = "ps";
            m4.moduloT.typeDescription = "TCSPC";
        } else {
            m4.sizeC = this.uniquePMTs.size() <= this.pixelsOffsets.size() ? this.uniquePMTs.size() : 1;
            if (m4.imageCount != m4.sizeZ * m4.sizeC * m4.sizeT) {
                if (this.planesPerBlock.size() > 1) {
                    m4.sizeZ = 1;
                    for (Integer block : this.planesPerBlock) {
                        if (block <= m4.sizeZ) continue;
                        m4.sizeZ = block;
                    }
                    m4.imageCount = m4.sizeZ * m4.sizeC * m4.sizeT;
                } else {
                    m4.sizeZ = m4.imageCount / m4.sizeC;
                    m4.sizeT = m4.imageCount / (m4.sizeZ * m4.sizeC);
                }
            }
            m4.dimensionOrder = m4.sizeC > 1 && m4.sizeT != 1 ? "XYZTC" : "XYZCT";
        }
        this.tileCount = tileX * tileY;
        if (this.tileCount == 0 || m4.imageCount % this.tileCount != 0) {
            this.tileCount = 1;
        }
        if (this.tileCount > 1) {
            m4.imageCount /= this.tileCount;
            if (m4.sizeT >= this.tileCount) {
                m4.sizeT /= this.tileCount;
            } else if (m4.sizeC >= this.tileCount) {
                m4.sizeC /= this.tileCount;
            } else {
                m4.sizeZ /= this.tileCount;
            }
            for (int i2 = 1; i2 < this.tileCount; ++i2) {
                this.core.add(m4);
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    private void readStackHeader() throws IOException {
        int count = this.in.readInt();
        if (count > 65535) {
            this.in.seek(this.in.getFilePointer() - 2L);
            short len = this.in.readShort();
            this.in.skipBytes(len);
            count = this.in.readInt() + 1;
        }
        this.skipTags(count);
        this.skipTagBlock();
    }

    private void skipTags(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            int length = this.in.read();
            if (length == 0) {
                --i;
            }
            if (length < 0) {
                return;
            }
            String string = this.in.readString(length);
        }
    }

    private int skipTagBlock() throws IOException {
        this.in.skipBytes(1);
        short length = this.in.readShort();
        this.in.skipBytes(length);
        return length;
    }

    private void findOffset() throws IOException {
        this.findOffset(true);
    }

    private void findOffset(boolean readStackHeader) throws IOException {
        if (readStackHeader) {
            this.readStackHeader();
        }
        short pmtCheck = this.in.readShort();
        while (pmtCheck != 3 && pmtCheck != 2) {
            this.in.seek(this.in.getFilePointer() - 1L);
            pmtCheck = this.in.readShort();
            if (pmtCheck != 2) continue;
            if (this.in.readShort() == 0) {
                this.in.seek(this.in.getFilePointer() - 2L);
                continue;
            }
            pmtCheck = 0;
        }
        this.in.skipBytes(26);
        int len = this.in.read();
        if (len < 0) {
            return;
        }
        String pmt = this.in.readString(len);
        if (!this.uniquePMTs.contains(pmt) && (pmt.startsWith("PMT") || pmt.indexOf("TCSPC") >= 0)) {
            this.uniquePMTs.add(pmt);
        }
        boolean noPMT = len == 0;
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        this.in.skipBytes(14);
        int newT = this.in.readInt();
        int newZ = this.in.readInt();
        long planeSize = (long)this.getSizeX() * (long)this.getSizeY() * (long)FormatTools.getBytesPerPixel(this.getPixelType());
        long newCount = (long)newZ * (long)newT;
        if (newZ > this.getSizeZ() && newT > this.getSizeT() && newCount * planeSize < this.in.length() - this.in.getFilePointer() && newCount > 0L && newCount * planeSize > 0L) {
            this.uniquePMTs.remove(0);
            this.planesPerBlock.remove(this.planesPerBlock.size() - 1);
            this.pixelsOffsets.remove(this.pixelsOffsets.size() - 1);
            m4.sizeZ = newZ;
            m4.sizeT = newT;
        }
        this.planesPerBlock.add(newZ * newT);
        this.in.skipBytes(noPMT ? 12 : 16);
        for (int i = 0; i < 4; ++i) {
            len = this.in.read();
            if (len < 0) {
                noPMT = true;
                break;
            }
            String string = this.in.readString(len);
        }
        if (noPMT) {
            while ((this.in.readShort() & 0xFFFF) != 32771) {
            }
            this.in.seek(this.in.getFilePointer() - 2L);
            this.planesPerBlock.remove(this.planesPerBlock.size() - 1);
            return;
        }
        planeSize = (long)m4.sizeX * (long)m4.sizeY * (long)this.planesPerBlock.get(this.planesPerBlock.size() - 1).intValue() * 2L;
        if (planeSize > 0L && this.in.getFilePointer() + planeSize < this.in.length()) {
            this.pixelsOffsets.add(this.in.getFilePointer());
            this.in.skipBytes(planeSize + 2L);
        } else {
            this.planesPerBlock.remove(this.planesPerBlock.size() - 1);
        }
    }
}

