/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.CoreMetadataList;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.Modulo;
import loci.formats.SubResolutionFormatReader;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import loci.formats.services.OMEXMLServiceImpl;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Channel;
import ome.xml.model.Image;
import ome.xml.model.MapPair;
import ome.xml.model.Pixels;
import ome.xml.model.Plane;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PrimitiveType;
import ome.xml.model.primitives.Timestamp;

public class OMETiffReader
extends SubResolutionFormatReader {
    public static final String[] OME_TIFF_SUFFIXES = new String[]{"ome.tiff", "ome.tif", "ome.tf2", "ome.tf8", "ome.btf", "companion.ome"};
    public static final String FAIL_ON_MISSING_KEY = "ometiff.fail_on_missing_tiff";
    public static final boolean FAIL_ON_MISSING_DEFAULT = true;
    protected OMETiffPlane[][] info;
    protected String[] used;
    private int lastPlane = 0;
    private boolean hasSPW;
    private OMEXMLService service;
    private transient OMEXMLMetadata meta;
    private String metaFile;
    private String metadataFile;

    public OMETiffReader() {
        super("OME-TIFF", OME_TIFF_SUFFIXES);
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.domains = FormatTools.NON_GRAPHICS_DOMAINS;
        this.hasCompanionFiles = true;
        this.datasetDescription = "One or more .ome.tiff files";
    }

    @Override
    protected ArrayList<String> getAvailableOptions() {
        ArrayList<String> optionsList = super.getAvailableOptions();
        optionsList.add(FAIL_ON_MISSING_KEY);
        return optionsList;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        OMEXMLMetadata meta;
        if (OMETiffReader.checkSuffix(id, "companion.ome")) {
            return false;
        }
        String fileName = new Location(id).getAbsoluteFile().getAbsolutePath();
        IFD ifd = null;
        long[] ifdOffsets = null;
        try (RandomAccessInputStream ras = new RandomAccessInputStream(fileName, 16);){
            TiffParser tp = new TiffParser(ras);
            ifd = tp.getFirstIFD();
            ifdOffsets = tp.getIFDOffsets();
        }
        String xml = ifd.getComment();
        if (this.service == null) {
            this.setupService();
        }
        try {
            meta = this.service.createOMEXMLMetadata(xml);
            this.metaFile = new Location(id).getAbsolutePath();
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        if (meta.getRoot() == null) {
            throw new FormatException("Could not parse OME-XML from TIFF comment");
        }
        int nImages = 0;
        for (int i = 0; i < meta.getImageCount(); ++i) {
            int nChannels = meta.getChannelCount(i);
            if (nChannels == 0) {
                nChannels = 1;
            }
            int z = (Integer)meta.getPixelsSizeZ(i).getValue();
            int t2 = (Integer)meta.getPixelsSizeT(i).getValue();
            nImages += z * t2 * nChannels;
        }
        return nImages > 0 && nImages <= ifdOffsets.length;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (OMETiffReader.checkSuffix(name, "companion.ome")) {
            return true;
        }
        this.metaFile = new Location(name).getAbsolutePath();
        boolean valid = super.isThisType(name, open);
        if (this.metadataFile != null) {
            String dir = new File(this.metaFile).getParent();
            Location path = new Location(dir, this.metadataFile);
            LOGGER.debug("Checking metadata file {}", (Object)path);
            if (!path.exists()) {
                return false;
            }
            this.metadataFile = path.getAbsolutePath();
            try {
                String xml = this.readMetadataFile();
                this.service.createOMEXMLMetadata(xml);
            }
            catch (ServiceException se) {
                LOGGER.debug("OME-XML parsing failed", se);
                return false;
            }
            catch (IOException | NullPointerException e) {
                return false;
            }
        }
        return valid;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        tp.setDoCaching(false);
        boolean validHeader = tp.isValidHeader();
        if (!validHeader) {
            return false;
        }
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        Object description = ifd.get(270);
        if (description == null) {
            return false;
        }
        String comment = null;
        if (description instanceof TiffIFDEntry) {
            Object value = tp.getIFDValue((TiffIFDEntry)description);
            if (value != null) {
                comment = value.toString();
            }
        } else if (description instanceof String) {
            comment = (String)description;
        }
        if (comment == null || comment.trim().length() == 0) {
            return false;
        }
        if (!(comment = comment.trim()).startsWith("<") || !comment.endsWith(">")) {
            return false;
        }
        try {
            if (this.service == null) {
                this.setupService();
            }
            this.meta = this.service.createOMEXMLMetadata(comment);
            try {
                this.metadataFile = this.meta.getBinaryOnlyMetadataFile();
                if (this.metadataFile != null) {
                    return true;
                }
            }
            catch (NullPointerException value) {
                // empty catch block
            }
            for (int i = 0; i < this.meta.getImageCount(); ++i) {
                this.meta.setPixelsBigEndian(Boolean.TRUE, i);
                if (this.meta.getPixelsBinDataCount(i) > 0) {
                    for (int j = 0; j < this.meta.getPixelsBinDataCount(i); ++j) {
                        this.meta.setPixelsBinDataBigEndian(Boolean.TRUE, i, j);
                    }
                }
                MetadataTools.verifyMinimumPopulated(this.meta, i);
            }
            return this.meta.getImageCount() > 0;
        }
        catch (IndexOutOfBoundsException | NullPointerException | ServiceException | FormatException se) {
            LOGGER.debug("OME-XML parsing failed", se);
            return false;
        }
    }

    @Override
    public String[] getDomains() {
        String[] stringArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.hasSPW) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "High-Content Screening (HCS)";
        } else {
            stringArray = FormatTools.NON_SPECIAL_DOMAINS;
        }
        return stringArray;
    }

    @Override
    public void setSeries(int series) {
        super.setSeries(series);
        for (int i = 0; i < this.info.length; ++i) {
            if (i == series || this.info[i] == null) continue;
            for (OMETiffPlane p : this.info[i]) {
                if (p == null || p.reader == null || this.getCurrentFile().equals(p.reader.getCurrentFile())) continue;
                try {
                    p.reader.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Could not close " + p.id, e);
                }
            }
        }
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        if (this.info[this.series][this.lastPlane] == null || this.info[this.series][this.lastPlane].reader == null || this.info[this.series][this.lastPlane].id == null) {
            return null;
        }
        this.initializeReader(this.info[this.series][this.lastPlane].reader, this.info[this.series][this.lastPlane].id);
        return this.info[this.series][this.lastPlane].reader.get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        if (this.info[this.series][this.lastPlane] == null || this.info[this.series][this.lastPlane].reader == null || this.info[this.series][this.lastPlane].id == null) {
            return null;
        }
        this.initializeReader(this.info[this.series][this.lastPlane].reader, this.info[this.series][this.lastPlane].id);
        return this.info[this.series][this.lastPlane].reader.get16BitLookupTable();
    }

    @Override
    public void reopenFile() throws IOException {
        super.reopenFile();
        for (int s2 = 0; s2 < this.info.length; ++s2) {
            for (int q = 0; q < this.info[s2].length; ++q) {
                if (this.info[s2][q] == null || this.info[s2][q].reader == null || this.info[s2][q].reader.getCurrentFile() == null) continue;
                this.info[s2][q].reader.reopenFile();
            }
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.lastPlane = no;
        int i = this.info[this.series][no].ifd;
        if (!this.info[this.series][no].exists || this.info[this.series][no].reader == null || this.info[this.series][no].id == null) {
            Arrays.fill(buf, this.getFillColor());
            return buf;
        }
        MinimalTiffReader r = (MinimalTiffReader)this.info[this.series][no].reader;
        if (r.getCurrentFile() == null) {
            this.initializeReader(r, this.info[this.series][no].id);
        }
        r.lastPlane = i;
        IFDList ifdList = r.getIFDs();
        if (i >= ifdList.size()) {
            LOGGER.warn("Error untangling IFDs; the OME-TIFF file may be malformed (IFD #{} missing).", (Object)i);
            return buf;
        }
        IFD ifd = (IFD)ifdList.get(i);
        try (RandomAccessInputStream s2 = new RandomAccessInputStream(this.info[this.series][no].id, 16);){
            TiffParser p = new TiffParser(s2);
            if (this.resolution > 0) {
                p.setDoCaching(false);
                long offset = ifd.getIFDLongArray(330)[((OMETiffCoreMetadata)this.core.get((int)this.series, (int)this.resolution)).subresolutionOffset];
                ifd = p.getIFD(offset);
                ifd.remove(270);
                p.fillInIFD(ifd);
            }
            p.getSamples(ifd, buf, x, y, w, h2);
        }
        if (r.getImageCount() == 1 && w + x == this.getSizeX() && h2 + y == this.getSizeY()) {
            r.close();
        }
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return null;
        }
        ArrayList<String> usedFiles = new ArrayList<String>();
        if (this.metadataFile != null) {
            usedFiles.add(this.metadataFile);
        }
        if (this.info != null && this.info[this.series] != null) {
            for (int i = 0; i < this.info[this.series].length; ++i) {
                if (this.info[this.series] == null || this.info[this.series][i] == null || this.info[this.series][i].id == null || usedFiles.contains(this.info[this.series][i].id)) continue;
                usedFiles.add(this.info[this.series][i].id);
            }
        }
        return usedFiles.toArray(new String[usedFiles.size()]);
    }

    @Override
    public int fileGroupOption(String id) {
        try {
            boolean single = this.isSingleFile(id);
            return single ? 1 : 0;
        }
        catch (IOException | FormatException e) {
            LOGGER.debug("", e);
            return 1;
        }
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.info != null) {
            for (OMETiffPlane[] dimension : this.info) {
                if (dimension == null) continue;
                for (OMETiffPlane plane : dimension) {
                    if (plane == null || plane.reader == null) continue;
                    try {
                        plane.reader.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("Plane closure failure!", e);
                    }
                }
            }
        }
        if (!fileOnly) {
            this.info = null;
            this.used = null;
            this.lastPlane = 0;
            this.metadataFile = null;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return ((OMETiffCoreMetadata)this.getCurrentCore()).tileWidth;
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return ((OMETiffCoreMetadata)this.getCurrentCore()).tileHeight;
    }

    @Override
    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return FormatTools.getRequiredDirectories(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        Hashtable originalMetadata;
        int i2;
        Location path;
        String xml;
        super.initFile(this.normalizeFilename(null, id));
        id = this.currentId;
        String dir = new File(id).getParent();
        String fileName = new Location(id).getAbsoluteFile().getAbsolutePath();
        if (!new File(fileName).exists()) {
            fileName = this.currentId;
        }
        IFD firstIFD = null;
        boolean companion = false;
        if (OMETiffReader.checkSuffix(fileName, "companion.ome")) {
            xml = DataTools.readFile(fileName);
            companion = true;
        } else {
            firstIFD = OMETiffReader.getFirstIFD(fileName);
            xml = firstIFD.getComment();
        }
        if (this.service == null) {
            this.setupService();
        }
        try {
            if (this.meta == null || !this.metaFile.equals(this.currentId)) {
                this.meta = this.service.createOMEXMLMetadata(xml);
                this.metaFile = this.currentId;
            }
            if (companion) {
                String firstTIFF = this.meta.getUUIDFileName(0, 0);
                firstIFD = OMETiffReader.getFirstIFD(new Location(dir, firstTIFF).getAbsolutePath());
                this.metadataFile = fileName;
            }
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        String metadataPath = null;
        if (this.metadataFile == null) {
            try {
                metadataPath = this.meta.getBinaryOnlyMetadataFile();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (metadataPath != null && (path = new Location(dir, metadataPath)).exists()) {
            this.metadataFile = Paths.get(path.toString(), new String[0]).normalize().toString();
            xml = this.readMetadataFile();
            try {
                this.meta = this.service.createOMEXMLMetadata(xml);
                dir = path.getParentFile().getAbsolutePath();
                this.currentId = this.metadataFile;
            }
            catch (ServiceException se) {
                throw new FormatException(se);
            }
            catch (NullPointerException e) {
                this.metadataFile = null;
                metadataPath = null;
            }
        }
        this.hasSPW = this.meta.getPlateCount() > 0;
        for (i2 = 0; i2 < this.meta.getImageCount(); ++i2) {
            int sizeC = (Integer)this.meta.getPixelsSizeC(i2).getValue();
            this.service.removeChannels(this.meta, i2, sizeC);
        }
        if (this.hasFlattenedResolutions()) {
            try {
                for (i2 = 0; i2 < this.meta.getMapAnnotationCount(); ++i2) {
                    if (!this.meta.getMapAnnotationNamespace(i2).equals("openmicroscopy.org/PyramidResolution")) continue;
                    this.meta.setMapAnnotationValue(new ArrayList<MapPair>(), i2);
                }
            }
            catch (NullPointerException e) {
                LOGGER.trace("Could not remove resolution annotations", e);
            }
        }
        if ((originalMetadata = this.service.getOriginalMetadata(this.meta)) != null) {
            this.metadata = originalMetadata;
        }
        LOGGER.trace(xml);
        if (this.meta.getRoot() == null) {
            throw new FormatException("Could not parse OME-XML from TIFF comment");
        }
        String[] acquiredDates = new String[this.meta.getImageCount()];
        for (int i3 = 0; i3 < acquiredDates.length; ++i3) {
            Timestamp acquisitionDate = this.meta.getImageAcquisitionDate(i3);
            if (acquisitionDate == null) continue;
            acquiredDates[i3] = (String)acquisitionDate.getValue();
        }
        String currentUUID = this.meta.getUUID();
        if (!this.isGroupFiles() && !this.isSingleFile(this.currentId)) {
            int i4;
            MinimalTiffReader reader = new MinimalTiffReader();
            this.initializeReader(reader, this.currentId);
            OMETiffCoreMetadata baseCore = new OMETiffCoreMetadata(reader.getCoreMetadataList().get(0));
            this.core.clear();
            int ifdCount = reader.getImageCount();
            reader.close();
            int maxSeries = 0;
            ArrayList<OMETiffPlane[]> tmpInfo = new ArrayList<OMETiffPlane[]>();
            ArrayList<Integer> imagesToRemove = new ArrayList<Integer>();
            ArrayList<int[]> cBounds = new ArrayList<int[]>();
            for (int i5 = 0; i5 < this.meta.getImageCount(); ++i5) {
                int maxZ = 0;
                int maxC = 0;
                int maxT = 0;
                int minZ = Integer.MAX_VALUE;
                int minC = Integer.MAX_VALUE;
                int minT = Integer.MAX_VALUE;
                int sizeZ = (Integer)this.meta.getPixelsSizeZ(i5).getValue();
                int sizeC = this.meta.getChannelCount(i5);
                int sizeT = (Integer)this.meta.getPixelsSizeT(i5).getValue();
                String order = this.meta.getPixelsDimensionOrder(i5).getValue();
                int num = sizeZ * sizeC * sizeT;
                OMETiffCoreMetadata m4 = new OMETiffCoreMetadata(baseCore);
                m4.dimensionOrder = order;
                OMETiffPlane[] thisInfo = new OMETiffPlane[this.meta.getTiffDataCount(i5)];
                int next = 0;
                boolean hasAnyPlanes = false;
                for (int td = 0; td < this.meta.getTiffDataCount(i5); ++td) {
                    int realCount;
                    String uuid = null;
                    try {
                        uuid = this.meta.getUUIDValue(i5, td);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    String filename = null;
                    try {
                        filename = this.meta.getUUIDFileName(i5, td);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (!(uuid != null && uuid.equals(currentUUID) || filename != null && this.currentId.endsWith(filename))) continue;
                    hasAnyPlanes = true;
                    if (i5 > maxSeries) {
                        maxSeries = i5;
                    }
                    NonNegativeInteger ifd = this.meta.getTiffDataIFD(i5, td);
                    NonNegativeInteger count = this.meta.getTiffDataPlaneCount(i5, td);
                    NonNegativeInteger firstZ = this.meta.getTiffDataFirstZ(i5, td);
                    NonNegativeInteger firstC = this.meta.getTiffDataFirstC(i5, td);
                    NonNegativeInteger firstT = this.meta.getTiffDataFirstT(i5, td);
                    int n = realCount = count == null ? 1 : (Integer)count.getValue();
                    if (ifd == null && count == null) {
                        realCount = ifdCount;
                    }
                    for (int q = 0; q < realCount; ++q) {
                        int t2;
                        OMETiffPlane p = new OMETiffPlane();
                        p.id = this.currentId;
                        p.ifd = q;
                        if (ifd != null) {
                            p.ifd += ((Integer)ifd.getValue()).intValue();
                        }
                        p.reader = reader;
                        thisInfo[next++] = p;
                        int z = firstZ == null ? 0 : (Integer)firstZ.getValue();
                        int c = firstC == null ? 0 : (Integer)firstC.getValue();
                        int n2 = t2 = firstT == null ? 0 : (Integer)firstT.getValue();
                        if (q > 0) {
                            int index = FormatTools.getIndex(order, sizeZ, sizeC, sizeT, num, z, c, t2);
                            int[] add = FormatTools.getZCTCoords(order, sizeZ, sizeC, sizeT, num, q);
                            z += add[0];
                            c += add[1];
                            t2 += add[2];
                        }
                        if (z > maxZ) {
                            maxZ = z;
                        }
                        if (c > maxC) {
                            maxC = c;
                        }
                        if (t2 > maxT) {
                            maxT = t2;
                        }
                        if (z < minZ) {
                            minZ = z;
                        }
                        if (c < minC) {
                            minC = c;
                        }
                        if (t2 >= minT) continue;
                        minT = t2;
                    }
                }
                if (!hasAnyPlanes) {
                    imagesToRemove.add(i5);
                    continue;
                }
                if (i5 <= maxSeries) {
                    m4.sizeZ = maxZ - minZ + 1;
                    m4.sizeC = maxC - minC + 1;
                    m4.sizeT = maxT - minT + 1;
                    m4.imageCount = m4.sizeZ * m4.sizeC * m4.sizeT;
                    m4.sizeC *= ((Integer)this.meta.getChannelSamplesPerPixel(i5, 0).getValue()).intValue();
                    this.core.add(m4);
                    cBounds.add(new int[]{minC, maxC});
                    tmpInfo.add(thisInfo);
                    continue;
                }
                imagesToRemove.add(i5);
            }
            this.info = (OMETiffPlane[][])tmpInfo.toArray((T[])new OMETiffPlane[tmpInfo.size()][]);
            this.meta.resolveReferences();
            OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)this.meta.getRoot();
            List<Image> images = root.copyImageList();
            for (i4 = imagesToRemove.size() - 1; i4 >= 0; --i4) {
                images.remove(images.get((Integer)imagesToRemove.get(i4)));
            }
            for (i4 = 0; i4 < images.size(); ++i4) {
                Image img = images.get(i4);
                Pixels pix = img.getPixels();
                List<Plane> planes = pix.copyPlaneList();
                for (int p = 0; p < planes.size(); ++p) {
                    Plane plane = planes.get(p);
                    if ((Integer)plane.getTheZ().getValue() < ((CoreMetadata)this.core.get((int)i4, (int)0)).sizeZ && (Integer)plane.getTheC().getValue() < ((CoreMetadata)this.core.get((int)i4, (int)0)).sizeC && (Integer)plane.getTheT().getValue() < ((CoreMetadata)this.core.get((int)i4, (int)0)).sizeT) continue;
                    pix.removePlane(planes.get(p));
                }
                pix.setMetadataOnly(null);
                List<Channel> channels = pix.copyChannelList();
                for (int c = 0; c < channels.size(); ++c) {
                    if (c >= ((int[])cBounds.get(i4))[0] && c <= ((int[])cBounds.get(i4))[1]) continue;
                    pix.removeChannel(channels.get(c));
                }
            }
            this.meta.setRoot(root);
            this.service.convertMetadata(this.meta, this.metadataStore);
            MetadataTools.populatePixels(this.metadataStore, this);
            this.addSubResolutions();
            return;
        }
        this.service.convertMetadata(this.meta, this.metadataStore);
        int seriesCount = this.meta.getImageCount();
        this.core.clear();
        for (int i6 = 0; i6 < seriesCount; ++i6) {
            this.core.add(new OMETiffCoreMetadata());
        }
        this.info = new OMETiffPlane[seriesCount][];
        Hashtable<String, String> files = new Hashtable<String, String>();
        for (int i7 = 0; i7 < seriesCount; ++i7) {
            int tiffDataCount = this.meta.getTiffDataCount(i7);
            for (int td = 0; td < tiffDataCount; ++td) {
                String existing;
                String uuid = null;
                try {
                    uuid = this.meta.getUUIDValue(i7, td);
                }
                catch (NullPointerException cBounds) {
                    // empty catch block
                }
                String filename = null;
                if (uuid == null) {
                    uuid = "";
                    filename = id;
                } else {
                    filename = this.meta.getUUIDFileName(i7, td);
                    if (!new Location(dir, filename).exists()) {
                        filename = null;
                    }
                    filename = filename == null ? (uuid.equals(currentUUID) || currentUUID == null ? id : "") : this.normalizeFilename(dir, filename);
                    if (filename.equals(id) && currentUUID == null) {
                        currentUUID = uuid;
                    }
                }
                if (filename.isEmpty()) {
                    String msg = "Missing file " + this.meta.getUUIDFileName(i7, td) + " associated with UUID " + uuid + ".";
                    if (this.failOnMissingTIFF()) {
                        throw new FormatException(msg);
                    }
                    LOGGER.error(msg + " Corresponding planes will be black.");
                    filename = this.normalizeFilename(dir, this.meta.getUUIDFileName(i7, td));
                }
                if ((existing = (String)files.get(uuid)) == null) {
                    files.put(uuid, filename);
                    continue;
                }
                if (existing.equals(filename)) continue;
                throw new FormatException("Inconsistent filenames for UUID " + uuid + ": " + this.meta.getUUIDFileName(i7, td) + " does not match " + existing + ".");
            }
        }
        Enumeration en = files.keys();
        int numUUIDs = files.size();
        HashSet<String> fileSet = new HashSet<String>();
        for (int i8 = 0; i8 < numUUIDs; ++i8) {
            String uuid = (String)en.nextElement();
            String filename = (String)files.get(uuid);
            fileSet.add(filename);
        }
        this.used = new String[fileSet.size()];
        Iterator iter = fileSet.iterator();
        for (int i9 = 0; i9 < this.used.length; ++i9) {
            this.used[i9] = (String)iter.next();
        }
        Hashtable<String, IFormatReader> readers = new Hashtable<String, IFormatReader>();
        Hashtable<String, long[]> ifdOffsets = new Hashtable<String, long[]>();
        boolean adjustedSamples = false;
        boolean hasSubIFDs = false;
        for (int i10 = 0; i10 < seriesCount; ++i10) {
            int td;
            int s2 = i10;
            LOGGER.debug("Image[{}] {", (Object)i10);
            LOGGER.debug("  id = {}", (Object)this.meta.getImageID(i10));
            String order = this.meta.getPixelsDimensionOrder(i10).toString();
            PrimitiveType samplesPerPixel = null;
            if (this.meta.getChannelCount(i10) > 0) {
                samplesPerPixel = this.meta.getChannelSamplesPerPixel(i10, 0);
            }
            int samples = samplesPerPixel == null ? -1 : (Integer)samplesPerPixel.getValue();
            int tiffSamples = firstIFD.getSamplesPerPixel();
            if (adjustedSamples || samples != tiffSamples && (i10 == 0 || samples < 0)) {
                LOGGER.warn("SamplesPerPixel mismatch: OME={}, TIFF={}", (Object)samples, (Object)tiffSamples);
                samples = tiffSamples;
                adjustedSamples = true;
            } else {
                adjustedSamples = false;
            }
            if (adjustedSamples && this.meta.getChannelCount(i10) <= 1) {
                adjustedSamples = false;
            }
            int effSizeC = (Integer)this.meta.getPixelsSizeC(i10).getValue();
            if (!adjustedSamples) {
                effSizeC /= samples;
            }
            if (effSizeC == 0) {
                effSizeC = 1;
            }
            if (effSizeC * samples != (Integer)this.meta.getPixelsSizeC(i10).getValue()) {
                effSizeC = (Integer)this.meta.getPixelsSizeC(i10).getValue();
            }
            int sizeT = (Integer)this.meta.getPixelsSizeT(i10).getValue();
            int sizeZ = (Integer)this.meta.getPixelsSizeZ(i10).getValue();
            int num = effSizeC * sizeT * sizeZ;
            OMETiffPlane[] planes = new OMETiffPlane[num];
            for (int no = 0; no < num; ++no) {
                planes[no] = new OMETiffPlane();
            }
            int tiffDataCount = this.meta.getTiffDataCount(i10);
            Boolean zOneIndexed = null;
            Boolean cOneIndexed = null;
            Boolean tOneIndexed = null;
            for (td = 0; td < tiffDataCount; ++td) {
                int z;
                NonNegativeInteger firstC = this.meta.getTiffDataFirstC(i10, td);
                NonNegativeInteger firstT = this.meta.getTiffDataFirstT(i10, td);
                NonNegativeInteger firstZ = this.meta.getTiffDataFirstZ(i10, td);
                int c = firstC == null ? 0 : (Integer)firstC.getValue();
                int t3 = firstT == null ? 0 : (Integer)firstT.getValue();
                int n = z = firstZ == null ? 0 : (Integer)firstZ.getValue();
                if (c >= effSizeC && cOneIndexed == null) {
                    cOneIndexed = true;
                } else if (c == 0) {
                    cOneIndexed = false;
                }
                if (z >= sizeZ && zOneIndexed == null) {
                    zOneIndexed = true;
                } else if (z == 0) {
                    zOneIndexed = false;
                }
                if (t3 >= sizeT && tOneIndexed == null) {
                    tOneIndexed = true;
                } else if (t3 == 0) {
                    tOneIndexed = false;
                }
                if (c == 0 && z == 0 && t3 == 0) break;
            }
            for (td = 0; td < tiffDataCount; ++td) {
                int count;
                int z;
                LOGGER.debug("    TiffData[{}] {", (Object)td);
                String filename = null;
                String uuid = null;
                try {
                    filename = this.meta.getUUIDFileName(i10, td);
                }
                catch (NullPointerException e) {
                    LOGGER.debug("Ignoring null UUID object when retrieving filename.");
                }
                try {
                    uuid = this.meta.getUUIDValue(i10, td);
                }
                catch (NullPointerException e) {
                    LOGGER.debug("Ignoring null UUID object when retrieving value.");
                }
                NonNegativeInteger tdIFD = this.meta.getTiffDataIFD(i10, td);
                int ifd = tdIFD == null ? 0 : (Integer)tdIFD.getValue();
                NonNegativeInteger numPlanes = this.meta.getTiffDataPlaneCount(i10, td);
                NonNegativeInteger firstC = this.meta.getTiffDataFirstC(i10, td);
                NonNegativeInteger firstT = this.meta.getTiffDataFirstT(i10, td);
                NonNegativeInteger firstZ = this.meta.getTiffDataFirstZ(i10, td);
                int c = firstC == null ? 0 : (Integer)firstC.getValue();
                int t4 = firstT == null ? 0 : (Integer)firstT.getValue();
                int n = z = firstZ == null ? 0 : (Integer)firstZ.getValue();
                if (cOneIndexed != null && cOneIndexed.booleanValue()) {
                    --c;
                }
                if (zOneIndexed != null && zOneIndexed.booleanValue()) {
                    --z;
                }
                if (tOneIndexed != null && tOneIndexed.booleanValue()) {
                    --t4;
                }
                if (z >= sizeZ || c >= effSizeC || t4 >= sizeT) {
                    LOGGER.warn("Found invalid TiffData: Z={}, C={}, T={}", z, c, t4);
                    break;
                }
                int index = FormatTools.getIndex(order, sizeZ, effSizeC, sizeT, num, z, c, t4);
                int n3 = count = numPlanes == null ? 1 : (Integer)numPlanes.getValue();
                if (count == 0) {
                    this.core.set(s2, 0, null);
                    break;
                }
                filename = filename == null ? (uuid == null ? id : (String)files.get(uuid)) : this.normalizeFilename(dir, filename);
                IFormatReader r = (IFormatReader)readers.get(filename);
                if (r == null) {
                    r = new MinimalTiffReader();
                    readers.put(filename, r);
                }
                Location file2 = new Location(filename);
                boolean exists = true;
                if (!file2.exists()) {
                    filename = filename.substring(filename.lastIndexOf(File.separator) + 1);
                    filename = dir + File.separator + filename;
                    if (!new Location(filename).exists()) {
                        filename = this.currentId;
                        exists = fileSet.size() == 1;
                    }
                }
                for (int q = 0; q < count; ++q) {
                    int no = index + q;
                    planes[no].reader = r;
                    planes[no].id = filename;
                    planes[no].ifd = ifd + q;
                    planes[no].certain = true;
                    planes[no].exists = exists;
                    LOGGER.trace("      Plane[{}]: file={}, IFD={}", no, planes[no].id, planes[no].ifd);
                }
                if (numPlanes == null) {
                    for (int no = index + 1; no < num && !planes[no].certain; ++no) {
                        planes[no].reader = r;
                        planes[no].id = filename;
                        planes[no].ifd = planes[no - 1].ifd + 1;
                        planes[no].exists = exists;
                        LOGGER.trace("      Plane[{}]: FILLED", (Object)no);
                    }
                }
                LOGGER.debug("    }");
            }
            if (this.core.get(s2, 0) == null) continue;
            LOGGER.debug("    --------------------------------");
            int validPlanes = num;
            for (int no = 0; no < num; ++no) {
                LOGGER.debug("    Plane[{}]: file={}, IFD={}", no, planes[no].id, planes[no].ifd);
                if (planes[no].reader != null) continue;
                --validPlanes;
                LOGGER.warn("Image ID '{}': missing plane #{}", (Object)this.meta.getImageID(i10), (Object)no);
            }
            if (validPlanes < num && files.size() <= 1) {
                LOGGER.warn("Using TiffReader to determine the number of planes.");
                this.initializeReader(r, this.currentId);
                try (TiffReader r = new TiffReader();){
                    planes = new OMETiffPlane[r.getImageCount()];
                    for (int plane = 0; plane < planes.length; ++plane) {
                        planes[plane] = new OMETiffPlane();
                        planes[plane].id = this.currentId;
                        planes[plane].reader = r;
                        planes[plane].ifd = plane;
                    }
                    num = planes.length;
                }
            }
            LOGGER.debug("  }");
            OMETiffCoreMetadata m5 = (OMETiffCoreMetadata)this.core.get(s2, 0);
            this.info[s2] = planes;
            RandomAccessInputStream testFile = null;
            try {
                String firstFile;
                if (this.info[s2][0].id != null) {
                    testFile = new RandomAccessInputStream(this.info[s2][0].id, 16);
                }
                if (this.info[s2][0].reader == null) {
                    this.info[s2][0].reader = new MinimalTiffReader();
                }
                if ((firstFile = this.info[s2][0].id) == null || testFile != null && !this.info[s2][0].reader.isThisType(testFile)) {
                    if (this.info[s2][0].id != null && this.failOnMissingTIFF()) {
                        throw new FormatException("Invalid file (may be corrupted): " + this.info[s2][0].id);
                    }
                    LOGGER.warn("{} is not a valid OME-TIFF", (Object)this.info[s2][0].id);
                    this.info[s2][0].id = this.currentId;
                    this.info[s2][0].exists = false;
                    if (this.info[s2][0].ifd < 0) {
                        this.info[s2][0].ifd = 0;
                    }
                } else {
                    try (TiffParser tp = new TiffParser(testFile);){
                        tp.setDoCaching(false);
                        long[] offsets = (long[])ifdOffsets.get(firstFile);
                        if (offsets == null) {
                            offsets = tp.getIFDOffsets();
                        }
                        IFD checkIFD = tp.getIFD(offsets[this.info[s2][0].ifd]);
                        hasSubIFDs = hasSubIFDs || checkIFD.containsKey(330);
                        m5.tileWidth = (int)checkIFD.getTileWidth();
                        m5.tileHeight = (int)checkIFD.getTileLength();
                        ifdOffsets.put(firstFile, offsets);
                    }
                }
                if (testFile != null) {
                    testFile.close();
                }
                for (int plane = 1; plane < this.info[s2].length; ++plane) {
                    if (this.info[s2][plane].id == null || this.info[s2][plane].reader == null) continue;
                    if (this.info[s2][plane].id.equals(firstFile)) {
                        if (this.info[s2][0].exists) continue;
                        this.info[s2][plane].id = this.info[s2][0].id;
                        this.info[s2][plane].exists = false;
                        continue;
                    }
                    try (RandomAccessInputStream test = new RandomAccessInputStream(this.info[s2][plane].id, 16);){
                        if (this.info[s2][plane].reader.isThisType(test)) continue;
                        LOGGER.warn("{} is not a valid OME-TIFF", (Object)this.info[s2][plane].id);
                        this.info[s2][plane].id = this.info[s2][0].id;
                        this.info[s2][plane].exists = false;
                        continue;
                    }
                }
                m5.sizeX = (Integer)this.meta.getPixelsSizeX(i10).getValue();
                int tiffWidth = (int)firstIFD.getImageWidth();
                if (m5.sizeX != tiffWidth && s2 == 0) {
                    LOGGER.warn("SizeX mismatch: OME={}, TIFF={}", (Object)m5.sizeX, (Object)tiffWidth);
                }
                m5.sizeY = (Integer)this.meta.getPixelsSizeY(i10).getValue();
                int tiffHeight = (int)firstIFD.getImageLength();
                if (m5.sizeY != tiffHeight && s2 == 0) {
                    LOGGER.warn("SizeY mismatch: OME={}, TIFF={}", (Object)m5.sizeY, (Object)tiffHeight);
                }
                m5.sizeZ = (Integer)this.meta.getPixelsSizeZ(i10).getValue();
                m5.sizeC = (Integer)this.meta.getPixelsSizeC(i10).getValue();
                m5.sizeT = (Integer)this.meta.getPixelsSizeT(i10).getValue();
                m5.pixelType = FormatTools.pixelTypeFromString(this.meta.getPixelsType(i10).toString());
                int tiffPixelType = firstIFD.getPixelType();
                if (m5.pixelType != tiffPixelType && (s2 == 0 || adjustedSamples)) {
                    LOGGER.warn("PixelType mismatch: OME={}, TIFF={}", (Object)m5.pixelType, (Object)tiffPixelType);
                    m5.pixelType = tiffPixelType;
                }
                m5.imageCount = num;
                m5.dimensionOrder = this.meta.getPixelsDimensionOrder(i10).toString();
                String uuidFileName = "";
                try {
                    if (this.meta.getTiffDataCount(i10) > 0) {
                        uuidFileName = this.meta.getUUIDFileName(i10, 0);
                    }
                }
                catch (NullPointerException firstZ) {
                    // empty catch block
                }
                if (this.meta.getChannelCount(i10) > 0 && this.meta.getChannelName(i10, 0) == null && this.meta.getTiffDataCount(i10) > 0 && uuidFileName.indexOf("__omero_export") != -1) {
                    m5.dimensionOrder = "XYZCT";
                }
                m5.orderCertain = true;
                PhotoInterp photo = firstIFD.getPhotometricInterpretation();
                boolean bl = m5.rgb = samples > 1 || photo == PhotoInterp.RGB;
                if (samples != m5.sizeC && samples % m5.sizeC != 0 && m5.sizeC % samples != 0 || m5.sizeC == 1 || adjustedSamples) {
                    m5.sizeC *= samples;
                }
                if (m5.sizeZ * m5.sizeT * m5.sizeC > m5.imageCount && !m5.rgb) {
                    if (m5.sizeZ == m5.imageCount) {
                        m5.sizeT = 1;
                        m5.sizeC = 1;
                    } else if (m5.sizeT == m5.imageCount) {
                        m5.sizeZ = 1;
                        m5.sizeC = 1;
                    } else if (m5.sizeC == m5.imageCount) {
                        m5.sizeT = 1;
                        m5.sizeZ = 1;
                    }
                }
                if (this.meta.getPixelsBinDataCount(i10) > 1) {
                    LOGGER.warn("OME-TIFF Pixels element contains BinData elements! Ignoring.");
                }
                m5.littleEndian = firstIFD.isLittleEndian();
                m5.interleaved = false;
                boolean bl2 = m5.indexed = photo == PhotoInterp.RGB_PALETTE && firstIFD.getIFDValue(320) != null;
                if (m5.indexed) {
                    m5.rgb = false;
                }
                m5.falseColor = true;
                m5.metadataComplete = true;
                if (this.meta.getPixelsSignificantBits(i10) == null) continue;
                m5.bitsPerPixel = (Integer)this.meta.getPixelsSignificantBits(i10).getValue();
                continue;
            }
            catch (NullPointerException exc) {
                throw new FormatException("Incomplete Pixels metadata", exc);
            }
            finally {
                if (testFile != null) {
                    testFile.close();
                }
                if (this.info[s2][0].reader != null) {
                    this.info[s2][0].reader.close(true);
                }
            }
        }
        CoreMetadataList series = new CoreMetadataList();
        ArrayList<OMETiffPlane[]> planeInfo = new ArrayList<OMETiffPlane[]>();
        int currentSeries = 0;
        for (int i11 = 0; i11 < this.core.size(); ++i11) {
            if (this.core.get(i11, 0) == null) continue;
            series.add();
            planeInfo.add(this.info[i11]);
            for (int j = 0; j < this.core.size(i11); ++j) {
                series.add(currentSeries, (CoreMetadata)this.core.get(i11, j));
            }
            ++currentSeries;
        }
        this.core = series;
        this.info = (OMETiffPlane[][])planeInfo.toArray((T[])new OMETiffPlane[0][0]);
        if (this.getImageCount() == 1) {
            OMETiffCoreMetadata ms0 = (OMETiffCoreMetadata)this.core.get(0, 0);
            ms0.sizeZ = 1;
            if (!ms0.rgb) {
                ms0.sizeC = 1;
            }
            ms0.sizeT = 1;
        }
        for (int i12 = 0; i12 < this.core.size(); ++i12) {
            Modulo t5;
            Modulo c;
            OMETiffCoreMetadata m6 = (OMETiffCoreMetadata)this.core.get(i12, 0);
            Modulo z = this.service.getModuloAlongZ(this.meta, i12);
            if (z != null) {
                m6.moduloZ = z;
            }
            if ((c = this.service.getModuloAlongC(this.meta, i12)) != null) {
                m6.moduloC = c;
            }
            if ((t5 = this.service.getModuloAlongT(this.meta, i12)) == null) continue;
            m6.moduloT = t5;
        }
        OMETiffPlane[][] i12 = this.info;
        int m6 = i12.length;
        for (int z = 0; z < m6; ++z) {
            OMETiffPlane[] s3;
            for (OMETiffPlane p : s3 = i12[z]) {
                if (p == null || p.reader == null) continue;
                this.removeIFDComments(p.reader);
                p.reader.close();
            }
        }
        MetadataTools.populatePixels(this.metadataStore, this, false, false);
        for (i = 0; i < this.meta.getImageCount(); ++i) {
            for (int p = 0; p < this.meta.getPlaneCount(i); ++p) {
                NonNegativeInteger z = this.meta.getPlaneTheZ(i, p);
                NonNegativeInteger c = this.meta.getPlaneTheC(i, p);
                NonNegativeInteger t6 = this.meta.getPlaneTheT(i, p);
                if (z == null) {
                    z = new NonNegativeInteger(0);
                    this.metadataStore.setPlaneTheZ(z, i, p);
                }
                if (c == null) {
                    c = new NonNegativeInteger(0);
                    this.metadataStore.setPlaneTheC(c, i, p);
                }
                if (t6 != null) continue;
                t6 = new NonNegativeInteger(0);
                this.metadataStore.setPlaneTheT(t6, i, p);
            }
        }
        for (i = 0; i < acquiredDates.length; ++i) {
            if (acquiredDates[i] == null) continue;
            this.metadataStore.setImageAcquisitionDate(new Timestamp(acquiredDates[i]), i);
        }
        if (hasSubIFDs) {
            this.addSubResolutions();
        }
    }

    public MetadataStore getMetadataStoreForDisplay() {
        return this.getMetadataStore();
    }

    public MetadataStore getMetadataStoreForConversion() {
        return this.getMetadataStore();
    }

    private String normalizeFilename(String dir, String name) {
        Location file2 = new Location(dir, name);
        if (file2.exists()) {
            return file2.getAbsolutePath();
        }
        return name;
    }

    private void setupService() throws FormatException {
        try {
            ServiceFactory factory2 = new ServiceFactory();
            this.service = factory2.getInstance(OMEXMLService.class);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException(OMEXMLServiceImpl.NO_OME_XML_MSG, de);
        }
    }

    private void addSubResolutions() throws IOException, FormatException {
        boolean repopulateMetadata = false;
        for (int s2 = 0; s2 < this.core.size(); ++s2) {
            OMETiffCoreMetadata c0 = (OMETiffCoreMetadata)this.core.get(s2, 0);
            int i = this.info[s2][0].ifd;
            MinimalTiffReader r = (MinimalTiffReader)this.info[s2][0].reader;
            if (r.getCurrentFile() == null) {
                r.setId(this.info[s2][0].id);
            }
            r.lastPlane = i;
            IFDList ifdList = r.getIFDs();
            if (i >= ifdList.size()) {
                LOGGER.warn("Error untangling IFDs; the OME-TIFF file may be malformed (IFD #{} missing).", (Object)i);
                continue;
            }
            IFD ifd = (IFD)ifdList.get(i);
            IFDList subifds = null;
            try (RandomAccessInputStream rs = new RandomAccessInputStream(this.info[s2][0].id, 16);){
                TiffParser p = new TiffParser(rs);
                subifds = p.getSubIFDs(ifd);
            }
            c0.resolutionCount = subifds.size() + 1;
            if (c0.resolutionCount > 1 && this.hasFlattenedResolutions()) {
                repopulateMetadata = true;
            }
            for (int si = 0; si < subifds.size(); ++si) {
                IFD subifd = (IFD)subifds.get(si);
                OMETiffCoreMetadata c = new OMETiffCoreMetadata(c0);
                c.subresolutionOffset = si;
                c.sizeX = (int)subifd.getImageWidth();
                c.sizeY = (int)subifd.getImageLength();
                try {
                    c.tileWidth = (int)subifd.getTileWidth();
                }
                catch (FormatException e) {
                    c.tileWidth = c.sizeX;
                }
                try {
                    c.tileHeight = (int)subifd.getTileLength();
                    if (c.tileHeight <= 0) {
                        c.tileHeight = c.sizeY;
                    }
                }
                catch (FormatException e) {
                    c.tileHeight = c.sizeY;
                }
                if (DataTools.safeMultiply64(c.tileHeight, c.tileWidth) > 0xA00000L) {
                    int bpp = FormatTools.getBytesPerPixel(c.pixelType);
                    int effC = c.sizeC / (c.imageCount / (c.sizeZ * c.sizeT));
                    int maxHeight = 0x100000 / (c.sizeX * effC * bpp);
                    c.tileHeight = Math.min(maxHeight, c.sizeY);
                }
                this.core.add(s2, c);
            }
            if (this.getCurrentFile().equals(r.getCurrentFile())) continue;
            r.close();
        }
        this.core.reorder();
        if (repopulateMetadata) {
            MetadataTools.populatePixels(this.metadataStore, this);
        }
    }

    private String readMetadataFile() throws IOException {
        LOGGER.debug("Reading metadata from {}", (Object)this.metadataFile);
        if (OMETiffReader.checkSuffix(this.metadataFile, "ome.tiff") || OMETiffReader.checkSuffix(this.metadataFile, "ome.tif") || OMETiffReader.checkSuffix(this.metadataFile, "ome.tf2") || OMETiffReader.checkSuffix(this.metadataFile, "ome.tf8") || OMETiffReader.checkSuffix(this.metadataFile, "ome.btf")) {
            try (RandomAccessInputStream in = new RandomAccessInputStream(this.metadataFile);){
                TiffParser parser = new TiffParser(in);
                String string = parser.getComment();
                return string;
            }
        }
        return DataTools.readFile(this.metadataFile);
    }

    private static IFD getFirstIFD(String fname) throws IOException {
        IFD firstIFD = null;
        try (RandomAccessInputStream ras = new RandomAccessInputStream(fname, 16);){
            TiffParser tp = new TiffParser(ras);
            firstIFD = tp.getFirstIFD();
        }
        return firstIFD;
    }

    private void initializeReader(IFormatReader r, String file2) throws FormatException, IOException {
        r.setId(file2);
        this.removeIFDComments(r);
    }

    private void removeIFDComments(IFormatReader r) {
        if (r != null && r instanceof MinimalTiffReader && ((MinimalTiffReader)r).ifds != null) {
            for (IFD ifd : ((MinimalTiffReader)r).ifds) {
                ifd.remove(270);
            }
        }
    }

    public boolean failOnMissingTIFF() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(FAIL_ON_MISSING_KEY, true);
        }
        return true;
    }

    private class OMETiffCoreMetadata
    extends CoreMetadata {
        int subresolutionOffset;
        int tileWidth;
        int tileHeight;

        OMETiffCoreMetadata() {
            this.subresolutionOffset = -1;
        }

        OMETiffCoreMetadata(OMETiffCoreMetadata copy) {
            super(copy);
            this.subresolutionOffset = -1;
            this.subresolutionOffset = copy.subresolutionOffset;
            this.tileWidth = copy.tileWidth;
            this.tileHeight = copy.tileHeight;
        }

        OMETiffCoreMetadata(CoreMetadata copy) {
            super(copy);
            this.subresolutionOffset = -1;
        }
    }

    private class OMETiffPlane {
        public IFormatReader reader;
        public String id;
        public int ifd = -1;
        public boolean certain = false;
        public boolean exists = true;

        private OMETiffPlane() {
        }
    }
}

