/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.POIService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.primitives.Timestamp;

public class PCIReader
extends FormatReader {
    public static final int PCI_MAGIC_BYTES = -791735840;
    private HashMap<Integer, String> imageFiles;
    private transient POIService poi;
    private HashMap<Integer, Double> timestamps;
    private String creationDate;
    private int binning;
    private List<Double> uniqueZ;

    public PCIReader() {
        super("Compix Simple-PCI", "cxd");
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readInt() == -791735840;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        String file2 = this.imageFiles.get(0);
        try {
            if (this.poi == null) {
                this.initPOIService();
            }
            try (RandomAccessInputStream s2 = this.poi.getDocumentStream(file2);){
                TiffParser tp = new TiffParser(s2);
                if (!tp.isValidHeader()) return super.getOptimalTileWidth();
                IFD ifd = tp.getFirstIFD();
                int n = (int)ifd.getTileWidth();
                return n;
            }
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", e);
            return super.getOptimalTileWidth();
        }
        catch (IOException e) {
            LOGGER.debug("Could not retrieve tile width", e);
        }
        return super.getOptimalTileWidth();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        String file2 = this.imageFiles.get(0);
        try {
            if (this.poi == null) {
                this.initPOIService();
            }
            try (RandomAccessInputStream s2 = this.poi.getDocumentStream(file2);){
                TiffParser tp = new TiffParser(s2);
                if (!tp.isValidHeader()) return super.getOptimalTileHeight();
                IFD ifd = tp.getFirstIFD();
                int n = (int)ifd.getTileLength();
                return n;
            }
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", e);
            return super.getOptimalTileHeight();
        }
        catch (IOException e) {
            LOGGER.debug("Could not retrieve tile height", e);
        }
        return super.getOptimalTileHeight();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.poi == null) {
            this.initPOIService();
        }
        String file2 = this.imageFiles.get(no);
        try (RandomAccessInputStream s2 = this.poi.getDocumentStream(file2);){
            TiffParser tp = new TiffParser(s2);
            if (tp.isValidHeader()) {
                IFD ifd = tp.getFirstIFD();
                tp.getSamples(ifd, buf, x, y, w, h2);
            } else {
                s2.seek(0L);
                this.readPlane(s2, x, y, w, h2, buf);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.imageFiles = null;
            this.timestamps = null;
            if (this.poi != null) {
                this.poi.close();
            }
            this.poi = null;
            this.binning = 0;
            this.creationDate = null;
            this.uniqueZ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        String[] files;
        boolean zFirst;
        super.initFile(id);
        this.imageFiles = new HashMap();
        this.timestamps = new HashMap();
        this.uniqueZ = new ArrayList<Double>();
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        this.initPOIService();
        double scaleFactor = 1.0;
        double magnification = 1.0;
        Unit<Length> units = UNITS.MICROMETER;
        Vector<String> allFiles = this.poi.getDocumentList();
        if (allFiles.isEmpty()) {
            throw new FormatException("No files were found - the .cxd may be corrupt.");
        }
        double firstZ = 0.0;
        double secondZ = 0.0;
        int mode = 0;
        for (String name : allFiles) {
            int separator = name.lastIndexOf(File.separator);
            String parent = name.substring(0, separator);
            String relativePath = name.substring(separator + 1).trim();
            RandomAccessInputStream stream = null;
            if (!(relativePath.startsWith("Bitmap") || relativePath.equals("Data") && parent.indexOf("Image") != -1)) {
                stream = this.poi.getDocumentStream(name);
                stream.order(true);
            }
            try {
                String[] lines;
                if (stream != null && stream.length() == 8L) {
                    double value = stream.readDouble();
                    stream.seek(0L);
                    String[] key = name.replace(File.separatorChar, ' ');
                    key = key.replaceAll("Root Entry ", "");
                    key = key.replaceAll("Field Data ", "");
                    key = key.replaceAll("Details ", "");
                    this.addGlobalMeta((String)key, value);
                }
                if (relativePath.equals("Field Count")) {
                    m4.imageCount = stream.readInt();
                    continue;
                }
                if (relativePath.equals("File Has Image")) {
                    if (stream.readShort() != 0) continue;
                    throw new FormatException("This file does not contain image data.");
                }
                if (relativePath.startsWith("Bitmap") || relativePath.equals("Data") && parent.indexOf("Image") != -1) {
                    this.imageFiles.put(this.imageFiles.size(), name);
                    if (this.getSizeX() == 0 || this.getSizeY() == 0) continue;
                    int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
                    int plane = this.getSizeX() * this.getSizeY() * bpp;
                    if (this.getSizeC() != 0 && this.getSizeC() * plane <= this.poi.getFileSize(name)) continue;
                    m4.sizeC = this.poi.getFileSize(name) / plane;
                    continue;
                }
                if (relativePath.indexOf("Image_Depth") != -1) {
                    int bits;
                    boolean firstBits = m4.bitsPerPixel == 0;
                    m4.bitsPerPixel = bits = (int)stream.readDouble();
                    while (bits % 8 != 0 || bits == 0) {
                        ++bits;
                    }
                    if (bits % 3 == 0) {
                        m4.sizeC = 3;
                        bits /= 3;
                        m4.bitsPerPixel /= 3;
                    }
                    m4.pixelType = FormatTools.pixelTypeFromBytes(bits /= 8, false, false);
                    if (this.getSizeC() <= 1 || !firstBits) continue;
                    m4.sizeC /= bits;
                    continue;
                }
                if (relativePath.indexOf("Image_Height") != -1 && this.getSizeY() == 0) {
                    m4.sizeY = (int)stream.readDouble();
                    continue;
                }
                if (relativePath.indexOf("Image_Width") != -1 && this.getSizeX() == 0) {
                    m4.sizeX = (int)stream.readDouble();
                    continue;
                }
                if (relativePath.indexOf("Time_From_Start") != -1) {
                    this.timestamps.put(this.getTimestampIndex(parent), stream.readDouble());
                    continue;
                }
                if (relativePath.endsWith("Position_Z")) {
                    double zPos = stream.readDouble();
                    if (!this.uniqueZ.contains(zPos) && this.getSizeZ() <= 1) {
                        this.uniqueZ.add(zPos);
                    }
                    if (name.indexOf("Field 1" + File.separator) != -1) {
                        firstZ = zPos;
                        continue;
                    }
                    if (name.indexOf("Field 2" + File.separator) == -1) continue;
                    secondZ = zPos;
                    continue;
                }
                if (relativePath.equals("First Field Date & Time")) {
                    long date = (long)stream.readDouble() * 1000L;
                    this.creationDate = DateTools.convertDate(date, 1);
                    continue;
                }
                if (relativePath.equals("GroupMode")) {
                    mode = stream.readInt();
                    continue;
                }
                if (relativePath.equals("GroupSelectedFields")) {
                    m4.sizeZ = (int)(stream.length() / 8L);
                    continue;
                }
                if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
                if (relativePath.equals("Binning")) {
                    this.binning = (int)stream.readDouble();
                    continue;
                }
                if (!relativePath.equals("Comments")) continue;
                String comments = stream.readString((int)stream.length());
                for (String line : lines = comments.split("\n")) {
                    int eq = line.indexOf(61);
                    if (eq == -1) continue;
                    String key = line.substring(0, eq).trim();
                    String value = line.substring(eq + 1).trim();
                    this.addGlobalMeta(key, value);
                    if (key.equals("factor")) {
                        if (value.indexOf(59) != -1) {
                            value = value.substring(0, value.indexOf(59));
                        }
                        scaleFactor = DataTools.parseDouble(value.trim());
                    }
                    if (key.equals("magnification")) {
                        if (value.indexOf(59) != -1) {
                            value = value.substring(0, value.indexOf(59));
                        }
                        magnification = DataTools.parseDouble(value.trim());
                    }
                    if (!key.equals("units") || value.indexOf(59) == -1) continue;
                    if ((value = value.substring(0, value.indexOf(59))).toLowerCase().trim().equals("pixels")) {
                        value = UNITS.PIXEL.getSymbol();
                    }
                    try {
                        units = UnitsLengthEnumHandler.getBaseUnit(UnitsLength.fromString(value));
                    }
                    catch (EnumerationException e) {
                        LOGGER.info("Failed to parse calibration units", e);
                    }
                }
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        boolean bl = zFirst = Math.abs(firstZ - secondZ) > 1.0E-6;
        if (this.getSizeC() == 0) {
            m4.sizeC = 1;
        }
        if (mode == 0) {
            m4.sizeZ = 0;
        }
        if (this.getSizeZ() <= 1 || this.getImageCount() % this.getSizeZ() != 0) {
            m4.sizeZ = this.uniqueZ.isEmpty() ? 1 : this.uniqueZ.size();
        }
        m4.sizeT = this.getImageCount() / this.getSizeZ();
        while (this.getSizeZ() * this.getSizeT() < this.getImageCount()) {
            ++m4.sizeZ;
            m4.sizeT = this.getImageCount() / this.getSizeZ();
        }
        boolean bl2 = m4.rgb = this.getSizeC() > 1;
        if (this.imageFiles.size() > this.getImageCount() && this.getSizeC() == 1) {
            m4.sizeC = this.imageFiles.size() / this.getImageCount();
            m4.imageCount *= this.getSizeC();
        } else {
            m4.imageCount = this.getSizeZ() * this.getSizeT();
        }
        m4.interleaved = false;
        m4.dimensionOrder = zFirst ? "XYCZT" : "XYCTZ";
        m4.littleEndian = true;
        m4.indexed = false;
        m4.falseColor = false;
        m4.metadataComplete = true;
        for (String file2 : files = this.imageFiles.values().toArray(new String[this.imageFiles.size()])) {
            int separator = file2.lastIndexOf(File.separator);
            String parent = file2.substring(0, separator);
            this.imageFiles.put(this.getImageIndex(parent), file2);
        }
        int bpp = FormatTools.getBytesPerPixel(m4.pixelType);
        int expectedPlaneSize = m4.sizeX * m4.sizeY * bpp * m4.sizeC;
        String file3 = this.imageFiles.get(0);
        try (RandomAccessInputStream s2 = this.poi.getDocumentStream(file3);){
            TiffParser tp = new TiffParser(s2);
            if (!tp.isValidHeader() && s2.length() > (long)expectedPlaneSize) {
                m4.sizeX = (int)((long)m4.sizeX + (s2.length() - (long)expectedPlaneSize) / (long)(m4.sizeY * bpp * m4.sizeC));
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        if (this.creationDate != null) {
            store.setImageAcquisitionDate(new Timestamp(this.creationDate), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            if (!units.equals(UNITS.PIXEL)) {
                scaleFactor *= magnification;
            }
            Length sizeX = FormatTools.getPhysicalSizeX(scaleFactor);
            Length sizeY = FormatTools.getPhysicalSizeY(scaleFactor);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            for (int i = 0; i < this.timestamps.size() && i < this.getImageCount(); ++i) {
                Double timestamp = this.timestamps.get(i);
                if (timestamp != null) {
                    store.setPlaneDeltaT(new Time(timestamp, UNITS.SECOND), 0, i);
                }
                if (i != 2) continue;
                Double first = this.timestamps.get(1);
                Double increment = timestamp - first;
                if (increment == null) continue;
                store.setPixelsTimeIncrement(new Time(increment, UNITS.SECOND), 0);
            }
            if (this.binning > 0) {
                String instrumentID = MetadataTools.createLSID("Instrument", 0);
                String detectorID = MetadataTools.createLSID("Detector", 0);
                store.setInstrumentID(instrumentID, 0);
                store.setDetectorID(detectorID, 0, 0);
                store.setDetectorType(MetadataTools.getDetectorType("Other"), 0, 0);
                store.setImageInstrumentRef(instrumentID, 0);
                Binning binningEnum = MetadataTools.getBinning(this.binning + "x" + this.binning);
                for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                    store.setDetectorSettingsID(detectorID, 0, c);
                    store.setDetectorSettingsBinning(binningEnum, 0, c);
                }
            }
        }
    }

    private void initPOIService() throws FormatException, IOException {
        try {
            ServiceFactory factory2 = new ServiceFactory();
            this.poi = factory2.getInstance(POIService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("POI library not found", de);
        }
        this.poi.initialize(Location.getMappedId(this.getCurrentFile()));
    }

    private Integer getImageIndex(String path) {
        int space = path.lastIndexOf(" ") + 1;
        if (space >= path.length()) {
            return null;
        }
        int end = path.indexOf(File.separator, space);
        String field = path.substring(space, end);
        String image = "1";
        int imageIndex = path.indexOf("Image") + 5;
        if (imageIndex >= 0) {
            end = path.indexOf(File.separator, imageIndex);
            if (end < 0) {
                end = path.length();
            }
            image = path.substring(imageIndex, end);
        }
        try {
            int channel = Integer.parseInt(image) - 1;
            return this.getEffectiveSizeC() * (Integer.parseInt(field) - 1) + channel;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Integer getTimestampIndex(String path) {
        int space = path.lastIndexOf(" ") + 1;
        if (space >= path.length()) {
            return null;
        }
        int end = path.indexOf(File.separator, space);
        return Integer.parseInt(path.substring(space, end)) - 1;
    }
}

