/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;

public class PerkinElmerReader
extends FormatReader {
    public static final String[] CFG_SUFFIX = new String[]{"cfg"};
    public static final String[] ANO_SUFFIX = new String[]{"ano"};
    public static final String[] REC_SUFFIX = new String[]{"rec"};
    public static final String[] TIM_SUFFIX = new String[]{"tim"};
    public static final String[] CSV_SUFFIX = new String[]{"csv"};
    public static final String[] ZPO_SUFFIX = new String[]{"zpo"};
    public static final String[] HTM_SUFFIX = new String[]{"htm"};
    public static final String HTML_REGEX = "<p>|</p>|<br>|<hr>|<b>|</b>|<HTML>|<HEAD>|</HTML>|</HEAD>|<h1>|</h1>|<HR>|</body>";
    public static final String DATE_FORMAT = "HH:mm:ss (MM/dd/yyyy)";
    protected MinimalTiffReader tiff;
    protected PixelsFile[] files;
    private boolean isTiff = true;
    private List<String> allFiles;
    private int extCount;
    private String details;
    private String sliceSpace;
    private double pixelSizeX = 1.0;
    private double pixelSizeY = 1.0;
    private String finishTime = null;
    private String startTime = null;
    private double originX = 0.0;
    private double originY = 0.0;
    private double originZ = 0.0;

    public PerkinElmerReader() {
        super("PerkinElmer", new String[]{"ano", "cfg", "csv", "htm", "rec", "tim", "zpo", "tif"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .htm file, several other metadata files (.tim, .ano, .csv, \u2026) and either .tif files or .2, .3, .4, etc. files";
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        boolean binFile;
        String ext;
        block13: {
            if (!open) {
                return false;
            }
            if (PerkinElmerReader.checkSuffix(name, "cfg")) {
                try {
                    String check2 = DataTools.readFile(name);
                    if (check2.indexOf("Ultraview") == -1) {
                        return false;
                    }
                }
                catch (IOException check2) {
                    // empty catch block
                }
            }
            if ((ext = name).indexOf(46) != -1) {
                ext = ext.substring(ext.lastIndexOf(".") + 1);
            }
            binFile = true;
            try {
                Integer.parseInt(ext, 16);
            }
            catch (NumberFormatException e) {
                ext = ext.toLowerCase();
                if (ext.equals("tif") || ext.equals("tiff")) break block13;
                binFile = false;
            }
        }
        Location baseFile = new Location(name).getAbsoluteFile();
        String prefix = baseFile.getParent() + File.separator;
        String namePrefix = baseFile.getName();
        if (namePrefix.indexOf(46) != -1) {
            namePrefix = namePrefix.substring(0, namePrefix.lastIndexOf("."));
        }
        if (namePrefix.indexOf(95) != -1 && binFile) {
            namePrefix = namePrefix.substring(0, namePrefix.lastIndexOf("_"));
        }
        prefix = prefix + namePrefix;
        Location htmlFile = new Location(prefix + ".htm");
        if (ext.toLowerCase().equals("htm")) {
            htmlFile = new Location(name).getAbsoluteFile();
        }
        if (!htmlFile.exists()) {
            htmlFile = new Location(prefix + ".HTM");
            while (!htmlFile.exists() && prefix.indexOf(95) != -1) {
                htmlFile = new Location((prefix = prefix.substring(0, prefix.lastIndexOf("_"))) + ".htm");
                if (htmlFile.exists()) continue;
                htmlFile = new Location(prefix + ".HTM");
            }
        }
        return htmlFile.exists() && (binFile || super.isThisType(name, false));
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        if (this.isTiff && this.tiff != null) {
            return this.tiff.get8BitLookupTable();
        }
        return null;
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        if (this.isTiff && this.tiff != null) {
            return this.tiff.get16BitLookupTable();
        }
        return null;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        String file2 = this.getFile(no);
        int index = this.getFileIndex(no);
        if (this.isTiff) {
            this.tiff.setId(file2);
            return this.tiff.openBytes(index, buf, x, y, w, h2);
        }
        try (RandomAccessInputStream ras = new RandomAccessInputStream(file2);){
            if ((long)(6 + index * FormatTools.getPlaneSize(this)) < ras.length()) {
                ras.seek(6 + index * FormatTools.getPlaneSize(this));
                this.readPlane(ras, x, y, w, h2, buf);
            }
        }
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            ArrayList<String> files = new ArrayList<String>();
            if (this.isTiff) {
                for (String f : this.allFiles) {
                    if (PerkinElmerReader.checkSuffix(f, new String[]{"tif", "tiff"})) continue;
                    files.add(f);
                }
            } else {
                for (String f : this.allFiles) {
                    String ext = f.substring(f.lastIndexOf(".") + 1);
                    try {
                        Integer.parseInt(ext, 16);
                    }
                    catch (NumberFormatException e) {
                        files.add(f);
                    }
                }
            }
            return files.toArray(new String[files.size()]);
        }
        return this.allFiles.toArray(new String[this.allFiles.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiff != null) {
            this.tiff.close(fileOnly);
        }
        if (!fileOnly) {
            this.tiff = null;
            this.allFiles = null;
            this.files = null;
            this.sliceSpace = null;
            this.details = null;
            this.isTiff = true;
            this.pixelSizeY = 1.0;
            this.pixelSizeX = 1.0;
            this.startTime = null;
            this.finishTime = null;
            this.originZ = 0.0;
            this.originY = 0.0;
            this.originX = 0.0;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.isTiff) {
            return this.tiff.getOptimalTileWidth();
        }
        return super.getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.isTiff) {
            return this.tiff.getOptimalTileHeight();
        }
        return super.getOptimalTileHeight();
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        Timestamp timestamp;
        String[] tokens;
        String workingDirPath;
        if (this.currentId != null && (id.equals(this.currentId) || this.isUsedFile(id))) {
            return;
        }
        LOGGER.info("Finding HTML companion file");
        if (!PerkinElmerReader.checkSuffix(id, HTM_SUFFIX)) {
            String[] ls;
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            for (String file2 : ls = parent.list()) {
                if (!PerkinElmerReader.checkSuffix(file2, HTM_SUFFIX) || file2.startsWith(".")) continue;
                id = new Location(parent.getAbsolutePath(), file2).getAbsolutePath();
                break;
            }
        }
        super.initFile(id);
        this.allFiles = new ArrayList<String>();
        Location tmpFile = new Location(id).getAbsoluteFile();
        Location workingDir = tmpFile.getParentFile();
        if (workingDir == null) {
            workingDir = new Location(".");
        }
        if (!(workingDirPath = workingDir.getPath()).equals("")) {
            workingDirPath = workingDirPath + File.separator;
        }
        Object[] ls = workingDir.list(true);
        if (!new Location(id).exists()) {
            ls = Location.getIdMap().keySet().toArray(new String[0]);
            workingDirPath = "";
        }
        LOGGER.info("Searching for all metadata companion files");
        Object cfgFile = null;
        Object anoFile = null;
        Object recFile = null;
        Object timFile = null;
        Object csvFile = null;
        Object zpoFile = null;
        Object htmFile = null;
        ArrayList<PixelsFile> tempFiles = new ArrayList<PixelsFile>();
        int dot = id.lastIndexOf(".");
        String check2 = dot < 0 ? id : id.substring(0, dot);
        check2 = check2.substring(check2.lastIndexOf(File.separator) + 1);
        String prefix = null;
        Arrays.sort(ls);
        for (int i = 0; i < ls.length; ++i) {
            Object s2;
            int d = ((String)ls[i]).lastIndexOf(".");
            while (d == -1 && i < ls.length - 1) {
                d = ((String)ls[++i]).lastIndexOf(".");
            }
            Object object = s2 = d < 0 ? ls[i] : ((String)ls[i]).substring(0, d);
            if (!((String)s2).startsWith(check2) && !check2.startsWith((String)s2) && (prefix == null || !((String)s2).startsWith(prefix))) continue;
            prefix = ((String)ls[i]).substring(0, d);
            if (cfgFile == null && PerkinElmerReader.checkSuffix((String)ls[i], CFG_SUFFIX)) {
                cfgFile = ls[i];
            }
            if (anoFile == null && PerkinElmerReader.checkSuffix((String)ls[i], ANO_SUFFIX)) {
                anoFile = ls[i];
            }
            if (recFile == null && PerkinElmerReader.checkSuffix((String)ls[i], REC_SUFFIX)) {
                recFile = ls[i];
            }
            if (timFile == null && PerkinElmerReader.checkSuffix((String)ls[i], TIM_SUFFIX)) {
                timFile = ls[i];
            }
            if (csvFile == null && PerkinElmerReader.checkSuffix((String)ls[i], CSV_SUFFIX)) {
                csvFile = ls[i];
            }
            if (zpoFile == null && PerkinElmerReader.checkSuffix((String)ls[i], ZPO_SUFFIX)) {
                zpoFile = ls[i];
            }
            if (htmFile == null && PerkinElmerReader.checkSuffix((String)ls[i], HTM_SUFFIX)) {
                htmFile = ls[i];
            }
            dot = ((String)ls[i]).lastIndexOf(".");
            PixelsFile f = new PixelsFile();
            f.path = workingDirPath + (String)ls[i];
            if (PerkinElmerReader.checkSuffix((String)ls[i], TiffReader.TIFF_SUFFIXES)) {
                f.firstIndex = dot - 4 >= 0 && dot - 4 < ((String)ls[i]).length() && ((String)ls[i]).charAt(dot - 4) == '_' ? Integer.parseInt(((String)ls[i]).substring(dot - 3, dot)) : -1;
                if (dot - 9 >= 0 && dot - 9 < ((String)ls[i]).length() && ((String)ls[i]).charAt(dot - 9) == '_') {
                    f.extIndex = Integer.parseInt(((String)ls[i]).substring(dot - 8, dot - 4));
                } else {
                    f.firstIndex = i;
                    f.extIndex = 0;
                }
                tempFiles.add(f);
                continue;
            }
            try {
                f.firstIndex = dot - 4 >= 0 && dot - 4 < ((String)ls[i]).length() && ((String)ls[i]).charAt(dot - 4) == '_' ? Integer.parseInt(((String)ls[i]).substring(dot - 3, dot)) : -1;
                String ext = dot + 1 < ((String)ls[i]).length() ? ((String)ls[i]).substring(dot + 1) : "";
                f.extIndex = Integer.parseInt(ext, 16);
                this.isTiff = false;
                tempFiles.add(f);
                continue;
            }
            catch (NumberFormatException exc) {
                LOGGER.debug("Failed to parse file extension", exc);
            }
        }
        this.files = tempFiles.toArray(new PixelsFile[tempFiles.size()]);
        LOGGER.info("Finding image files");
        ArrayList<Integer> foundExts = new ArrayList<Integer>();
        for (PixelsFile f : this.files) {
            if (foundExts.contains(f.extIndex)) continue;
            foundExts.add(f.extIndex);
        }
        this.extCount = foundExts.size();
        foundExts = null;
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        ms0.imageCount = 0;
        for (PixelsFile f : this.files) {
            this.allFiles.add(f.path);
            ++ms0.imageCount;
            if (f.firstIndex >= 0 || this.files.length <= this.extCount) continue;
            ms0.imageCount += (this.files.length - 1) / (this.extCount - 1) - 1;
        }
        this.tiff = new MinimalTiffReader();
        LOGGER.info("Parsing metadata values");
        this.addUsedFile(workingDirPath, (String)cfgFile);
        this.addUsedFile(workingDirPath, (String)anoFile);
        this.addUsedFile(workingDirPath, (String)recFile);
        this.addUsedFile(workingDirPath, (String)timFile);
        if (timFile != null) {
            timFile = this.allFiles.get(this.allFiles.size() - 1);
        }
        this.addUsedFile(workingDirPath, (String)csvFile);
        if (csvFile != null) {
            csvFile = this.allFiles.get(this.allFiles.size() - 1);
        }
        this.addUsedFile(workingDirPath, (String)zpoFile);
        if (zpoFile != null) {
            zpoFile = this.allFiles.get(this.allFiles.size() - 1);
        }
        this.addUsedFile(workingDirPath, (String)htmFile);
        if (htmFile != null) {
            htmFile = this.allFiles.get(this.allFiles.size() - 1);
        }
        if (timFile != null) {
            this.parseTimFile((String)timFile);
        }
        if (csvFile != null) {
            this.parseCSVFile((String)csvFile);
        }
        if (zpoFile != null && csvFile == null) {
            this.parseZpoFile((String)zpoFile);
        }
        ArrayList<Double> exposureTimes = new ArrayList<Double>();
        ArrayList<Double> zPositions = new ArrayList<Double>();
        ArrayList<Double> emWaves = new ArrayList<Double>();
        ArrayList<Double> exWaves = new ArrayList<Double>();
        if (htmFile != null) {
            int j;
            tokens = DataTools.readFile((String)htmFile).split(HTML_REGEX);
            for (j = 0; j < tokens.length; ++j) {
                if (tokens[j].indexOf(60) == -1) continue;
                tokens[j] = "";
            }
            for (j = 0; j < tokens.length - 1; j += 2) {
                if (tokens[j].indexOf("Exposure") != -1) {
                    this.addGlobalMeta("Camera Data " + tokens[j].charAt(13), tokens[j]);
                    int ndx = tokens[j].indexOf("Exposure") + 9;
                    String exposure = tokens[j].substring(ndx, tokens[j].indexOf(" ", ndx)).trim();
                    if (exposure.endsWith(",")) {
                        exposure = exposure.substring(0, exposure.length() - 1);
                    }
                    exposureTimes.add(Double.parseDouble(exposure) / 1000.0);
                    if (tokens[j].indexOf("nm") != -1) {
                        int nmIndex = tokens[j].indexOf("nm");
                        int paren = tokens[j].lastIndexOf("(", nmIndex);
                        int slash = tokens[j].lastIndexOf("/", nmIndex);
                        if (slash == -1) {
                            slash = nmIndex;
                        }
                        emWaves.add(DataTools.parseDouble(tokens[j].substring(paren + 1, slash).trim()));
                        if (tokens[j].indexOf("nm", nmIndex + 3) != -1) {
                            nmIndex = tokens[j].indexOf("nm", nmIndex + 3);
                            paren = tokens[j].lastIndexOf(" ", nmIndex);
                            slash = tokens[j].lastIndexOf("/", nmIndex);
                            if (slash == -1) {
                                slash = nmIndex + 2;
                            }
                            exWaves.add(DataTools.parseDouble(tokens[j].substring(paren + 1, slash).trim()));
                        }
                    }
                    --j;
                    continue;
                }
                if (tokens[j + 1].trim().equals("Slice Z positions")) {
                    for (int q = j + 2; q < tokens.length; ++q) {
                        if (tokens[q].trim().equals("")) continue;
                        try {
                            zPositions.add(DataTools.parseDouble(tokens[q].trim()));
                            continue;
                        }
                        catch (NumberFormatException exposure) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                if (tokens[j].trim().equals("")) continue;
                tokens[j] = tokens[j].trim();
                tokens[j + 1] = tokens[j + 1].trim();
                this.parseKeyValue(tokens[j], tokens[j + 1]);
            }
        } else {
            throw new FormatException("Valid header files not found.");
        }
        if (this.details != null) {
            tokens = this.details.split("\\s");
            int n = 0;
            for (String token : tokens) {
                if (token.equals("Wavelengths")) {
                    ms0.sizeC = n;
                } else if (token.equals("Frames")) {
                    ms0.sizeT = n;
                } else if (token.equals("Slices")) {
                    ms0.sizeZ = n;
                }
                try {
                    n = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    n = 0;
                }
            }
        }
        LOGGER.info("Populating metadata");
        if (this.files.length == 0) {
            throw new FormatException("TIFF files not found.");
        }
        if (this.isTiff) {
            this.tiff.setId(this.getFile(0));
            ms0.pixelType = this.tiff.getPixelType();
        } else {
            int bpp = 0;
            try (RandomAccessInputStream tmp = new RandomAccessInputStream(this.getFile(0));){
                bpp = (int)(tmp.length() - 6L) / (this.getSizeX() * this.getSizeY());
            }
            if (bpp % 3 == 0) {
                bpp /= 3;
            }
            ms0.pixelType = FormatTools.pixelTypeFromBytes(bpp, false, false);
        }
        if (this.getSizeZ() <= 0) {
            ms0.sizeZ = 1;
        }
        if (this.getSizeC() <= 0) {
            ms0.sizeC = 1;
        }
        if (this.getSizeT() <= 0 || this.getImageCount() % (this.getSizeZ() * this.getSizeC()) == 0) {
            ms0.sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
        } else {
            ms0.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            if (this.getImageCount() > this.files.length) {
                ms0.imageCount = this.files.length;
                ms0.sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
            }
        }
        ms0.dimensionOrder = "XYCTZ";
        ms0.rgb = this.isTiff ? this.tiff.isRGB() : false;
        ms0.interleaved = false;
        ms0.littleEndian = this.isTiff ? this.tiff.isLittleEndian() : true;
        ms0.metadataComplete = true;
        ms0.indexed = this.isTiff ? this.tiff.isIndexed() : false;
        ms0.falseColor = false;
        if (this.getImageCount() != this.getSizeZ() * this.getSizeC() * this.getSizeT()) {
            ms0.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        }
        if (!this.isTiff && this.extCount > this.getSizeT()) {
            this.extCount = this.getSizeT() * this.getSizeC();
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        if (this.finishTime != null && (timestamp = Timestamp.valueOf(DateTools.formatDate(this.finishTime, DATE_FORMAT))) != null) {
            store.setImageAcquisitionDate(timestamp, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Length sizeX = FormatTools.getPhysicalSizeX(this.pixelSizeX);
            Length sizeY = FormatTools.getPhysicalSizeY(this.pixelSizeY);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            for (int i = 0; i < this.getEffectiveSizeC(); ++i) {
                Length ex;
                Length em;
                if (i < emWaves.size() && (em = FormatTools.getEmissionWavelength((Double)emWaves.get(i))) != null) {
                    store.setChannelEmissionWavelength(em, 0, i);
                }
                if (i >= exWaves.size() || (ex = FormatTools.getExcitationWavelength((Double)exWaves.get(i))) == null) continue;
                store.setChannelExcitationWavelength(ex, 0, i);
            }
            long start = 0L;
            long end = 0L;
            if (this.startTime != null) {
                start = DateTools.getTime(this.startTime, DATE_FORMAT);
            }
            if (this.finishTime != null) {
                end = DateTools.getTime(this.finishTime, "yyyy-MM-dd'T'HH:mm:ss");
            }
            double secondsPerPlane = (double)(end - start) / (double)this.getImageCount() / 1000.0;
            for (int i = 0; i < this.getImageCount(); ++i) {
                int[] zct = this.getZCTCoords(i);
                store.setPlaneDeltaT(new Time((double)i * secondsPerPlane, UNITS.SECOND), 0, i);
                if (zct[1] < exposureTimes.size() && exposureTimes.get(zct[1]) != null) {
                    store.setPlaneExposureTime(new Time((Number)exposureTimes.get(zct[1]), UNITS.SECOND), 0, i);
                }
                if (zct[0] >= zPositions.size()) continue;
                Double zPosition = (Double)zPositions.get(zct[0]);
                Length xl = new Length(0.0, UNITS.REFERENCEFRAME);
                Length yl = new Length(0.0, UNITS.REFERENCEFRAME);
                Length zl = zPosition == null ? null : new Length(zPosition, UNITS.REFERENCEFRAME);
                store.setPlanePositionX(xl, 0, i);
                store.setPlanePositionY(yl, 0, i);
                store.setPlanePositionZ(zl, 0, i);
            }
        }
    }

    private PixelsFile lookupFile(int no) {
        int minExtIndex = Integer.MAX_VALUE;
        int minFirstIndex = Integer.MAX_VALUE;
        for (PixelsFile f : this.files) {
            if (f.extIndex < minExtIndex) {
                minExtIndex = f.extIndex;
            }
            if (f.firstIndex < 0 || f.firstIndex >= minFirstIndex) continue;
            minFirstIndex = f.firstIndex;
        }
        for (int ext = minExtIndex; ext <= this.extCount + minExtIndex; ++ext) {
            for (PixelsFile f : this.files) {
                if (f.extIndex != ext || !(f.firstIndex < 0 ? no % this.extCount == ext - minExtIndex : no == (f.firstIndex - minFirstIndex) * this.extCount + ext - minExtIndex)) continue;
                return f;
            }
        }
        return null;
    }

    private String getFile(int no) {
        PixelsFile f = this.lookupFile(no);
        return f.path;
    }

    private int getFileIndex(int no) {
        PixelsFile f = this.lookupFile(no);
        return f.firstIndex >= 0 ? 0 : no / this.extCount;
    }

    private void parseKeyValue(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.addGlobalMeta(key, value);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        try {
            if (key.equals("Image Width")) {
                m4.sizeX = Integer.parseInt(value);
            } else if (key.equals("Image Length")) {
                m4.sizeY = Integer.parseInt(value);
            } else if (key.equals("Number of slices")) {
                m4.sizeZ = Integer.parseInt(value);
            } else if (key.equals("Experiment details:")) {
                this.details = value;
            } else if (key.equals("Z slice space")) {
                this.sliceSpace = value;
            } else if (key.equals("Pixel Size X")) {
                this.pixelSizeX = Double.parseDouble(value);
            } else if (key.equals("Pixel Size Y")) {
                this.pixelSizeY = Double.parseDouble(value);
            } else if (key.equals("Finish Time:")) {
                this.finishTime = value;
            } else if (key.equals("Start Time:")) {
                this.startTime = value;
            } else if (key.equals("Origin X")) {
                this.originX = Double.parseDouble(value);
            } else if (key.equals("Origin Y")) {
                this.originY = Double.parseDouble(value);
            } else if (key.equals("Origin Z")) {
                this.originZ = Double.parseDouble(value);
            } else if (key.equals("SubfileType X")) {
                m4.bitsPerPixel = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException exc) {
            LOGGER.debug("", exc);
        }
    }

    private void addUsedFile(String workingDirPath, String file2) {
        if (file2 == null) {
            return;
        }
        Location f = new Location(workingDirPath, file2);
        if (!workingDirPath.equals("")) {
            this.allFiles.add(f.getAbsolutePath());
        } else {
            this.allFiles.add(file2);
        }
    }

    private void parseTimFile(String timFile) throws IOException {
        String[] tokens = DataTools.readFile(timFile).split("\\s");
        int tNum = 0;
        String[] hashKeys = new String[]{"Number of Wavelengths/Timepoints", "Zero 1", "Zero 2", "Number of slices", "Extra int", "Calibration Unit", "Pixel Size Y", "Pixel Size X", "Image Width", "Image Length", "Origin X", "SubfileType X", "Dimension Label X", "Origin Y", "SubfileType Y", "Dimension Label Y", "Origin Z", "SubfileType Z", "Dimension Label Z"};
        for (String token : tokens) {
            if (token.trim().length() == 0) continue;
            if (tNum >= hashKeys.length) break;
            if (token.equals("um")) {
                tNum = 5;
            }
            while (!(tNum != 1 && tNum != 2 || token.trim().equals("0"))) {
                ++tNum;
            }
            if (tNum == 4) {
                try {
                    Integer.parseInt(token);
                }
                catch (NumberFormatException e) {}
            }
            int n = ++tNum;
            ++tNum;
            this.parseKeyValue(hashKeys[n], token);
        }
    }

    private void parseCSVFile(String csvFile) throws IOException {
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        String[] tokens = DataTools.readFile(csvFile).split("\\s");
        ArrayList<String> tmp = new ArrayList<String>();
        for (String token : tokens) {
            if (token.trim().length() <= 0) continue;
            tmp.add(token.trim());
        }
        tokens = tmp.toArray(new String[0]);
        int tNum = 0;
        String[] hashKeys = new String[]{"Calibration Unit", "Pixel Size X", "Pixel Size Y", "Z slice space"};
        int pt = 0;
        int j = 0;
        while (j < tokens.length) {
            String key = null;
            String value = null;
            if (tNum < 7) {
                ++j;
            } else if (tNum > 7 && tNum < 12 || tNum > 12 && tNum < 18 || tNum > 18 && tNum < 22) {
                ++j;
            } else if (pt < hashKeys.length) {
                key = hashKeys[pt++];
                value = tokens[j++];
            } else {
                key = tokens[j++] + tokens[j++];
                value = tokens[j++];
            }
            this.parseKeyValue(key, value);
            ++tNum;
        }
    }

    private void parseZpoFile(String zpoFile) throws IOException {
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        String[] tokens = DataTools.readFile(zpoFile).split("\\s");
        for (int t2 = 0; t2 < tokens.length; ++t2) {
            this.addGlobalMetaList("Z slice position", tokens[t2]);
        }
    }

    class PixelsFile {
        public int firstIndex;
        public int extIndex;
        public String path;

        PixelsFile() {
        }
    }
}

