/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import loci.common.DataTools;
import ome.units.UNITS;
import ome.units.quantity.Length;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrairieMetadata {
    private final HashMap<Integer, Sequence> sequences = new HashMap();
    private final ValueTable scanValues = new ValueTable();
    private Sequence firstSequence;
    private int cycleMin = Integer.MAX_VALUE;
    private int cycleMax = Integer.MIN_VALUE;
    private String date;
    private Double waitTime;
    private final HashSet<Integer> activeChannels = new HashSet();
    private final ValueTable config = new ValueTable();

    public PrairieMetadata(Document xml, Document cfg, Document env) {
        if (xml != null) {
            this.parseXML(xml);
        }
        if (cfg != null) {
            this.parseCFG(cfg);
        }
        if (env != null) {
            this.parseENV(env);
        }
        this.parseChannels();
    }

    public Double getWaitTime() {
        return this.waitTime;
    }

    public int[] getActiveChannels() {
        int[] result = new int[this.activeChannels.size()];
        int i = 0;
        for (int channelIndex : this.activeChannels) {
            result[i++] = channelIndex;
        }
        Arrays.sort(result);
        return result;
    }

    public boolean isInvertX() {
        return false;
    }

    public boolean isInvertY() {
        return this.b(this.value(this.getConfig("xYStageYPositionIncreasesBottomToTop")));
    }

    public Integer getBitDepth() {
        return this.i(this.value(this.getConfig("bitDepth")));
    }

    public Double getLaserPower() {
        return this.d(this.value(this.getConfig("laserPower"), 0));
    }

    public Value getConfig(String key) {
        return (Value)this.config.get(key);
    }

    public ValueTable getConfig() {
        return this.config;
    }

    public String getDate() {
        return this.date;
    }

    public int getCycleMin() {
        return this.cycleMin;
    }

    public int getCycleMax() {
        return this.cycleMax;
    }

    public int getCycleCount() {
        return this.cycleMax - this.cycleMin + 1;
    }

    public Sequence getFirstSequence() {
        return this.firstSequence;
    }

    public Sequence getSequence(int cycle) {
        return this.sequences.get(cycle);
    }

    public ArrayList<Sequence> getSequences() {
        return this.valuesByKey(this.sequences);
    }

    public Frame getFrame(int cycle, int index) {
        Sequence sequence2 = this.getSequence(cycle);
        if (sequence2 == null) {
            return null;
        }
        return sequence2.getFrame(index);
    }

    public PFile getFile(int cycle, int index, int channel) {
        Frame frame = this.getFrame(cycle, index);
        if (frame == null) {
            return null;
        }
        return frame.getFile(channel);
    }

    public Value getValue(String key) {
        return (Value)this.scanValues.get(key);
    }

    public ValueTable getValues() {
        return this.scanValues;
    }

    private void parseXML(Document doc) {
        Element pvScan = doc.getDocumentElement();
        this.checkElement(pvScan, "PVScan");
        this.parsePVStateShard(pvScan, this.scanValues);
        this.date = this.attr(pvScan, "date");
        NodeList sequenceNodes = doc.getElementsByTagName("Sequence");
        for (int s2 = 0; s2 < sequenceNodes.getLength(); ++s2) {
            int cycle;
            Element sequenceElement = this.el(sequenceNodes, s2);
            if (sequenceElement == null) continue;
            Sequence sequence2 = new Sequence(sequenceElement);
            if (this.firstSequence == null) {
                this.firstSequence = sequence2;
            }
            if ((cycle = sequence2.getCycle()) < this.cycleMin) {
                this.cycleMin = cycle;
            }
            if (cycle > this.cycleMax) {
                this.cycleMax = cycle;
            }
            this.sequences.put(cycle, sequence2);
        }
    }

    private void parseCFG(Document doc) {
        this.checkElement(doc.getDocumentElement(), "PVConfig");
        NodeList waitNodes = doc.getElementsByTagName("PVTSeriesElementWait");
        if (waitNodes.getLength() > 0) {
            Element waitElement = this.el(waitNodes, 0);
            this.waitTime = this.d(this.attr(waitElement, "waitTime"));
        }
        this.parseKeys(doc.getDocumentElement(), this.config);
    }

    private void parseENV(Document doc) {
        this.checkElement(doc.getDocumentElement(), "Environment");
        this.parsePVStateShard(doc.getDocumentElement(), this.config);
    }

    private void parseKeys(Element el, ValueTable table) {
        NodeList keyNodes = el.getElementsByTagName("Key");
        for (int k = 0; k < keyNodes.getLength(); ++k) {
            Element keyElement = this.el(keyNodes, k);
            if (keyElement == null) continue;
            String key = this.attr(keyElement, "key");
            String value = this.attr(keyElement, "value");
            int underscore = key.indexOf(95);
            if (underscore < 0) {
                table.put(key, new ValueItem(value, null));
                continue;
            }
            String prefix = key.substring(0, underscore);
            String index = key.substring(underscore + 1);
            if (!table.containsKey(prefix)) {
                table.put(prefix, new ValueTable());
            }
            ValueTable subTable = (ValueTable)table.get(prefix);
            String[] tokens = value.split(",");
            if (tokens.length == 1) {
                subTable.put(index, new ValueItem(value, null));
                continue;
            }
            ValueTable subSubTable = new ValueTable();
            for (int i = 0; i < tokens.length; ++i) {
                subSubTable.put("" + i, new ValueItem(tokens[i], null));
            }
            subTable.put(index, subSubTable);
        }
    }

    private void parsePVStateShard(Element el, ValueTable table) {
        Element pvStateShard = this.getFirstChild(el, "PVStateShard");
        if (pvStateShard == null) {
            return;
        }
        NodeList svNodes = el.getElementsByTagName("PVStateValue");
        for (int k = 0; k < svNodes.getLength(); ++k) {
            Element keyElement = this.el(svNodes, k);
            if (keyElement == null) continue;
            String key = this.attr(keyElement, "key");
            String value = this.attr(keyElement, "value");
            if (value != null) {
                table.put(key, new ValueItem(value, this.attr(keyElement, "description")));
                continue;
            }
            ValueTable subTable = new ValueTable();
            table.put(key, subTable);
            NodeList ivNodes = keyElement.getElementsByTagName("IndexedValue");
            for (int i = 0; i < ivNodes.getLength(); ++i) {
                String index;
                Element ivElement = this.el(ivNodes, i);
                if (ivElement == null || (index = this.attr(ivElement, "index")) == null) continue;
                String iValue = this.attr(ivElement, "value");
                String iDescription = this.attr(ivElement, "description");
                subTable.put(index, new ValueItem(iValue, iDescription));
            }
            NodeList sivNodes = keyElement.getElementsByTagName("SubindexedValues");
            for (int i = 0; i < sivNodes.getLength(); ++i) {
                String index;
                Element sivElement = this.el(sivNodes, i);
                if (sivElement == null || (index = this.attr(sivElement, "index")) == null) continue;
                ValueTable subSubTable = new ValueTable();
                subTable.put(index, subSubTable);
                NodeList subNodes = sivElement.getElementsByTagName("SubindexedValue");
                for (int s2 = 0; s2 < subNodes.getLength(); ++s2) {
                    Element subElement = this.el(subNodes, s2);
                    String subindex = this.attr(subElement, "subindex");
                    if (subindex == null) continue;
                    String sValue = this.attr(subElement, "value");
                    String sDescription = this.attr(subElement, "description");
                    subSubTable.put(subindex, new ValueItem(sValue, sDescription));
                }
            }
        }
    }

    private void parseChannels() {
        Value channels = (Value)this.config.get("channel");
        if (!(channels instanceof ValueTable)) {
            return;
        }
        ValueTable channelsTable = (ValueTable)channels;
        for (String key : channelsTable.keySet()) {
            Value value = (Value)channelsTable.get(key);
            if (!this.b(this.value(value))) continue;
            int channelIndex = this.i(key) + 1;
            this.activeChannels.add(channelIndex);
        }
    }

    private void checkElement(Element el, String name) {
        if (!el.getNodeName().equals(name)) {
            throw new IllegalArgumentException("Not a " + name + " element");
        }
    }

    private Element getFirstChild(Element el, String name) {
        NodeList nodeList = el.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element child = this.el(nodeList, i);
            if (child == null || !name.equals(child.getNodeName())) continue;
            return child;
        }
        return null;
    }

    private Element el(NodeList nodes, int index) {
        Node node = nodes.item(index);
        if (!(node instanceof Element)) {
            return null;
        }
        return (Element)node;
    }

    private String attr(Element el, String name) {
        return el.hasAttribute(name) ? el.getAttribute(name) : null;
    }

    private String value(Value value) {
        return value == null ? null : value.value();
    }

    private String value(Value value, String key) {
        if (value == null) {
            return null;
        }
        Value v = value.get(key);
        return v == null ? null : v.value();
    }

    private String value(Value value, int index) {
        if (value == null) {
            return null;
        }
        Value v = value.get(index);
        return v == null ? null : v.value();
    }

    private boolean b(String value) {
        return Boolean.parseBoolean(value);
    }

    private Double d(String value) {
        if (value == null) {
            return null;
        }
        try {
            return DataTools.parseDouble(value);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    private Integer i(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    private String token(String s2, String regex, int i) {
        if (s2 == null) {
            return null;
        }
        String[] tokens = s2.split(regex);
        return tokens.length > i ? tokens[i] : null;
    }

    private <K extends Comparable<? super K>, V> ArrayList<V> valuesByKey(Map<K, V> map) {
        ArrayList<K> keys2 = new ArrayList<K>(map.size());
        ArrayList<V> values2 = new ArrayList<V>(map.size());
        keys2.addAll(map.keySet());
        Collections.sort(keys2);
        for (Comparable key : keys2) {
            values2.add(map.get(key));
        }
        return values2;
    }

    public static class ValueTable
    extends HashMap<String, Value>
    implements Value {
        @Override
        public boolean isTable() {
            return true;
        }

        @Override
        public Value get(int index) {
            return (Value)this.get("" + index);
        }

        @Override
        public String value() {
            return this.size() == 1 ? ((Value)this.values().iterator().next()).value() : null;
        }

        @Override
        public String description() {
            return null;
        }
    }

    public static class ValueItem
    implements Value {
        private String value;
        private String description;

        public ValueItem(String value, String description) {
            this.value = value;
            this.description = description;
        }

        @Override
        public boolean isTable() {
            return false;
        }

        @Override
        public Value get(Object key) {
            return null;
        }

        @Override
        public Value get(int index) {
            return null;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String description() {
            return this.description;
        }

        public String toString() {
            return this.value();
        }
    }

    public static interface Value {
        public boolean isTable();

        public Value get(Object var1);

        public Value get(int var1);

        public String value();

        public String description();
    }

    public class PFile {
        private Frame frame;
        private Integer channel;
        private String channelName;
        private String filename;
        private Double waveMin;
        private Double waveMax;

        public PFile(Frame frame, Element fileElement) {
            this.frame = frame;
            this.parse(fileElement);
        }

        public Frame getFrame() {
            return this.frame;
        }

        public void parse(Element fileElement) {
            PrairieMetadata.this.checkElement(fileElement, "File");
            this.channel = PrairieMetadata.this.i(PrairieMetadata.this.attr(fileElement, "channel"));
            if (this.channel == null) {
                throw new IllegalArgumentException("File missing channel attribute");
            }
            PrairieMetadata.this.activeChannels.add(this.channel);
            this.channelName = PrairieMetadata.this.attr(fileElement, "channelName");
            this.filename = PrairieMetadata.this.attr(fileElement, "filename");
            this.waveMin = PrairieMetadata.this.d(PrairieMetadata.this.attr(fileElement, "wavelengthMin"));
            this.waveMax = PrairieMetadata.this.d(PrairieMetadata.this.attr(fileElement, "wavelengthMax"));
        }

        public int getChannel() {
            return this.channel;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public String getFilename() {
            return this.filename;
        }

        public Double getWavelengthMin() {
            return this.waveMin;
        }

        public Double getWavelengthMax() {
            return this.waveMax;
        }
    }

    public class Frame {
        private Sequence sequence;
        private final HashMap<Integer, PFile> files = new HashMap();
        private final ValueTable frameValues = new ValueTable();
        private PFile firstFile;
        private Double relativeTime;
        private Double absoluteTime;
        private Integer index;

        public Frame(Sequence sequence2, Element frameElement) {
            this.sequence = sequence2;
            this.parse(frameElement);
        }

        public Sequence getSequence() {
            return this.sequence;
        }

        public void parse(Element frameElement) {
            PrairieMetadata.this.checkElement(frameElement, "Frame");
            PrairieMetadata.this.parsePVStateShard(frameElement, this.frameValues);
            this.relativeTime = PrairieMetadata.this.d(PrairieMetadata.this.attr(frameElement, "relativeTime"));
            this.absoluteTime = PrairieMetadata.this.d(PrairieMetadata.this.attr(frameElement, "absoluteTime"));
            this.index = PrairieMetadata.this.i(PrairieMetadata.this.attr(frameElement, "index"));
            if (this.index == null) {
                throw new IllegalArgumentException("Frame missing index attribute");
            }
            NodeList fileNodes = frameElement.getElementsByTagName("File");
            for (int f = 0; f < fileNodes.getLength(); ++f) {
                Element fileElement = PrairieMetadata.this.el(fileNodes, f);
                if (fileElement == null) continue;
                PFile file2 = new PFile(this, fileElement);
                if (this.firstFile == null) {
                    this.firstFile = file2;
                }
                int channel = file2.getChannel();
                this.files.put(channel, file2);
            }
            PrairieMetadata.this.parseKeys(frameElement, this.frameValues);
        }

        public double getRelativeTime() {
            return this.relativeTime;
        }

        public double getAbsoluteTime() {
            return this.absoluteTime;
        }

        public int getIndex() {
            return this.index;
        }

        public PFile getFirstFile() {
            return this.firstFile;
        }

        public PFile getFile(int channel) {
            return this.files.get(channel);
        }

        public String getObjectiveLens() {
            return PrairieMetadata.this.value(this.getValue("objectiveLens"));
        }

        public String getObjectiveManufacturer() {
            return PrairieMetadata.this.token(this.getObjectiveLens(), " ", 0);
        }

        public Double getMagnification() {
            return PrairieMetadata.this.d(PrairieMetadata.this.token(this.getObjectiveLens(), " ", 1));
        }

        public String getImmersion() {
            return PrairieMetadata.this.token(this.getObjectiveLens(), " ", 2);
        }

        public Double getObjectiveLensNA() {
            return PrairieMetadata.this.d(PrairieMetadata.this.value(this.getValue("objectiveLensNA")));
        }

        public Integer getPixelsPerLine() {
            return PrairieMetadata.this.i(PrairieMetadata.this.value(this.getValue("pixelsPerLine")));
        }

        public Integer getLinesPerFrame() {
            return PrairieMetadata.this.i(PrairieMetadata.this.value(this.getValue("linesPerFrame")));
        }

        private Length toLength(Double position, boolean isInvert) {
            if (position == null) {
                return null;
            }
            if (isInvert) {
                position = -position.doubleValue();
            }
            return new Length(position, UNITS.REFERENCEFRAME);
        }

        public Length getPositionX() {
            Double posX = PrairieMetadata.this.d(PrairieMetadata.this.value(this.getValue("positionCurrent"), "XAxis"));
            return this.toLength(posX, PrairieMetadata.this.isInvertX());
        }

        public Length getPositionY() {
            Double posY = PrairieMetadata.this.d(PrairieMetadata.this.value(this.getValue("positionCurrent"), "YAxis"));
            return this.toLength(posY, PrairieMetadata.this.isInvertY());
        }

        public Length getPositionZ() {
            Double posZ = PrairieMetadata.this.d(PrairieMetadata.this.value(this.getValue("positionCurrent"), "ZAxis"));
            return this.toLength(posZ, false);
        }

        public Double getOpticalZoom() {
            return PrairieMetadata.this.d(PrairieMetadata.this.value(this.getValue("opticalZoom")));
        }

        public Double getMicronsPerPixelX() {
            return PrairieMetadata.this.d(PrairieMetadata.this.value(this.getValue("micronsPerPixel"), "XAxis"));
        }

        public Double getMicronsPerPixelY() {
            return PrairieMetadata.this.d(PrairieMetadata.this.value(this.getValue("micronsPerPixel"), "YAxis"));
        }

        public Double getOffset(int c) {
            return PrairieMetadata.this.d(PrairieMetadata.this.value(this.getValue("pmtOffset"), c));
        }

        public Double getGain(int c) {
            return PrairieMetadata.this.d(PrairieMetadata.this.value(this.getValue("pmtGain"), c));
        }

        public String getImagingDevice() {
            return PrairieMetadata.this.value(this.getValue("imagingDevice"));
        }

        public Value getValue(String key) {
            if (this.frameValues.containsKey(key)) {
                return (Value)this.frameValues.get(key);
            }
            return this.getSequence().getValue(key);
        }

        public ValueTable getValues() {
            return this.frameValues;
        }
    }

    public class Sequence {
        private final HashMap<Integer, Frame> frames = new HashMap();
        private final ValueTable sequenceValues = new ValueTable();
        private Frame firstFrame;
        private int indexMin = Integer.MAX_VALUE;
        private int indexMax = Integer.MIN_VALUE;
        private String type;
        private Integer cycle;
        private boolean spectralMode;

        public Sequence(Element sequenceElement) {
            this.parse(sequenceElement);
        }

        public void parse(Element sequenceElement) {
            PrairieMetadata.this.checkElement(sequenceElement, "Sequence");
            PrairieMetadata.this.parsePVStateShard(sequenceElement, this.sequenceValues);
            this.type = PrairieMetadata.this.attr(sequenceElement, "type");
            this.cycle = PrairieMetadata.this.i(PrairieMetadata.this.attr(sequenceElement, "cycle"));
            if (this.cycle == null) {
                throw new IllegalArgumentException("Sequence missing cycle attribute");
            }
            this.spectralMode = PrairieMetadata.this.b(PrairieMetadata.this.attr(sequenceElement, "SpectralMode"));
            NodeList frameNodes = sequenceElement.getElementsByTagName("Frame");
            for (int f = 0; f < frameNodes.getLength(); ++f) {
                int index;
                Element frameElement = PrairieMetadata.this.el(frameNodes, f);
                if (frameElement == null) continue;
                Frame frame = new Frame(this, frameElement);
                if (this.firstFrame == null) {
                    this.firstFrame = frame;
                }
                if ((index = frame.getIndex()) < this.indexMin) {
                    this.indexMin = index;
                }
                if (index > this.indexMax) {
                    this.indexMax = index;
                }
                this.frames.put(index, frame);
            }
        }

        public String getType() {
            return this.type;
        }

        public boolean isTimeSeries() {
            return "TSeries Timed Element".equals(this.type);
        }

        public int getCycle() {
            return this.cycle;
        }

        public boolean isSpectralMode() {
            return this.spectralMode;
        }

        public int getIndexMin() {
            return this.indexMin;
        }

        public int getIndexMax() {
            return this.indexMax;
        }

        public int getIndexCount() {
            return this.indexMax - this.indexMin + 1;
        }

        public Frame getFirstFrame() {
            return this.firstFrame;
        }

        public Frame getFrame(int index) {
            return this.frames.get(index);
        }

        public PFile getFile(int index, int channel) {
            Frame frame = this.getFrame(index);
            if (frame == null) {
                return null;
            }
            return frame.getFile(channel);
        }

        public Value getValue(String key) {
            if (this.sequenceValues.containsKey(key)) {
                return (Value)this.sequenceValues.get(key);
            }
            return PrairieMetadata.this.getValue(key);
        }

        public ValueTable getValues() {
            return this.sequenceValues;
        }
    }
}

