/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class ZeissLMSReader
extends FormatReader {
    private static final String CHECK = "LMSFLE";
    private static final String MARKER = "BM6";
    private ArrayList<Long> offsets = new ArrayList();
    private byte[][] lut;

    public ZeissLMSReader() {
        super("Zeiss LMS", "lms");
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int checkLen = 16;
        if (!FormatTools.validStream(stream, checkLen, false)) {
            return false;
        }
        return stream.readString(checkLen).indexOf(CHECK) >= 0;
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.isIndexed()) {
            return this.lut;
        }
        return null;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.in.seek(this.offsets.get(this.getSeriesCount() - this.getSeries() - 1));
        this.in.skipBytes((long)no * (long)FormatTools.getPlaneSize(this));
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets.clear();
            this.lut = null;
        }
    }

    @Override
    public void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        CoreMetadata thumb = new CoreMetadata();
        m4.littleEndian = true;
        thumb.littleEndian = true;
        this.in.order(m4.littleEndian);
        this.in.seek(18L);
        double magnification = this.in.readInt();
        thumb.sizeX = 1280;
        thumb.sizeY = 1024;
        thumb.pixelType = 1;
        thumb.sizeC = 3;
        thumb.rgb = true;
        thumb.interleaved = true;
        thumb.dimensionOrder = "XYCZT";
        m4.sizeX = 1280;
        m4.sizeY = 1024;
        m4.pixelType = 3;
        m4.sizeC = 1;
        m4.rgb = false;
        m4.dimensionOrder = "XYCZT";
        m4.indexed = true;
        this.seekToNextMarker();
        this.in.skipBytes(50);
        this.offsets.add(this.in.getFilePointer());
        this.in.skipBytes((long)thumb.sizeX * (long)thumb.sizeY * (long)thumb.sizeC);
        this.seekToNextMarker();
        this.in.skipBytes(50);
        this.lut = new byte[3][256];
        for (int i = 0; i < this.lut[0].length; ++i) {
            for (int j = 0; j < this.lut.length; ++j) {
                this.lut[j][i] = this.in.readByte();
            }
            this.in.skipBytes(1);
        }
        this.offsets.add(this.in.getFilePointer());
        thumb.sizeZ = 1;
        thumb.sizeT = 1;
        thumb.imageCount = thumb.sizeZ * thumb.sizeT;
        long availableBytes = this.in.length() - this.offsets.get(1);
        int planeSize = m4.sizeX * m4.sizeY * FormatTools.getBytesPerPixel(m4.pixelType);
        m4.sizeZ = (int)(availableBytes / (long)planeSize);
        m4.sizeT = 1;
        m4.imageCount = m4.sizeZ * m4.sizeT;
        this.core.add(thumb);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setInstrumentID(MetadataTools.createLSID("Instrument", 0), 0);
        String objective = MetadataTools.createLSID("Objective", 0, 0);
        store.setObjectiveID(objective, 0, 0);
        store.setObjectiveNominalMagnification(magnification, 0, 0);
        store.setObjectiveSettingsID(objective, 0);
        store.setObjectiveSettingsID(objective, 1);
    }

    private void seekToNextMarker() throws IOException {
        while (this.in.getFilePointer() < this.in.length()) {
            String check2 = this.in.readString(3);
            if (check2.equals(MARKER)) {
                this.in.skipBytes(1);
                return;
            }
            this.in.seek(this.in.getFilePointer() - 2L);
        }
    }
}

