/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import loci.common.DataTools;
import loci.common.DebugTools;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffSaver;
import loci.formats.tools.CommandLineTools;
import loci.formats.tools.EditTiffG;

public class TiffComment {
    public static void main(String[] args2) throws FormatException, IOException {
        if (args2.length == 0) {
            System.out.println("Usage:");
            System.out.println("tiffcomment [-version] [-debug] [-trace] [-no-upgrade] [-set comment] [-edit] file1 [file2 ...]");
            System.out.println();
            System.out.println("This tool requires an ImageDescription tag to be present in the TIFF file. ");
            System.out.println();
            System.out.println("If using the '-set' option, the new TIFF comment must be specified and may take any of the following forms:");
            System.out.println();
            System.out.println("  * the text of the comment, e.g. 'new comment!'");
            System.out.println("  * the name of the file containing the text of the comment, e.g. 'file.xml'");
            System.out.println("  * '-', to enter the comment using stdin.  Entering a blank line will");
            System.out.println("    terminate reading from stdin.");
            System.out.println();
            System.out.println("Additional options:");
            System.out.println("    -version: print the library version and exit");
            System.out.println(" -no-upgrade: do not perform the upgrade check");
            System.out.println("      -debug: enable DEBUG-level logging");
            System.out.println("      -trace: enable TRACE-level logging");
            return;
        }
        boolean edit = false;
        String newComment = null;
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < args2.length; ++i) {
            if (!args2[i].startsWith("-")) {
                files.add(args2[i]);
                continue;
            }
            if (args2[i].equals("-edit")) {
                edit = true;
                continue;
            }
            if (args2[i].equals("-set")) {
                if (new File(newComment = args2[++i]).exists()) {
                    newComment = DataTools.readFile(newComment);
                    continue;
                }
                if (!newComment.equals("-")) continue;
                newComment = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));){
                    String line = reader.readLine();
                    while (line != null && line.length() > 0) {
                        newComment = newComment == null ? line : newComment + "\n" + line;
                        line = reader.readLine();
                    }
                    continue;
                }
            }
            if (args2[i].equals("-version")) {
                CommandLineTools.printVersion();
                return;
            }
            if (args2[i].equals("-debug")) {
                DebugTools.setRootLevel("DEBUG");
                continue;
            }
            if (args2[i].equals("-trace")) {
                DebugTools.setRootLevel("TRACE");
                continue;
            }
            if (args2[i].equals("-no-upgrade")) continue;
            System.out.println("Warning: unknown flag: " + args2[i]);
        }
        CommandLineTools.runUpgradeCheck(args2);
        for (String file2 : files) {
            Throwable throwable;
            RandomAccessInputStream in;
            if (edit) {
                in = EditTiffG.open(file2);
                throwable = null;
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                in.close();
                continue;
            }
            if (newComment != null) {
                TiffComment.overwriteComment(file2, newComment);
                continue;
            }
            in = new RandomAccessInputStream(file2);
            throwable = null;
            try {
                TiffParser parser = new TiffParser(in);
                String comment = parser.getComment();
                System.out.println(comment == null ? file2 + ": no TIFF comment found." : comment);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    private static void overwriteComment(String file2, String comment) {
        try (RandomAccessInputStream in = new RandomAccessInputStream(file2);
             RandomAccessOutputStream out = new RandomAccessOutputStream(file2);){
            TiffSaver saver = new TiffSaver(out, file2);
            saver.overwriteComment(in, comment);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

