/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.config;

import ij.Prefs;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import loci.plugins.config.IFormatWidgets;

public class LIFWidgets
implements IFormatWidgets,
ItemListener {
    private String[] labels;
    private Component[] widgets;

    public LIFWidgets() {
        boolean physicalSizeBackwardsCompatibility = Prefs.get("bioformats.leicalif.physicalsize.compatibility", false);
        String physicalSizeLabel = "Physical size";
        JCheckBox physicalSizeBox = new JCheckBox("Ensure physical pixel sizes are compatible with versions <= 5.3.2", physicalSizeBackwardsCompatibility);
        physicalSizeBox.addItemListener(this);
        this.labels = new String[]{physicalSizeLabel};
        this.widgets = new Component[]{physicalSizeBox};
    }

    @Override
    public String[] getLabels() {
        return this.labels;
    }

    @Override
    public Component[] getWidgets() {
        return this.widgets;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBox box = (JCheckBox)e.getSource();
        if (box.equals(this.widgets[0])) {
            Prefs.set("bioformats.leicalif.physicalsize.compatibility", box.isSelected());
        }
    }
}

