/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterOptions;

public class ImporterMetadata
extends HashMap<String, Object> {
    public ImporterMetadata(IFormatReader r, ImportProcess process, boolean usePrefix) {
        this.putAll(r.getGlobalMetadata());
        this.put("Location", process.getCurrentFile());
        ImporterOptions options = process.getOptions();
        int oldSeries = r.getSeries();
        int seriesCount = r.getSeriesCount();
        int digits = ImporterMetadata.digits(seriesCount);
        for (int i = 0; i < seriesCount; ++i) {
            if (!options.isSeriesOn(i)) continue;
            r.setSeries(i);
            String s2 = "";
            if (usePrefix) {
                s2 = process.getOMEMetadata().getImageName(i);
                if ((s2 == null || s2.trim().length() == 0) && seriesCount > 1) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Series ");
                    int zeroes = digits - ImporterMetadata.digits(i + 1);
                    for (int j = 0; j < zeroes; ++j) {
                        sb.append(0);
                    }
                    sb.append(i + 1);
                    sb.append(" ");
                    s2 = sb.toString();
                } else {
                    s2 = s2 + ' ';
                }
            }
            Hashtable<String, Object> seriesMeta = r.getSeriesMetadata();
            MetadataTools.merge(seriesMeta, this, s2);
            String pad = " ";
            this.put(" " + s2 + "SizeX", r.getSizeX());
            this.put(" " + s2 + "SizeY", r.getSizeY());
            this.put(" " + s2 + "SizeZ", r.getSizeZ());
            this.put(" " + s2 + "SizeT", r.getSizeT());
            this.put(" " + s2 + "SizeC", r.getSizeC());
            this.put(" " + s2 + "IsRGB", r.isRGB());
            this.put(" " + s2 + "PixelType", FormatTools.getPixelTypeString(r.getPixelType()));
            this.put(" " + s2 + "LittleEndian", r.isLittleEndian());
            this.put(" " + s2 + "DimensionOrder", r.getDimensionOrder());
            this.put(" " + s2 + "IsInterleaved", r.isInterleaved());
            this.put(" " + s2 + "BitsPerPixel", r.getBitsPerPixel());
            String seriesName = process.getOMEMetadata().getImageName(i);
            this.put(" Series " + i + " Name", seriesName);
        }
        r.setSeries(oldSeries);
    }

    public String getMetadataString(String separator) {
        ArrayList keys2 = new ArrayList(this.keySet());
        Collections.sort(keys2);
        StringBuffer sb = new StringBuffer();
        for (String key : keys2) {
            sb.append(key);
            sb.append(separator);
            sb.append(this.get(key));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getMetadataString(" = ");
    }

    private static int digits(int value) {
        int digits = 0;
        while (value > 0) {
            value /= 10;
            ++digits;
        }
        return digits;
    }
}

