/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.IJ;
import loci.common.StatusEvent;
import loci.common.StatusListener;
import loci.plugins.BF;
import loci.plugins.in.ColorDialog;
import loci.plugins.in.CropDialog;
import loci.plugins.in.FilePatternDialog;
import loci.plugins.in.IdDialog;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImportStep;
import loci.plugins.in.ImporterOptions;
import loci.plugins.in.LocationDialog;
import loci.plugins.in.MainDialog;
import loci.plugins.in.MemoryDialog;
import loci.plugins.in.RangeDialog;
import loci.plugins.in.SeriesDialog;
import loci.plugins.in.SwapDialog;
import loci.plugins.in.UpgradeDialog;

public class ImporterPrompter
implements StatusListener {
    private ImportProcess process;

    public ImporterPrompter(ImportProcess process) {
        this.process = process;
        process.addStatusListener(this);
    }

    @Override
    public void statusUpdated(StatusEvent e) {
        String message = e.getStatusMessage();
        int value = e.getProgressValue();
        ImportStep step = ImportStep.getStep(value);
        BF.status(!this.process.getOptions().isQuiet(), message);
        switch (step) {
            case READER: {
                if (!this.promptUpgrade()) {
                    this.process.cancel();
                    break;
                }
                if (!this.promptLocation()) {
                    this.process.cancel();
                    break;
                }
                if (this.promptId()) break;
                this.process.cancel();
                break;
            }
            case FILE: {
                if (this.promptMain()) break;
                this.process.cancel();
                break;
            }
            case STACK: {
                ImporterOptions options = this.process.getOptions();
                if (options != null && options.doMustGroup() && options.isGroupFiles()) {
                    IJ.showMessage("Bio-Formats", "File Stitching Options are not available for files of this format.\nFiles will be grouped according to image format specifications.\n");
                    break;
                }
                if (this.promptFilePattern()) break;
                this.process.cancel();
                break;
            }
            case SERIES: {
                if (this.promptSeries()) break;
                this.process.cancel();
                break;
            }
            case DIM_ORDER: {
                if (this.promptSwap()) break;
                this.process.cancel();
                break;
            }
            case RANGE: {
                if (this.promptRange()) break;
                this.process.cancel();
                break;
            }
            case CROP: {
                if (this.promptCrop()) break;
                this.process.cancel();
                break;
            }
            case COLORS: {
                if (this.promptColors()) break;
                this.process.cancel();
                break;
            }
            case METADATA: {
                break;
            }
            case COMPLETE: {
                if (this.promptMemory()) break;
                this.process.cancel();
                break;
            }
        }
    }

    private boolean promptUpgrade() {
        UpgradeDialog dialog = new UpgradeDialog(this.process);
        return dialog.showDialog() == 0;
    }

    private boolean promptLocation() {
        LocationDialog dialog = new LocationDialog(this.process);
        return dialog.showDialog() == 0;
    }

    private boolean promptId() {
        IdDialog dialog = new IdDialog(this.process);
        return dialog.showDialog() == 0;
    }

    private boolean promptMain() {
        MainDialog dialog = new MainDialog(this.process);
        return dialog.showDialog() == 0;
    }

    private boolean promptFilePattern() {
        FilePatternDialog dialog = new FilePatternDialog(this.process);
        return dialog.showDialog() == 0;
    }

    private boolean promptSeries() {
        SeriesDialog dialog = new SeriesDialog(this.process);
        return dialog.showDialog() == 0;
    }

    private boolean promptSwap() {
        SwapDialog dialog = new SwapDialog(this.process);
        return dialog.showDialog() == 0;
    }

    private boolean promptRange() {
        RangeDialog dialog = new RangeDialog(this.process);
        return dialog.showDialog() == 0;
    }

    private boolean promptCrop() {
        CropDialog dialog = new CropDialog(this.process);
        return dialog.showDialog() == 0;
    }

    private boolean promptColors() {
        ColorDialog dialog = new ColorDialog(this.process);
        return dialog.showDialog() == 0;
    }

    private boolean promptMemory() {
        MemoryDialog dialog = new MemoryDialog(this.process);
        return dialog.showDialog() == 0;
    }
}

