/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.macro;

import ij.IJ;
import ij.macro.ExtensionDescriptor;
import ij.macro.Functions;
import ij.macro.MacroExtension;
import ij.plugin.PlugIn;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import loci.plugins.util.LibraryChecker;
import loci.plugins.util.WindowTools;

public class MacroFunctions
implements PlugIn,
MacroExtension {
    protected ExtensionDescriptor[] extensions = this.buildExtensions();

    @Override
    public void run(String arg) {
        if (!LibraryChecker.checkImageJ()) {
            return;
        }
        if (!IJ.macroRunning()) {
            IJ.error("Cannot install extensions from outside a macro.");
            return;
        }
        Functions.registerExtensions(this);
    }

    @Override
    public ExtensionDescriptor[] getExtensionFunctions() {
        return this.extensions;
    }

    @Override
    public String handleExtension(String name, Object[] args2) {
        Class[] c = null;
        if (args2 != null) {
            c = new Class[args2.length];
            for (int i = 0; i < args2.length; ++i) {
                c[i] = args2[i].getClass();
            }
        }
        try {
            this.getClass().getMethod(name, c).invoke((Object)this, args2);
        }
        catch (NoSuchMethodException exc) {
            WindowTools.reportException(exc, false, "Macro error");
        }
        catch (IllegalAccessException exc) {
            WindowTools.reportException(exc, false, "Macro error");
        }
        catch (InvocationTargetException exc) {
            WindowTools.reportException(exc, false, "Macro error");
        }
        return null;
    }

    protected ExtensionDescriptor[] buildExtensions() {
        Method[] m4 = this.getClass().getMethods();
        ExtensionDescriptor[] desc = new ExtensionDescriptor[m4.length];
        for (int i = 0; i < m4.length; ++i) {
            Class<?>[] c = m4[i].getParameterTypes();
            int[] types = new int[c.length];
            for (int j = 0; j < c.length; ++j) {
                if (c[j] == String.class) {
                    types[j] = 1;
                    continue;
                }
                if (c[j] == Double.class) {
                    types[j] = 2;
                    continue;
                }
                if (c[j] == Object[].class) {
                    types[j] = 4;
                    continue;
                }
                if (c[j] == String[].class) {
                    types[j] = 17;
                    continue;
                }
                if (c[j] != Double[].class) continue;
                types[j] = 18;
            }
            desc[i] = ExtensionDescriptor.newDescriptor(m4[i].getName(), (MacroExtension)this, types);
        }
        return desc;
    }
}

