/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.prefs;

import ij.Macro;
import ij.Prefs;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import loci.plugins.prefs.Option;

public class StringOption
extends Option {
    public static final String INI_POSSIBLE = "values";
    protected String defaultValue;
    protected Vector<String> possibleValues;
    protected String value;

    public static Vector<String> parseList(String s2) {
        if (s2 == null) {
            return null;
        }
        String[] array = s2.split(",");
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].trim();
        }
        return new Vector<String>(Arrays.asList(array));
    }

    public StringOption(HashMap<String, String> entry) {
        this(entry.get("header"), !"false".equals(entry.get("save")), entry.get("label"), entry.get("info"), entry.get("default"), StringOption.parseList(entry.get(INI_POSSIBLE)));
    }

    public StringOption(String key, boolean save, String label, String info, String defaultValue, Vector<String> possibleValues) {
        super(key, save, label, info);
        this.defaultValue = defaultValue;
        this.possibleValues = possibleValues;
        this.value = defaultValue;
    }

    public Vector<String> getPossible() {
        return this.possibleValues;
    }

    public void addPossible(String val) {
        this.possibleValues.add(val);
    }

    public void removePossible(String val) {
        this.possibleValues.remove(val);
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (this.possibleValues != null) {
            for (String p : this.possibleValues) {
                if (!p.equals(value)) continue;
                this.value = value;
                return;
            }
            throw new IllegalArgumentException("'" + value + "' is not a possible value");
        }
        this.value = value;
    }

    @Override
    public void parseOption(String arg) {
        String keyValue = Macro.getValue(arg, this.key, this.value);
        this.value = (this.value == null || keyValue.equals(this.value)) && this.label != null ? Macro.getValue(arg, this.label, this.value) : keyValue;
    }

    @Override
    public void loadOption() {
        this.value = Prefs.get("bioformats." + this.key, this.defaultValue);
    }

    @Override
    public void saveOption() {
        if (this.save) {
            Prefs.set("bioformats." + this.key, this.value);
        }
    }
}

