/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.Prefs;
import loci.formats.ClassList;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.in.SDTReader;
import loci.formats.in.TiffDelegateReader;

public final class LociPrefs {
    public static final String PREF_READER_ENABLED = "bioformats.enabled";
    public static final String PREF_READER_WINDOWLESS = "bioformats.windowless";
    public static final String PREF_SDT_INTENSITY = "bioformats.sdt.intensity";
    public static final String PREF_TIFF_IMAGEIO = "bioformats.tiff.imageio";
    public static final String PREF_CZI_AUTOSTITCH = "bioformats.zeissczi.allow.autostitch";
    public static final String PREF_CZI_ATTACHMENT = "bioformats.zeissczi.include.attachments";
    public static final String PREF_ND2_CHUNKMAP = "bioformats.nd2.chunkmap";
    public static final String PREF_LEICA_LIF_PHYSICAL_SIZE = "bioformats.leicalif.physicalsize.compatibility";
    public static final String PREF_SLICE_LABEL_PATTERN = "bioformats.sliceLabelPattern";
    public static final String PREF_SLICE_LABEL_BASE_INDEX = "bioformats.sliceLabelBaseIndex";
    public static final String PREF_CELLSENS_FAIL = "bioformats.cellsens.fail_on_missing_ets";

    private LociPrefs() {
    }

    public static ImageReader makeImageReader() {
        ClassList<IFormatReader> defaultClasses = ImageReader.getDefaultReaderClasses();
        Class<IFormatReader>[] c = defaultClasses.getClasses();
        ClassList<IFormatReader> enabledClasses = new ClassList<IFormatReader>(IFormatReader.class);
        for (int i = 0; i < c.length; ++i) {
            boolean on = LociPrefs.isReaderEnabled(c[i]);
            if (!on) continue;
            enabledClasses.addClass(c[i]);
        }
        ImageReader reader = new ImageReader(enabledClasses);
        MetadataOptions options = reader.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            ((DynamicMetadataOptions)options).setBoolean("zeissczi.autostitch", LociPrefs.allowCZIAutostitch());
            ((DynamicMetadataOptions)options).setBoolean("zeissczi.attachments", LociPrefs.includeCZIAttachments());
            ((DynamicMetadataOptions)options).setBoolean("nd2.chunkmap", LociPrefs.useND2Chunkmap());
            ((DynamicMetadataOptions)options).setBoolean("leicalif.old_physical_size", LociPrefs.isLeicaLIFPhysicalSizeBackwardsCompatible());
            ((DynamicMetadataOptions)options).setBoolean("cellsens.fail_on_missing_ets", LociPrefs.isCellsensFailOnMissing());
            reader.setMetadataOptions(options);
        }
        boolean sdtIntensity = LociPrefs.isSDTIntensity();
        boolean tiffImageIO = LociPrefs.isTiffImageIO();
        IFormatReader[] r = reader.getReaders();
        for (int i = 0; i < r.length; ++i) {
            if (r[i] instanceof SDTReader) {
                SDTReader sdt = (SDTReader)r[i];
                sdt.setIntensity(sdtIntensity);
                continue;
            }
            if (!(r[i] instanceof TiffDelegateReader)) continue;
            TiffDelegateReader tiff = (TiffDelegateReader)r[i];
            tiff.setLegacy(tiffImageIO);
        }
        return reader;
    }

    public static boolean isWindowless(IFormatReader r) {
        return LociPrefs.getPref(PREF_READER_WINDOWLESS, r.getClass(), false);
    }

    public static boolean isReaderEnabled(Class<? extends IFormatReader> c) {
        return LociPrefs.getPref(PREF_READER_ENABLED, c, true);
    }

    public static boolean isSDTIntensity() {
        return Prefs.get(PREF_SDT_INTENSITY, false);
    }

    public static boolean isTiffImageIO() {
        return Prefs.get(PREF_TIFF_IMAGEIO, false);
    }

    public static boolean allowCZIAutostitch() {
        return Prefs.get(PREF_CZI_AUTOSTITCH, true);
    }

    public static boolean includeCZIAttachments() {
        return Prefs.get(PREF_CZI_ATTACHMENT, true);
    }

    public static boolean useND2Chunkmap() {
        return Prefs.get(PREF_ND2_CHUNKMAP, true);
    }

    public static boolean isLeicaLIFPhysicalSizeBackwardsCompatible() {
        return Prefs.get(PREF_LEICA_LIF_PHYSICAL_SIZE, false);
    }

    public static String getSliceLabelPattern() {
        return Prefs.get(PREF_SLICE_LABEL_PATTERN, "%c%z%t- %n");
    }

    public static int getSliceLabelBaseIndex() {
        return Prefs.getInt(PREF_SLICE_LABEL_BASE_INDEX, 1);
    }

    public static boolean isCellsensFailOnMissing() {
        return Prefs.get(PREF_CELLSENS_FAIL, false);
    }

    private static boolean getPref(String pref, Class<? extends IFormatReader> c, boolean defaultValue) {
        String n = c.getName();
        String readerName = n.substring(n.lastIndexOf(".") + 1, n.length() - 6);
        String key = pref + "." + readerName;
        return Prefs.get(key, defaultValue);
    }
}

