/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.eventmodel;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import loci.poi.hssf.eventmodel.ERFListener;
import loci.poi.hssf.eventmodel.EventRecordFactory;
import loci.poi.hssf.eventmodel.ModelFactoryListener;
import loci.poi.hssf.model.Model;
import loci.poi.hssf.model.Sheet;
import loci.poi.hssf.model.Workbook;
import loci.poi.hssf.record.BOFRecord;
import loci.poi.hssf.record.Record;

public class ModelFactory
implements ERFListener {
    List listeners = new ArrayList(1);
    Model currentmodel;
    boolean lastEOF;

    public void registerListener(ModelFactoryListener listener) {
        this.listeners.add(listener);
    }

    public void run(InputStream stream) {
        EventRecordFactory factory2 = new EventRecordFactory(true);
        factory2.registerListener(this, null);
        this.lastEOF = true;
        factory2.processRecords(stream);
    }

    @Override
    public boolean processRecord(Record rec) {
        if (rec.getSid() == 2057) {
            if (!this.lastEOF) {
                throw new RuntimeException("Not yet handled embedded models");
            }
            BOFRecord bof = (BOFRecord)rec;
            switch (bof.getType()) {
                case 5: {
                    this.currentmodel = new Workbook();
                    break;
                }
                case 16: {
                    this.currentmodel = new Sheet();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported model type " + bof.getType());
                }
            }
        }
        if (rec.getSid() == 10) {
            this.lastEOF = true;
            this.throwEvent(this.currentmodel);
        } else {
            this.lastEOF = false;
        }
        return true;
    }

    private void throwEvent(Model model) {
        for (ModelFactoryListener mfl : this.listeners) {
            mfl.process(model);
        }
    }
}

