/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import loci.poi.hssf.record.EndSubRecord;
import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.SubRecord;
import loci.poi.util.LittleEndian;

public class ObjRecord
extends Record {
    public static final short sid = 93;
    private List subrecords;

    public ObjRecord() {
        this.subrecords = new ArrayList(2);
    }

    public ObjRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 93) {
            throw new RecordFormatException("Not an OBJ record");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.subrecords = new ArrayList();
        int subSize = 0;
        byte[] subRecordData = in.readRemainder();
        RecordInputStream subRecStream = new RecordInputStream(new ByteArrayInputStream(subRecordData));
        while (subRecStream.hasNextRecord()) {
            subRecStream.nextRecord();
            Record subRecord = SubRecord.createSubRecord(subRecStream);
            subSize += subRecord.getRecordSize();
            this.subrecords.add(subRecord);
        }
        if (subRecordData.length - subSize == 4) {
            this.subrecords.add(new EndSubRecord());
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[OBJ]\n");
        for (Record record : this.subrecords) {
            buffer.append("SUBRECORD: " + record.toString());
        }
        buffer.append("[/OBJ]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)93);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        pos = offset + 4;
        for (Record record : this.subrecords) {
            pos += record.serialize(pos, data);
        }
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        int size = 0;
        for (Record record : this.subrecords) {
            size += record.getRecordSize();
        }
        return 4 + size;
    }

    @Override
    public short getSid() {
        return 93;
    }

    public List getSubRecords() {
        return this.subrecords;
    }

    public void clearSubRecords() {
        this.subrecords.clear();
    }

    public void addSubRecord(int index, Object element) {
        this.subrecords.add(index, element);
    }

    public boolean addSubRecord(Object o) {
        return this.subrecords.add(o);
    }

    @Override
    public Object clone() {
        ObjRecord rec = new ObjRecord();
        Iterator iterator2 = this.subrecords.iterator();
        while (iterator2.hasNext()) {
            rec.addSubRecord(((Record)iterator2.next()).clone());
        }
        return rec;
    }
}

