/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.dev;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import loci.common.RandomAccessInputStream;
import loci.poi.poifs.dev.POIFSViewEngine;
import loci.poi.poifs.filesystem.POIFSFileSystem;

public class POIFSViewer {
    public static void main(String[] args2) {
        if (args2.length < 0) {
            System.err.println("Must specify at least one file to view");
            System.exit(1);
        }
        boolean printNames = args2.length > 1;
        for (int j = 0; j < args2.length; ++j) {
            POIFSViewer.viewFile(args2[j], printNames);
        }
    }

    private static void viewFile(String filename, boolean printName) {
        if (printName) {
            StringBuffer flowerbox = new StringBuffer();
            flowerbox.append(".");
            for (int j = 0; j < filename.length(); ++j) {
                flowerbox.append("-");
            }
            flowerbox.append(".");
            System.out.println(flowerbox);
            System.out.println("|" + filename + "|");
            System.out.println(flowerbox);
        }
        try {
            POIFSFileSystem fs = new POIFSFileSystem(new RandomAccessInputStream(filename), 512);
            List strings = POIFSViewEngine.inspectViewable(fs, true, 0, "  ");
            Iterator iter = strings.iterator();
            while (iter.hasNext()) {
                System.out.print(iter.next());
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
}

