/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.util.zip.Deflater;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Segment;
import okio.SegmentPool;
import okio.Sink;
import okio.Timeout;
import okio.Util;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public final class DeflaterSink
implements Sink {
    private final BufferedSink sink;
    private final Deflater deflater;
    private boolean closed;

    public DeflaterSink(Sink sink2, Deflater deflater) {
        this(Okio.buffer(sink2), deflater);
    }

    DeflaterSink(BufferedSink sink2, Deflater deflater) {
        if (sink2 == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (deflater == null) {
            throw new IllegalArgumentException("inflater == null");
        }
        this.sink = sink2;
        this.deflater = deflater;
    }

    @Override
    public void write(Buffer source2, long byteCount) throws IOException {
        Util.checkOffsetAndCount(source2.size, 0L, byteCount);
        while (byteCount > 0L) {
            Segment head = source2.head;
            int toDeflate = (int)Math.min(byteCount, (long)(head.limit - head.pos));
            this.deflater.setInput(head.data, head.pos, toDeflate);
            this.deflate(false);
            source2.size -= (long)toDeflate;
            head.pos += toDeflate;
            if (head.pos == head.limit) {
                source2.head = head.pop();
                SegmentPool.recycle(head);
            }
            byteCount -= (long)toDeflate;
        }
    }

    @IgnoreJRERequirement
    private void deflate(boolean syncFlush) throws IOException {
        Segment s2;
        Buffer buffer = this.sink.buffer();
        while (true) {
            int deflated;
            s2 = buffer.writableSegment(1);
            int n = deflated = syncFlush ? this.deflater.deflate(s2.data, s2.limit, 8192 - s2.limit, 2) : this.deflater.deflate(s2.data, s2.limit, 8192 - s2.limit);
            if (deflated > 0) {
                s2.limit += deflated;
                buffer.size += (long)deflated;
                this.sink.emitCompleteSegments();
                continue;
            }
            if (this.deflater.needsInput()) break;
        }
        if (s2.pos == s2.limit) {
            buffer.head = s2.pop();
            SegmentPool.recycle(s2);
        }
    }

    @Override
    public void flush() throws IOException {
        this.deflate(true);
        this.sink.flush();
    }

    void finishDeflate() throws IOException {
        this.deflater.finish();
        this.deflate(false);
    }

    @Override
    public void close() throws IOException {
        Throwable thrown;
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                thrown = null;
                try {
                    this.finishDeflate();
                }
                catch (Throwable e) {
                    thrown = e;
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable e) {
                    if (thrown != null) break block8;
                    thrown = e;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable e) {
                if (thrown != null) break block9;
                thrown = e;
            }
        }
        this.closed = true;
        if (thrown != null) {
            Util.sneakyRethrow(thrown);
        }
    }

    @Override
    public Timeout timeout() {
        return this.sink.timeout();
    }

    public String toString() {
        return "DeflaterSink(" + this.sink + ")";
    }
}

