/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat;

import org.apache.commons.math.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.GeometricMean;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.Variance;
import org.apache.commons.math.stat.descriptive.rank.Max;
import org.apache.commons.math.stat.descriptive.rank.Min;
import org.apache.commons.math.stat.descriptive.rank.Percentile;
import org.apache.commons.math.stat.descriptive.summary.Product;
import org.apache.commons.math.stat.descriptive.summary.Sum;
import org.apache.commons.math.stat.descriptive.summary.SumOfLogs;
import org.apache.commons.math.stat.descriptive.summary.SumOfSquares;

public final class StatUtils {
    private static UnivariateStatistic sum = new Sum();
    private static UnivariateStatistic sumSq = new SumOfSquares();
    private static UnivariateStatistic prod = new Product();
    private static UnivariateStatistic sumLog = new SumOfLogs();
    private static UnivariateStatistic min = new Min();
    private static UnivariateStatistic max = new Max();
    private static UnivariateStatistic mean = new Mean();
    private static Variance variance = new Variance();
    private static Percentile percentile = new Percentile();
    private static GeometricMean geometricMean = new GeometricMean();

    private StatUtils() {
    }

    public static double sum(double[] values2) {
        return sum.evaluate(values2);
    }

    public static double sum(double[] values2, int begin, int length) {
        return sum.evaluate(values2, begin, length);
    }

    public static double sumSq(double[] values2) {
        return sumSq.evaluate(values2);
    }

    public static double sumSq(double[] values2, int begin, int length) {
        return sumSq.evaluate(values2, begin, length);
    }

    public static double product(double[] values2) {
        return prod.evaluate(values2);
    }

    public static double product(double[] values2, int begin, int length) {
        return prod.evaluate(values2, begin, length);
    }

    public static double sumLog(double[] values2) {
        return sumLog.evaluate(values2);
    }

    public static double sumLog(double[] values2, int begin, int length) {
        return sumLog.evaluate(values2, begin, length);
    }

    public static double mean(double[] values2) {
        return mean.evaluate(values2);
    }

    public static double mean(double[] values2, int begin, int length) {
        return mean.evaluate(values2, begin, length);
    }

    public static double geometricMean(double[] values2) {
        return geometricMean.evaluate(values2);
    }

    public static double geometricMean(double[] values2, int begin, int length) {
        return geometricMean.evaluate(values2, begin, length);
    }

    public static double variance(double[] values2) {
        return variance.evaluate(values2);
    }

    public static double variance(double[] values2, int begin, int length) {
        return variance.evaluate(values2, begin, length);
    }

    public static double variance(double[] values2, double mean, int begin, int length) {
        return variance.evaluate(values2, mean, begin, length);
    }

    public static double variance(double[] values2, double mean) {
        return variance.evaluate(values2, mean);
    }

    public static double max(double[] values2) {
        return max.evaluate(values2);
    }

    public static double max(double[] values2, int begin, int length) {
        return max.evaluate(values2, begin, length);
    }

    public static double min(double[] values2) {
        return min.evaluate(values2);
    }

    public static double min(double[] values2, int begin, int length) {
        return min.evaluate(values2, begin, length);
    }

    public static double percentile(double[] values2, double p) {
        return percentile.evaluate(values2, p);
    }

    public static double percentile(double[] values2, int begin, int length, double p) {
        return percentile.evaluate(values2, begin, length, p);
    }

    public static double sumDifference(double[] sample1, double[] sample2) throws IllegalArgumentException {
        int n = sample1.length;
        if (n != sample2.length || n < 1) {
            throw new IllegalArgumentException("Input arrays must have the same (positive) length.");
        }
        double result = 0.0;
        for (int i = 0; i < n; ++i) {
            result += sample1[i] - sample2[i];
        }
        return result;
    }

    public static double meanDifference(double[] sample1, double[] sample2) throws IllegalArgumentException {
        return StatUtils.sumDifference(sample1, sample2) / (double)sample1.length;
    }

    public static double varianceDifference(double[] sample1, double[] sample2, double meanDifference) throws IllegalArgumentException {
        double sum1 = 0.0;
        double sum2 = 0.0;
        double diff = 0.0;
        int n = sample1.length;
        if (n < 2 || n != sample2.length) {
            throw new IllegalArgumentException("Input array lengths must be equal and at least 2.");
        }
        for (int i = 0; i < n; ++i) {
            diff = sample1[i] - sample2[i];
            sum1 += (diff - meanDifference) * (diff - meanDifference);
            sum2 += diff - meanDifference;
        }
        return (sum1 - sum2 * sum2 / (double)n) / (double)(n - 1);
    }
}

