/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.ThirdMoment;

public class Skewness
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 7101857578996691352L;
    protected ThirdMoment moment = null;
    protected boolean incMoment;

    public Skewness() {
        this.incMoment = true;
        this.moment = new ThirdMoment();
    }

    public Skewness(ThirdMoment m32) {
        this.incMoment = false;
        this.moment = m32;
    }

    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    public double getResult() {
        if (this.moment.n < 3L) {
            return Double.NaN;
        }
        double variance = this.moment.m2 / (double)(this.moment.n - 1L);
        if (variance < 1.0E-19) {
            return 0.0;
        }
        double n0 = this.moment.getN();
        return n0 * this.moment.m3 / ((n0 - 1.0) * (n0 - 2.0) * Math.sqrt(variance) * variance);
    }

    public long getN() {
        return this.moment.getN();
    }

    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    public double evaluate(double[] values2, int begin, int length) {
        double skew = Double.NaN;
        if (this.test(values2, begin, length) && length > 2) {
            Mean mean = new Mean();
            double m4 = mean.evaluate(values2, begin, length);
            double accum = 0.0;
            double accum2 = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                accum += Math.pow(values2[i] - m4, 2.0);
                accum2 += values2[i] - m4;
            }
            double stdDev = Math.sqrt((accum - Math.pow(accum2, 2.0) / (double)length) / (double)(length - 1));
            double accum3 = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                accum3 += Math.pow(values2[i] - m4, 3.0);
            }
            double n0 = length;
            skew = n0 / ((n0 - 1.0) * (n0 - 2.0)) * (accum3 /= Math.pow(stdDev, 3.0));
        }
        return skew;
    }
}

