/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.Range;
import ucar.ma2.RangeComposite;
import ucar.ma2.RangeIterator;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft2.coverage.CoordAxisReader;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.LatLonAxis2D;
import ucar.nc2.ft2.coverage.TimeHelper;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.Counters;
import ucar.nc2.util.Misc;
import ucar.unidata.util.StringUtil2;

public class CoverageCoordAxisBuilder {
    public String name;
    public String description;
    public DataType dataType;
    public AxisType axisType;
    public AttributeContainerMutable attributes;
    public CoverageCoordAxis.DependenceType dependenceType;
    public List<String> dependsOn;
    public int ncoords;
    public CoverageCoordAxis.Spacing spacing;
    public double startValue;
    public double endValue;
    public double resolution;
    public CoordAxisReader reader;
    public boolean isSubset;
    TimeHelper timeHelper;
    public String units;
    public double[] values;
    public Range range;
    RangeComposite crange;
    public int[] shape;
    public List<RangeIterator> ranges;
    public Object userObject;
    private double missingTolerance = 0.05;

    public CoverageCoordAxisBuilder() {
    }

    public CoverageCoordAxisBuilder(String name, String units, String description, DataType dataType, AxisType axisType, AttributeContainer atts, CoverageCoordAxis.DependenceType dependenceType, String dependsOnS, CoverageCoordAxis.Spacing spacing, int ncoords, double startValue, double endValue, double resolution, double[] values2, CoordAxisReader reader) {
        this.name = name;
        this.units = units;
        this.description = description;
        this.dataType = dataType;
        this.axisType = axisType;
        this.attributes = AttributeContainerMutable.copyFrom(atts);
        this.dependenceType = dependenceType;
        this.setDependsOn(dependsOnS);
        this.spacing = spacing;
        this.ncoords = ncoords;
        this.startValue = startValue;
        this.endValue = endValue;
        this.resolution = resolution;
        this.values = values2;
        this.reader = reader;
    }

    CoverageCoordAxisBuilder(CoverageCoordAxis from) {
        this.name = from.name;
        this.units = from.units;
        this.description = from.description;
        this.dataType = from.dataType;
        this.axisType = from.axisType;
        this.attributes = AttributeContainerMutable.copyFrom(from.attributes);
        this.dependenceType = from.dependenceType;
        this.spacing = from.spacing;
        this.values = from.values;
        this.reader = from.reader;
        this.dependsOn = from.dependsOn;
        this.startValue = from.startValue;
        this.endValue = from.endValue;
        this.resolution = from.resolution;
        this.ncoords = from.ncoords;
        this.isSubset = from.isSubset;
        this.timeHelper = from.timeHelper;
        if (from instanceof LatLonAxis2D) {
            LatLonAxis2D latlon = (LatLonAxis2D)from;
            this.shape = latlon.getShape();
            this.userObject = latlon.getUserObject();
            this.ranges = latlon.getRanges();
        }
    }

    public void setIsSubset(boolean isSubset) {
        this.isSubset = isSubset;
    }

    public CoverageCoordAxisBuilder setDependsOn(String dependsOn) {
        if (dependsOn != null && !dependsOn.trim().isEmpty()) {
            ArrayList temp = new ArrayList();
            Collections.addAll(temp, StringUtil2.splitString(dependsOn));
            this.dependsOn = Collections.unmodifiableList(temp);
        } else {
            this.dependsOn = Collections.emptyList();
        }
        return this;
    }

    public void setMissingTolerance(double tolerance) {
        this.missingTolerance = tolerance;
    }

    public void setSpacingFromValues(boolean isInterval) {
        if (isInterval) {
            this.setSpacingFromIntervalValues();
        } else {
            this.setSpacingFromPointValues();
        }
    }

    private void setSpacingFromPointValues() {
        boolean isRegular;
        assert (this.values.length == this.ncoords);
        this.startValue = this.values[0];
        this.endValue = this.values[this.ncoords - 1];
        double d = this.resolution = this.ncoords == 1 ? 0.0 : (this.endValue - this.startValue) / (double)(this.ncoords - 1);
        if (this.ncoords == 1) {
            this.spacing = CoverageCoordAxis.Spacing.regularPoint;
            this.values = null;
            return;
        }
        this.resolution = (this.endValue - this.startValue) / (double)(this.ncoords - 1);
        Counters.Counter resol = new Counters.Counter("resol");
        for (int i = 0; i < this.values.length - 1; ++i) {
            double diff = this.values[i + 1] - this.values[i];
            resol.count(Double.valueOf(diff));
        }
        Comparable resolMode = resol.getMode();
        if (resolMode != null) {
            this.resolution = ((Number)((Object)resolMode)).doubleValue();
        }
        CoverageCoordAxis.Spacing spacing = this.spacing = (isRegular = this.isRegular(resol)) ? CoverageCoordAxis.Spacing.regularPoint : CoverageCoordAxis.Spacing.irregularPoint;
        if (isRegular) {
            this.values = null;
        }
    }

    private void setSpacingFromIntervalValues() {
        double modeValue;
        assert (this.values.length == 2 * this.ncoords);
        this.startValue = this.values[0];
        this.endValue = this.values[this.values.length - 1];
        this.resolution = (this.endValue - this.startValue) / (double)this.ncoords;
        Counters.Counter resol = new Counters.Counter("resol");
        boolean isContiguous = true;
        for (int i = 0; i < this.values.length - 2; i += 2) {
            double diff = this.values[i + 2] - this.values[i];
            resol.count(Double.valueOf(diff));
            if (!isContiguous || Misc.nearlyEquals(this.values[i + 1], this.values[i + 2])) continue;
            isContiguous = false;
        }
        Comparable resolMode = resol.getMode();
        if (resolMode != null && (modeValue = ((Number)((Object)resolMode)).doubleValue()) != 0.0) {
            this.resolution = modeValue;
        }
        boolean regular = this.isRegular(resol);
        if (this.ncoords == 2) {
            double diff0 = this.values[1] - this.values[0];
            double diff1 = this.values[3] - this.values[2];
            regular = Misc.nearlyEquals(diff0, diff1);
        }
        if (regular && isContiguous) {
            this.spacing = CoverageCoordAxis.Spacing.regularInterval;
            this.values = null;
        } else if (isContiguous) {
            this.spacing = CoverageCoordAxis.Spacing.contiguousInterval;
            double[] contValues = new double[this.ncoords + 1];
            int count = 0;
            for (int i = 0; i < this.values.length; i += 2) {
                contValues[count++] = this.values[i];
            }
            contValues[count] = this.values[this.values.length - 1];
            this.values = contValues;
        } else {
            this.spacing = CoverageCoordAxis.Spacing.discontiguousInterval;
        }
    }

    private boolean isRegular(Counters.Counter resol) {
        if (resol.getUnique() == 1) {
            return true;
        }
        Comparable mode = resol.getMode();
        Number modeNumber = (Number)((Object)mode);
        if (modeNumber == null || modeNumber.intValue() == 0) {
            return false;
        }
        int modeCount = 0;
        int nonModeCount = 0;
        for (Comparable value : resol.getValues()) {
            if (value.compareTo(mode) == 0) {
                modeCount = resol.getCount(value);
                continue;
            }
            Number valueNumber = (Number)((Object)value);
            if (valueNumber.intValue() == 0) {
                return false;
            }
            int rem = valueNumber.intValue() % modeNumber.intValue();
            if (rem != 0) {
                return false;
            }
            int multiple = valueNumber.intValue() / modeNumber.intValue();
            nonModeCount += (multiple - 1) * resol.getCount(value);
        }
        if (modeCount == 0) {
            return true;
        }
        double ratio = (double)nonModeCount / (double)modeCount;
        return ratio < this.missingTolerance;
    }

    CoverageCoordAxisBuilder subset(String dependsOn, CoverageCoordAxis.Spacing spacing, int ncoords, double[] values2) {
        assert (values2 != null);
        if (dependsOn != null) {
            this.dependenceType = CoverageCoordAxis.DependenceType.dependent;
            this.setDependsOn(dependsOn);
        }
        this.spacing = spacing;
        this.ncoords = ncoords;
        this.reader = null;
        this.values = values2;
        this.isSubset = true;
        return this;
    }

    CoverageCoordAxisBuilder subset(int ncoords, double startValue, double endValue, double resolution, double[] values2) {
        this.ncoords = ncoords;
        this.startValue = startValue;
        this.endValue = endValue;
        this.resolution = resolution;
        this.values = values2;
        this.isSubset = true;
        return this;
    }

    CoverageCoordAxisBuilder setRange(Range r) {
        this.range = r;
        this.isSubset = true;
        return this;
    }

    CoverageCoordAxisBuilder setCompositeRange(RangeComposite cr) {
        this.crange = cr;
        this.isSubset = true;
        return this;
    }

    void setReferenceDate(CalendarDate refDate) {
        this.timeHelper = this.timeHelper.setReferenceDate(refDate);
        this.units = this.timeHelper.getUdUnit();
        this.attributes.addAttribute(new Attribute("units", this.units));
    }
}

