/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.roi;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.type.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.math.plot.Plot2DPanel;
import org.math.plot.plots.Plot;
import plugins.adufour.activecontours.ActiveContour;
import plugins.adufour.activecontours.ActiveContours;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.roi.ROIMeasures;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarROIDescriptor;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarWorkbook;
import plugins.adufour.vars.util.VarException;
import plugins.adufour.workbooks.IcySpreadSheet;
import plugins.adufour.workbooks.Workbooks;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi3d.ROI3DArea;
import plugins.kernel.roi.roi3d.ROI3DPoint;
import plugins.nchenouard.particletracking.DetectionSpotTrack;
import plugins.nchenouard.particletracking.legacytracker.SpotTrack;
import plugins.nchenouard.spot.Detection;
import plugins.nchenouard.spot.Point3D;

public class ROITrackStatistics
extends Plugin
implements ROIBlock,
PluginBundled {
    public final Var<TrackGroup> tracks = new Var("Track group", (Object)new TrackGroup(null));
    public final VarSequence sequence = new VarSequence("Sequence", null);
    public final VarInteger channel = new VarInteger("Channel", 0);
    public final VarROIDescriptor descriptor = new VarROIDescriptor("Descriptor");
    public final VarWorkbook workbook = new VarWorkbook("Workbook", Workbooks.createEmptyWorkbook());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildPlot(List<TrackGroup> trackGroups, Sequence sequence, int channel, ROIDescriptor descriptor, Plot2DPanel plotPanel) throws UnsupportedOperationException, InterruptedException {
        int sizeZ = sequence != null ? sequence.getSizeZ() : 1;
        double timeInterval = sequence != null ? sequence.getTimeInterval() : 1.0;
        String name = descriptor.getName();
        String unit = descriptor.getUnit(sequence);
        String title = name + " (" + (unit == null ? "a.u." : unit) + ")";
        plotPanel.removeAllPlots();
        plotPanel.removeAllPlotables();
        plotPanel.setAxisLabels(new String[]{"Time (sec.)", title});
        for (TrackGroup tg : trackGroups) {
            ArrayList tracks = tg.getTrackSegmentList();
            for (int trackInd = 0; trackInd < tracks.size(); ++trackInd) {
                TrackSegment ts = (TrackSegment)tracks.get(trackInd);
                if (!ts.isAllDetectionEnabled()) continue;
                ArrayList detections = ts.getDetectionList();
                double[][] xy = new double[detections.size()][];
                for (int detInd = 0; detInd < detections.size(); ++detInd) {
                    double d;
                    Detection det = (Detection)detections.get(detInd);
                    Object roi = null;
                    if (det instanceof DetectionSpotTrack || det instanceof SpotTrack) {
                        ArrayList pts = det instanceof DetectionSpotTrack ? (((DetectionSpotTrack)det).spot != null ? ((DetectionSpotTrack)det).spot.point3DList : null) : ((SpotTrack)det).getPoint3DList();
                        if (pts != null && pts.size() > 1) {
                            if (sizeZ == 1) {
                                roi = new ROI2DArea();
                                roi.beginUpdate();
                                try {
                                    for (Point3D pt : pts) {
                                        ((ROI2DArea)roi).addPoint((int)pt.x, (int)pt.y);
                                    }
                                }
                                finally {
                                    roi.endUpdate();
                                }
                            } else {
                                roi = new ROI3DArea();
                                roi.beginUpdate();
                                try {
                                    for (Point3D pt : pts) {
                                        ((ROI3DArea)roi).addPoint((int)pt.x, (int)pt.y, (int)pt.z);
                                    }
                                }
                                finally {
                                    roi.endUpdate();
                                }
                            }
                        }
                    } else if (det instanceof ActiveContour) {
                        roi = ((ActiveContour)det).toROI(ActiveContours.ROIType.AREA, sequence);
                    }
                    if (roi == null) {
                        roi = sizeZ == 1 ? new ROI2DPoint(det.getX(), det.getY()) : new ROI3DPoint(det.getX(), det.getY(), det.getZ());
                    }
                    if (descriptor.separateChannel() && channel != -1) {
                        roi = roi.getSubROI(-1, -1, channel);
                    }
                    if (roi instanceof ROI2D) {
                        ((ROI2D)roi).setT(det.getT());
                    } else if (roi instanceof ROI3D) {
                        ((ROI3D)roi).setT(det.getT());
                    }
                    if (roi.isEmpty()) {
                        xy[detInd] = new double[]{(double)det.getT() * timeInterval, 0.0};
                        continue;
                    }
                    double value = 0.0;
                    Object res = descriptor.compute(roi, sequence);
                    if (res instanceof Double && Double.isFinite(d = ((Double)res).doubleValue())) {
                        value = d;
                    }
                    xy[detInd] = new double[]{(double)det.getT() * timeInterval, value};
                }
                plotPanel.addLinePlot(tg.getDescription() + " #" + trackInd, ts.getFirstDetection().getColor(), (double[][])xy);
            }
        }
    }

    public static Workbook getWorkBook(Sequence sequence, String name, Plot2DPanel plotPanel) {
        Workbook wb = Workbooks.createEmptyWorkbook();
        IcySpreadSheet sheet = Workbooks.getSheet((Workbook)wb, (String)name);
        int sizeT = sequence != null ? sequence.getSizeT() : 1;
        double tScale = sequence != null ? sequence.getTimeInterval() : 1.0;
        sheet.setValue(0, 0, (Object)"Time (sec.)");
        for (int t = 0; t < sizeT; ++t) {
            sheet.setValue(t + 1, 0, (Object)((double)t * tScale));
        }
        int column = 1;
        for (Plot plot : plotPanel.getPlots()) {
            double[][] data = plot.getData();
            sheet.setValue(0, column, (Object)plot.getName());
            for (double[] xy : data) {
                int row = 1 + (int)Math.round(xy[0] / tScale);
                sheet.setValue(row, column, (Object)xy[1]);
            }
            ++column;
        }
        return wb;
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("trackgroup", this.tracks);
        inputMap.add("sequence", (Var)this.sequence);
        inputMap.add("channel", (Var)this.channel);
        inputMap.add("descriptor", (Var)this.descriptor);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("workbook", (Var)this.workbook);
    }

    public void run() {
        int ch;
        TrackGroup trackGroup = (TrackGroup)this.tracks.getValue();
        Sequence seq = (Sequence)this.sequence.getValue();
        ROIDescriptor desc = ROIDescriptor.getDescriptor((String)((String)this.descriptor.getValue()));
        int n = ch = desc != null && desc.separateChannel() ? this.channel.getValue() : -1;
        if (seq != null && ch >= seq.getSizeC()) {
            throw new VarException((Var)this.channel, "Invalid channel parameter (cannot be > " + (seq.getSizeC() - 1) + ")");
        }
        try {
            if (trackGroup != null && desc != null) {
                Plot2DPanel plotPanel = new Plot2DPanel();
                ROITrackStatistics.buildPlot(CollectionUtil.createArrayList((Object)trackGroup), seq, ch, desc, plotPanel);
                Workbook wb = ROITrackStatistics.getWorkBook(seq, desc.getName(), plotPanel);
                this.workbook.setValue((Object)wb);
            }
        }
        catch (UnsupportedOperationException e) {
            throw new VarException((Var)this.descriptor, e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public String getMainPluginClassName() {
        return ROIMeasures.class.getName();
    }
}

