/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.distancetransforms;

import icy.sequence.Sequence;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.distancetransforms.DistanceTransform;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarPlugin;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;

public class ROIToDistanceMap
extends EzPlug
implements Block {
    EzVarSequence sequence = new EzVarSequence("Sequence");
    EzVarBoolean selectedOnly = new EzVarBoolean("Restrict to selected ROI", false);
    EzVarPlugin<DistanceTransform> transform = new EzVarPlugin("Algorithm", DistanceTransform.class);
    EzVarBoolean invert = new EzVarBoolean("Invert map", true);
    EzVarBoolean useRealUnits = new EzVarBoolean("Use pixel size", false);
    VarSequence map = new VarSequence("Distance map", null);

    public void declareInput(VarList inputMap) {
        inputMap.add("Use ROI from", (Var)this.sequence.getVariable());
        inputMap.add("Algorithm", this.transform.getVariable());
        inputMap.add("Invert map", this.invert.getVariable());
        inputMap.add("Real units", this.useRealUnits.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("Distance map", (Var)this.map);
    }

    protected void initialize() {
        this.addEzComponent((EzComponent)this.sequence);
        this.addEzComponent((EzComponent)this.transform);
        this.addEzComponent((EzComponent)this.selectedOnly);
        this.addEzComponent((EzComponent)this.invert);
        this.addEzComponent((EzComponent)this.useRealUnits);
        this.setTimeDisplay(true);
    }

    protected void execute() {
        this.map.setValue(((DistanceTransform)this.transform.newInstance()).createDistanceMap((Sequence)this.sequence.getValue(true), (Boolean)this.selectedOnly.getValue(), (Boolean)this.invert.getValue() == false, (Boolean)this.useRealUnits.getValue()));
        if (!this.isHeadLess()) {
            Sequence mapSequence = (Sequence)this.map.getValue();
            mapSequence.updateChannelsBounds();
            this.addSequence(mapSequence);
        }
    }

    public void clean() {
    }
}

