/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.distancetransforms;

import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.type.dimension.Dimension3D;
import icy.type.dimension.Dimension5D;
import icy.type.rectangle.Rectangle5D;
import java.util.ArrayList;
import java.util.List;
import plugins.adufour.distancetransforms.DistanceTransform;
import plugins.kernel.roi.morphology.ROIDistanceTransformCalculator;
import plugins.kernel.roi.roi5d.ROI5DStackRectangle;

public class Saito
extends DistanceTransform {
    @Override
    public Sequence createDistanceMap(Sequence input, int channel, double threshold, boolean invertMap, boolean useRealUnits) {
        throw new UnsupportedOperationException("Cannot work on thresholded sequence");
    }

    @Override
    public Sequence createDistanceMap(Sequence sequence, boolean mapOnlySelectedROI, boolean invertMap, boolean useRealUnits) {
        Dimension3D pixelSize = this.getPixelSize(sequence, useRealUnits);
        ROIDistanceTransformCalculator calculator = new ROIDistanceTransformCalculator((Dimension5D)sequence.getDimension5D(), pixelSize, false);
        List<ROI> rois = this.getTargetROIs(sequence, mapOnlySelectedROI, invertMap);
        calculator.addAll(rois);
        try {
            return calculator.getDistanceMap();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Dimension3D getPixelSize(Sequence sequence, boolean useRealUnits) {
        return useRealUnits ? new Dimension3D.Double(sequence.getPixelSize()) : new Dimension3D.Double(1.0, 1.0, 1.0);
    }

    private List<ROI> getTargetROIs(Sequence sequence, boolean mapOnlySelectedROI, boolean invertMap) {
        List<Object> rois;
        ArrayList arrayList = rois = mapOnlySelectedROI ? sequence.getSelectedROIs() : sequence.getROIs();
        if (!invertMap) {
            rois = this.getInvertedRoi(sequence, rois);
        }
        return rois;
    }

    private List<ROI> getInvertedRoi(Sequence sequence, List<ROI> rois) {
        ROI5DStackRectangle seqRoi = new ROI5DStackRectangle((Rectangle5D)sequence.getBounds5D());
        for (ROI roi : rois) {
            seqRoi = seqRoi.subtract(roi, true);
        }
        ArrayList<ROI> resultRoiList = new ArrayList<ROI>(1);
        resultRoiList.add((ROI)seqRoi);
        return resultRoiList;
    }
}

