/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.NewImage;
import ij.gui.Plot;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.process.ImageStatistics;
import java.awt.Color;

public class ImageColocalizer {
    int width;
    int height;
    int nbSlices;
    int depth;
    int length;
    int widthCostes;
    int heightCostes;
    int nbsliceCostes;
    int lengthCostes;
    String titleA;
    String titleB;
    int[] A;
    int[] B;
    int Amin;
    int Amax;
    int Bmin;
    int Bmax;
    double Amean;
    double Bmean;
    Calibration cal;
    Calibration micronCal;
    boolean doThat;
    double sumA;
    double sumB;
    double sumAB;
    double sumsqrA;
    double Aarraymean;
    double Barraymean;
    boolean verbose;

    public ImageColocalizer(ImagePlus ipA, ImagePlus ipB, Calibration cal, boolean verbose) {
        this.verbose = verbose;
        this.width = ipA.getWidth();
        this.height = ipA.getHeight();
        this.nbSlices = ipA.getNSlices();
        this.depth = ipA.getBitDepth();
        if (this.width != ipB.getWidth() || this.height != ipB.getHeight() || this.nbSlices != ipB.getNSlices() || this.depth != ipB.getBitDepth()) {
            IJ.error((String)"ImageColocalizer expects both images to have the same size and depth");
            return;
        }
        this.length = this.width * this.height * this.nbSlices;
        this.A = new int[this.length];
        this.B = new int[this.length];
        this.titleA = ipA.getTitle();
        this.titleB = ipB.getTitle();
        this.cal = cal;
        this.micronCal = (Calibration)cal.clone();
        this.micronCal.pixelDepth /= 1000.0;
        this.micronCal.pixelHeight /= 1000.0;
        this.micronCal.pixelWidth /= 1000.0;
        this.micronCal.setUnit("\ufffdm");
        this.buildArray(ipA, ipB);
        if (verbose) {
            IJ.log((String)("**************************************************\nImage A: " + this.titleA + "\nImage B: " + this.titleB));
        }
    }

    public ImageColocalizer(ImagePlus ipA, ImagePlus ipB, boolean verbose) {
        this(ipA, ipB, new Calibration(), verbose);
    }

    private void Pearson() {
        this.doThat = true;
        if (this.verbose) {
            IJ.log((String)("\nPearson's Coefficient:\nr=" + this.round(this.linreg(this.A, this.B, 0, 0)[2], 3)));
        }
    }

    public double getPearson() {
        return this.round(this.linreg(this.A, this.B, 0, 0)[2], 3);
    }

    public double[] Overlap(int thrA, int thrB) {
        double num = 0.0;
        double numThr = 0.0;
        double den1 = 0.0;
        double den1Thr = 0.0;
        double den2 = 0.0;
        double den2Thr = 0.0;
        for (int i = 0; i < this.length; ++i) {
            num += (double)(this.A[i] * this.B[i]);
            den1 += Math.pow(this.A[i], 2.0);
            den2 += Math.pow(this.B[i], 2.0);
            if (this.A[i] <= thrA || this.B[i] <= thrB) continue;
            numThr += (double)(this.A[i] * this.B[i]);
            den1Thr += Math.pow(this.A[i], 2.0);
            den2Thr += Math.pow(this.B[i], 2.0);
        }
        double OverlapCoeff = num / Math.sqrt(den1 * den2);
        if (this.verbose) {
            IJ.log((String)("\nOverlap Coefficient:\nr=" + this.round(OverlapCoeff, 3)));
        }
        if (this.verbose) {
            IJ.log((String)("\nr^2=k1xk2:\nk1=" + this.round(num / den1, 3) + "\nk2=" + this.round(num / den2, 3)));
        }
        double OverlapCoeffThr = numThr / Math.sqrt(den1Thr * den2Thr);
        if (this.verbose) {
            IJ.log((String)("\n\nUsing thresholds (thrA=" + thrA + " and thrB=" + thrB + ")"));
        }
        if (this.verbose) {
            IJ.log((String)("\nOverlap Coefficient:\nr=" + this.round(OverlapCoeffThr, 3)));
        }
        if (this.verbose) {
            IJ.log((String)("\nr^2=k1xk2:\nk1=" + this.round(numThr / den1Thr, 3) + "\nk2=" + this.round(numThr / den2Thr, 3)));
        }
        return new double[]{OverlapCoeff, num / den1, num / den2, OverlapCoeffThr, numThr / den1Thr, numThr / den2Thr};
    }

    public double[] MM(int thrA, int thrB) {
        double sumAcoloc = 0.0;
        double sumAcolocThr = 0.0;
        double sumA = 0.0;
        double sumAThr = 0.0;
        double sumBcoloc = 0.0;
        double sumBcolocThr = 0.0;
        double sumB = 0.0;
        double sumBThr = 0.0;
        for (int i = 0; i < this.length; ++i) {
            if (this.B[i] > 0) {
                sumB += (double)this.B[i];
                if (this.A[i] > 0) {
                    sumAcoloc += (double)this.A[i];
                }
            }
            if (this.B[i] > thrB) {
                sumBThr += (double)this.B[i];
                if (this.A[i] > thrA) {
                    sumAcolocThr += (double)this.A[i];
                }
            }
            if (this.A[i] > 0) {
                sumA += (double)this.A[i];
                if (this.B[i] > 0) {
                    sumBcoloc += (double)this.B[i];
                }
            }
            if (this.A[i] <= thrA) continue;
            sumAThr += (double)this.A[i];
            if (this.B[i] <= thrB) continue;
            sumBcolocThr += (double)this.B[i];
        }
        double M1 = sumAcoloc / sumA;
        double M1Thr = sumAcolocThr / sumAThr;
        double M2 = sumBcoloc / sumB;
        double M2Thr = sumBcolocThr / sumBThr;
        double[] res = new double[]{M1, M2, M1Thr, M2Thr};
        if (this.verbose) {
            IJ.log((String)("\nManders' Coefficients (original):\nM1=" + this.round(M1, 3) + " (fraction of A overlapping B)\nM2=" + this.round(M2, 3) + " (fraction of B overlapping A)"));
        }
        if (this.verbose) {
            IJ.log((String)("\nManders' Coefficients (using threshold value of " + thrA + " for imgA and " + thrB + " for imgB):\nM1=" + this.round(M1Thr, 3) + " (fraction of A overlapping B)\nM2=" + this.round(M2Thr, 3) + " (fraction of B overlapping A)"));
        }
        return res;
    }

    public void CostesAutoThr() {
        int LoopMax;
        int i;
        int CostesThrA = this.Amax;
        int CostesThrB = this.Bmax;
        double CostesSumAThr = 0.0;
        double CostesSumA = 0.0;
        double CostesSumBThr = 0.0;
        double CostesSumB = 0.0;
        double CostesPearson = 1.0;
        double[] rx = new double[this.Amax - this.Amin + 1];
        double[] ry = new double[this.Amax - this.Amin + 1];
        double rmax = 0.0;
        double rmin = 1.0;
        this.doThat = true;
        int count = 0;
        this.doThat = true;
        double[] tmp = this.linreg(this.A, this.B, 0, 0);
        double a = tmp[0];
        double b = tmp[1];
        double CoeffCorr = tmp[2];
        this.doThat = false;
        int LoopMin = (int)Math.max((double)this.Amin, ((double)this.Bmin - b) / a);
        for (i = LoopMax = (int)Math.min((double)this.Amax, ((double)this.Bmax - b) / a); i >= LoopMin; --i) {
            IJ.showStatus((String)("Costes' threshold calculation in progress : " + 100 * (LoopMax - i) / (LoopMax - LoopMin) + "% done"));
            if (IJ.escapePressed()) {
                IJ.showStatus((String)"Task canceled by user");
                return;
            }
            CostesPearson = this.linregCostes(this.A, this.B, i, (int)(a * (double)i + b))[2];
            rx[count] = i;
            ry[count] = CostesPearson;
            if (Double.valueOf(CostesPearson).isNaN()) {
                ry[count] = count != LoopMax ? ry[count - 1] : 1.0;
            }
            if (CostesPearson <= rmin && i != LoopMax) {
                CostesThrA = i;
                CostesThrB = (int)(a * (double)i + b);
            }
            rmax = Math.max(rmax, ry[count]);
            rmin = Math.min(rmin, ry[count]);
            ++count;
        }
        for (i = 0; i < this.length; ++i) {
            CostesSumA += (double)this.A[i];
            if (this.A[i] > CostesThrA) {
                CostesSumAThr += (double)this.A[i];
            }
            CostesSumB += (double)this.B[i];
            if (this.B[i] <= CostesThrB) continue;
            CostesSumBThr += (double)this.B[i];
        }
        if (this.verbose) {
            Plot plot = new Plot("Costes' threshold " + this.titleA + " and " + this.titleB, "ThrA", "Pearson's coefficient below", rx, ry);
            plot.setLimits((double)LoopMin, (double)LoopMax, rmin, rmax);
            plot.setColor(Color.black);
            plot.draw();
            double[] xline = new double[]{CostesThrA, CostesThrA};
            double[] yline = new double[]{rmin, rmax};
            plot.setColor(Color.red);
            plot.addPoints(xline, yline, 2);
            plot.show();
        }
        ImagePlus CostesMask = NewImage.createRGBImage((String)"Costes' mask", (int)this.width, (int)this.height, (int)this.nbSlices, (int)0);
        CostesMask.getProcessor().setValue(Math.pow(2.0, this.depth));
        for (int k = 1; k <= this.nbSlices; ++k) {
            CostesMask.setSlice(k);
            for (int j = 0; j < this.height; ++j) {
                for (int i2 = 0; i2 < this.width; ++i2) {
                    int position = this.offset(i2, j, k);
                    int[] color = new int[]{this.A[position], this.B[position], 0};
                    if (color[0] > CostesThrA && color[1] > CostesThrB) {
                        for (int l = 0; l <= 2; ++l) {
                            color[l] = 255;
                        }
                    }
                    CostesMask.getProcessor().putPixel(i2, j, color);
                }
            }
        }
        CostesMask.setCalibration(this.cal);
        CostesMask.setSlice(1);
        CostesMask.show();
        IJ.showStatus((String)"");
        this.doThat = true;
        if (this.verbose) {
            IJ.log((String)("\nCostes' automatic threshold set to " + CostesThrA + " for imgA & " + CostesThrB + " for imgB"));
            IJ.log((String)("Pearson's Coefficient:\nr=" + this.round(this.linreg(this.A, this.B, CostesThrA, CostesThrB)[2], 3) + " (" + this.round(CostesPearson, 3) + " below thresholds)"));
            IJ.log((String)("M1=" + this.round(CostesSumAThr / CostesSumA, 3) + " & M2=" + this.round(CostesSumBThr / CostesSumB, 3)));
        }
    }

    public void CCF(int CCFx) {
        double CCF0 = 0.0;
        double CCFmin = 0.0;
        int lmin = -CCFx;
        double CCFmax = 0.0;
        int lmax = -CCFx;
        double[] CCFarray = new double[2 * CCFx + 1];
        double[] x = new double[2 * CCFx + 1];
        int count = 0;
        if (this.verbose) {
            IJ.log((String)("\nVan Steensel's Cross-correlation Coefficient between " + this.titleA + " and " + this.titleB + ":"));
        }
        for (int l = -CCFx; l <= CCFx; ++l) {
            int coordShift;
            int coord;
            int i;
            int j;
            int k;
            if (this.verbose) {
                IJ.showStatus((String)("CCF calculation in progress: " + (count + 1) + "/" + (2 * CCFx + 1)));
            }
            if (IJ.escapePressed()) {
                IJ.showStatus((String)"Task canceled by user");
                return;
            }
            double meanA = 0.0;
            double meanB = 0.0;
            double nPoints = 0.0;
            for (k = 1; k <= this.nbSlices; ++k) {
                for (j = 0; j < this.height; ++j) {
                    for (i = 0; i < this.width; ++i) {
                        if (i + l < 0 || i + l >= this.width) continue;
                        coord = this.offset(i, j, k);
                        coordShift = this.offset(i + l, j, k);
                        meanA += (double)this.A[coord];
                        meanB += (double)this.B[coordShift];
                        nPoints += 1.0;
                    }
                }
            }
            meanA /= nPoints;
            meanB /= nPoints;
            double num = 0.0;
            double den1 = 0.0;
            double den2 = 0.0;
            for (k = 1; k <= this.nbSlices; ++k) {
                for (j = 0; j < this.height; ++j) {
                    for (i = 0; i < this.width; ++i) {
                        if (i + l < 0 || i + l >= this.width) continue;
                        coord = this.offset(i, j, k);
                        coordShift = this.offset(i + l, j, k);
                        num += ((double)this.A[coord] - meanA) * ((double)this.B[coordShift] - meanB);
                        den1 += Math.pow((double)this.A[coord] - meanA, 2.0);
                        den2 += Math.pow((double)this.B[coordShift] - meanB, 2.0);
                    }
                }
            }
            double CCF = num / Math.sqrt(den1 * den2);
            if (l == -CCFx) {
                CCF0 = CCF;
                CCFmin = CCF;
                CCFmax = CCF;
            } else {
                if (CCF < CCFmin) {
                    CCFmin = CCF;
                    lmin = l;
                }
                if (CCF > CCFmax) {
                    CCFmax = CCF;
                    lmax = l;
                }
            }
            x[count] = l;
            CCFarray[count] = CCF;
            ++count;
        }
        IJ.log((String)("CCF min.: " + this.round(CCFmin, 3) + " (obtained for dx=" + lmin + ") CCF max.: " + this.round(CCFmax, 3) + " (obtained for dx=" + lmax + ")"));
        Plot plot = new Plot("Van Steensel's CCF between " + this.titleA + " and " + this.titleB, "dx", "CCF", x, CCFarray);
        plot.setLimits((double)(-CCFx), (double)CCFx, CCFmin - (CCFmax - CCFmin) * 0.05, CCFmax + (CCFmax - CCFmin) * 0.05);
        plot.setColor(Color.white);
        plot.draw();
        plot.setColor(Color.black);
        plot.addPoints(x, CCFarray, 0);
        double[] xline = new double[]{0.0, 0.0};
        double[] yline = new double[]{CCFmin - (CCFmax - CCFmin) * 0.05, CCFmax + (CCFmax - CCFmin) * 0.05};
        plot.setColor(Color.red);
        plot.addPoints(xline, yline, 2);
        CurveFitter cf = new CurveFitter(x, CCFarray);
        double[] param = new double[]{CCFmin, CCFmax, lmax, CCFx};
        cf.setInitialParameters(param);
        cf.doFit(12);
        param = cf.getParams();
        IJ.log((String)("\nResults for fitting CCF on a Gaussian (CCF=a+(b-a)exp(-(xshift-c)^2/(2d^2))):" + cf.getResultString() + "\nFWHM=" + Math.abs(this.round(2.0 * Math.sqrt(2.0 * Math.log(2.0)) * param[3], 3)) + " pixels"));
        for (int i = 0; i < x.length; ++i) {
            CCFarray[i] = CurveFitter.f((int)12, (double[])param, (double)x[i]);
        }
        plot.setColor(Color.BLUE);
        plot.addPoints(x, CCFarray, 2);
        IJ.showStatus((String)"");
        plot.show();
    }

    public void CytoFluo() {
        double[] Adb = this.int2double(this.A);
        double[] Bdb = this.int2double(this.B);
        Plot plot = new Plot("Cytofluorogram between " + this.titleA + " and " + this.titleB, this.titleA, this.titleB, Adb, Bdb);
        double limHigh = Math.max(this.Amax, this.Bmax);
        double limLow = Math.min(this.Amin, this.Bmin);
        plot.setLimits((double)this.Amin, (double)this.Amax, (double)this.Bmin, (double)this.Bmax);
        plot.setColor(Color.white);
        this.doThat = true;
        double[] tmp = this.linreg(this.A, this.B, 0, 0);
        double a = tmp[0];
        double b = tmp[1];
        double CoeffCorr = tmp[2];
        plot.draw();
        plot.setColor(Color.black);
        plot.addPoints(Adb, Bdb, 6);
        double[] xline = new double[]{limLow, limHigh};
        double[] yline = new double[]{a * limLow + b, a * limHigh + b};
        plot.setColor(Color.red);
        plot.addPoints(xline, yline, 2);
        plot.show();
        IJ.log((String)("\nCytofluorogram's parameters:\na: " + this.round(a, 3) + "\nb: " + this.round(b, 3) + "\nCorrelation coefficient: " + this.round(CoeffCorr, 3)));
    }

    private double ICA() {
        int i;
        double[] Anorm = new double[this.length];
        double[] Bnorm = new double[this.length];
        double AnormMean = 0.0;
        double BnormMean = 0.0;
        double prodMin = 0.0;
        double prodMax = 0.0;
        double lim = 0.0;
        double[] x = new double[this.length];
        double ICQ = 0.0;
        for (i = 0; i < this.length; ++i) {
            Anorm[i] = (double)(this.A[i] - this.Amin) / (double)this.Amax;
            Bnorm[i] = (double)(this.B[i] - this.Bmin) / (double)this.Bmax;
            AnormMean += Anorm[i];
            BnormMean += Bnorm[i];
        }
        AnormMean /= (double)this.length;
        BnormMean /= (double)this.length;
        for (i = 0; i < this.length; ++i) {
            x[i] = (Anorm[i] - AnormMean) * (Bnorm[i] - BnormMean);
            if (x[i] > prodMax) {
                prodMax = x[i];
            }
            if (x[i] < prodMin) {
                prodMin = x[i];
            }
            if (!(x[i] > 0.0)) continue;
            ICQ += 1.0;
        }
        lim = Math.abs(prodMin) > Math.abs(prodMax) ? Math.abs(prodMin) : Math.abs(prodMax);
        ICQ = ICQ / (double)this.length - 0.5;
        if (this.verbose) {
            Plot plotA = new Plot("ICA A (" + this.titleA + ")", "(Ai-a)(Bi-b)", this.titleA, new double[]{0.0, 0.0}, new double[]{0.0, 0.0});
            plotA.setColor(Color.white);
            plotA.setLimits(-lim, lim, 0.0, 1.0);
            plotA.draw();
            plotA.setColor(Color.black);
            plotA.addPoints(x, Anorm, 6);
            plotA.draw();
            plotA.setColor(Color.red);
            plotA.drawLine(0.0, 0.0, 0.0, 1.0);
            plotA.show();
            Plot plotB = new Plot("ICA B (" + this.titleB + ")", "(Ai-a)(Bi-b)", this.titleB, new double[]{0.0, 0.0}, new double[]{0.0, 0.0});
            plotB.setColor(Color.white);
            plotB.setLimits(-lim, lim, 0.0, 1.0);
            plotB.draw();
            plotB.setColor(Color.black);
            plotB.addPoints(x, Bnorm, 6);
            plotB.setColor(Color.red);
            plotB.drawLine(0.0, 0.0, 0.0, 1.0);
            plotB.show();
            IJ.log((String)("\nLi's Intensity correlation coefficient:\nICQ: " + ICQ));
        }
        return ICQ;
    }

    public double getICQ() {
        return this.ICA();
    }

    public void CostesRand(int xyBlock, int zBlock, int nbRand, double binWidth, int fillMeth, boolean xyRand, boolean zRand, boolean showRand) {
        int i;
        if (fillMeth == 0) {
            this.widthCostes = this.width / xyBlock * xyBlock;
            this.heightCostes = this.height / xyBlock * xyBlock;
        } else {
            this.widthCostes = (this.width / xyBlock + 1) * xyBlock;
            this.heightCostes = (this.height / xyBlock + 1) * xyBlock;
        }
        if (zRand) {
            this.nbsliceCostes = fillMeth == 0 ? this.nbSlices / zBlock * zBlock : (this.nbSlices / zBlock + 1) * zBlock;
            if (this.nbSlices == 1) {
                this.nbsliceCostes = 1;
            }
        } else {
            this.nbsliceCostes = this.nbSlices;
        }
        this.lengthCostes = this.widthCostes * this.heightCostes * this.nbsliceCostes;
        int[] ACostes = new int[this.lengthCostes];
        int[] BCostes = new int[this.lengthCostes];
        int[] BRandCostes = new int[this.lengthCostes];
        int index = 0;
        for (int k = 1; k <= this.nbsliceCostes; ++k) {
            for (int j = 0; j < this.heightCostes; ++j) {
                for (int i2 = 0; i2 < this.widthCostes; ++i2) {
                    int offset = this.offset(i2, j, k);
                    ACostes[index] = this.A[offset];
                    BCostes[index] = this.B[offset];
                    ++index;
                }
            }
        }
        if (xyRand || this.nbsliceCostes == 1) {
            zBlock = 1;
            zRand = false;
        }
        this.doThat = true;
        double r2test = this.linreg(ACostes, BCostes, 0, 0)[2];
        this.doThat = false;
        double[] arrayR = new double[nbRand];
        double mean = 0.0;
        double SD = 0.0;
        double Pval = 0.0;
        double[] arrayDistribR = new double[(int)(2.0 / binWidth + 1.0)];
        double[] x = new double[arrayDistribR.length];
        for (int f = 0; f < nbRand; ++f) {
            int newposition;
            int c;
            int b;
            int a;
            int shift;
            int d;
            int e;
            for (e = 1; e <= this.nbsliceCostes - zBlock + 1; e += zBlock) {
                for (d = 0; d < this.heightCostes - xyBlock + 1; d += xyBlock) {
                    double direction = 1.0;
                    if (Math.random() < 0.5) {
                        direction = -1.0;
                    }
                    shift = (int)(direction * Math.random() * (double)this.widthCostes / (double)xyBlock) * xyBlock;
                    for (a = 0; a < this.widthCostes; ++a) {
                        for (b = d; b < d + xyBlock; ++b) {
                            for (c = e; c < e + zBlock; ++c) {
                                newposition = a + shift;
                                if (newposition >= this.widthCostes) {
                                    newposition -= this.widthCostes;
                                }
                                if (newposition < 0) {
                                    newposition += this.widthCostes;
                                }
                                BRandCostes[this.offsetCostes((int)newposition, (int)b, (int)c)] = BCostes[this.offsetCostes(a, b, c)];
                            }
                        }
                    }
                }
            }
            System.arraycopy(BRandCostes, 0, BCostes, 0, BCostes.length);
            for (e = 1; e <= this.nbsliceCostes - zBlock + 1; e += zBlock) {
                for (d = 0; d < this.widthCostes - xyBlock + 1; d += xyBlock) {
                    double direction = 1.0;
                    if (Math.random() < 0.5) {
                        direction = -1.0;
                    }
                    shift = (int)(direction * Math.random() * (double)this.heightCostes / (double)xyBlock) * xyBlock;
                    for (a = 0; a < this.heightCostes; ++a) {
                        for (b = d; b < d + xyBlock; ++b) {
                            for (c = e; c < e + zBlock; ++c) {
                                newposition = a + shift;
                                if (newposition >= this.heightCostes) {
                                    newposition -= this.heightCostes;
                                }
                                if (newposition < 0) {
                                    newposition += this.heightCostes;
                                }
                                BRandCostes[this.offsetCostes((int)b, (int)newposition, (int)c)] = BCostes[this.offsetCostes(b, a, c)];
                            }
                        }
                    }
                }
            }
            System.arraycopy(BRandCostes, 0, BCostes, 0, BCostes.length);
            if (zRand) {
                for (e = 0; e < this.heightCostes - xyBlock + 1; e += xyBlock) {
                    for (d = 0; d < this.widthCostes - xyBlock + 1; d += xyBlock) {
                        double direction = 1.0;
                        if (Math.random() < 0.5) {
                            direction = -1.0;
                        }
                        shift = (int)(direction * Math.random() * (double)this.nbsliceCostes / (double)zBlock) * zBlock;
                        for (a = 1; a <= this.nbsliceCostes; ++a) {
                            for (b = d; b < d + xyBlock; ++b) {
                                for (c = e; c < e + xyBlock; ++c) {
                                    newposition = a + shift;
                                    if (newposition > this.nbsliceCostes) {
                                        newposition -= this.nbsliceCostes;
                                    }
                                    if (newposition < 1) {
                                        newposition += this.nbsliceCostes;
                                    }
                                    BRandCostes[this.offsetCostes((int)b, (int)c, (int)newposition)] = BCostes[this.offsetCostes(b, c, a)];
                                }
                            }
                        }
                    }
                }
                System.arraycopy(BRandCostes, 0, BCostes, 0, BCostes.length);
            }
            arrayR[f] = this.linreg(ACostes, BCostes, 0, 0)[2];
            mean += arrayR[f];
            int n = (int)((arrayR[f] + 1.0) / binWidth);
            arrayDistribR[n] = arrayDistribR[n] + 1.0;
            int n2 = (int)((arrayR[f] + 1.0) / binWidth);
            x[n2] = x[n2] + arrayR[f];
            IJ.showStatus((String)("Costes' randomization loop n\ufffd" + f + "/" + nbRand));
        }
        if (showRand) {
            ImagePlus Rand = NewImage.createImage((String)("Randomized images of " + this.titleB), (int)this.widthCostes, (int)this.heightCostes, (int)this.nbsliceCostes, (int)this.depth, (int)1);
            index = 0;
            for (int k = 1; k <= this.nbsliceCostes; ++k) {
                Rand.setSlice(k);
                for (int j = 0; j < this.heightCostes; ++j) {
                    for (int i3 = 0; i3 < this.widthCostes; ++i3) {
                        Rand.getProcessor().putPixel(i3, j, BRandCostes[index]);
                        ++index;
                    }
                }
            }
            Rand.setCalibration(this.cal);
            Rand.setSlice(1);
            Rand.show();
            IJ.setMinAndMax((double)this.Bmin, (double)this.Bmax);
        }
        double minx = -1.0;
        double maxx = 1.0;
        double maxy = 0.0;
        for (i = 0; i < arrayDistribR.length; ++i) {
            x[i] = arrayDistribR[i] == 0.0 ? (double)i * binWidth - 1.0 + binWidth / 2.0 : x[i] / arrayDistribR[i];
        }
        i = 0;
        while (i < arrayDistribR.length) {
            int n = i++;
            arrayDistribR[n] = arrayDistribR[n] / (double)nbRand;
        }
        for (i = 0; i < arrayDistribR.length; ++i) {
            if (minx == -1.0 && arrayDistribR[i] != 0.0) {
                minx = x[i];
            }
            if (!(maxy < arrayDistribR[i])) continue;
            maxy = arrayDistribR[i];
        }
        minx = Math.min(minx, r2test);
        i = arrayDistribR.length - 1;
        while (arrayDistribR[i] == 0.0) {
            maxx = x[i];
            --i;
        }
        maxx = Math.max(maxx, r2test);
        int newLength = 0;
        for (i = 0; i < arrayDistribR.length; ++i) {
            if (arrayDistribR[i] == 0.0) continue;
            ++newLength;
        }
        double[] xNew = new double[newLength];
        double[] arrayNew = new double[newLength];
        newLength = 0;
        for (i = 0; i < arrayDistribR.length; ++i) {
            if (arrayDistribR[i] == 0.0) continue;
            xNew[newLength] = x[i];
            arrayNew[newLength++] = arrayDistribR[i];
        }
        x = xNew;
        arrayDistribR = arrayNew;
        Plot plot = new Plot("Costes' method (" + this.titleA + " & " + this.titleB + ")", "r", "Probability density of r", x, arrayDistribR);
        plot.setLimits(minx - 10.0 * binWidth, maxx + 10.0 * binWidth, 0.0, maxy * 1.05);
        plot.setColor(Color.white);
        plot.draw();
        plot.setColor(Color.black);
        plot.addPoints(x, arrayDistribR, 0);
        double[] xline = new double[]{r2test, r2test};
        double[] yline = new double[]{0.0, maxy * 1.05};
        plot.setColor(Color.red);
        plot.addPoints(xline, yline, 2);
        for (i = 1; i < nbRand; ++i) {
            SD += Math.pow(arrayR[i] - mean, 2.0);
        }
        SD = Math.sqrt(SD / (double)(nbRand - 1));
        IJ.log((String)("\nCostes' randomization based colocalization:\nParameters: Nb of randomization rounds: " + nbRand + ", Resolution (bin width): " + binWidth));
        CurveFitter cf = new CurveFitter(x, arrayDistribR);
        double[] param = new double[]{0.0, maxy, mean /= (double)nbRand, SD};
        cf.setInitialParameters(param);
        cf.doFit(12);
        param = cf.getParams();
        mean = param[2];
        SD = param[3];
        double[] b = new double[]{0.31938153, -0.356563782, 1.781477937, -1.821255978, 1.330274429};
        double p = 0.2316419;
        double z = 1.0 / Math.sqrt(Math.PI * 2) * Math.exp(-Math.pow((r2test - mean) / SD, 2.0) / 2.0);
        double t = 1.0 / (1.0 + p * Math.abs((r2test - mean) / SD));
        Pval = r2test >= 0.0 ? 1.0 - z * t * (t * (t * (t * (t * b[4] + b[3]) + b[2]) + b[1]) + b[0]) : z * t * (t * (t * (t * (t * b[4] + b[3]) + b[2]) + b[1]) + b[0]);
        IJ.log((String)("r (original)=" + this.round(r2test, 3) + "\nr (randomized)=" + this.round(mean, 3) + "\ufffd" + this.round(SD, 3) + " (calculated from the fitted data)\nP-value=" + this.round(Pval * 100.0, 2) + "% (calculated from the fitted data)"));
        IJ.log((String)("\nResults for fitting the probability density function on a Gaussian (Probability=a+(b-a)exp(-(R-c)^2/(2d^2))):" + cf.getResultString() + "\nFWHM=" + Math.abs(this.round(2.0 * Math.sqrt(2.0 * Math.log(2.0)) * param[3], 3))));
        for (i = 0; i < x.length; ++i) {
            arrayDistribR[i] = CurveFitter.f((int)12, (double[])param, (double)x[i]);
        }
        plot.setColor(Color.BLUE);
        plot.addPoints(x, arrayDistribR, 2);
        plot.show();
    }

    private void buildArray(ImagePlus imgA, ImagePlus imgB) {
        int index = 0;
        this.Amin = (int)Math.pow(2.0, this.depth);
        this.Amax = 0;
        this.Amean = 0.0;
        this.Bmin = this.Amin;
        this.Bmax = 0;
        this.Bmean = 0.0;
        for (int z = 1; z <= this.nbSlices; ++z) {
            imgA.setSlice(z);
            imgB.setSlice(z);
            ImageStatistics stA = imgA.getStatistics();
            ImageStatistics stB = imgB.getStatistics();
            this.Amin = Math.min(this.Amin, (int)stA.min);
            this.Bmin = Math.min(this.Bmin, (int)stB.min);
            this.Amax = Math.max(this.Amax, (int)stA.max);
            this.Bmax = Math.max(this.Bmax, (int)stB.max);
            this.Amean += (double)stA.pixelCount * stA.mean;
            this.Bmean += (double)stB.pixelCount * stB.mean;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.A[index] = imgA.getProcessor().getPixel(x, y);
                    this.B[index] = imgB.getProcessor().getPixel(x, y);
                    ++index;
                }
            }
            this.Amean /= (double)this.length;
            this.Bmean /= (double)this.length;
        }
    }

    private ImagePlus buildImg(int[] array, String title) {
        int index = 0;
        double min = array[0];
        double max = array[0];
        ImagePlus img = NewImage.createImage((String)title, (int)this.width, (int)this.height, (int)this.nbSlices, (int)this.depth, (int)1);
        for (int z = 1; z <= this.nbSlices; ++z) {
            IJ.showStatus((String)"Creating the image...");
            img.setSlice(z);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int currVal = array[index];
                    min = Math.min(min, (double)currVal);
                    max = Math.max(max, (double)currVal);
                    img.getProcessor().putPixel(x, y, currVal);
                    ++index;
                }
            }
        }
        IJ.showStatus((String)"");
        img.setCalibration(this.micronCal);
        img.getProcessor().setMinAndMax(min, max);
        return img;
    }

    public double[] linreg(int[] Aarray, int[] Barray, int TA, int TB) {
        int m;
        double num = 0.0;
        double den1 = 0.0;
        double den2 = 0.0;
        double[] coeff = new double[6];
        int count = 0;
        if (this.doThat) {
            this.sumA = 0.0;
            this.sumB = 0.0;
            this.sumAB = 0.0;
            this.sumsqrA = 0.0;
            this.Aarraymean = 0.0;
            this.Barraymean = 0.0;
            for (m = 0; m < Aarray.length; ++m) {
                if (Aarray[m] < TA || Barray[m] < TB) continue;
                this.sumA += (double)Aarray[m];
                this.sumB += (double)Barray[m];
                this.sumAB += (double)(Aarray[m] * Barray[m]);
                this.sumsqrA += Math.pow(Aarray[m], 2.0);
                ++count;
            }
            this.Aarraymean = this.sumA / (double)count;
            this.Barraymean = this.sumB / (double)count;
        }
        for (m = 0; m < Aarray.length; ++m) {
            if (Aarray[m] < TA || Barray[m] < TB) continue;
            num += ((double)Aarray[m] - this.Aarraymean) * ((double)Barray[m] - this.Barraymean);
            den1 += Math.pow((double)Aarray[m] - this.Aarraymean, 2.0);
            den2 += Math.pow((double)Barray[m] - this.Barraymean, 2.0);
        }
        coeff[0] = ((double)count * this.sumAB - this.sumA * this.sumB) / ((double)count * this.sumsqrA - Math.pow(this.sumA, 2.0));
        coeff[1] = (this.sumsqrA * this.sumB - this.sumA * this.sumAB) / ((double)count * this.sumsqrA - Math.pow(this.sumA, 2.0));
        coeff[2] = num / Math.sqrt(den1 * den2);
        coeff[3] = num;
        coeff[4] = den1;
        coeff[5] = den2;
        return coeff;
    }

    public double[] linregCostes(int[] Aarray, int[] Barray, int TA, int TB) {
        int m;
        double num = 0.0;
        double den1 = 0.0;
        double den2 = 0.0;
        double[] coeff = new double[3];
        int count = 0;
        this.sumA = 0.0;
        this.sumB = 0.0;
        this.sumAB = 0.0;
        this.sumsqrA = 0.0;
        this.Aarraymean = 0.0;
        this.Barraymean = 0.0;
        for (m = 0; m < Aarray.length; ++m) {
            if (Aarray[m] >= TA || Barray[m] >= TB) continue;
            this.sumA += (double)Aarray[m];
            this.sumB += (double)Barray[m];
            this.sumAB += (double)(Aarray[m] * Barray[m]);
            this.sumsqrA += Math.pow(Aarray[m], 2.0);
            ++count;
        }
        this.Aarraymean = this.sumA / (double)count;
        this.Barraymean = this.sumB / (double)count;
        for (m = 0; m < Aarray.length; ++m) {
            if (Aarray[m] >= TA || Barray[m] >= TB) continue;
            num += ((double)Aarray[m] - this.Aarraymean) * ((double)Barray[m] - this.Barraymean);
            den1 += Math.pow((double)Aarray[m] - this.Aarraymean, 2.0);
            den2 += Math.pow((double)Barray[m] - this.Barraymean, 2.0);
        }
        coeff[0] = ((double)count * this.sumAB - this.sumA * this.sumB) / ((double)count * this.sumsqrA - Math.pow(this.sumA, 2.0));
        coeff[1] = (this.sumsqrA * this.sumB - this.sumA * this.sumAB) / ((double)count * this.sumsqrA - Math.pow(this.sumA, 2.0));
        coeff[2] = num / Math.sqrt(den1 * den2);
        return coeff;
    }

    private double[] int2double(int[] input) {
        double[] output = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    private int offset(int x, int y, int z) {
        if (x + y * this.width + (z - 1) * this.width * this.height >= this.width * this.height * this.nbSlices) {
            return this.width * this.height * this.nbSlices - 1;
        }
        if (x + y * this.width + (z - 1) * this.width * this.height < 0) {
            return 0;
        }
        return x + y * this.width + (z - 1) * this.width * this.height;
    }

    public int offsetCostes(int m, int n, int o) {
        if (m + n * this.widthCostes + (o - 1) * this.widthCostes * this.heightCostes >= this.widthCostes * this.heightCostes * this.nbsliceCostes) {
            return this.widthCostes * this.heightCostes * this.nbsliceCostes - 1;
        }
        if (m + n * this.widthCostes + (o - 1) * this.widthCostes * this.heightCostes < 0) {
            return 0;
        }
        return m + n * this.widthCostes + (o - 1) * this.widthCostes * this.heightCostes;
    }

    public double round(double y, int z) {
        y *= Math.pow(10.0, z);
        y = (int)y;
        return y /= Math.pow(10.0, z);
    }
}

