/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array3D;
import mitiv.array.Byte3D;
import mitiv.array.Double3D;
import mitiv.array.Float1D;
import mitiv.array.Float2D;
import mitiv.array.FloatArray;
import mitiv.array.Int3D;
import mitiv.array.Long3D;
import mitiv.array.ShapedArray;
import mitiv.array.Short3D;
import mitiv.array.impl.FlatFloat3D;
import mitiv.array.impl.StriddenFloat3D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.FloatGenerator;

public abstract class Float3D
extends Array3D
implements FloatArray {
    protected Float3D(int dim1, int dim2, int dim3) {
        super(dim1, dim2, dim3);
    }

    protected Float3D(int[] dims) {
        super(dims);
    }

    protected Float3D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 4;
    }

    public abstract float get(int var1, int var2, int var3);

    public abstract void set(int var1, int var2, int var3, float var4);

    @Override
    public void fill(float value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, value);
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, value);
                    }
                }
            }
        }
    }

    @Override
    public void increment(float value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) + value);
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) + value);
                    }
                }
            }
        }
    }

    @Override
    public void decrement(float value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) - value);
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) - value);
                    }
                }
            }
        }
    }

    @Override
    public void scale(float value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) * value);
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) * value);
                    }
                }
            }
        }
    }

    @Override
    public void map(FloatFunction function) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, function.apply(this.get(i1, i2, i3)));
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, function.apply(this.get(i1, i2, i3)));
                    }
                }
            }
        }
    }

    @Override
    public void fill(FloatGenerator generator) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, generator.nextFloat());
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, generator.nextFloat());
                    }
                }
            }
        }
    }

    @Override
    public void scan(FloatScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        if (initialized) {
                            scanner.update(this.get(i1, i2, i3));
                            continue;
                        }
                        scanner.initialize(this.get(i1, i2, i3));
                        initialized = true;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        if (initialized) {
                            scanner.update(this.get(i1, i2, i3));
                            continue;
                        }
                        scanner.initialize(this.get(i1, i2, i3));
                        initialized = true;
                    }
                }
            }
        }
    }

    @Override
    public final float[] flatten() {
        return this.flatten(false);
    }

    @Override
    public float min() {
        float minValue = this.get(0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        if (skip) {
                            skip = false;
                            continue;
                        }
                        float value = this.get(i1, i2, i3);
                        if (!(value < minValue)) continue;
                        minValue = value;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        if (skip) {
                            skip = false;
                            continue;
                        }
                        float value = this.get(i1, i2, i3);
                        if (!(value < minValue)) continue;
                        minValue = value;
                    }
                }
            }
        }
        return minValue;
    }

    @Override
    public float max() {
        float maxValue = this.get(0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        if (skip) {
                            skip = false;
                            continue;
                        }
                        float value = this.get(i1, i2, i3);
                        if (!(value > maxValue)) continue;
                        maxValue = value;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        if (skip) {
                            skip = false;
                            continue;
                        }
                        float value = this.get(i1, i2, i3);
                        if (!(value > maxValue)) continue;
                        maxValue = value;
                    }
                }
            }
        }
        return maxValue;
    }

    @Override
    public float[] getMinAndMax() {
        float[] result = new float[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(float[] mm) {
        float minValue;
        float maxValue = minValue = this.get(0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        if (skip) {
                            skip = false;
                            continue;
                        }
                        float value = this.get(i1, i2, i3);
                        if (value < minValue) {
                            minValue = value;
                        }
                        if (!(value > maxValue)) continue;
                        maxValue = value;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        if (skip) {
                            skip = false;
                            continue;
                        }
                        float value = this.get(i1, i2, i3);
                        if (value < minValue) {
                            minValue = value;
                        }
                        if (!(value > maxValue)) continue;
                        maxValue = value;
                    }
                }
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public float sum() {
        float totalValue = 0.0f;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        totalValue += this.get(i1, i2, i3);
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        totalValue += this.get(i1, i2, i3);
                    }
                }
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte3D toByte() {
        byte[] out = new byte[this.number];
        if (this.isFlat()) {
            float[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (byte)inp[i];
            }
        } else {
            int i = -1;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        out[++i] = (byte)this.get(i1, i2, i3);
                    }
                }
            }
        }
        return Byte3D.wrap(out, this.getShape());
    }

    @Override
    public Short3D toShort() {
        short[] out = new short[this.number];
        if (this.isFlat()) {
            float[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (short)inp[i];
            }
        } else {
            int i = -1;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        out[++i] = (short)this.get(i1, i2, i3);
                    }
                }
            }
        }
        return Short3D.wrap(out, this.getShape());
    }

    @Override
    public Int3D toInt() {
        int[] out = new int[this.number];
        if (this.isFlat()) {
            float[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (int)inp[i];
            }
        } else {
            int i = -1;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        out[++i] = (int)this.get(i1, i2, i3);
                    }
                }
            }
        }
        return Int3D.wrap(out, this.getShape());
    }

    @Override
    public Long3D toLong() {
        long[] out = new long[this.number];
        if (this.isFlat()) {
            float[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (long)inp[i];
            }
        } else {
            int i = -1;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        out[++i] = (long)this.get(i1, i2, i3);
                    }
                }
            }
        }
        return Long3D.wrap(out, this.getShape());
    }

    @Override
    public Float3D toFloat() {
        return this;
    }

    @Override
    public Double3D toDouble() {
        double[] out = new double[this.number];
        if (this.isFlat()) {
            float[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i];
            }
        } else {
            int i = -1;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        out[++i] = this.get(i1, i2, i3);
                    }
                }
            }
        }
        return Double3D.wrap(out, this.getShape());
    }

    @Override
    public Float3D copy() {
        return new FlatFloat3D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Float3D src = arr.getType() == 4 ? (Float3D)arr : (Float3D)arr.toFloat();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, src.get(i1, i2, i3));
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, src.get(i1, i2, i3));
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, (float)src.get(++i));
                    }
                }
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, (float)src.get(++i));
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Float3D create() {
        return new FlatFloat3D(this.getShape());
    }

    public static Float3D create(int dim1, int dim2, int dim3) {
        return new FlatFloat3D(dim1, dim2, dim3);
    }

    public static Float3D create(int[] dims) {
        return new FlatFloat3D(dims);
    }

    public static Float3D create(Shape shape) {
        return new FlatFloat3D(shape);
    }

    public static Float3D wrap(float[] data, int dim1, int dim2, int dim3) {
        return new FlatFloat3D(data, dim1, dim2, dim3);
    }

    public static Float3D wrap(float[] data, int[] dims) {
        return new FlatFloat3D(data, dims);
    }

    public static Float3D wrap(float[] data, Shape shape) {
        return new FlatFloat3D(data, shape);
    }

    public static Float3D wrap(float[] data, int offset, int stride1, int stride2, int stride3, int dim1, int dim2, int dim3) {
        return new StriddenFloat3D(data, offset, stride1, stride2, stride3, dim1, dim2, dim3);
    }

    @Override
    public abstract Float2D slice(int var1);

    @Override
    public abstract Float2D slice(int var1, int var2);

    @Override
    public abstract Float3D view(Range var1, Range var2, Range var3);

    @Override
    public abstract Float3D view(int[] var1, int[] var2, int[] var3);

    @Override
    public abstract Float1D as1D();
}

