/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.ByteArray;
import mitiv.array.ByteScalar;
import mitiv.array.DoubleArray;
import mitiv.array.DoubleScalar;
import mitiv.array.Float1D;
import mitiv.array.FloatArray;
import mitiv.array.IntArray;
import mitiv.array.IntScalar;
import mitiv.array.LongArray;
import mitiv.array.LongScalar;
import mitiv.array.Scalar;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.array.ShortScalar;
import mitiv.array.impl.FlatFloat1D;
import mitiv.array.impl.StriddenFloat1D;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.FloatGenerator;

public class FloatScalar
extends Scalar
implements FloatArray {
    final float[] data;
    final int offset;
    final boolean flat;

    public FloatScalar() {
        this.data = new float[1];
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public FloatScalar create() {
        return new FloatScalar();
    }

    public FloatScalar(float[] arr, int idx) {
        this.data = arr;
        this.offset = idx;
        this.flat = idx == 0 && arr.length == 1;
        this.checkSanity();
    }

    public static FloatScalar wrap(float[] arr, int idx) {
        return new FloatScalar(arr, idx);
    }

    public FloatScalar(float value) {
        this.data = new float[]{value};
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public final void checkSanity() {
        if (this.offset < 0 || this.offset >= this.data.length) {
            throw new IndexOutOfBoundsException("Scalar offset is out of bounds");
        }
    }

    @Override
    public final int getType() {
        return 4;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    final int index() {
        return this.offset;
    }

    public final float get() {
        return this.data[this.offset];
    }

    public final void set(float value) {
        this.data[this.offset] = value;
    }

    @Override
    public final void fill(float value) {
        this.data[this.offset] = value;
    }

    @Override
    public final void fill(FloatGenerator generator) {
        this.data[this.offset] = generator.nextFloat();
    }

    @Override
    public final void increment(float value) {
        int n = this.offset;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public final void decrement(float value) {
        int n = this.offset;
        this.data[n] = this.data[n] - value;
    }

    @Override
    public final void scale(float value) {
        int n = this.offset;
        this.data[n] = this.data[n] * value;
    }

    @Override
    public final void map(FloatFunction function) {
        this.data[this.offset] = function.apply(this.data[this.offset]);
    }

    @Override
    public final void scan(FloatScanner scanner) {
        scanner.initialize(this.data[this.offset]);
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public final float[] flatten() {
        return this.flatten(false);
    }

    @Override
    public final float[] flatten(boolean forceCopy) {
        if (!forceCopy && this.flat) {
            return this.data;
        }
        return new float[]{this.data[this.offset]};
    }

    @Override
    public final float[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public float min() {
        return this.data[this.offset];
    }

    @Override
    public float max() {
        return this.data[this.offset];
    }

    @Override
    public float[] getMinAndMax() {
        float[] result = new float[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(float[] mm) {
        float value;
        mm[0] = value = this.data[this.offset];
        mm[1] = value;
    }

    @Override
    public float sum() {
        return this.data[this.offset];
    }

    @Override
    public double average() {
        return this.data[this.offset];
    }

    @Override
    public final ByteArray toByte() {
        return new ByteScalar((byte)this.data[this.offset]);
    }

    @Override
    public final ShortArray toShort() {
        return new ShortScalar((short)this.data[this.offset]);
    }

    @Override
    public final IntArray toInt() {
        return new IntScalar((int)this.data[this.offset]);
    }

    @Override
    public final LongArray toLong() {
        return new LongScalar((long)this.data[this.offset]);
    }

    @Override
    public final FloatArray toFloat() {
        return this;
    }

    @Override
    public final DoubleArray toDouble() {
        return new DoubleScalar(this.data[this.offset]);
    }

    @Override
    public final Float1D as1D() {
        if (this.offset == 0) {
            return new FlatFloat1D(this.data, 1);
        }
        return new StriddenFloat1D(this.data, this.offset, 0, 1);
    }

    @Override
    public final void assign(ShapedArray src) {
        if (!shape.equals(src.getShape())) {
            throw new NonConformableArrayException();
        }
        switch (src.getType()) {
            case 0: {
                this.data[this.offset] = ((ByteScalar)src).get();
                break;
            }
            case 1: {
                this.data[this.offset] = ((ShortScalar)src).get();
                break;
            }
            case 2: {
                this.data[this.offset] = ((IntScalar)src).get();
                break;
            }
            case 3: {
                this.data[this.offset] = ((LongScalar)src).get();
                break;
            }
            case 4: {
                this.data[this.offset] = ((FloatScalar)src).get();
                break;
            }
            case 5: {
                this.data[this.offset] = (float)((DoubleScalar)src).get();
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
    }

    @Override
    public final void assign(ShapedVector src) {
        if (!shape.equals(src.getShape())) {
            throw new NonConformableArrayException();
        }
        this.data[this.offset] = (float)src.get(0);
    }

    @Override
    public final FloatScalar copy() {
        return new FloatScalar(this.data[this.offset]);
    }
}

