/*
 * Decompiled with CFR 0.152.
 */
package mitiv.conv;

import mitiv.array.ArrayUtils;
import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.conv.Convolution;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

abstract class ConvolutionDouble
extends Convolution {
    private double[] wrk = null;
    private double[] mtf = null;

    protected ConvolutionDouble(Shape wrk, ShapedVectorSpace inp, int[] inpOff, ShapedVectorSpace out, int[] outOff) {
        super(wrk, inp, inpOff, out, outOff);
        if (this.getType() != 5) {
            throw new IllegalArgumentException("Input and output vector spaces must be for double data type");
        }
    }

    public double[] getWorkArray() {
        if (this.wrk == null) {
            this.wrk = new double[2 * this.getNumberOfFrequencies()];
        }
        return this.wrk;
    }

    @Override
    public void push(ShapedVector src, boolean adjoint) {
        if (adjoint) {
            if (!src.belongsTo(this.outputSpace)) {
                throw new IncorrectSpaceException("Vector does not belong to output space");
            }
        } else if (!src.belongsTo(this.inputSpace)) {
            throw new IncorrectSpaceException("Vector does not belong to input space");
        }
        this.push(this.getWorkArray(), ((DoubleShapedVector)src).getData(), adjoint);
    }

    @Override
    public void pull(ShapedVector dst, boolean adjoint) {
        if (adjoint) {
            if (!dst.belongsTo(this.inputSpace)) {
                throw new IncorrectSpaceException("Vector does not belong to input space");
            }
        } else if (!dst.belongsTo(this.outputSpace)) {
            throw new IncorrectSpaceException("Vector does not belong to output space");
        }
        this.pull(((DoubleShapedVector)dst).getData(), this.getWorkArray(), adjoint);
    }

    public abstract void push(double[] var1, double[] var2, boolean var3);

    public abstract void pull(double[] var1, double[] var2, boolean var3);

    public abstract void forwardFFT(double[] var1);

    @Override
    public void forwardFFT() {
        this.forwardFFT(this.getWorkArray());
    }

    public abstract void backwardFFT(double[] var1);

    @Override
    public void backwardFFT() {
        this.forwardFFT(this.getWorkArray());
    }

    @Override
    public void convolve(boolean conj) {
        if (this.mtf == null) {
            throw new IllegalArgumentException("You must set the PSF or the MTF first");
        }
        double[] h = this.mtf;
        double[] z = this.getWorkArray();
        int n = this.getNumberOfFrequencies();
        this.forwardFFT();
        if (conj) {
            for (int k = 0; k < n; ++k) {
                int real = k + k;
                int imag = real + 1;
                double h_re = h[real];
                double h_im = h[imag];
                double z_re = z[real];
                double z_im = z[imag];
                z[real] = h_re * z_re + h_im * z_im;
                z[imag] = h_re * z_im - h_im * z_re;
            }
        } else {
            for (int k = 0; k < n; ++k) {
                int real = k + k;
                int imag = real + 1;
                double h_re = h[real];
                double h_im = h[imag];
                double z_re = z[real];
                double z_im = z[imag];
                z[real] = h_re * z_re - h_im * z_im;
                z[imag] = h_re * z_im + h_im * z_re;
            }
        }
        this.backwardFFT(z);
    }

    @Override
    public void setPSF(ShapedVector psf) {
        if (!psf.belongsTo(this.inputSpace)) {
            throw new IncorrectSpaceException("PSF does not belong to the correct space");
        }
        this.computeMTF(((DoubleShapedVector)psf).getData());
    }

    @Override
    public void setPSF(ShapedArray psf, int[] off, boolean normalize) {
        double sum;
        boolean writable = false;
        if (psf.getType() != 5) {
            psf = psf.toDouble();
            writable = true;
        }
        if (normalize && (sum = ArrayUtils.sum(psf)) != 1.0) {
            if (!writable) {
                psf = psf.copy();
            }
            ((DoubleArray)psf).scale(1.0 / sum);
        }
        psf = this.adjustPSF(psf, off);
        this.computeMTF(((DoubleArray)psf).flatten());
    }

    private final void computeMTF(double[] psf) {
        double zero = 0.0;
        int n = this.getNumberOfFrequencies();
        double scale = 1.0 / (double)n;
        if (this.mtf == null) {
            this.mtf = new double[2 * n];
        }
        for (int k = 0; k < n; ++k) {
            int real = k + k;
            int imag = real + 1;
            this.mtf[real] = psf[k] * scale;
            this.mtf[imag] = 0.0;
        }
        this.forwardFFT(this.mtf);
    }

    @Override
    public DoubleShapedVectorSpace getInputSpace() {
        return (DoubleShapedVectorSpace)this.inputSpace;
    }

    @Override
    public DoubleShapedVectorSpace getOutputSpace() {
        return (DoubleShapedVectorSpace)this.outputSpace;
    }
}

