/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.base.Shape;
import mitiv.base.indexing.BoundaryConditions;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.random.DoubleGenerator;
import mitiv.random.FloatGenerator;
import mitiv.random.UniformDistribution;

public class FiniteDifferenceOperator
extends LinearOperator {
    private int[][] index;
    final boolean single;
    double[] scale = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};

    private static void testDoubleOperator(DoubleGenerator generator, int[] shape, BoundaryConditions condition) {
        DoubleShapedVectorSpace inp = new DoubleShapedVectorSpace(shape);
        FiniteDifferenceOperator D = new FiniteDifferenceOperator(inp, condition);
        DoubleShapedVectorSpace out = (DoubleShapedVectorSpace)D.getOutputSpace();
        DoubleShapedVector a = inp.create();
        DoubleShapedVector b = out.create();
        a.fill(generator);
        b.fill(generator);
        System.out.printf("Testing the adjoint in %dD arrays, shape = [%d", shape.length, shape[0]);
        for (int k = 1; k < shape.length; ++k) {
            System.out.printf(",%d", shape[k]);
        }
        System.out.printf("], of random values:\n", new Object[0]);
        System.out.println("  relative error = " + D.checkAdjoint(a, b));
    }

    private static void testFloatOperator(FloatGenerator generator, int[] shape, BoundaryConditions condition) {
        FloatShapedVectorSpace inp = new FloatShapedVectorSpace(shape);
        FiniteDifferenceOperator D = new FiniteDifferenceOperator(inp, condition);
        FloatShapedVectorSpace out = (FloatShapedVectorSpace)D.getOutputSpace();
        FloatShapedVector a = inp.create();
        FloatShapedVector b = out.create();
        a.fill(generator);
        b.fill(generator);
        System.out.printf("Testing the adjoint in %dD arrays, shape = [%d", shape.length, shape[0]);
        for (int k = 1; k < shape.length; ++k) {
            System.out.printf(",%d", shape[k]);
        }
        System.out.printf("], of random values:\n", new Object[0]);
        System.out.println("  relative error = " + D.checkAdjoint(a, b));
    }

    public static void main(String[] args) {
        DoubleShapedVectorSpace inp = new DoubleShapedVectorSpace(new int[]{5});
        DoubleShapedVector a = inp.create();
        a.set(0, 1.2);
        a.set(1, 2.7);
        a.set(2, -3.1);
        a.set(3, 5.3);
        a.set(4, -9.0);
        FiniteDifferenceOperator dif = new FiniteDifferenceOperator(inp);
        DoubleShapedVectorSpace out = (DoubleShapedVectorSpace)dif.getOutputSpace();
        DoubleShapedVector b = out.create();
        b.set(0, 2.1);
        b.set(1, 7.2);
        b.set(2, -1.3);
        b.set(3, 3.5);
        b.set(4, -0.9);
        System.out.println("Testing the adjoint:");
        System.out.println("  a = " + a);
        System.out.println("  b = " + b);
        System.out.println("  relative error = " + dif.checkAdjoint(a, b));
        System.out.println("");
        System.out.println("Testing the operator:");
        dif.apply(b, a);
        DoubleShapedVector c = inp.create();
        dif.apply(c, b, LinearOperator.ADJOINT);
        System.out.println("a = " + a);
        System.out.println("b = " + b);
        System.out.println("c = " + c);
        System.out.println("");
        UniformDistribution rand = new UniformDistribution(-1.0, 1.0);
        FiniteDifferenceOperator.testDoubleOperator(rand, new int[]{3, 4, 5}, BoundaryConditions.MIRROR);
        FiniteDifferenceOperator.testDoubleOperator(rand, new int[]{3, 4, 5}, BoundaryConditions.NORMAL);
        FiniteDifferenceOperator.testFloatOperator(rand, new int[]{3, 4, 5, 6}, BoundaryConditions.NORMAL);
        FiniteDifferenceOperator.testFloatOperator(rand, new int[]{3, 4, 5, 6, 7}, BoundaryConditions.PERIODIC);
    }

    public FiniteDifferenceOperator(DoubleShapedVectorSpace inputSpace, double[] scale, BoundaryConditions[] bounds) {
        super(inputSpace, new DoubleShapedVectorSpace(FiniteDifferenceOperator.buildShape(inputSpace.getShape())));
        this.checkscale(inputSpace.getShape(), scale);
        this.buildIndex(inputSpace.getShape(), bounds);
        this.single = false;
    }

    public FiniteDifferenceOperator(DoubleShapedVectorSpace inputSpace, BoundaryConditions[] bounds) {
        super(inputSpace, new DoubleShapedVectorSpace(FiniteDifferenceOperator.buildShape(inputSpace.getShape())));
        this.buildIndex(inputSpace.getShape(), bounds);
        this.single = false;
    }

    public FiniteDifferenceOperator(DoubleShapedVectorSpace inputSpace, double[] scale, BoundaryConditions bounds) {
        super(inputSpace, new DoubleShapedVectorSpace(FiniteDifferenceOperator.buildShape(inputSpace.getShape())));
        this.checkscale(inputSpace.getShape(), scale);
        this.buildIndex(inputSpace.getShape(), bounds);
        this.single = false;
    }

    public FiniteDifferenceOperator(DoubleShapedVectorSpace inputSpace, BoundaryConditions bounds) {
        super(inputSpace, new DoubleShapedVectorSpace(FiniteDifferenceOperator.buildShape(inputSpace.getShape())));
        this.buildIndex(inputSpace.getShape(), bounds);
        this.single = false;
    }

    public FiniteDifferenceOperator(DoubleShapedVectorSpace inputSpace, double[] scale) {
        this(inputSpace, scale, BoundaryConditions.NORMAL);
    }

    public FiniteDifferenceOperator(DoubleShapedVectorSpace inputSpace) {
        this(inputSpace, BoundaryConditions.NORMAL);
    }

    public FiniteDifferenceOperator(FloatShapedVectorSpace inputSpace, double[] scale, BoundaryConditions[] bounds) {
        super(inputSpace, new FloatShapedVectorSpace(FiniteDifferenceOperator.buildShape(inputSpace.getShape())));
        this.buildIndex(inputSpace.getShape(), bounds);
        this.checkscale(inputSpace.getShape(), scale);
        this.single = true;
    }

    public FiniteDifferenceOperator(FloatShapedVectorSpace inputSpace, BoundaryConditions[] bounds) {
        super(inputSpace, new FloatShapedVectorSpace(FiniteDifferenceOperator.buildShape(inputSpace.getShape())));
        this.buildIndex(inputSpace.getShape(), bounds);
        this.single = true;
    }

    public FiniteDifferenceOperator(FloatShapedVectorSpace inputSpace, BoundaryConditions bounds) {
        super(inputSpace, new FloatShapedVectorSpace(FiniteDifferenceOperator.buildShape(inputSpace.getShape())));
        this.buildIndex(inputSpace.getShape(), bounds);
        this.single = true;
    }

    public FiniteDifferenceOperator(FloatShapedVectorSpace inputSpace, double[] scale, BoundaryConditions bounds) {
        super(inputSpace, new FloatShapedVectorSpace(FiniteDifferenceOperator.buildShape(inputSpace.getShape())));
        this.buildIndex(inputSpace.getShape(), bounds);
        this.checkscale(inputSpace.getShape(), scale);
        this.single = true;
    }

    public FiniteDifferenceOperator(FloatShapedVectorSpace inputSpace, double[] scale) {
        this(inputSpace, scale, BoundaryConditions.NORMAL);
    }

    public FiniteDifferenceOperator(FloatShapedVectorSpace inputSpace) {
        this(inputSpace, BoundaryConditions.NORMAL);
    }

    private static Shape buildShape(Shape inputShape) {
        int rank = inputShape.rank();
        if (rank == 1) {
            return inputShape;
        }
        int[] outDims = new int[rank + 1];
        outDims[0] = rank;
        for (int k = 0; k < rank; ++k) {
            outDims[k + 1] = inputShape.dimension(k);
        }
        return new Shape(outDims);
    }

    private BoundaryConditions getBoundaryConditions(BoundaryConditions[] arr, int k) {
        return arr == null || k < 0 || k >= arr.length ? BoundaryConditions.NORMAL : arr[k];
    }

    private void buildIndex(Shape inputShape, BoundaryConditions[] bounds) {
        int rank = inputShape.rank();
        this.index = new int[rank][];
        for (int k = 0; k < rank; ++k) {
            this.index[k] = BoundaryConditions.buildIndex(inputShape.dimension(k), -1, this.getBoundaryConditions(bounds, k));
        }
    }

    private void buildIndex(Shape inputShape, BoundaryConditions bounds) {
        int rank = inputShape.rank();
        this.index = new int[rank][];
        for (int k = 0; k < rank; ++k) {
            this.index[k] = BoundaryConditions.buildIndex(inputShape.dimension(k), -1, bounds);
        }
    }

    private void checkscale(Shape inputShape, double[] scale) {
        if (inputShape.rank() != scale.length) {
            throw new IllegalArgumentException("illegal job");
        }
    }

    private double[] getDoubleData(Vector v) {
        return ((DoubleShapedVector)v).getData();
    }

    private float[] getFloatData(Vector v) {
        return ((FloatShapedVector)v).getData();
    }

    @Override
    protected void _apply(Vector dst, Vector src, int job) throws IncorrectSpaceException {
        boolean transpose;
        if (job == ADJOINT) {
            dst.zero();
            transpose = true;
        } else if (job == DIRECT) {
            transpose = false;
        } else {
            throw new IllegalArgumentException("illegal job");
        }
        int rank = this.index.length;
        if (rank == 1) {
            if (this.single) {
                this.apply1D(this.getFloatData(src), this.getFloatData(dst), transpose);
            } else {
                this.apply1D(this.getDoubleData(src), this.getDoubleData(dst), transpose);
            }
        } else if (rank == 2) {
            if (this.single) {
                this.apply2D(this.getFloatData(src), this.getFloatData(dst), transpose);
            } else {
                this.apply2D(this.getDoubleData(src), this.getDoubleData(dst), transpose);
            }
        } else if (rank == 3) {
            if (this.single) {
                this.apply3D(this.getFloatData(src), this.getFloatData(dst), transpose);
            } else {
                this.apply3D(this.getDoubleData(src), this.getDoubleData(dst), transpose);
            }
        } else if (rank == 4) {
            if (this.single) {
                this.apply4D(this.getFloatData(src), this.getFloatData(dst), transpose);
            } else {
                this.apply4D(this.getDoubleData(src), this.getDoubleData(dst), transpose);
            }
        } else if (rank == 5) {
            if (this.single) {
                this.apply5D(this.getFloatData(src), this.getFloatData(dst), transpose);
            } else {
                this.apply5D(this.getDoubleData(src), this.getDoubleData(dst), transpose);
            }
        } else {
            throw new IllegalArgumentException("too many dimensions");
        }
    }

    private final void apply1D(double[] x, double[] y, boolean transpose) {
        int[] prev1 = this.index[0];
        int n1 = prev1.length;
        double scale1 = this.scale[0];
        if (transpose) {
            for (int i1 = 0; i1 < n1; ++i1) {
                double x1 = x[i1];
                int n = i1;
                y[n] = y[n] + scale1 * x1;
                int n2 = prev1[i1];
                y[n2] = y[n2] - scale1 * x1;
            }
        } else {
            for (int i1 = 0; i1 < n1; ++i1) {
                y[i1] = scale1 * (x[i1] - x[prev1[i1]]);
            }
        }
    }

    private final void apply2D(double[] x, double[] y, boolean transpose) {
        int[] prev1 = this.index[0];
        int n1 = prev1.length;
        int[] prev2 = this.index[1];
        int n2 = prev2.length;
        double scale1 = this.scale[0];
        double scale2 = this.scale[1];
        if (transpose) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int j2 = n1 * i2;
                int k2 = n1 * (prev2[i2] - i2);
                for (int i1 = 0; i1 < n1; ++i1) {
                    int j1 = i1 + j2;
                    int k1 = prev1[i1] - i1;
                    int l1 = 2 * j1;
                    double x1 = x[l1];
                    double x2 = x[l1 + 1];
                    int n = j1;
                    y[n] = y[n] + (scale1 * x1 + scale2 * x2);
                    int n3 = j1 + k1;
                    y[n3] = y[n3] - scale1 * x1;
                    int n4 = j1 + k2;
                    y[n4] = y[n4] - scale2 * x2;
                }
            }
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                int j2 = n1 * i2;
                int k2 = n1 * (prev2[i2] - i2);
                for (int i1 = 0; i1 < n1; ++i1) {
                    int j1 = i1 + j2;
                    int k1 = prev1[i1] - i1;
                    int l1 = 2 * j1;
                    double x_j1 = x[j1];
                    y[l1] = scale1 * (x_j1 - x[j1 + k1]);
                    y[l1 + 1] = scale2 * (x_j1 - x[j1 + k2]);
                }
            }
        }
    }

    private final void apply3D(double[] x, double[] y, boolean transpose) {
        int[] prev1 = this.index[0];
        int n1 = prev1.length;
        int[] prev2 = this.index[1];
        int n2 = prev2.length;
        int[] prev3 = this.index[2];
        int n3 = prev3.length;
        int n1n2 = n1 * n2;
        double scale1 = this.scale[0];
        double scale2 = this.scale[1];
        double scale3 = this.scale[2];
        if (transpose) {
            for (int i3 = 0; i3 < n3; ++i3) {
                int j3 = n1n2 * i3;
                int k3 = n1n2 * (prev3[i3] - i3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    int j2 = n1 * i2 + j3;
                    int k2 = n1 * (prev2[i2] - i2);
                    for (int i1 = 0; i1 < n1; ++i1) {
                        int j1 = i1 + j2;
                        int k1 = prev1[i1] - i1;
                        int l1 = 3 * j1;
                        double x1 = x[l1];
                        double x2 = x[l1 + 1];
                        double x3 = x[l1 + 2];
                        int n = j1;
                        y[n] = y[n] + (scale1 * x1 + scale2 * x2 + scale3 * x3);
                        int n4 = j1 + k1;
                        y[n4] = y[n4] - scale1 * x1;
                        int n5 = j1 + k2;
                        y[n5] = y[n5] - scale2 * x2;
                        int n6 = j1 + k3;
                        y[n6] = y[n6] - scale3 * x3;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                int j3 = n1n2 * i3;
                int k3 = n1n2 * (prev3[i3] - i3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    int j2 = n1 * i2 + j3;
                    int k2 = n1 * (prev2[i2] - i2);
                    for (int i1 = 0; i1 < n1; ++i1) {
                        int j1 = i1 + j2;
                        int k1 = prev1[i1] - i1;
                        int l1 = 3 * j1;
                        double x_j1 = x[j1];
                        y[l1] = scale1 * (x_j1 - x[j1 + k1]);
                        y[l1 + 1] = scale2 * (x_j1 - x[j1 + k2]);
                        y[l1 + 2] = scale3 * (x_j1 - x[j1 + k3]);
                    }
                }
            }
        }
    }

    private final void apply4D(double[] x, double[] y, boolean transpose) {
        int[] prev1 = this.index[0];
        int n1 = prev1.length;
        int[] prev2 = this.index[1];
        int n2 = prev2.length;
        int[] prev3 = this.index[2];
        int n3 = prev3.length;
        int n1n2 = n1 * n2;
        int[] prev4 = this.index[3];
        int n4 = prev4.length;
        int n1n2n3 = n1n2 * n3;
        double scale1 = this.scale[0];
        double scale2 = this.scale[1];
        double scale3 = this.scale[2];
        double scale4 = this.scale[3];
        if (transpose) {
            for (int i4 = 0; i4 < n4; ++i4) {
                int j4 = n1n2n3 * i4;
                int k4 = n1n2n3 * (prev4[i4] - i4);
                for (int i3 = 0; i3 < n3; ++i3) {
                    int j3 = n1n2 * i3 + j4;
                    int k3 = n1n2 * (prev3[i3] - i3);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        int j2 = n1 * i2 + j3;
                        int k2 = n1 * (prev2[i2] - i2);
                        for (int i1 = 0; i1 < n1; ++i1) {
                            int j1 = i1 + j2;
                            int k1 = prev1[i1] - i1;
                            int l1 = 4 * j1;
                            double x1 = x[l1];
                            double x2 = x[l1 + 1];
                            double x3 = x[l1 + 2];
                            double x4 = x[l1 + 3];
                            int n = j1;
                            y[n] = y[n] + (scale1 * x1 + scale2 * x2 + scale3 * x3 + scale4 * x4);
                            int n5 = j1 + k1;
                            y[n5] = y[n5] - scale1 * x1;
                            int n6 = j1 + k2;
                            y[n6] = y[n6] - scale2 * x2;
                            int n7 = j1 + k3;
                            y[n7] = y[n7] - scale3 * x3;
                            int n8 = j1 + k4;
                            y[n8] = y[n8] - scale4 * x4;
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < n4; ++i4) {
                int j4 = n1n2n3 * i4;
                int k4 = n1n2n3 * (prev4[i4] - i4);
                for (int i3 = 0; i3 < n3; ++i3) {
                    int j3 = n1n2 * i3 + j4;
                    int k3 = n1n2 * (prev3[i3] - i3);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        int j2 = n1 * i2 + j3;
                        int k2 = n1 * (prev2[i2] - i2);
                        for (int i1 = 0; i1 < n1; ++i1) {
                            int j1 = i1 + j2;
                            int k1 = prev1[i1] - i1;
                            int l1 = 4 * j1;
                            double x_j1 = x[j1];
                            y[l1] = scale1 * (x_j1 - x[j1 + k1]);
                            y[l1 + 1] = scale2 * (x_j1 - x[j1 + k2]);
                            y[l1 + 2] = scale3 * (x_j1 - x[j1 + k3]);
                            y[l1 + 3] = scale4 * (x_j1 - x[j1 + k4]);
                        }
                    }
                }
            }
        }
    }

    private final void apply5D(double[] x, double[] y, boolean transpose) {
        int[] prev1 = this.index[0];
        int n1 = prev1.length;
        int[] prev2 = this.index[1];
        int n2 = prev2.length;
        int[] prev3 = this.index[2];
        int n3 = prev3.length;
        int n1n2 = n1 * n2;
        int[] prev4 = this.index[3];
        int n4 = prev4.length;
        int n1n2n3 = n1n2 * n3;
        int[] prev5 = this.index[4];
        int n5 = prev5.length;
        int n1n2n3n4 = n1n2n3 * n4;
        double scale1 = this.scale[0];
        double scale2 = this.scale[1];
        double scale3 = this.scale[2];
        double scale4 = this.scale[3];
        double scale5 = this.scale[4];
        if (transpose) {
            for (int i5 = 0; i5 < n5; ++i5) {
                int j5 = n1n2n3n4 * i5;
                int k5 = n1n2n3n4 * (prev5[i5] - i5);
                for (int i4 = 0; i4 < n4; ++i4) {
                    int j4 = n1n2n3 * i4 + j5;
                    int k4 = n1n2n3 * (prev4[i4] - i4);
                    for (int i3 = 0; i3 < n3; ++i3) {
                        int j3 = n1n2 * i3 + j4;
                        int k3 = n1n2 * (prev3[i3] - i3);
                        for (int i2 = 0; i2 < n2; ++i2) {
                            int j2 = n1 * i2 + j3;
                            int k2 = n1 * (prev2[i2] - i2);
                            for (int i1 = 0; i1 < n1; ++i1) {
                                int j1 = i1 + j2;
                                int k1 = prev1[i1] - i1;
                                int l1 = 5 * j1;
                                double x1 = x[l1];
                                double x2 = x[l1 + 1];
                                double x3 = x[l1 + 2];
                                double x4 = x[l1 + 3];
                                double x5 = x[l1 + 4];
                                int n = j1;
                                y[n] = y[n] + (scale1 * x1 + scale2 * x2 + scale3 * x3 + scale4 * x4 + scale5 * x5);
                                int n6 = j1 + k1;
                                y[n6] = y[n6] - scale1 * x1;
                                int n7 = j1 + k2;
                                y[n7] = y[n7] - scale2 * x2;
                                int n8 = j1 + k3;
                                y[n8] = y[n8] - scale3 * x3;
                                int n9 = j1 + k4;
                                y[n9] = y[n9] - scale4 * x4;
                                int n10 = j1 + k5;
                                y[n10] = y[n10] - scale5 * x5;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i5 = 0; i5 < n5; ++i5) {
                int j5 = n1n2n3n4 * i5;
                int k5 = n1n2n3n4 * (prev5[i5] - i5);
                for (int i4 = 0; i4 < n4; ++i4) {
                    int j4 = n1n2n3 * i4 + j5;
                    int k4 = n1n2n3 * (prev4[i4] - i4);
                    for (int i3 = 0; i3 < n3; ++i3) {
                        int j3 = n1n2 * i3 + j4;
                        int k3 = n1n2 * (prev3[i3] - i3);
                        for (int i2 = 0; i2 < n2; ++i2) {
                            int j2 = n1 * i2 + j3;
                            int k2 = n1 * (prev2[i2] - i2);
                            for (int i1 = 0; i1 < n1; ++i1) {
                                int j1 = i1 + j2;
                                int k1 = prev1[i1] - i1;
                                int l1 = 5 * j1;
                                double x_j1 = x[j1];
                                y[l1] = scale1 * (x_j1 - x[j1 + k1]);
                                y[l1 + 1] = scale2 * (x_j1 - x[j1 + k2]);
                                y[l1 + 2] = scale3 * (x_j1 - x[j1 + k3]);
                                y[l1 + 3] = scale4 * (x_j1 - x[j1 + k4]);
                                y[l1 + 4] = scale5 * (x_j1 - x[j1 + k5]);
                            }
                        }
                    }
                }
            }
        }
    }

    private final void apply1D(float[] x, float[] y, boolean transpose) {
        int[] prev1 = this.index[0];
        int n1 = prev1.length;
        float scale1 = (float)this.scale[0];
        if (transpose) {
            for (int i1 = 0; i1 < n1; ++i1) {
                float x1 = x[i1];
                int n = i1;
                y[n] = y[n] + x1;
                int n2 = prev1[i1];
                y[n2] = y[n2] - scale1 * x1;
            }
        } else {
            for (int i1 = 0; i1 < n1; ++i1) {
                y[i1] = scale1 * (x[i1] - x[prev1[i1]]);
            }
        }
    }

    private final void apply2D(float[] x, float[] y, boolean transpose) {
        int[] prev1 = this.index[0];
        int n1 = prev1.length;
        int[] prev2 = this.index[1];
        int n2 = prev2.length;
        float scale1 = (float)this.scale[0];
        float scale2 = (float)this.scale[1];
        if (transpose) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int j2 = n1 * i2;
                int k2 = n1 * (prev2[i2] - i2);
                for (int i1 = 0; i1 < n1; ++i1) {
                    int j1 = i1 + j2;
                    int k1 = prev1[i1] - i1;
                    int l1 = 2 * j1;
                    float x1 = x[l1];
                    float x2 = x[l1 + 1];
                    int n = j1;
                    y[n] = y[n] + (scale1 * x1 + scale2 * x2);
                    int n3 = j1 + k1;
                    y[n3] = y[n3] - scale1 * x1;
                    int n4 = j1 + k2;
                    y[n4] = y[n4] - scale2 * x2;
                }
            }
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                int j2 = n1 * i2;
                int k2 = n1 * (prev2[i2] - i2);
                for (int i1 = 0; i1 < n1; ++i1) {
                    int j1 = i1 + j2;
                    int k1 = prev1[i1] - i1;
                    int l1 = 2 * j1;
                    float x_j1 = x[j1];
                    y[l1] = scale1 * (x_j1 - x[j1 + k1]);
                    y[l1 + 1] = scale2 * (x_j1 - x[j1 + k2]);
                }
            }
        }
    }

    private final void apply3D(float[] x, float[] y, boolean transpose) {
        int[] prev1 = this.index[0];
        int n1 = prev1.length;
        int[] prev2 = this.index[1];
        int n2 = prev2.length;
        int[] prev3 = this.index[2];
        int n3 = prev3.length;
        int n1n2 = n1 * n2;
        float scale1 = (float)this.scale[0];
        float scale2 = (float)this.scale[1];
        float scale3 = (float)this.scale[2];
        if (transpose) {
            for (int i3 = 0; i3 < n3; ++i3) {
                int j3 = n1n2 * i3;
                int k3 = n1n2 * (prev3[i3] - i3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    int j2 = n1 * i2 + j3;
                    int k2 = n1 * (prev2[i2] - i2);
                    for (int i1 = 0; i1 < n1; ++i1) {
                        int j1 = i1 + j2;
                        int k1 = prev1[i1] - i1;
                        int l1 = 3 * j1;
                        float x1 = x[l1];
                        float x2 = x[l1 + 1];
                        float x3 = x[l1 + 2];
                        int n = j1;
                        y[n] = y[n] + (scale1 * x1 + scale2 * x2 + scale3 * x3);
                        int n4 = j1 + k1;
                        y[n4] = y[n4] - scale1 * x1;
                        int n5 = j1 + k2;
                        y[n5] = y[n5] - scale2 * x2;
                        int n6 = j1 + k3;
                        y[n6] = y[n6] - scale3 * x3;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                int j3 = n1n2 * i3;
                int k3 = n1n2 * (prev3[i3] - i3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    int j2 = n1 * i2 + j3;
                    int k2 = n1 * (prev2[i2] - i2);
                    for (int i1 = 0; i1 < n1; ++i1) {
                        int j1 = i1 + j2;
                        int k1 = prev1[i1] - i1;
                        int l1 = 3 * j1;
                        float x_j1 = x[j1];
                        y[l1] = scale1 * (x_j1 - x[j1 + k1]);
                        y[l1 + 1] = scale2 * (x_j1 - x[j1 + k2]);
                        y[l1 + 2] = scale3 * (x_j1 - x[j1 + k3]);
                    }
                }
            }
        }
    }

    private final void apply4D(float[] x, float[] y, boolean transpose) {
        int[] prev1 = this.index[0];
        int n1 = prev1.length;
        int[] prev2 = this.index[1];
        int n2 = prev2.length;
        int[] prev3 = this.index[2];
        int n3 = prev3.length;
        int n1n2 = n1 * n2;
        int[] prev4 = this.index[3];
        int n4 = prev4.length;
        int n1n2n3 = n1n2 * n3;
        float scale1 = (float)this.scale[0];
        float scale2 = (float)this.scale[1];
        float scale3 = (float)this.scale[2];
        float scale4 = (float)this.scale[3];
        if (transpose) {
            for (int i4 = 0; i4 < n4; ++i4) {
                int j4 = n1n2n3 * i4;
                int k4 = n1n2n3 * (prev4[i4] - i4);
                for (int i3 = 0; i3 < n3; ++i3) {
                    int j3 = n1n2 * i3 + j4;
                    int k3 = n1n2 * (prev3[i3] - i3);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        int j2 = n1 * i2 + j3;
                        int k2 = n1 * (prev2[i2] - i2);
                        for (int i1 = 0; i1 < n1; ++i1) {
                            int j1 = i1 + j2;
                            int k1 = prev1[i1] - i1;
                            int l1 = 4 * j1;
                            float x1 = x[l1];
                            float x2 = x[l1 + 1];
                            float x3 = x[l1 + 2];
                            float x4 = x[l1 + 3];
                            int n = j1;
                            y[n] = y[n] + (scale1 * x1 + scale2 * x2 + scale3 * x3 + scale4 * x4);
                            int n5 = j1 + k1;
                            y[n5] = y[n5] - scale1 * x1;
                            int n6 = j1 + k2;
                            y[n6] = y[n6] - scale2 * x2;
                            int n7 = j1 + k3;
                            y[n7] = y[n7] - scale3 * x3;
                            int n8 = j1 + k4;
                            y[n8] = y[n8] - scale4 * x4;
                        }
                    }
                }
            }
        } else {
            for (int i4 = 0; i4 < n4; ++i4) {
                int j4 = n1n2n3 * i4;
                int k4 = n1n2n3 * (prev4[i4] - i4);
                for (int i3 = 0; i3 < n3; ++i3) {
                    int j3 = n1n2 * i3 + j4;
                    int k3 = n1n2 * (prev3[i3] - i3);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        int j2 = n1 * i2 + j3;
                        int k2 = n1 * (prev2[i2] - i2);
                        for (int i1 = 0; i1 < n1; ++i1) {
                            int j1 = i1 + j2;
                            int k1 = prev1[i1] - i1;
                            int l1 = 4 * j1;
                            float x_j1 = x[j1];
                            y[l1] = scale1 * (x_j1 - x[j1 + k1]);
                            y[l1 + 1] = scale2 * (x_j1 - x[j1 + k2]);
                            y[l1 + 2] = scale3 * (x_j1 - x[j1 + k3]);
                            y[l1 + 3] = scale4 * (x_j1 - x[j1 + k4]);
                        }
                    }
                }
            }
        }
    }

    private final void apply5D(float[] x, float[] y, boolean transpose) {
        int[] prev1 = this.index[0];
        int n1 = prev1.length;
        int[] prev2 = this.index[1];
        int n2 = prev2.length;
        int[] prev3 = this.index[2];
        int n3 = prev3.length;
        int n1n2 = n1 * n2;
        int[] prev4 = this.index[3];
        int n4 = prev4.length;
        int n1n2n3 = n1n2 * n3;
        int[] prev5 = this.index[4];
        int n5 = prev5.length;
        int n1n2n3n4 = n1n2n3 * n4;
        float scale1 = (float)this.scale[0];
        float scale2 = (float)this.scale[1];
        float scale3 = (float)this.scale[2];
        float scale4 = (float)this.scale[3];
        float scale5 = (float)this.scale[4];
        if (transpose) {
            for (int i5 = 0; i5 < n5; ++i5) {
                int j5 = n1n2n3n4 * i5;
                int k5 = n1n2n3n4 * (prev5[i5] - i5);
                for (int i4 = 0; i4 < n4; ++i4) {
                    int j4 = n1n2n3 * i4 + j5;
                    int k4 = n1n2n3 * (prev4[i4] - i4);
                    for (int i3 = 0; i3 < n3; ++i3) {
                        int j3 = n1n2 * i3 + j4;
                        int k3 = n1n2 * (prev3[i3] - i3);
                        for (int i2 = 0; i2 < n2; ++i2) {
                            int j2 = n1 * i2 + j3;
                            int k2 = n1 * (prev2[i2] - i2);
                            for (int i1 = 0; i1 < n1; ++i1) {
                                int j1 = i1 + j2;
                                int k1 = prev1[i1] - i1;
                                int l1 = 5 * j1;
                                float x1 = x[l1];
                                float x2 = x[l1 + 1];
                                float x3 = x[l1 + 2];
                                float x4 = x[l1 + 3];
                                float x5 = x[l1 + 4];
                                int n = j1;
                                y[n] = y[n] + (scale1 * x1 + scale2 * x2 + scale3 * x3 + scale4 * x4 + scale5 * x5);
                                int n6 = j1 + k1;
                                y[n6] = y[n6] - scale1 * x1;
                                int n7 = j1 + k2;
                                y[n7] = y[n7] - scale2 * x2;
                                int n8 = j1 + k3;
                                y[n8] = y[n8] - scale3 * x3;
                                int n9 = j1 + k4;
                                y[n9] = y[n9] - scale4 * x4;
                                int n10 = j1 + k5;
                                y[n10] = y[n10] - scale5 * x5;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i5 = 0; i5 < n5; ++i5) {
                int j5 = n1n2n3n4 * i5;
                int k5 = n1n2n3n4 * (prev5[i5] - i5);
                for (int i4 = 0; i4 < n4; ++i4) {
                    int j4 = n1n2n3 * i4 + j5;
                    int k4 = n1n2n3 * (prev4[i4] - i4);
                    for (int i3 = 0; i3 < n3; ++i3) {
                        int j3 = n1n2 * i3 + j4;
                        int k3 = n1n2 * (prev3[i3] - i3);
                        for (int i2 = 0; i2 < n2; ++i2) {
                            int j2 = n1 * i2 + j3;
                            int k2 = n1 * (prev2[i2] - i2);
                            for (int i1 = 0; i1 < n1; ++i1) {
                                int j1 = i1 + j2;
                                int k1 = prev1[i1] - i1;
                                int l1 = 5 * j1;
                                float x_j1 = x[j1];
                                y[l1] = scale1 * (x_j1 - x[j1 + k1]);
                                y[l1 + 1] = scale2 * (x_j1 - x[j1 + k2]);
                                y[l1 + 2] = scale3 * (x_j1 - x[j1 + k3]);
                                y[l1 + 3] = scale4 * (x_j1 - x[j1 + k4]);
                                y[l1 + 4] = scale5 * (x_j1 - x[j1 + k5]);
                            }
                        }
                    }
                }
            }
        }
    }
}

