/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.base.mapping.Mapping;
import mitiv.cost.CostFunction;
import mitiv.cost.WeightedData;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class GaussianLikelihood
implements CostFunction {
    protected final WeightedData weightedData;
    protected final Mapping directModel;
    protected final VectorSpace variableSpace;
    protected final ShapedVectorSpace dataSpace;
    protected ShapedVector work1 = null;
    protected boolean ignoreWeights = false;

    public GaussianLikelihood(WeightedData weightedData, Mapping directModel) {
        if (directModel.getOutputSpace() != weightedData.getDataSpace()) {
            throw new IllegalArgumentException("Output space of the direct model must be the data space");
        }
        this.directModel = directModel;
        this.variableSpace = directModel.getInputSpace();
        this.dataSpace = weightedData.getDataSpace();
        this.weightedData = weightedData;
    }

    @Override
    public final VectorSpace getInputSpace() {
        return this.variableSpace;
    }

    public final VectorSpace getVariableSpace() {
        return this.variableSpace;
    }

    public final ShapedVectorSpace getDataSpace() {
        return this.dataSpace;
    }

    public final ShapedVector getData() {
        return this.weightedData.getData();
    }

    public final ShapedVector getWeights() {
        return this.weightedData.getWeights();
    }

    public final boolean isSinglePrecision() {
        return this.weightedData.isSinglePrecision();
    }

    public final ShapedVector computeModel(ShapedVector x) {
        ShapedVector dst = this.dataSpace.create();
        this.computeModel(dst, x);
        return dst;
    }

    public final void computeModel(ShapedVector dst, Vector src) {
        this.directModel.apply(dst, src);
    }

    protected final void computeResiduals(Vector x) {
        if (this.work1 == null) {
            this.work1 = this.dataSpace.create();
        }
        this.computeModel(this.work1, x);
        this.work1.add(-1.0, this.getData());
    }

    @Override
    public final double evaluate(double alpha, Vector x) {
        this.dataSpace.check(x);
        if (alpha == 0.0) {
            return 0.0;
        }
        this.computeResiduals(x);
        double sum = 0.0;
        if (this.ignoreWeights) {
            sum = this.work1.norm2();
        } else if (this.isSinglePrecision()) {
            float[] r = ((FloatShapedVector)this.work1).getData();
            float[] w = ((FloatShapedVector)this.getWeights()).getData();
            for (int i = 0; i < r.length; ++i) {
                sum += (double)(w[i] * r[i] * r[i]);
            }
        } else {
            double[] r = ((DoubleShapedVector)this.work1).getData();
            double[] w = ((DoubleShapedVector)this.getWeights()).getData();
            for (int i = 0; i < r.length; ++i) {
                sum += w[i] * r[i] * r[i];
            }
        }
        return alpha / 2.0 * sum;
    }
}

