/*
 * Decompiled with CFR 0.152.
 */
package mitiv.invpb;

import mitiv.array.ArrayFactory;
import mitiv.array.ArrayUtils;
import mitiv.array.ByteArray;
import mitiv.array.DoubleArray;
import mitiv.array.FloatArray;
import mitiv.array.IntArray;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.base.Shape;
import mitiv.conv.Convolution;
import mitiv.conv.WeightedConvolutionCost;
import mitiv.cost.DifferentiableGaussianLikelihood;
import mitiv.cost.HyperbolicTotalVariation;
import mitiv.cost.WeightedData;
import mitiv.invpb.Deconvolution;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.utils.FFTUtils;

public class EdgePreservingDeconvolution
extends Deconvolution {
    private boolean single;
    private ShapedVectorSpace dataSpace = null;
    private ShapedVectorSpace objectSpace = null;
    private ShapedArray data = null;
    private boolean writableData = false;
    private ShapedArray weights = null;
    private boolean writableWeights = false;
    private double sigma = Double.NaN;
    private double gamma = Double.NaN;
    private ShapedArray bads = null;
    private WeightedData weightedData = null;
    private ShapedArray psf = null;
    private boolean normalizePSF = false;
    private ShapedArray object = null;
    private Shape objectShape = null;
    private double padValue = Double.NaN;
    private double epsilon = 1.0;
    private double[] scale = new double[]{1.0};
    private boolean useNewCode = false;

    @Override
    protected void forceRestart() {
        this.weightedData = null;
        this.updatePending = true;
    }

    public boolean getUseNewCode() {
        return this.useNewCode;
    }

    public void setUseNewCode(boolean value) {
        if (this.useNewCode != value) {
            this.useNewCode = value;
            this.forceRestart();
        }
    }

    public boolean getForceSinglePrecision() {
        return this.single;
    }

    public void setForceSinglePrecision(boolean value) {
        if (this.single != value) {
            this.single = value;
            this.forceRestart();
        }
    }

    public ShapedArray getData() {
        return this.data;
    }

    public void setData(ShapedArray arr, boolean writable) {
        if (this.data != arr) {
            this.data = arr;
            this.writableData = writable;
            this.forceRestart();
        }
    }

    public void setData(ShapedArray arr) {
        this.setData(arr, false);
    }

    public ShapedArray getWeights() {
        return this.weights;
    }

    public void setWeights(ShapedArray arr, boolean writable) {
        if (this.weights != arr) {
            this.weights = arr;
            this.writableWeights = writable;
            this.forceRestart();
        }
    }

    public void setWeights(ShapedArray arr) {
        this.setWeights(arr, false);
    }

    public ShapedArray getBads() {
        return this.bads;
    }

    public void setBads(ShapedArray arr) {
        if (this.bads != arr) {
            this.bads = arr;
            this.forceRestart();
        }
    }

    public ShapedArray getPSF() {
        return this.psf;
    }

    public void setPSF(ShapedArray arr) {
        this.setPSF(arr, false);
    }

    public void setPSF(ShapedArray arr, boolean normalize) {
        if (this.psf != arr) {
            this.psf = arr;
            this.normalizePSF = normalize;
            this.forceRestart();
        }
    }

    public double getEdgeThreshold() {
        return this.epsilon;
    }

    public void setEdgeThreshold(double value) {
        if (this.nonfinite(value) || value <= 0.0) {
            EdgePreservingDeconvolution.error("Edge threshold must be strictly positive");
        }
        if (this.epsilon != value) {
            this.epsilon = value;
            this.forceRestart();
        }
    }

    public void setScale(double ... delta) {
        this.scale = delta;
    }

    public double[] getScale() {
        return this.scale;
    }

    @Override
    public ShapedArray getSolution() {
        return this.object;
    }

    public Shape getObjectShape() {
        return this.objectShape;
    }

    public void setObjectShape(Shape shape) {
        if (shape == null != (this.objectShape == null) || shape != null && this.objectShape != null && !shape.equals(this.objectShape)) {
            this.objectShape = shape;
            this.forceRestart();
        }
    }

    public double getFillValue() {
        return this.padValue;
    }

    public void setFillValue(double fillValue) {
        this.padValue = fillValue;
    }

    public void setObjectShape(int[] dims) {
        this.setObjectShape(new Shape(dims));
    }

    @Override
    protected void update() {
        double val;
        int k;
        if (this.data == null) {
            EdgePreservingDeconvolution.error("No data specified");
        }
        int rank = this.data.getRank();
        Shape dataShape = this.data.getShape();
        if (this.weights != null && !this.weights.getShape().equals(dataShape)) {
            EdgePreservingDeconvolution.error("Weights and data must have the same dimensions");
        }
        if (this.bads != null && !this.bads.getShape().equals(dataShape)) {
            EdgePreservingDeconvolution.error("Mask of invalid data must have the same dimensions as the data");
        }
        if (this.psf != null && this.psf.getRank() != rank) {
            EdgePreservingDeconvolution.error("PSF and data must have the same number of dimensions");
        }
        if (this.object != null && this.object.getRank() != rank) {
            EdgePreservingDeconvolution.error("Object and data must have the same number of dimensions");
        }
        if (this.objectShape != null && this.objectShape.rank() != rank) {
            EdgePreservingDeconvolution.error("Given object shape must the same number of dimensions as the data");
        }
        if (this.debug) {
            System.out.format("mu: %.2g, epsilon: %.2g\n", this.getRegularizationLevel(), this.getEdgeThreshold());
        }
        int type = this.single ? 4 : (this.data.getType() == 5 || this.psf != null && this.psf.getType() == 5 || this.weights != null && this.weights.getType() == 5 || this.object != null && this.object.getType() == 5 ? 5 : 4);
        if (this.psf == null) {
            this.objectShape = dataShape;
        } else {
            Shape psfShape = this.psf.getShape();
            if (this.objectShape != null) {
                for (int k2 = 0; k2 < rank; ++k2) {
                    if (this.objectShape.dimension(k2) < dataShape.dimension(k2)) {
                        EdgePreservingDeconvolution.error("Given object dimensions must be at least those of the data");
                    }
                    if (psfShape == null || this.objectShape.dimension(k2) >= psfShape.dimension(k2)) continue;
                    EdgePreservingDeconvolution.error("Given object dimensions must be at least those of the PSF");
                }
            } else {
                int[] objectDims = new int[rank];
                for (k = 0; k < rank; ++k) {
                    int dim = dataShape.dimension(k) + psfShape.dimension(k) - 1;
                    if (this.object != null) {
                        dim = Math.max(dim, this.object.getDimension(k));
                    }
                    objectDims[k] = FFTUtils.bestDimension(dim);
                }
                this.objectShape = new Shape(objectDims);
            }
        }
        if (type == 4) {
            if (this.dataSpace == null) {
                this.dataSpace = new FloatShapedVectorSpace(dataShape);
            }
            if (this.objectSpace == null) {
                this.objectSpace = new FloatShapedVectorSpace(this.objectShape);
            }
        } else {
            if (this.dataSpace == null) {
                this.dataSpace = new DoubleShapedVectorSpace(dataShape);
            }
            if (this.objectSpace == null) {
                this.objectSpace = new DoubleShapedVectorSpace(this.objectShape);
            }
        }
        if (this.psf == null) {
            this.weightedData = new WeightedData(this.dataSpace);
            this.setWeightsAndData(this.weightedData);
            this.setLikelihood(this.weightedData);
        } else if (this.useNewCode) {
            this.weightedData = new WeightedData(this.dataSpace);
            this.setWeightsAndData(this.weightedData);
            Convolution directModel = Convolution.build(this.objectSpace, this.dataSpace);
            directModel.setPSF(this.psf, this.normalizePSF);
            this.setLikelihood(new DifferentiableGaussianLikelihood(this.weightedData, directModel));
        } else {
            WeightedConvolutionCost fdata = WeightedConvolutionCost.build(this.objectSpace, this.dataSpace);
            this.setWeightsAndData(fdata);
            fdata.setPSF(this.psf, this.normalizePSF);
            this.setLikelihood(fdata);
            this.weightedData = fdata;
        }
        if (this.object == null) {
            val = this.computePadValue();
            this.object = ArrayFactory.create(type, this.objectShape);
            if (this.single) {
                ((FloatArray)this.object).fill((float)val);
            } else {
                ((DoubleArray)this.object).fill(val);
            }
            if (this.debug) {
                System.err.format("Create initial array with value %g\n", val);
            }
        } else {
            val = 0.0;
            for (k = 0; k < rank; ++k) {
                if (this.objectShape.dimension(k) <= this.object.getDimension(k)) continue;
                val = this.computePadValue();
                break;
            }
            if (this.debug) {
                System.err.format("Pad initial array with value %g\n", val);
            }
            this.object = ArrayUtils.extract(this.object, this.objectShape, val);
        }
        HyperbolicTotalVariation fprior = new HyperbolicTotalVariation(this.objectSpace, this.epsilon);
        if (this.scale.length == 1) {
            fprior.setScale(this.scale[0]);
        } else {
            fprior.setScale(this.scale);
        }
        this.setRegularization(fprior);
        boolean wrap = this.object.getType() != type || !this.object.isFlat();
        this.x = this.objectSpace.create(this.object, false);
        if (wrap) {
            this.object = type == 4 ? ArrayFactory.wrap(((FloatShapedVector)this.x).getData(), this.objectShape) : ArrayFactory.wrap(((DoubleShapedVector)this.x).getData(), this.objectShape);
        }
        this.updatePending = false;
    }

    private boolean nonfinite(double value) {
        return Double.isInfinite(value) || Double.isNaN(value);
    }

    public double getDetectorNoise() {
        return this.sigma;
    }

    public void setDetectorNoise(double sigma) {
        this.sigma = sigma;
    }

    public double getDetectorGain() {
        return this.gamma;
    }

    public void setDetectorGain(double gamma) {
        this.gamma = gamma;
    }

    private void setWeightsAndData(WeightedData weightedData) {
        weightedData.setData(this.data, this.writableData);
        if (this.weights != null) {
            if (!EdgePreservingDeconvolution.isnan(this.sigma) || !EdgePreservingDeconvolution.isnan(this.gamma)) {
                System.err.println("Warning: noise model parameters are ignored when weights are specified.");
            }
            weightedData.setWeights(this.weights, this.writableWeights);
        } else {
            double beta;
            double alpha;
            if (EdgePreservingDeconvolution.isnan(this.sigma)) {
                if (!EdgePreservingDeconvolution.isnan(this.gamma)) {
                    System.err.println("Warning: linear noise model parameter is ignored if affine noise model parameter is not specified");
                }
                alpha = 0.0;
                beta = 1.0;
            } else if (EdgePreservingDeconvolution.isnan(this.gamma)) {
                alpha = 0.0;
                beta = EdgePreservingDeconvolution.abs2(this.sigma);
            } else {
                alpha = 1.0 / this.gamma;
                beta = EdgePreservingDeconvolution.abs2(this.sigma / this.gamma);
            }
            System.err.format("alpha = %g, beta = %g\n", alpha, beta);
            weightedData.computeWeightsFromData(alpha, beta);
        }
        if (this.bads != null) {
            weightedData.markBadData(this.bads);
        }
    }

    private double computePadValue() {
        double val;
        if (EdgePreservingDeconvolution.isnan(this.padValue)) {
            val = this.weightedData.getWeightedMean();
            if (this.psf != null && !this.normalizePSF) {
                val /= EdgePreservingDeconvolution.sum(this.psf);
            }
        } else {
            val = this.padValue;
        }
        return val;
    }

    private static double sum(ShapedArray arr) {
        double sum = 0.0;
        if (arr != null) {
            switch (arr.getType()) {
                case 0: {
                    sum = ((ByteArray)arr).sum();
                    break;
                }
                case 1: {
                    sum = ((ShortArray)arr).sum();
                    break;
                }
                case 2: {
                    sum = ((IntArray)arr).sum();
                    break;
                }
                case 3: {
                    sum = ((LongArray)arr).sum();
                    break;
                }
                case 4: {
                    sum = ((FloatArray)arr).sum();
                    break;
                }
                case 5: {
                    sum = ((DoubleArray)arr).sum();
                }
            }
        }
        return sum;
    }

    private static final boolean isnan(double x) {
        return Double.isNaN(x);
    }

    private static final double abs2(double x) {
        return x * x;
    }
}

