/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.VectorSpace;

public abstract class Vector {
    protected final VectorSpace space;
    protected final int number;

    protected Vector(VectorSpace owner) {
        this.space = owner;
        this.number = owner.number;
    }

    public VectorSpace getOwner() {
        return this.space;
    }

    public VectorSpace getSpace() {
        return this.space;
    }

    public final int getNumber() {
        return this.number;
    }

    public final int length() {
        return this.number;
    }

    public final boolean belongsTo(VectorSpace space) {
        return this.space == space;
    }

    public final void assertBelongsTo(VectorSpace space) throws IncorrectSpaceException {
        if (!this.belongsTo(space)) {
            throw new IncorrectSpaceException();
        }
    }

    public abstract double get(int var1) throws IndexOutOfBoundsException;

    public abstract void set(int var1, double var2) throws IndexOutOfBoundsException;

    public Vector create() {
        return this.space.create();
    }

    public Vector clone() {
        return this.space._clone(this);
    }

    public final void copy(Vector src) throws IncorrectSpaceException {
        if (src != this) {
            this.space.check(src);
            this.space._copy(this, src);
        }
    }

    public final void swap(Vector vec) throws IncorrectSpaceException {
        if (vec != this) {
            this.space.check(vec);
            this.space._swap(this, vec);
        }
    }

    public final double dot(Vector vec) {
        this.space.check(vec);
        return this.space._dot(this, vec);
    }

    public final double dot(Vector x, Vector y) {
        this.space.check(x);
        this.space.check(y);
        return this.space._dot(this, x, y);
    }

    public final double norm1() {
        return this.space._norm1(this);
    }

    public final double norm2() {
        return this.space._norm2(this);
    }

    public final double normInf() {
        return this.space._normInf(this);
    }

    public final void fill(double alpha) {
        this.space._fill(this, alpha);
    }

    public final void zero() {
        this.space._zero(this);
    }

    public final void scale(double alpha) {
        this.space._scale(this, alpha);
    }

    public final void scale(double alpha, Vector vec) {
        this.space.check(vec);
        this.space._scale(this, alpha, vec);
    }

    public final void add(double alpha, Vector x) throws IncorrectSpaceException {
        this.space.check(x);
        this.space._add(this, alpha, x);
    }

    public final void combine(double alpha, Vector x, double beta, Vector y) throws IncorrectSpaceException {
        this.space.check(x);
        this.space.check(y);
        this.space._combine(this, alpha, x, beta, y);
    }

    public final void combine(double alpha, Vector x, double beta, Vector y, double gamma, Vector z) throws IncorrectSpaceException {
        this.space.check(x);
        this.space.check(y);
        this.space.check(z);
        this.space._combine(this, alpha, x, beta, y, gamma, z);
    }

    public final void multiply(Vector x) throws IncorrectSpaceException {
        this.space.check(x);
        this.space._multiply(this, this, x);
    }

    public final void multiply(Vector x, Vector y) throws IncorrectSpaceException {
        this.space.check(x);
        this.space.check(y);
        this.space._multiply(this, x, y);
    }

    public String toString() {
        return this.toString(this.number);
    }

    public String toString(int n) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        if (this.number > n) {
            if (n <= 0) {
                buf.append("...");
            } else {
                int i;
                for (i = 0; i < Math.min(this.number, (n + 1) / 2); ++i) {
                    buf.append(String.format(i > 0 ? ", %g" : "%g", this.get(i)));
                }
                buf.append(", ...");
                for (i = this.number - (n - (n + 1) / 2); i < this.number; ++i) {
                    buf.append(String.format(", %g", this.get(i)));
                }
            }
        } else {
            for (int i = 0; i < this.number; ++i) {
                buf.append(String.format(i > 0 ? ", %g" : "%g", this.get(i)));
            }
        }
        return buf.append("}").toString();
    }
}

