/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.base.Traits;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.optim.LineSearch;
import mitiv.optim.LineSearchTask;
import mitiv.optim.MoreThuenteLineSearch;
import mitiv.optim.OptimStatus;
import mitiv.optim.OptimTask;
import mitiv.optim.ReverseCommunicationOptimizerWithLineSearch;
import mitiv.tests.MinPack1Tests;

public class NonLinearConjugateGradient
extends ReverseCommunicationOptimizerWithLineSearch {
    public static final double SFTOL = 0.05;
    public static final double SGTOL = 0.1;
    public static final double SXTOL = Traits.DBL_EPSILON;
    public static final double STPMIN = 1.0E-20;
    public static final double STPMAX = 1.0E20;
    public static final double DELTA = 0.05;
    public static final double EPSILON = 0.01;
    public static final int FLETCHER_REEVES = 1;
    public static final int HESTENES_STIEFEL = 2;
    public static final int POLAK_RIBIERE_POLYAK = 3;
    public static final int FLETCHER = 4;
    public static final int LIU_STOREY = 5;
    public static final int DAI_YUAN = 6;
    public static final int PERRY_SHANNO = 7;
    public static final int HAGER_ZHANG = 8;
    public static final int POWELL = 256;
    public static final int SHANNO_PHUA = 512;
    public static final int DEFAULT_METHOD = 771;
    private double f0;
    private double g0norm;
    private double gnorm;
    private double dtg0;
    private double dtg;
    private double grtol;
    private double gatol;
    private double ginit;
    private double fmin;
    private final double delta;
    private final double epsilon;
    private double beta;
    private final double stpmin;
    private final double stpmax;
    private final Vector x0;
    private final Vector g0;
    private final Vector d;
    private final Vector y;
    private final int method;
    private boolean fmin_given;
    private final boolean update_Hager_Zhang_orig = false;

    public NonLinearConjugateGradient(VectorSpace space) {
        this(space, 771);
    }

    public NonLinearConjugateGradient(VectorSpace space, int method) {
        this(space, method, new MoreThuenteLineSearch(0.05, 0.1, SXTOL));
    }

    public NonLinearConjugateGradient(VectorSpace space, int method, LineSearch lnsrch) {
        super(space, lnsrch);
        boolean y_needed;
        boolean g0_needed;
        if (method == 0) {
            method = 771;
        }
        switch (method & 0xFF) {
            case 1: {
                g0_needed = false;
                y_needed = false;
                break;
            }
            case 2: {
                g0_needed = true;
                y_needed = true;
                break;
            }
            case 3: {
                g0_needed = true;
                y_needed = true;
                break;
            }
            case 4: {
                g0_needed = false;
                y_needed = false;
                break;
            }
            case 5: {
                g0_needed = true;
                y_needed = true;
                break;
            }
            case 6: {
                g0_needed = true;
                y_needed = true;
                break;
            }
            case 7: {
                g0_needed = true;
                y_needed = true;
                break;
            }
            case 8: {
                g0_needed = true;
                y_needed = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal method value");
            }
        }
        this.unsetFMin();
        this.method = method;
        this.grtol = 0.001;
        this.gatol = 0.0;
        this.ginit = 0.0;
        this.stpmin = 1.0E-20;
        this.stpmax = 1.0E20;
        this.delta = 0.05;
        this.epsilon = 0.01;
        this.x0 = space.create();
        this.g0 = g0_needed ? space.create() : null;
        this.d = space.create();
        this.y = y_needed ? space.create() : null;
        this.evaluations = 0;
        this.failure(OptimStatus.LNSRCH_NOT_STARTED);
    }

    private int update0(Vector g, double beta) {
        this.beta = beta;
        if (this.beta != 0.0) {
            this.d.combine(1.0, g, beta, this.d);
            return 0;
        }
        return -1;
    }

    private int update1(Vector g, double beta) {
        if ((this.method & 0x100) == 256 && beta < 0.0) {
            ++this.restarts;
            this.beta = 0.0;
        } else {
            this.beta = beta;
        }
        if (this.beta != 0.0) {
            this.d.combine(1.0, g, beta, this.d);
            return 0;
        }
        return -1;
    }

    private void form_y(Vector g) {
        this.y.combine(1.0, g, -1.0, this.g0);
    }

    private int update_Hestenes_Stiefel(Vector x, Vector g) {
        this.form_y(g);
        double gty = g.dot(this.y);
        double dty = -this.d.dot(this.y);
        double beta = dty != 0.0 ? gty / dty : 0.0;
        return this.update1(g, beta);
    }

    private int update_Fletcher_Reeves(Vector x, Vector g) {
        double r = this.gnorm / this.g0norm;
        return this.update0(g, r * r);
    }

    private int update_Polak_Ribiere_Polyak(Vector x, Vector g) {
        this.form_y(g);
        double beta = g.dot(this.y) / this.g0norm / this.g0norm;
        return this.update1(g, beta);
    }

    private int update_Fletcher(Vector x, Vector g) {
        double beta = -this.gnorm * (this.gnorm / this.dtg0);
        return this.update0(g, beta);
    }

    private int update_Liu_Storey(Vector x, Vector g) {
        this.form_y(g);
        double gty = g.dot(this.y);
        double beta = -gty / this.dtg0;
        return this.update1(g, beta);
    }

    private int update_Dai_Yuan(Vector x, Vector g) {
        this.form_y(g);
        double dty = -this.d.dot(this.y);
        double beta = dty != 0.0 ? this.gnorm * (this.gnorm / dty) : 0.0;
        return this.update1(g, beta);
    }

    private int update_Hager_Zhang(Vector x, Vector g) {
        double beta;
        this.form_y(g);
        double dty = -this.d.dot(this.y);
        if (dty != 0.0) {
            double ytg = this.y.dot(g);
            double ynorm = this.y.norm2();
            beta = (ytg - 2.0 * (ynorm / dty) * ynorm * this.dtg) / dty;
        } else {
            beta = 0.0;
        }
        return this.update1(g, beta);
    }

    private int update_Perry_Shanno(Vector x, Vector g) {
        this.form_y(g);
        double yty = this.y.dot(this.y);
        if (yty <= 0.0) {
            return -1;
        }
        double dty = -this.d.dot(this.y);
        if (dty == 0.0) {
            return -1;
        }
        double gty = g.dot(this.y);
        double c1 = dty / yty;
        double c2 = gty / yty - 2.0 * this.dtg / dty;
        double c3 = -this.dtg / yty;
        this.beta = c2 / c1;
        this.d.combine(c1, g, c2, this.d, c3, this.y);
        return 0;
    }

    private int update(Vector x, Vector g) {
        switch (this.method & 0xFF) {
            case 1: {
                return this.update_Fletcher_Reeves(x, g);
            }
            case 2: {
                return this.update_Hestenes_Stiefel(x, g);
            }
            case 3: {
                return this.update_Polak_Ribiere_Polyak(x, g);
            }
            case 4: {
                return this.update_Fletcher(x, g);
            }
            case 5: {
                return this.update_Liu_Storey(x, g);
            }
            case 6: {
                return this.update_Dai_Yuan(x, g);
            }
            case 7: {
                return this.update_Perry_Shanno(x, g);
            }
            case 8: {
                return this.update_Hager_Zhang(x, g);
            }
        }
        return -1;
    }

    @Override
    public OptimTask start() {
        this.iterations = 0;
        this.evaluations = 0;
        this.restarts = 0;
        this.ginit = 0.0;
        return this.success(OptimTask.COMPUTE_FG);
    }

    @Override
    public OptimTask restart() {
        ++this.restarts;
        return this.success(OptimTask.COMPUTE_FG);
    }

    @Override
    public OptimTask iterate(Vector x, double f, Vector g) {
        switch (this.getTask()) {
            case COMPUTE_FG: {
                ++this.evaluations;
                if (this.evaluations > 1) {
                    this.dtg = -this.d.dot(g);
                    LineSearchTask lnsrchTask = this.lnsrch.iterate(f, this.dtg);
                    if (lnsrchTask != LineSearchTask.CONVERGENCE) {
                        if (lnsrchTask == LineSearchTask.SEARCH) break;
                        OptimStatus lnsrchStatus = this.lnsrch.getStatus();
                        if (lnsrchTask != LineSearchTask.WARNING || lnsrchStatus != OptimStatus.ROUNDING_ERRORS_PREVENT_PROGRESS) {
                            return this.failure(lnsrchStatus);
                        }
                    }
                    ++this.iterations;
                }
                this.gnorm = g.norm2();
                if (this.evaluations <= 1) {
                    this.ginit = this.gnorm;
                }
                return this.success(this.gnorm <= this.getGradientThreshold(this.ginit) ? OptimTask.FINAL_X : OptimTask.NEW_X);
            }
            case NEW_X: 
            case FINAL_X: {
                if (this.evaluations <= 1 || this.update(x, g) != 0) {
                    this.dtg = 0.0;
                } else {
                    this.dtg = -this.d.dot(g);
                    if (this.epsilon > 0.0 && this.dtg > -this.epsilon * this.d.norm2() * this.gnorm) {
                        this.dtg = 0.0;
                    }
                }
                double alpha = this.lnsrch.getStep();
                if (this.dtg < 0.0) {
                    if ((this.method & 0x200) == 512) {
                        alpha *= this.dtg0 / this.dtg;
                    }
                } else {
                    if (this.evaluations > 1) {
                        ++this.restarts;
                    }
                    this.d.copy(g);
                    this.dtg = -this.gnorm * this.gnorm;
                    if (f != 0.0) {
                        alpha = 2.0 * Math.abs(f / this.dtg);
                    } else {
                        double dnorm = this.gnorm;
                        double xnorm = x.norm2();
                        alpha = xnorm > 0.0 ? this.delta * xnorm / dnorm : this.delta / dnorm;
                    }
                    this.beta = 0.0;
                }
                this.x0.copy(x);
                this.f0 = f;
                if (this.g0 != null) {
                    this.g0.copy(g);
                }
                this.g0norm = this.gnorm;
                this.dtg0 = this.dtg;
                if (this.lnsrch.start(this.f0, this.dtg0, alpha, this.stpmin * alpha, this.stpmax * alpha) == LineSearchTask.SEARCH) break;
                return this.failure(this.lnsrch.getStatus());
            }
            default: {
                return this.getTask();
            }
        }
        x.combine(1.0, this.x0, -this.lnsrch.getStep(), this.d);
        return this.success(OptimTask.COMPUTE_FG);
    }

    public void setAbsoluteTolerance(double gatol) {
        this.gatol = gatol;
    }

    public void setRelativeTolerance(double grtol) {
        this.grtol = grtol;
    }

    public double getAbsoluteTolerance() {
        return this.gatol;
    }

    public double getRelativeTolerance() {
        return this.grtol;
    }

    public double getGradientThreshold(double g0nrm) {
        return NonLinearConjugateGradient.max(0.0, this.gatol, this.grtol * g0nrm);
    }

    private static final double max(double a1, double a2, double a3) {
        if (a3 >= a2) {
            return a3 >= a1 ? a3 : a1;
        }
        return a2 >= a1 ? a2 : a1;
    }

    public double getFMin() {
        return this.fmin_given ? this.fmin : Double.NaN;
    }

    public void setFMin(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            this.unsetFMin();
        } else {
            this.fmin = value;
            this.fmin_given = true;
        }
    }

    public void unsetFMin() {
        this.fmin = Double.NaN;
        this.fmin_given = false;
    }

    public static void main(String[] args) {
        int[] prob = new int[]{1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
        int[] size = new int[]{3, 6, 3, 2, 3, 5, 6, 9, 6, 8, 2, 4, 3, 8, 8, 12, 2, 4, 30};
        double factor = 1.0;
        int method = 8;
        MoreThuenteLineSearch lineSearch = new MoreThuenteLineSearch(0.05, 0.1, 1.0E-8);
        block0: for (int k = 0; k < prob.length; ++k) {
            int p = prob[k];
            int n = size[k];
            DoubleShapedVectorSpace space = new DoubleShapedVectorSpace(new int[]{n});
            double[] xData = new double[n];
            double[] gData = new double[n];
            int iter = -1;
            int nf = 0;
            int ng = 0;
            double fx = 0.0;
            DoubleShapedVector x = space.wrap(xData);
            DoubleShapedVector gx = space.wrap(gData);
            MinPack1Tests.umipt(xData, p, 1.0);
            NonLinearConjugateGradient minimizer = new NonLinearConjugateGradient(space, 8, lineSearch);
            OptimTask task = minimizer.start();
            while (true) {
                if (task == OptimTask.COMPUTE_FG) {
                    fx = MinPack1Tests.umobj(xData, p);
                    ++nf;
                    MinPack1Tests.umgrd(xData, gData, p);
                    ++ng;
                } else if (task == OptimTask.NEW_X) {
                    if (++iter == 0) {
                        System.out.println("\nProblem #" + p + " with " + n + " variables.");
                        System.out.println("|x0| = " + x.norm2() + " f0 = " + fx + " |g0| = " + gx.norm2());
                    }
                } else {
                    if (task == OptimTask.FINAL_X) {
                        System.out.println("|xn| = " + x.norm2() + " f(xn) = " + fx + " |g(xn)| = " + gx.norm2());
                        System.out.println("in " + ++iter + " iterations, " + nf + " function calls and " + ng + " gradient calls");
                        continue block0;
                    }
                    System.err.println("TiPi: NonLinearConjugateGradient, error/warning: " + (Object)((Object)task));
                    continue block0;
                }
                task = minimizer.iterate(x, fx, gx);
            }
        }
        System.out.flush();
        System.err.flush();
    }
}

