/*
 * Decompiled with CFR 0.152.
 */
package mitiv.random;

import mitiv.exception.NotImplementedException;
import mitiv.random.DoubleGenerator;
import mitiv.random.FloatGenerator;
import mitiv.random.RandomEngine;

public class NormalDistribution
implements DoubleGenerator,
FloatGenerator {
    public static final double DEFAULT_MEAN = 0.0;
    public static final double DEFAULT_VARIANCE = 1.0;
    protected RandomEngine engine;
    protected double mean;
    protected double variance;
    protected double standardDeviation;
    private double savedValue;
    private boolean haveSavedValue = false;

    public NormalDistribution(double mean, double variance) {
        this.engine = RandomEngine.NewDefaultEngine();
        this.setState(mean, variance);
    }

    public NormalDistribution(int seed, double mean, double variance) {
        this.engine = RandomEngine.NewDefaultEngine(seed);
        this.setState(mean, variance);
    }

    public NormalDistribution(RandomEngine engine, double mean, double variance) {
        this.engine = engine;
        this.setState(mean, variance);
    }

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    public NormalDistribution(int seed) {
        this(seed, 0.0, 1.0);
    }

    public NormalDistribution(RandomEngine engine) {
        this(engine, 0.0, 1.0);
    }

    public void reset(int seed) {
        this.haveSavedValue = false;
        this.engine.reset(seed);
    }

    public void setState(double mean, double variance) {
        this.mean = mean;
        this.variance = variance;
        this.standardDeviation = Math.sqrt(variance);
    }

    @Override
    public double nextDouble() {
        double v2;
        double v1;
        double s;
        if (this.haveSavedValue) {
            this.haveSavedValue = false;
            return this.mean + this.standardDeviation * this.savedValue;
        }
        while ((s = (v1 = 2.0 * this.engine.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.engine.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        s = Math.sqrt(-2.0 * Math.log(s) / s);
        this.savedValue = s * v2;
        this.haveSavedValue = true;
        return this.mean + this.standardDeviation * (s * v1);
    }

    @Override
    public float nextFloat() {
        return (float)this.nextDouble();
    }

    public double cdf(double x) {
        throw new NotImplementedException();
    }

    public double pdf(double x) {
        throw new NotImplementedException();
    }
}

