/*
 * Decompiled with CFR 0.152.
 */
package mitiv.random;

import mitiv.random.DoubleGenerator;
import mitiv.random.FloatGenerator;
import mitiv.random.RandomEngine;

public class UniformDistribution
implements FloatGenerator,
DoubleGenerator {
    public static final double DEFAULT_INF = 0.0;
    public static final double DEFAULT_SUP = 1.0;
    protected RandomEngine engine;
    protected double inf;
    protected double sup;
    protected double pdfLevel;
    protected double scaleDouble;
    protected double biasDouble;
    protected float scaleFloat;
    protected float biasFloat;

    public UniformDistribution(double a, double b) {
        this.engine = RandomEngine.NewDefaultEngine();
        this.setState(a, b);
    }

    public UniformDistribution(int seed, double a, double b) {
        this.engine = RandomEngine.NewDefaultEngine(seed);
        this.setState(a, b);
    }

    public UniformDistribution(RandomEngine engine, double a, double b) {
        this.engine = engine;
        this.setState(a, b);
    }

    public UniformDistribution() {
        this(0.0, 1.0);
    }

    public UniformDistribution(int seed) {
        this(seed, 0.0, 1.0);
    }

    public UniformDistribution(RandomEngine engine) {
        this(engine, 0.0, 1.0);
    }

    public void reset(int seed) {
        this.engine.reset(seed);
    }

    public void setState(double a, double b) {
        this.inf = Math.min(a, b);
        this.sup = Math.max(a, b);
        this.pdfLevel = this.sup > this.inf ? 1.0 / (this.sup - this.inf) : Double.POSITIVE_INFINITY;
        double minValue = this.engine.min();
        double maxValue = this.engine.max();
        this.scaleDouble = (this.sup - this.inf) / (maxValue - minValue + 1.0);
        this.biasDouble = ((maxValue + minValue) * this.scaleDouble - (this.inf + this.sup)) / 2.0;
        this.scaleFloat = (float)this.scaleDouble;
        this.biasFloat = (float)this.biasDouble;
    }

    @Override
    public float nextFloat() {
        return (float)this.engine.next() * this.scaleFloat - this.biasFloat;
    }

    @Override
    public double nextDouble() {
        return (double)this.engine.next() * this.scaleDouble - this.biasDouble;
    }

    public double getInf() {
        return this.inf;
    }

    public double getSup() {
        return this.sup;
    }

    public double cdf(double x) {
        if (x <= this.inf) {
            return 0.0;
        }
        if (x >= this.sup) {
            return 1.0;
        }
        return (x - this.inf) / (this.sup - this.inf);
    }

    public double pdf(double x) {
        if (x <= this.inf) {
            return 0.0;
        }
        if (x >= this.sup) {
            return 1.0;
        }
        return this.pdfLevel * (x - this.inf);
    }
}

