/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.trackmanager.processors;

import icy.canvas.IcyCanvas;
import icy.gui.dialog.SaveDialog;
import icy.gui.util.GuiUtil;
import icy.main.Icy;
import icy.painter.Painter;
import icy.preferences.GeneralPreferences;
import icy.sequence.Sequence;
import icy.util.StringUtil;
import icy.util.XLSUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class TrackProcessorMSD
extends PluginTrackManagerProcessor
implements ActionListener,
Painter {
    JFreeChart chart;
    JCheckBox displayLegendCheckBox = new JCheckBox("Display legend.", false);
    JCheckBox displayGraphInSequenceCheckBox = new JCheckBox("Display graph on sequence.", false);
    JButton useRoiAsBoundsForChartButton = new JButton("place graph in ROI #1");
    JCheckBox forceAllSequenceGraphWidthCheckBox = new JCheckBox("Force graph width.", false);
    JCheckBox useRealScalesBox = new JCheckBox("use real scales", false);
    JPanel chartpanel = new JPanel();
    JTextField scaleTextField = new JTextField("1.0");
    JButton exportButton = new JButton("export to console");
    JButton exportExcelButton = new JButton("export to excel");
    Rectangle2D chartRectangleInSequence = new Rectangle2D.Float(250.0f, 20.0f, 490.0f, 240.0f);
    JLabel outLabel = new JLabel();

    public TrackProcessorMSD() {
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        this.chartpanel.add((Component)new ChartPanel(this.chart, 500, 300, 500, 300, 500, 300, false, false, true, true, true, true));
        this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.chartpanel}));
        this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.useRealScalesBox}));
        this.useRealScalesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackProcessorMSD.this.Compute();
            }
        });
        this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.displayLegendCheckBox, this.forceAllSequenceGraphWidthCheckBox}));
        this.exportButton.addActionListener(this);
        this.exportExcelButton.addActionListener(this);
        this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.exportButton, this.exportExcelButton}));
        this.useRoiAsBoundsForChartButton.addActionListener(this);
        this.displayGraphInSequenceCheckBox.addActionListener(this);
        this.displayLegendCheckBox.addActionListener(this);
        this.forceAllSequenceGraphWidthCheckBox.addActionListener(this);
        this.setName("Mean square displacement");
    }

    public void Compute() {
        int i;
        double[] msd;
        XYSeries series;
        double tScale;
        if (!super.isEnabled()) {
            return;
        }
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        Sequence seq = this.trackPool.getDisplaySequence();
        double d = tScale = seq != null ? seq.getTimeInterval() : 1.0;
        if (this.useRealScalesBox.isSelected()) {
            for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
                series = new XYSeries((Comparable)((Object)("Track " + this.trackPool.getTrackIndex(ts))));
                msd = this.scaledMeanSquaredDisplacement(seq, ts);
                if (msd.length <= 0) continue;
                for (i = 0; i < msd.length; ++i) {
                    series.add((double)i * tScale, msd[i]);
                }
                xyDataset.addSeries(series);
            }
        } else {
            for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
                series = new XYSeries((Comparable)((Object)("Track " + this.trackPool.getTrackIndex(ts))));
                msd = this.scaledMeanSquaredDisplacement(null, ts);
                if (msd.length <= 0) continue;
                for (i = 0; i < msd.length; ++i) {
                    series.add((double)i, msd[i]);
                }
                xyDataset.addSeries(series);
            }
        }
        String TitleString = "";
        String TitleString2 = "";
        String TitleString3 = "";
        if (this.displayLegendCheckBox.isSelected()) {
            if (this.useRealScalesBox.isSelected()) {
                TitleString = "Mean Square Displacement";
                TitleString2 = "Delta (s)";
                TitleString3 = "MSD (um^2)";
            } else {
                TitleString = "Mean Square Displacement";
                TitleString2 = "Delta (frame)";
                TitleString3 = "MSD (pixel^2)";
            }
        }
        this.chart = ChartFactory.createXYLineChart((String)TitleString, (String)TitleString2, (String)TitleString3, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.displayLegendCheckBox.isSelected(), (boolean)true, (boolean)false);
        if (this.forceAllSequenceGraphWidthCheckBox.isSelected()) {
            XYSeries series2 = new XYSeries((Comparable)((Object)""));
            series2.add((double)this.trackPool.getLastDetectionTimePoint(), 0.0);
            xyDataset.addSeries(series2);
        }
        this.chartpanel.removeAll();
        if (this.chart != null) {
            XYItemRenderer renderer = ((XYPlot)this.chart.getPlot()).getRenderer();
            for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
                renderer.setSeriesPaint(this.trackPool.getTrackIndex(ts), (Paint)ts.getFirstDetection().getColor());
            }
        }
        this.chartpanel.add((Component)new ChartPanel(this.chart, 400, 300, 400, 300, 400, 300, false, false, true, true, true, true));
        this.chartpanel.updateUI();
        this.panel.updateUI();
    }

    private void exportMSD(boolean xlsExport) {
        int cnt;
        Sequence seq;
        double tScale;
        WritableWorkbook workbook = null;
        WritableSheet page = null;
        if (xlsExport) {
            String outputName;
            if (Icy.getMainInterface().isHeadLess()) {
                outputName = this.trackPool.getDisplaySequence() == null || StringUtil.isEmpty((String)this.trackPool.getDisplaySequence().getFilename()) ? GeneralPreferences.getResultFolder() + "Tracks" : this.trackPool.getDisplaySequence().getFilename();
                outputName = outputName + ".msd.xls";
            } else {
                outputName = SaveDialog.chooseFileForResult((String)"XLS MSD export", (String)"tracks-msd", (String)".xls");
            }
            if (StringUtil.isEmpty((String)outputName)) {
                return;
            }
            try {
                workbook = XLSUtil.createWorkbook((File)new File(outputName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (workbook != null) {
            page = XLSUtil.createNewPage(workbook, (String)"results");
        }
        double d = tScale = (seq = this.trackPool.getDisplaySequence()) != null ? seq.getTimeInterval() : 1.0;
        if (this.useRealScalesBox.isSelected()) {
            cnt = 0;
            int row = 1;
            int cols = 0;
            for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
                double[] msd = this.scaledMeanSquaredDisplacement(seq, ts);
                if (msd.length <= 0) continue;
                if (msd.length > cols) {
                    cols = msd.length;
                }
                System.out.println("track " + cnt);
                if (page != null) {
                    XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)("track " + cnt));
                }
                for (int i = 0; i < msd.length; ++i) {
                    System.out.println((double)i * tScale + "\t" + msd[i]);
                    if (page == null) continue;
                    XLSUtil.setCellNumber((WritableSheet)page, (int)(i + 1), (int)row, (double)msd[i]);
                }
                ++cnt;
                ++row;
            }
            if (page != null) {
                XLSUtil.setCellString((WritableSheet)page, (int)0, (int)0, (String)"frame");
                if (cols > 0) {
                    for (int c = 0; c < cols; ++c) {
                        XLSUtil.setCellString((WritableSheet)page, (int)(c + 1), (int)0, (String)String.valueOf(c));
                    }
                }
            }
        } else {
            cnt = 0;
            int row = 1;
            int cols = 0;
            for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
                double[] msd = this.scaledMeanSquaredDisplacement(null, ts);
                if (msd.length <= 0) continue;
                if (msd.length > cols) {
                    cols = msd.length;
                }
                System.out.println("track " + cnt);
                if (page != null) {
                    XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)("track " + cnt));
                }
                for (int i = 0; i < msd.length; ++i) {
                    System.out.println(i + "\t" + msd[i]);
                    if (page == null) continue;
                    XLSUtil.setCellNumber((WritableSheet)page, (int)(i + 1), (int)row, (double)msd[i]);
                }
                ++cnt;
                ++row;
            }
            if (page != null) {
                XLSUtil.setCellString((WritableSheet)page, (int)0, (int)0, (String)"frame");
                if (cols > 0) {
                    for (int c = 0; c < cols; ++c) {
                        XLSUtil.setCellString((WritableSheet)page, (int)(c + 1), (int)0, (String)String.valueOf(c));
                    }
                }
            }
        }
        if (workbook != null) {
            try {
                XLSUtil.saveAndClose((WritableWorkbook)workbook);
            }
            catch (WriteException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private double[] scaledMeanSquaredDisplacement(Sequence seq, TrackSegment ts) {
        double sz;
        double sy;
        double sx;
        if (seq != null) {
            sx = seq.getPixelSizeX();
            sy = seq.getPixelSizeY();
            sz = seq.getPixelSizeZ();
        } else {
            sx = 1.0;
            sy = 1.0;
            sz = 1.0;
        }
        int numDetection = ts.getDetectionList().size();
        int firstEnabledDetectionIndex = -1;
        int numEnabledDetection = 0;
        int lastFirstEnabledDetectionIndex = -1;
        int lastNumEnabledDetection = 0;
        for (int i = 0; i < numDetection; ++i) {
            Detection d = ts.getDetectionAt(i);
            if (d.isEnabled()) {
                if (lastFirstEnabledDetectionIndex == -1) {
                    lastFirstEnabledDetectionIndex = i;
                    lastNumEnabledDetection = 1;
                    continue;
                }
                ++lastNumEnabledDetection;
                continue;
            }
            if (lastNumEnabledDetection > numEnabledDetection) {
                numEnabledDetection = lastNumEnabledDetection;
                firstEnabledDetectionIndex = lastFirstEnabledDetectionIndex;
            }
            lastFirstEnabledDetectionIndex = -1;
            lastNumEnabledDetection = 0;
        }
        if (lastNumEnabledDetection > numEnabledDetection) {
            numEnabledDetection = lastNumEnabledDetection;
            firstEnabledDetectionIndex = lastFirstEnabledDetectionIndex;
        }
        double[] msd = new double[numEnabledDetection];
        for (int t = 1; t < numEnabledDetection; ++t) {
            msd[t] = 0.0;
            for (int j = 1; j <= t; ++j) {
                int n = t;
                msd[n] = msd[n] + TrackProcessorMSD.scaledSquaredDistance(ts.getDetectionAt(firstEnabledDetectionIndex), ts.getDetectionAt(firstEnabledDetectionIndex + j), sx, sy, sz);
            }
            int n = t;
            msd[n] = msd[n] / (double)t;
        }
        return msd;
    }

    private static double squaredDistance(Detection d1, Detection d2) {
        return TrackProcessorMSD.scaledSquaredDistance(d1, d2, 1.0, 1.0, 1.0);
    }

    private static double scaledSquaredDistance(Detection d1, Detection d2, double sx, double sy, double sz) {
        return Math.pow((d1.getX() - d2.getX()) * sx, 2.0) + Math.pow((d1.getY() - d2.getY()) * sy, 2.0) + Math.pow((d1.getZ() - d2.getZ()) * sz, 2.0);
    }

    public void Close() {
        Sequence sequence = this.trackPool.getDisplaySequence();
        if (sequence != null) {
            sequence.removePainter((Painter)this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.exportButton) {
            this.exportMSD(false);
        }
        if (e.getSource() == this.exportExcelButton) {
            this.exportMSD(true);
        }
        this.trackPool.fireTrackEditorProcessorChange();
    }

    public void keyPressed(Point p, KeyEvent e) {
    }

    public void mouseClick(Point p, MouseEvent e) {
    }

    public void mouseDrag(Point p, MouseEvent e) {
    }

    public void mouseMove(Point p, MouseEvent e) {
    }

    public void displaySequenceChanged() {
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        double scale = Double.parseDouble(this.scaleTextField.getText());
        double minX = this.chartRectangleInSequence.getCenterX();
        double minY = this.chartRectangleInSequence.getCenterY();
        Rectangle2D transformedChartRectangleInSequence = (Rectangle2D)this.chartRectangleInSequence.clone();
        transformedChartRectangleInSequence.setRect(-this.chartRectangleInSequence.getWidth() / 2.0 * (1.0 / scale), -this.chartRectangleInSequence.getHeight() / 2.0 * (1.0 / scale), this.chartRectangleInSequence.getWidth() * (1.0 / scale), this.chartRectangleInSequence.getHeight() * (1.0 / scale));
        Graphics2D g2 = g;
        AffineTransform transform = g2.getTransform();
        g2.scale(scale, scale);
        g2.translate(minX * (1.0 / scale), minY * (1.0 / scale));
        if (this.displayGraphInSequenceCheckBox.isSelected()) {
            this.chart.draw(g, transformedChartRectangleInSequence);
        }
        g2.setTransform(transform);
    }

    public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }
}

